/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Constants;
import nxt.Fee;
import nxt.Nxt;
import nxt.NxtException;
import nxt.PhasingParams;
import nxt.PhasingPoll;
import nxt.PrunableMessage;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.TransactionProcessor;
import nxt.TransactionProcessorImpl;
import nxt.TransactionType;
import nxt.VoteWeighting;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public interface Appendix {
    public int getSize();

    public int getFullSize();

    public void putBytes(ByteBuffer var1);

    public JSONObject getJSONObject();

    public byte getVersion();

    public int getBaselineFeeHeight();

    public Fee getBaselineFee(Transaction var1);

    public int getNextFeeHeight();

    public Fee getNextFee(Transaction var1);

    public boolean isPhased(Transaction var1);

    public static boolean hasAppendix(String string, JSONObject jSONObject) {
        return jSONObject.get("version." + string) != null;
    }

    public static final class Phasing
    extends AbstractAppendix {
        private static final String appendixName = "Phasing";
        private static final Fee PHASING_FEE = (transactionImpl, appendix) -> {
            long l = 0L;
            Phasing phasing = (Phasing)appendix;
            l = !phasing.params.getVoteWeighting().isBalanceIndependent() ? (l += 2000000000L) : (l += 100000000L);
            if (phasing.hashedSecret.length > 0) {
                l += (long)(1 + (phasing.hashedSecret.length - 1) / 32) * 100000000L;
            }
            return l += 100000000L * (long)phasing.linkedFullHashes.length;
        };
        private final int finishHeight;
        private final PhasingParams params;
        private final byte[][] linkedFullHashes;
        private final byte[] hashedSecret;
        private final byte algorithm;

        static Phasing parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(appendixName, jSONObject)) {
                return null;
            }
            return new Phasing(jSONObject);
        }

        Phasing(ByteBuffer byteBuffer) {
            super(byteBuffer);
            int n;
            this.finishHeight = byteBuffer.getInt();
            this.params = new PhasingParams(byteBuffer);
            int n2 = byteBuffer.get();
            if (n2 > 0) {
                this.linkedFullHashes = new byte[n2][];
                for (n = 0; n < n2; ++n) {
                    this.linkedFullHashes[n] = new byte[32];
                    byteBuffer.get(this.linkedFullHashes[n]);
                }
            } else {
                this.linkedFullHashes = Convert.EMPTY_BYTES;
            }
            if ((n = byteBuffer.get()) > 0) {
                this.hashedSecret = new byte[n];
                byteBuffer.get(this.hashedSecret);
            } else {
                this.hashedSecret = Convert.EMPTY_BYTE;
            }
            this.algorithm = byteBuffer.get();
        }

        private Phasing(JSONObject jSONObject) {
            super(jSONObject);
            String string;
            this.finishHeight = ((Long)jSONObject.get("phasingFinishHeight")).intValue();
            this.params = new PhasingParams(jSONObject);
            JSONArray jSONArray = (JSONArray)jSONObject.get("phasingLinkedFullHashes");
            if (jSONArray != null && jSONArray.size() > 0) {
                this.linkedFullHashes = new byte[jSONArray.size()][];
                for (int i = 0; i < this.linkedFullHashes.length; ++i) {
                    this.linkedFullHashes[i] = Convert.parseHexString((String)jSONArray.get(i));
                }
            } else {
                this.linkedFullHashes = Convert.EMPTY_BYTES;
            }
            if ((string = Convert.emptyToNull((String)jSONObject.get("phasingHashedSecret"))) != null) {
                this.hashedSecret = Convert.parseHexString(string);
                this.algorithm = ((Long)jSONObject.get("phasingHashedSecretAlgorithm")).byteValue();
            } else {
                this.hashedSecret = Convert.EMPTY_BYTE;
                this.algorithm = 0;
            }
        }

        public Phasing(int n, PhasingParams phasingParams, byte[][] byArray, byte[] byArray2, byte by) {
            this.finishHeight = n;
            this.params = phasingParams;
            this.linkedFullHashes = Convert.nullToEmpty(byArray);
            this.hashedSecret = byArray2 != null ? byArray2 : Convert.EMPTY_BYTE;
            this.algorithm = by;
        }

        @Override
        String getAppendixName() {
            return appendixName;
        }

        @Override
        int getMySize() {
            return 4 + this.params.getMySize() + 1 + 32 * this.linkedFullHashes.length + 1 + this.hashedSecret.length + 1;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putInt(this.finishHeight);
            this.params.putMyBytes(byteBuffer);
            byteBuffer.put((byte)this.linkedFullHashes.length);
            for (byte[] byArray : this.linkedFullHashes) {
                byteBuffer.put(byArray);
            }
            byteBuffer.put((byte)this.hashedSecret.length);
            byteBuffer.put(this.hashedSecret);
            byteBuffer.put(this.algorithm);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("phasingFinishHeight", this.finishHeight);
            this.params.putMyJSON(jSONObject);
            if (this.linkedFullHashes.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (byte[] byArray : this.linkedFullHashes) {
                    jSONArray.add(Convert.toHexString(byArray));
                }
                jSONObject.put("phasingLinkedFullHashes", jSONArray);
            }
            if (this.hashedSecret.length > 0) {
                jSONObject.put("phasingHashedSecret", Convert.toHexString(this.hashedSecret));
                jSONObject.put("phasingHashedSecretAlgorithm", this.algorithm);
            }
        }

        @Override
        void validate(Transaction transaction) throws NxtException.ValidationException {
            this.params.validate();
            int n = Nxt.getBlockchain().getHeight();
            if (this.params.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.TRANSACTION) {
                if (this.linkedFullHashes.length == 0 || this.linkedFullHashes.length > 10) {
                    throw new NxtException.NotValidException("Invalid number of linkedFullHashes " + this.linkedFullHashes.length);
                }
                HashSet<Long> hashSet = new HashSet<Long>(this.linkedFullHashes.length);
                for (byte[] byArray : this.linkedFullHashes) {
                    if (Convert.emptyToNull(byArray) == null || byArray.length != 32) {
                        throw new NxtException.NotValidException("Invalid linkedFullHash " + Convert.toHexString(byArray));
                    }
                    if (!hashSet.add(Convert.fullHashToId(byArray))) {
                        throw new NxtException.NotValidException("Duplicate linked transaction ids");
                    }
                    TransactionImpl transactionImpl = TransactionDb.findTransactionByFullHash(byArray, n);
                    if (transactionImpl == null) continue;
                    if (transaction.getTimestamp() - transactionImpl.getTimestamp() > 5184000) {
                        throw new NxtException.NotValidException("Linked transaction cannot be more than 60 days older than the phased transaction");
                    }
                    if (transactionImpl.getPhasing() == null) continue;
                    throw new NxtException.NotCurrentlyValidException("Cannot link to an already existing phased transaction");
                }
                if (this.params.getQuorum() > (long)this.linkedFullHashes.length) {
                    throw new NxtException.NotValidException("Quorum of " + this.params.getQuorum() + " cannot be achieved in by-transaction voting with " + this.linkedFullHashes.length + " linked full hashes only");
                }
            } else if (this.linkedFullHashes.length != 0) {
                throw new NxtException.NotValidException("LinkedFullHashes can only be used with VotingModel.TRANSACTION");
            }
            if (this.params.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.HASH) {
                if (this.params.getQuorum() != 1L) {
                    throw new NxtException.NotValidException("Quorum must be 1 for by-hash voting");
                }
                if (this.hashedSecret.length == 0 || this.hashedSecret.length > 127) {
                    throw new NxtException.NotValidException("Invalid hashedSecret " + Convert.toHexString(this.hashedSecret));
                }
                if (PhasingPoll.getHashFunction(this.algorithm) == null) {
                    throw new NxtException.NotValidException("Invalid hashedSecretAlgorithm " + this.algorithm);
                }
            } else {
                if (this.hashedSecret.length != 0) {
                    throw new NxtException.NotValidException("HashedSecret can only be used with VotingModel.HASH");
                }
                if (this.algorithm != 0) {
                    throw new NxtException.NotValidException("HashedSecretAlgorithm can only be used with VotingModel.HASH");
                }
            }
            if (this.finishHeight <= n + (this.params.getVoteWeighting().acceptsVotes() ? 2 : 1) || this.finishHeight >= n + 20160) {
                throw new NxtException.NotCurrentlyValidException("Invalid finish height " + this.finishHeight);
            }
        }

        @Override
        void validateAtFinish(Transaction transaction) throws NxtException.ValidationException {
            this.params.checkApprovable();
        }

        @Override
        void apply(Transaction transaction, Account account, Account account2) {
            PhasingPoll.addPoll(transaction, this);
        }

        @Override
        boolean isPhasable() {
            return false;
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return PHASING_FEE;
        }

        private void release(TransactionImpl transactionImpl) {
            Account account = Account.getAccount(transactionImpl.getSenderId());
            Account account2 = transactionImpl.getRecipientId() == 0L ? null : Account.getAccount(transactionImpl.getRecipientId());
            transactionImpl.getAppendages().forEach(abstractAppendix -> {
                if (abstractAppendix.isPhasable()) {
                    abstractAppendix.apply(transactionImpl, account, account2);
                }
            });
            TransactionProcessorImpl.getInstance().notifyListeners(Collections.singletonList(transactionImpl), TransactionProcessor.Event.RELEASE_PHASED_TRANSACTION);
            Logger.logDebugMessage("Transaction " + transactionImpl.getStringId() + " has been released");
        }

        void reject(TransactionImpl transactionImpl) {
            Account account = Account.getAccount(transactionImpl.getSenderId());
            transactionImpl.getType().undoAttachmentUnconfirmed(transactionImpl, account);
            account.addToUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.REJECT_PHASED_TRANSACTION, transactionImpl.getId(), transactionImpl.getAmountNQT());
            TransactionProcessorImpl.getInstance().notifyListeners(Collections.singletonList(transactionImpl), TransactionProcessor.Event.REJECT_PHASED_TRANSACTION);
            Logger.logDebugMessage("Transaction " + transactionImpl.getStringId() + " has been rejected");
        }

        void countVotes(TransactionImpl transactionImpl) {
            if (PhasingPoll.getResult(transactionImpl.getId()) != null) {
                return;
            }
            PhasingPoll phasingPoll = PhasingPoll.getPoll(transactionImpl.getId());
            long l = phasingPoll.countVotes();
            phasingPoll.finish(l);
            if (l >= phasingPoll.getQuorum()) {
                try {
                    this.release(transactionImpl);
                }
                catch (RuntimeException runtimeException) {
                    Logger.logErrorMessage("Failed to release phased transaction " + transactionImpl.getJSONObject().toJSONString(), runtimeException);
                    this.reject(transactionImpl);
                }
            } else {
                this.reject(transactionImpl);
            }
        }

        void tryCountVotes(TransactionImpl transactionImpl, Map<TransactionType, Map<String, Integer>> map) {
            PhasingPoll phasingPoll = PhasingPoll.getPoll(transactionImpl.getId());
            long l = phasingPoll.countVotes();
            if (l >= phasingPoll.getQuorum()) {
                if (!transactionImpl.attachmentIsDuplicate(map, false)) {
                    try {
                        this.release(transactionImpl);
                        phasingPoll.finish(l);
                        Logger.logDebugMessage("Early finish of transaction " + transactionImpl.getStringId() + " at height " + Nxt.getBlockchain().getHeight());
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.logErrorMessage("Failed to release phased transaction " + transactionImpl.getJSONObject().toJSONString(), runtimeException);
                    }
                } else {
                    Logger.logDebugMessage("At height " + Nxt.getBlockchain().getHeight() + " phased transaction " + transactionImpl.getStringId() + " is duplicate, cannot finish early");
                }
            } else {
                Logger.logDebugMessage("At height " + Nxt.getBlockchain().getHeight() + " phased transaction " + transactionImpl.getStringId() + " does not yet meet quorum, cannot finish early");
            }
        }

        public int getFinishHeight() {
            return this.finishHeight;
        }

        public long getQuorum() {
            return this.params.getQuorum();
        }

        public long[] getWhitelist() {
            return this.params.getWhitelist();
        }

        public VoteWeighting getVoteWeighting() {
            return this.params.getVoteWeighting();
        }

        public byte[][] getLinkedFullHashes() {
            return this.linkedFullHashes;
        }

        public byte[] getHashedSecret() {
            return this.hashedSecret;
        }

        public byte getAlgorithm() {
            return this.algorithm;
        }

        public PhasingParams getParams() {
            return this.params;
        }
    }

    public static final class PublicKeyAnnouncement
    extends AbstractAppendix {
        private static final String appendixName = "PublicKeyAnnouncement";
        private final byte[] publicKey;

        static PublicKeyAnnouncement parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(appendixName, jSONObject)) {
                return null;
            }
            return new PublicKeyAnnouncement(jSONObject);
        }

        PublicKeyAnnouncement(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.publicKey = new byte[32];
            byteBuffer.get(this.publicKey);
        }

        private PublicKeyAnnouncement(JSONObject jSONObject) {
            super(jSONObject);
            this.publicKey = Convert.parseHexString((String)jSONObject.get("recipientPublicKey"));
        }

        public PublicKeyAnnouncement(byte[] byArray) {
            this.publicKey = byArray;
        }

        @Override
        String getAppendixName() {
            return appendixName;
        }

        @Override
        int getMySize() {
            return 32;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.put(this.publicKey);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("recipientPublicKey", Convert.toHexString(this.publicKey));
        }

        @Override
        void validate(Transaction transaction) throws NxtException.ValidationException {
            if (transaction.getRecipientId() == 0L) {
                throw new NxtException.NotValidException("PublicKeyAnnouncement cannot be attached to transactions with no recipient");
            }
            if (!Crypto.isCanonicalPublicKey(this.publicKey)) {
                throw new NxtException.NotValidException("Invalid recipient public key: " + Convert.toHexString(this.publicKey));
            }
            long l = transaction.getRecipientId();
            if (Account.getId(this.publicKey) != l) {
                throw new NxtException.NotValidException("Announced public key does not match recipient accountId");
            }
            byte[] byArray = Account.getPublicKey(l);
            if (byArray != null && !Arrays.equals(this.publicKey, byArray)) {
                throw new NxtException.NotCurrentlyValidException("A different public key for this account has already been announced");
            }
        }

        @Override
        void apply(Transaction transaction, Account account, Account account2) {
            if (Account.setOrVerify(account2.getId(), this.publicKey)) {
                account2.apply(this.publicKey);
            }
        }

        @Override
        boolean isPhasable() {
            return false;
        }

        public byte[] getPublicKey() {
            return this.publicKey;
        }
    }

    public static final class UnencryptedEncryptToSelfMessage
    extends EncryptToSelfMessage
    implements Encryptable {
        private final byte[] messageToEncrypt;

        UnencryptedEncryptToSelfMessage(JSONObject jSONObject) {
            super(jSONObject);
            this.setEncryptedData(null);
            JSONObject jSONObject2 = (JSONObject)jSONObject.get("encryptToSelfMessage");
            String string = (String)jSONObject2.get("messageToEncrypt");
            this.messageToEncrypt = this.isText() ? Convert.toBytes(string) : Convert.parseHexString(string);
        }

        public UnencryptedEncryptToSelfMessage(byte[] byArray, boolean bl, boolean bl2) {
            super(null, bl, bl2);
            this.messageToEncrypt = byArray;
        }

        @Override
        int getMySize() {
            if (this.getEncryptedData() != null) {
                return super.getMySize();
            }
            return 4 + EncryptedData.getEncryptedSize(this.getPlaintext());
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            if (this.getEncryptedData() == null) {
                throw new NxtException.NotYetEncryptedException("Message not yet encrypted");
            }
            super.putMyBytes(byteBuffer);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            if (this.getEncryptedData() == null) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("messageToEncrypt", this.isText() ? Convert.toString(this.messageToEncrypt) : Convert.toHexString(this.messageToEncrypt));
                jSONObject2.put("isText", this.isText());
                jSONObject2.put("isCompressed", this.isCompressed());
                jSONObject.put("encryptToSelfMessage", jSONObject2);
            } else {
                super.putMyJSON(jSONObject);
            }
        }

        @Override
        void apply(Transaction transaction, Account account, Account account2) {
            if (this.getEncryptedData() == null) {
                throw new NxtException.NotYetEncryptedException("Message not yet encrypted");
            }
            super.apply(transaction, account, account2);
        }

        @Override
        public void encrypt(String string) {
            this.setEncryptedData(EncryptedData.encrypt(this.getPlaintext(), string, Crypto.getPublicKey(string)));
        }

        @Override
        int getEncryptedDataLength() {
            return EncryptedData.getEncryptedDataLength(this.getPlaintext());
        }

        private byte[] getPlaintext() {
            return this.isCompressed() && this.messageToEncrypt.length > 0 ? Convert.compress(this.messageToEncrypt) : this.messageToEncrypt;
        }
    }

    public static class EncryptToSelfMessage
    extends AbstractEncryptedMessage {
        private static final String appendixName = "EncryptToSelfMessage";

        static EncryptToSelfMessage parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(appendixName, jSONObject)) {
                return null;
            }
            if (((JSONObject)jSONObject.get("encryptToSelfMessage")).get("data") == null) {
                return new UnencryptedEncryptToSelfMessage(jSONObject);
            }
            return new EncryptToSelfMessage(jSONObject);
        }

        EncryptToSelfMessage(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
        }

        EncryptToSelfMessage(JSONObject jSONObject) {
            super(jSONObject, (JSONObject)jSONObject.get("encryptToSelfMessage"));
        }

        public EncryptToSelfMessage(EncryptedData encryptedData, boolean bl, boolean bl2) {
            super(encryptedData, bl, bl2);
        }

        @Override
        final String getAppendixName() {
            return appendixName;
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            JSONObject jSONObject2 = new JSONObject();
            super.putMyJSON(jSONObject2);
            jSONObject.put("encryptToSelfMessage", jSONObject2);
        }
    }

    public static final class UnencryptedEncryptedMessage
    extends EncryptedMessage
    implements Encryptable {
        private final byte[] messageToEncrypt;
        private final byte[] recipientPublicKey;

        UnencryptedEncryptedMessage(JSONObject jSONObject) {
            super(jSONObject);
            this.setEncryptedData(null);
            JSONObject jSONObject2 = (JSONObject)jSONObject.get("encryptedMessage");
            String string = (String)jSONObject2.get("messageToEncrypt");
            this.messageToEncrypt = this.isText() ? Convert.toBytes(string) : Convert.parseHexString(string);
            this.recipientPublicKey = Convert.parseHexString((String)jSONObject.get("recipientPublicKey"));
        }

        public UnencryptedEncryptedMessage(byte[] byArray, boolean bl, boolean bl2, byte[] byArray2) {
            super(null, bl, bl2);
            this.messageToEncrypt = byArray;
            this.recipientPublicKey = byArray2;
        }

        @Override
        int getMySize() {
            if (this.getEncryptedData() != null) {
                return super.getMySize();
            }
            return 4 + EncryptedData.getEncryptedSize(this.getPlaintext());
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            if (this.getEncryptedData() == null) {
                throw new NxtException.NotYetEncryptedException("Message not yet encrypted");
            }
            super.putMyBytes(byteBuffer);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            if (this.getEncryptedData() == null) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("messageToEncrypt", this.isText() ? Convert.toString(this.messageToEncrypt) : Convert.toHexString(this.messageToEncrypt));
                jSONObject2.put("isText", this.isText());
                jSONObject2.put("isCompressed", this.isCompressed());
                jSONObject.put("encryptedMessage", jSONObject2);
                jSONObject.put("recipientPublicKey", Convert.toHexString(this.recipientPublicKey));
            } else {
                super.putMyJSON(jSONObject);
            }
        }

        @Override
        void apply(Transaction transaction, Account account, Account account2) {
            if (this.getEncryptedData() == null) {
                throw new NxtException.NotYetEncryptedException("Message not yet encrypted");
            }
            super.apply(transaction, account, account2);
        }

        @Override
        public void encrypt(String string) {
            this.setEncryptedData(EncryptedData.encrypt(this.getPlaintext(), string, this.recipientPublicKey));
        }

        private byte[] getPlaintext() {
            return this.isCompressed() && this.messageToEncrypt.length > 0 ? Convert.compress(this.messageToEncrypt) : this.messageToEncrypt;
        }

        @Override
        int getEncryptedDataLength() {
            return EncryptedData.getEncryptedDataLength(this.getPlaintext());
        }
    }

    public static class EncryptedMessage
    extends AbstractEncryptedMessage {
        private static final String appendixName = "EncryptedMessage";

        static EncryptedMessage parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(appendixName, jSONObject)) {
                return null;
            }
            if (((JSONObject)jSONObject.get("encryptedMessage")).get("data") == null) {
                return new UnencryptedEncryptedMessage(jSONObject);
            }
            return new EncryptedMessage(jSONObject);
        }

        EncryptedMessage(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
        }

        EncryptedMessage(JSONObject jSONObject) {
            super(jSONObject, (JSONObject)jSONObject.get("encryptedMessage"));
        }

        public EncryptedMessage(EncryptedData encryptedData, boolean bl, boolean bl2) {
            super(encryptedData, bl, bl2);
        }

        @Override
        final String getAppendixName() {
            return appendixName;
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            JSONObject jSONObject2 = new JSONObject();
            super.putMyJSON(jSONObject2);
            jSONObject.put("encryptedMessage", jSONObject2);
        }

        @Override
        void validate(Transaction transaction) throws NxtException.ValidationException {
            super.validate(transaction);
            if (transaction.getRecipientId() == 0L) {
                throw new NxtException.NotValidException("Encrypted messages cannot be attached to transactions with no recipient");
            }
        }
    }

    public static final class UnencryptedPrunableEncryptedMessage
    extends PrunableEncryptedMessage
    implements Encryptable {
        private final byte[] messageToEncrypt;
        private final byte[] recipientPublicKey;

        private UnencryptedPrunableEncryptedMessage(JSONObject jSONObject) {
            super(jSONObject);
            this.setEncryptedData(null);
            JSONObject jSONObject2 = (JSONObject)jSONObject.get("encryptedMessage");
            String string = (String)jSONObject2.get("messageToEncrypt");
            this.messageToEncrypt = this.isText() ? Convert.toBytes(string) : Convert.parseHexString(string);
            this.recipientPublicKey = Convert.parseHexString((String)jSONObject.get("recipientPublicKey"));
        }

        public UnencryptedPrunableEncryptedMessage(byte[] byArray, boolean bl, boolean bl2, byte[] byArray2) {
            super(null, bl, bl2);
            this.messageToEncrypt = byArray;
            this.recipientPublicKey = byArray2;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            if (this.getEncryptedData() == null) {
                throw new NxtException.NotYetEncryptedException("Prunable encrypted message not yet encrypted");
            }
            super.putMyBytes(byteBuffer);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            if (this.getEncryptedData() == null) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("messageToEncrypt", this.isText() ? Convert.toString(this.messageToEncrypt) : Convert.toHexString(this.messageToEncrypt));
                jSONObject2.put("isText", this.isText());
                jSONObject2.put("isCompressed", this.isCompressed());
                jSONObject.put("recipientPublicKey", Convert.toHexString(this.recipientPublicKey));
                jSONObject.put("encryptedMessage", jSONObject2);
            } else {
                super.putMyJSON(jSONObject);
            }
        }

        @Override
        void validate(Transaction transaction) throws NxtException.ValidationException {
            if (this.getEncryptedData() == null) {
                int n = this.getEncryptedDataLength();
                if (n > 43008) {
                    throw new NxtException.NotValidException(String.format("Message length %d exceeds max prunable encrypted message length %d", n, 43008));
                }
            } else {
                super.validate(transaction);
            }
        }

        @Override
        void apply(Transaction transaction, Account account, Account account2) {
            if (this.getEncryptedData() == null) {
                throw new NxtException.NotYetEncryptedException("Prunable encrypted message not yet encrypted");
            }
            super.apply(transaction, account, account2);
        }

        @Override
        void loadPrunable(Transaction transaction, boolean bl) {
        }

        @Override
        public void encrypt(String string) {
            this.setEncryptedData(EncryptedData.encrypt(this.getPlaintext(), string, this.recipientPublicKey));
        }

        @Override
        int getEncryptedDataLength() {
            return EncryptedData.getEncryptedDataLength(this.getPlaintext());
        }

        private byte[] getPlaintext() {
            return this.isCompressed() && this.messageToEncrypt.length > 0 ? Convert.compress(this.messageToEncrypt) : this.messageToEncrypt;
        }
    }

    public static class PrunableEncryptedMessage
    extends AbstractAppendix
    implements Prunable {
        private static final String appendixName = "PrunableEncryptedMessage";
        private static final Fee PRUNABLE_ENCRYPTED_DATA_FEE = new Fee.SizeBasedFee(10000000L){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                return appendix.getFullSize();
            }
        };
        private final byte[] hash;
        private EncryptedData encryptedData;
        private final boolean isText;
        private final boolean isCompressed;
        private volatile PrunableMessage prunableMessage;

        static PrunableEncryptedMessage parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(appendixName, jSONObject)) {
                return null;
            }
            JSONObject jSONObject2 = (JSONObject)jSONObject.get("encryptedMessage");
            if (jSONObject2 != null && jSONObject2.get("data") == null) {
                return new UnencryptedPrunableEncryptedMessage(jSONObject);
            }
            return new PrunableEncryptedMessage(jSONObject);
        }

        PrunableEncryptedMessage(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.hash = new byte[32];
            byteBuffer.get(this.hash);
            this.encryptedData = null;
            this.isText = false;
            this.isCompressed = false;
        }

        public PrunableEncryptedMessage(JSONObject jSONObject) {
            super(jSONObject);
            String string = Convert.emptyToNull((String)jSONObject.get("encryptedMessageHash"));
            JSONObject jSONObject2 = (JSONObject)jSONObject.get("encryptedMessage");
            if (string != null && jSONObject2 == null) {
                this.hash = Convert.parseHexString(string);
                this.encryptedData = null;
                this.isText = false;
                this.isCompressed = false;
            } else {
                this.hash = null;
                byte[] byArray = Convert.parseHexString((String)jSONObject2.get("data"));
                byte[] byArray2 = Convert.parseHexString((String)jSONObject2.get("nonce"));
                this.encryptedData = new EncryptedData(byArray, byArray2);
                this.isText = Boolean.TRUE.equals(jSONObject2.get("isText"));
                this.isCompressed = Boolean.TRUE.equals(jSONObject2.get("isCompressed"));
            }
        }

        public PrunableEncryptedMessage(EncryptedData encryptedData, boolean bl, boolean bl2) {
            this.encryptedData = encryptedData;
            this.isText = bl;
            this.isCompressed = bl2;
            this.hash = null;
        }

        @Override
        public final Fee getBaselineFee(Transaction transaction) {
            return PRUNABLE_ENCRYPTED_DATA_FEE;
        }

        @Override
        final int getMySize() {
            return 32;
        }

        @Override
        final int getMyFullSize() {
            return this.getEncryptedDataLength();
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.put(this.getHash());
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            if (this.prunableMessage != null) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject.put("encryptedMessage", jSONObject2);
                jSONObject2.put("data", Convert.toHexString(this.prunableMessage.getEncryptedData().getData()));
                jSONObject2.put("nonce", Convert.toHexString(this.prunableMessage.getEncryptedData().getNonce()));
                jSONObject2.put("isText", this.prunableMessage.encryptedMessageIsText());
                jSONObject2.put("isCompressed", this.prunableMessage.isCompressed());
            } else if (this.encryptedData != null) {
                JSONObject jSONObject3 = new JSONObject();
                jSONObject.put("encryptedMessage", jSONObject3);
                jSONObject3.put("data", Convert.toHexString(this.encryptedData.getData()));
                jSONObject3.put("nonce", Convert.toHexString(this.encryptedData.getNonce()));
                jSONObject3.put("isText", this.isText);
                jSONObject3.put("isCompressed", this.isCompressed);
            }
            jSONObject.put("encryptedMessageHash", Convert.toHexString(this.getHash()));
        }

        @Override
        final String getAppendixName() {
            return appendixName;
        }

        @Override
        void validate(Transaction transaction) throws NxtException.ValidationException {
            if (transaction.getEncryptedMessage() != null) {
                throw new NxtException.NotValidException("Cannot have both encrypted and prunable encrypted message attachments");
            }
            EncryptedData encryptedData = this.getEncryptedData();
            if (encryptedData == null && Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MIN_PRUNABLE_LIFETIME) {
                throw new NxtException.NotCurrentlyValidException("Encrypted message has been pruned prematurely");
            }
            if (encryptedData != null) {
                if (encryptedData.getData().length > 43008) {
                    throw new NxtException.NotValidException(String.format("Message length %d exceeds max prunable encrypted message length %d", encryptedData.getData().length, 43008));
                }
                if (encryptedData.getNonce().length != 32 && encryptedData.getData().length > 0 || encryptedData.getNonce().length != 0 && encryptedData.getData().length == 0) {
                    throw new NxtException.NotValidException("Invalid nonce length " + encryptedData.getNonce().length);
                }
            }
            if (transaction.getRecipientId() == 0L) {
                throw new NxtException.NotValidException("Encrypted messages cannot be attached to transactions with no recipient");
            }
        }

        @Override
        void apply(Transaction transaction, Account account, Account account2) {
            if (Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MAX_PRUNABLE_LIFETIME) {
                PrunableMessage.add((TransactionImpl)transaction, this);
            }
        }

        public final EncryptedData getEncryptedData() {
            if (this.prunableMessage != null) {
                return this.prunableMessage.getEncryptedData();
            }
            return this.encryptedData;
        }

        final void setEncryptedData(EncryptedData encryptedData) {
            this.encryptedData = encryptedData;
        }

        int getEncryptedDataLength() {
            return this.getEncryptedData() == null ? 0 : this.getEncryptedData().getData().length;
        }

        public final boolean isText() {
            if (this.prunableMessage != null) {
                return this.prunableMessage.encryptedMessageIsText();
            }
            return this.isText;
        }

        public final boolean isCompressed() {
            if (this.prunableMessage != null) {
                return this.prunableMessage.isCompressed();
            }
            return this.isCompressed;
        }

        @Override
        public final byte[] getHash() {
            if (this.hash != null) {
                return this.hash;
            }
            MessageDigest messageDigest = Crypto.sha256();
            messageDigest.update((byte)(this.isText ? 1 : 0));
            messageDigest.update((byte)(this.isCompressed ? 1 : 0));
            messageDigest.update(this.encryptedData.getData());
            messageDigest.update(this.encryptedData.getNonce());
            return messageDigest.digest();
        }

        @Override
        void loadPrunable(Transaction transaction, boolean bl) {
            PrunableMessage prunableMessage;
            if (!this.hasPrunableData() && this.shouldLoadPrunable(transaction, bl) && (prunableMessage = PrunableMessage.getPrunableMessage(transaction.getId())) != null && prunableMessage.getEncryptedData() != null) {
                this.prunableMessage = prunableMessage;
            }
        }

        @Override
        final boolean isPhasable() {
            return false;
        }

        @Override
        public final boolean hasPrunableData() {
            return this.prunableMessage != null || this.encryptedData != null;
        }

        @Override
        public void restorePrunableData(Transaction transaction, int n, int n2) {
            PrunableMessage.add((TransactionImpl)transaction, this, n, n2);
        }
    }

    public static abstract class AbstractEncryptedMessage
    extends AbstractAppendix {
        private static final Fee ENCRYPTED_MESSAGE_FEE = new Fee.SizeBasedFee(100000000L, 100000000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                return ((AbstractEncryptedMessage)appendix).getEncryptedDataLength() - 16;
            }
        };
        private EncryptedData encryptedData;
        private final boolean isText;
        private final boolean isCompressed;

        private AbstractEncryptedMessage(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            int n = byteBuffer.getInt();
            boolean bl = this.isText = n < 0;
            if (n < 0) {
                n &= Integer.MAX_VALUE;
            }
            this.encryptedData = EncryptedData.readEncryptedData(byteBuffer, n, 1000);
            this.isCompressed = this.getVersion() != 2;
        }

        private AbstractEncryptedMessage(JSONObject jSONObject, JSONObject jSONObject2) {
            super(jSONObject);
            byte[] byArray = Convert.parseHexString((String)jSONObject2.get("data"));
            byte[] byArray2 = Convert.parseHexString((String)jSONObject2.get("nonce"));
            this.encryptedData = new EncryptedData(byArray, byArray2);
            this.isText = Boolean.TRUE.equals(jSONObject2.get("isText"));
            Object v = jSONObject2.get("isCompressed");
            this.isCompressed = v == null || Boolean.TRUE.equals(v);
        }

        private AbstractEncryptedMessage(EncryptedData encryptedData, boolean bl, boolean bl2) {
            super(bl2 ? 1 : 2);
            this.encryptedData = encryptedData;
            this.isText = bl;
            this.isCompressed = bl2;
        }

        @Override
        int getMySize() {
            return 4 + this.encryptedData.getSize();
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putInt(this.isText ? this.encryptedData.getData().length | Integer.MIN_VALUE : this.encryptedData.getData().length);
            byteBuffer.put(this.encryptedData.getData());
            byteBuffer.put(this.encryptedData.getNonce());
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("data", Convert.toHexString(this.encryptedData.getData()));
            jSONObject.put("nonce", Convert.toHexString(this.encryptedData.getNonce()));
            jSONObject.put("isText", this.isText);
            jSONObject.put("isCompressed", this.isCompressed);
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return ENCRYPTED_MESSAGE_FEE;
        }

        @Override
        void validate(Transaction transaction) throws NxtException.ValidationException {
            if (this.getEncryptedDataLength() > 176) {
                throw new NxtException.NotValidException("Max encrypted message length exceeded");
            }
            if (this.encryptedData != null && (this.encryptedData.getNonce().length != 32 && this.encryptedData.getData().length > 0 || this.encryptedData.getNonce().length != 0 && this.encryptedData.getData().length == 0)) {
                throw new NxtException.NotValidException("Invalid nonce length " + this.encryptedData.getNonce().length);
            }
            if (this.getVersion() != 2 && !this.isCompressed || this.getVersion() == 2 && this.isCompressed) {
                throw new NxtException.NotValidException("Version mismatch - version " + this.getVersion() + ", isCompressed " + this.isCompressed);
            }
        }

        @Override
        boolean verifyVersion() {
            return this.getVersion() == 1 || this.getVersion() == 2;
        }

        @Override
        void apply(Transaction transaction, Account account, Account account2) {
        }

        public final EncryptedData getEncryptedData() {
            return this.encryptedData;
        }

        final void setEncryptedData(EncryptedData encryptedData) {
            this.encryptedData = encryptedData;
        }

        int getEncryptedDataLength() {
            return this.encryptedData.getData().length;
        }

        public final boolean isText() {
            return this.isText;
        }

        public final boolean isCompressed() {
            return this.isCompressed;
        }

        @Override
        final boolean isPhasable() {
            return false;
        }
    }

    public static class PrunablePlainMessage
    extends AbstractAppendix
    implements Prunable {
        private static final String appendixName = "PrunablePlainMessage";
        private static final Fee PRUNABLE_MESSAGE_FEE = new Fee.SizeBasedFee(10000000L){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                return appendix.getFullSize();
            }
        };
        private final byte[] hash;
        private final byte[] message;
        private final boolean isText;
        private volatile PrunableMessage prunableMessage;

        static PrunablePlainMessage parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(appendixName, jSONObject)) {
                return null;
            }
            return new PrunablePlainMessage(jSONObject);
        }

        PrunablePlainMessage(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.hash = new byte[32];
            byteBuffer.get(this.hash);
            this.message = null;
            this.isText = false;
        }

        private PrunablePlainMessage(JSONObject jSONObject) {
            super(jSONObject);
            String string = Convert.emptyToNull((String)jSONObject.get("messageHash"));
            String string2 = Convert.emptyToNull((String)jSONObject.get("message"));
            if (string != null && string2 == null) {
                this.hash = Convert.parseHexString(string);
                this.message = null;
                this.isText = false;
            } else {
                this.hash = null;
                this.isText = Boolean.TRUE.equals(jSONObject.get("messageIsText"));
                this.message = Convert.toBytes(string2, this.isText);
            }
        }

        public PrunablePlainMessage(byte[] byArray) {
            this(byArray, false);
        }

        public PrunablePlainMessage(String string) {
            this(Convert.toBytes(string), true);
        }

        public PrunablePlainMessage(String string, boolean bl) {
            this(Convert.toBytes(string, bl), bl);
        }

        public PrunablePlainMessage(byte[] byArray, boolean bl) {
            this.message = byArray;
            this.isText = bl;
            this.hash = null;
        }

        @Override
        String getAppendixName() {
            return appendixName;
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return PRUNABLE_MESSAGE_FEE;
        }

        @Override
        int getMySize() {
            return 32;
        }

        @Override
        int getMyFullSize() {
            return this.getMessage() == null ? 0 : this.getMessage().length;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.put(this.getHash());
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            if (this.prunableMessage != null) {
                jSONObject.put("message", Convert.toString(this.prunableMessage.getMessage(), this.prunableMessage.messageIsText()));
                jSONObject.put("messageIsText", this.prunableMessage.messageIsText());
            } else if (this.message != null) {
                jSONObject.put("message", Convert.toString(this.message, this.isText));
                jSONObject.put("messageIsText", this.isText);
            }
            jSONObject.put("messageHash", Convert.toHexString(this.getHash()));
        }

        @Override
        void validate(Transaction transaction) throws NxtException.ValidationException {
            if (transaction.getMessage() != null) {
                throw new NxtException.NotValidException("Cannot have both message and prunable message attachments");
            }
            byte[] byArray = this.getMessage();
            if (byArray != null && byArray.length > 43008) {
                throw new NxtException.NotValidException("Invalid prunable message length: " + byArray.length);
            }
            if (byArray == null && Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MIN_PRUNABLE_LIFETIME) {
                throw new NxtException.NotCurrentlyValidException("Message has been pruned prematurely");
            }
        }

        @Override
        void apply(Transaction transaction, Account account, Account account2) {
            if (Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MAX_PRUNABLE_LIFETIME) {
                PrunableMessage.add((TransactionImpl)transaction, this);
            }
        }

        public byte[] getMessage() {
            if (this.prunableMessage != null) {
                return this.prunableMessage.getMessage();
            }
            return this.message;
        }

        public boolean isText() {
            if (this.prunableMessage != null) {
                return this.prunableMessage.messageIsText();
            }
            return this.isText;
        }

        @Override
        public byte[] getHash() {
            if (this.hash != null) {
                return this.hash;
            }
            MessageDigest messageDigest = Crypto.sha256();
            messageDigest.update((byte)(this.isText ? 1 : 0));
            messageDigest.update(this.message);
            return messageDigest.digest();
        }

        @Override
        final void loadPrunable(Transaction transaction, boolean bl) {
            PrunableMessage prunableMessage;
            if (!this.hasPrunableData() && this.shouldLoadPrunable(transaction, bl) && (prunableMessage = PrunableMessage.getPrunableMessage(transaction.getId())) != null && prunableMessage.getMessage() != null) {
                this.prunableMessage = prunableMessage;
            }
        }

        @Override
        boolean isPhasable() {
            return false;
        }

        @Override
        public final boolean hasPrunableData() {
            return this.prunableMessage != null || this.message != null;
        }

        @Override
        public void restorePrunableData(Transaction transaction, int n, int n2) {
            PrunableMessage.add((TransactionImpl)transaction, this, n, n2);
        }
    }

    public static class Message
    extends AbstractAppendix {
        private static final String appendixName = "Message";
        private static final Fee MESSAGE_FEE = new Fee.SizeBasedFee(0L, 10000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                return ((Message)appendix).getMessage().length;
            }
        };
        private final byte[] message;
        private final boolean isText;

        static Message parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(appendixName, jSONObject)) {
                return null;
            }
            return new Message(jSONObject);
        }

        Message(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            int n = byteBuffer.getInt();
            boolean bl = this.isText = n < 0;
            if (n < 0) {
                n &= Integer.MAX_VALUE;
            }
            if (n > 1000) {
                throw new NxtException.NotValidException("Invalid arbitrary message length: " + n);
            }
            this.message = new byte[n];
            byteBuffer.get(this.message);
            if (this.isText && !Arrays.equals(this.message, Convert.toBytes(Convert.toString(this.message)))) {
                throw new NxtException.NotValidException("Message is not UTF-8 text");
            }
        }

        private Message(JSONObject jSONObject) {
            super(jSONObject);
            String string = (String)jSONObject.get("message");
            this.isText = Boolean.TRUE.equals(jSONObject.get("messageIsText"));
            this.message = this.isText ? Convert.toBytes(string) : Convert.parseHexString(string);
        }

        public Message(byte[] byArray) {
            this(byArray, false);
        }

        public Message(String string) {
            this(Convert.toBytes(string), true);
        }

        public Message(String string, boolean bl) {
            this(bl ? Convert.toBytes(string) : Convert.parseHexString(string), bl);
        }

        public Message(byte[] byArray, boolean bl) {
            this.message = byArray;
            this.isText = bl;
        }

        @Override
        String getAppendixName() {
            return appendixName;
        }

        @Override
        int getMySize() {
            return 4 + this.message.length;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putInt(this.isText ? this.message.length | Integer.MIN_VALUE : this.message.length);
            byteBuffer.put(this.message);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("message", Convert.toString(this.message, this.isText));
            jSONObject.put("messageIsText", this.isText);
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return MESSAGE_FEE;
        }

        @Override
        void validate(Transaction transaction) throws NxtException.ValidationException {
            if (this.message.length > 160) {
                throw new NxtException.NotValidException("Invalid arbitrary message length: " + this.message.length);
            }
        }

        @Override
        void apply(Transaction transaction, Account account, Account account2) {
        }

        public byte[] getMessage() {
            return this.message;
        }

        public boolean isText() {
            return this.isText;
        }

        @Override
        boolean isPhasable() {
            return false;
        }
    }

    public static abstract class AbstractAppendix
    implements Appendix {
        private final byte version;

        AbstractAppendix(JSONObject jSONObject) {
            this.version = ((Long)jSONObject.get("version." + this.getAppendixName())).byteValue();
        }

        AbstractAppendix(ByteBuffer byteBuffer) {
            this.version = byteBuffer.get();
        }

        AbstractAppendix(int n) {
            this.version = (byte)n;
        }

        AbstractAppendix() {
            this.version = 1;
        }

        abstract String getAppendixName();

        @Override
        public final int getSize() {
            return this.getMySize() + (this.version > 0 ? 1 : 0);
        }

        @Override
        public final int getFullSize() {
            return this.getMyFullSize() + (this.version > 0 ? 1 : 0);
        }

        abstract int getMySize();

        int getMyFullSize() {
            return this.getMySize();
        }

        @Override
        public final void putBytes(ByteBuffer byteBuffer) {
            if (this.version > 0) {
                byteBuffer.put(this.version);
            }
            this.putMyBytes(byteBuffer);
        }

        abstract void putMyBytes(ByteBuffer var1);

        @Override
        public final JSONObject getJSONObject() {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("version." + this.getAppendixName(), this.version);
            this.putMyJSON(jSONObject);
            return jSONObject;
        }

        abstract void putMyJSON(JSONObject var1);

        @Override
        public final byte getVersion() {
            return this.version;
        }

        boolean verifyVersion() {
            return this.version == 1;
        }

        @Override
        public int getBaselineFeeHeight() {
            return 1;
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return Fee.NONE;
        }

        @Override
        public int getNextFeeHeight() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Fee getNextFee(Transaction transaction) {
            return this.getBaselineFee(transaction);
        }

        abstract void validate(Transaction var1) throws NxtException.ValidationException;

        void validateAtFinish(Transaction transaction) throws NxtException.ValidationException {
            if (!this.isPhased(transaction)) {
                return;
            }
            this.validate(transaction);
        }

        abstract void apply(Transaction var1, Account var2, Account var3);

        final void loadPrunable(Transaction transaction) {
            this.loadPrunable(transaction, false);
        }

        void loadPrunable(Transaction transaction, boolean bl) {
        }

        abstract boolean isPhasable();

        @Override
        public final boolean isPhased(Transaction transaction) {
            return this.isPhasable() && transaction.getPhasing() != null;
        }
    }

    public static interface Encryptable {
        public void encrypt(String var1);
    }

    public static interface Prunable {
        public byte[] getHash();

        public boolean hasPrunableData();

        public void restorePrunableData(Transaction var1, int var2, int var3);

        default public boolean shouldLoadPrunable(Transaction transaction, boolean bl) {
            return Nxt.getEpochTime() - transaction.getTimestamp() < (bl && Constants.INCLUDE_EXPIRED_PRUNABLE ? Constants.MAX_PRUNABLE_LIFETIME : Constants.MIN_PRUNABLE_LIFETIME);
        }
    }
}

