/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Attachment;
import nxt.HoldingType;
import nxt.Nxt;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.EntityDbTable;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class AssetDividend {
    private static final Listeners<AssetDividend, Event> listeners = new Listeners();
    private static final DbKey.LongKeyFactory<AssetDividend> dividendDbKeyFactory = new DbKey.LongKeyFactory<AssetDividend>("id"){

        @Override
        public DbKey newKey(AssetDividend assetDividend) {
            return assetDividend.dbKey;
        }
    };
    private static final EntityDbTable<AssetDividend> assetDividendTable = new EntityDbTable<AssetDividend>("asset_dividend", dividendDbKeyFactory){

        @Override
        protected AssetDividend load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new AssetDividend(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, AssetDividend assetDividend) throws SQLException {
            assetDividend.save(connection);
        }
    };
    private final long id;
    private final DbKey dbKey;
    private final long holdingId;
    private final HoldingType holdingType;
    private final long assetId;
    private final long amountNQTPerQNT;
    private final int dividendHeight;
    private final long totalDividend;
    private final long numAccounts;
    private final int timestamp;
    private final int height;

    public static boolean addListener(Listener<AssetDividend> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<AssetDividend> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static DbIterator<AssetDividend> getAssetDividends(long l, int n, int n2) {
        return assetDividendTable.getManyBy(new DbClause.LongClause("asset_id", l), n, n2);
    }

    public static AssetDividend getLastDividend(long l) {
        try (DbIterator<AssetDividend> dbIterator = assetDividendTable.getManyBy(new DbClause.LongClause("asset_id", l), 0, 0);){
            if (dbIterator.hasNext()) {
                AssetDividend assetDividend = dbIterator.next();
                return assetDividend;
            }
        }
        return null;
    }

    static AssetDividend addAssetDividend(long l, Attachment.ColoredCoinsDividendPayment coloredCoinsDividendPayment, long l2, long l3) {
        AssetDividend assetDividend = new AssetDividend(l, coloredCoinsDividendPayment, l2, l3);
        assetDividendTable.insert(assetDividend);
        listeners.notify(assetDividend, Event.ASSET_DIVIDEND);
        return assetDividend;
    }

    static void init() {
    }

    private AssetDividend(long l, Attachment.ColoredCoinsDividendPayment coloredCoinsDividendPayment, long l2, long l3) {
        this.id = l;
        this.dbKey = dividendDbKeyFactory.newKey(this.id);
        this.holdingId = coloredCoinsDividendPayment.getHoldingId();
        this.holdingType = coloredCoinsDividendPayment.getHoldingType();
        this.assetId = coloredCoinsDividendPayment.getAssetId();
        this.amountNQTPerQNT = coloredCoinsDividendPayment.getAmountNQTPerQNT();
        this.dividendHeight = coloredCoinsDividendPayment.getHeight();
        this.totalDividend = l2;
        this.numAccounts = l3;
        this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
        this.height = Nxt.getBlockchain().getHeight();
    }

    private AssetDividend(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.holdingId = resultSet.getLong("holding_id");
        this.holdingType = HoldingType.get(resultSet.getByte("holding_type"));
        this.assetId = resultSet.getLong("asset_id");
        this.amountNQTPerQNT = resultSet.getLong("amount");
        this.dividendHeight = resultSet.getInt("dividend_height");
        this.totalDividend = resultSet.getLong("total_dividend");
        this.numAccounts = resultSet.getLong("num_accounts");
        this.timestamp = resultSet.getInt("timestamp");
        this.height = resultSet.getInt("height");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO asset_dividend (id, holding_id, holding_type, asset_id, amount, dividend_height, total_dividend, num_accounts, timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.holdingId);
            preparedStatement.setByte(++n, this.holdingType.getCode());
            preparedStatement.setLong(++n, this.assetId);
            preparedStatement.setLong(++n, this.amountNQTPerQNT);
            preparedStatement.setInt(++n, this.dividendHeight);
            preparedStatement.setLong(++n, this.totalDividend);
            preparedStatement.setLong(++n, this.numAccounts);
            preparedStatement.setInt(++n, this.timestamp);
            preparedStatement.setInt(++n, this.height);
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getHoldingId() {
        return this.holdingId;
    }

    public HoldingType getHoldingType() {
        return this.holdingType;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public long getAmountNQTPerQNT() {
        return this.amountNQTPerQNT;
    }

    public int getDividendHeight() {
        return this.dividendHeight;
    }

    public long getTotalDividend() {
        return this.totalDividend;
    }

    public long getNumAccounts() {
        return this.numAccounts;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getHeight() {
        return this.height;
    }

    public static enum Event {
        ASSET_DIVIDEND;

    }
}

