/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nxt.Account;
import nxt.Appendix;
import nxt.Constants;
import nxt.Fee;
import nxt.HoldingType;
import nxt.MonetarySystem;
import nxt.Nxt;
import nxt.NxtException;
import nxt.PhasingParams;
import nxt.ShufflingParticipant;
import nxt.ShufflingTransaction;
import nxt.TaggedData;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.TransactionType;
import nxt.VoteWeighting;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.util.Convert;
import nxt.util.bbh.LengthRwPrimitiveType;
import nxt.util.bbh.StringRw;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public interface Attachment
extends Appendix {
    public static final EmptyAttachment ORDINARY_PAYMENT = new EmptyAttachment(){

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Payment.ORDINARY;
        }
    };
    public static final EmptyAttachment ARBITRARY_MESSAGE = new EmptyAttachment(){

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.ARBITRARY_MESSAGE;
        }
    };

    public TransactionType getTransactionType();

    public static final class SetPhasingOnly
    extends AbstractAttachment {
        private final PhasingParams phasingParams;
        private final long maxFees;
        private final short minDuration;
        private final short maxDuration;

        public SetPhasingOnly(PhasingParams phasingParams, long l, short s, short s2) {
            this.phasingParams = phasingParams;
            this.maxFees = l;
            this.minDuration = s;
            this.maxDuration = s2;
        }

        SetPhasingOnly(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.phasingParams = new PhasingParams(byteBuffer);
            this.maxFees = byteBuffer.getLong();
            this.minDuration = byteBuffer.getShort();
            this.maxDuration = byteBuffer.getShort();
        }

        SetPhasingOnly(JSONObject jSONObject) {
            super(jSONObject);
            JSONObject jSONObject2 = (JSONObject)jSONObject.get("phasingControlParams");
            this.phasingParams = new PhasingParams(jSONObject2);
            this.maxFees = Convert.parseLong(jSONObject.get("controlMaxFees"));
            this.minDuration = ((Long)jSONObject.get("controlMinDuration")).shortValue();
            this.maxDuration = ((Long)jSONObject.get("controlMaxDuration")).shortValue();
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.AccountControl.SET_PHASING_ONLY;
        }

        @Override
        int getMySize() {
            return this.phasingParams.getMySize() + 8 + 2 + 2;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            this.phasingParams.putMyBytes(byteBuffer);
            byteBuffer.putLong(this.maxFees);
            byteBuffer.putShort(this.minDuration);
            byteBuffer.putShort(this.maxDuration);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            JSONObject jSONObject2 = new JSONObject();
            this.phasingParams.putMyJSON(jSONObject2);
            jSONObject.put("phasingControlParams", jSONObject2);
            jSONObject.put("controlMaxFees", this.maxFees);
            jSONObject.put("controlMinDuration", this.minDuration);
            jSONObject.put("controlMaxDuration", this.maxDuration);
        }

        public PhasingParams getPhasingParams() {
            return this.phasingParams;
        }

        public long getMaxFees() {
            return this.maxFees;
        }

        public short getMinDuration() {
            return this.minDuration;
        }

        public short getMaxDuration() {
            return this.maxDuration;
        }
    }

    public static final class TaggedDataExtend
    extends TaggedDataAttachment {
        private volatile byte[] hash;
        private final long taggedDataId;
        private final boolean jsonIsPruned;

        static TaggedDataExtend parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(TransactionType.Data.TAGGED_DATA_EXTEND.getName(), jSONObject)) {
                return null;
            }
            return new TaggedDataExtend(jSONObject);
        }

        TaggedDataExtend(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.taggedDataId = byteBuffer.getLong();
            this.jsonIsPruned = false;
        }

        TaggedDataExtend(JSONObject jSONObject) {
            super(jSONObject);
            this.taggedDataId = Convert.parseUnsignedLong((String)jSONObject.get("taggedData"));
            this.jsonIsPruned = jSONObject.get("data") == null;
        }

        public TaggedDataExtend(TaggedData taggedData) {
            super(taggedData.getName(), taggedData.getDescription(), taggedData.getTags(), taggedData.getType(), taggedData.getChannel(), taggedData.isText(), taggedData.getFilename(), taggedData.getData());
            this.taggedDataId = taggedData.getId();
            this.jsonIsPruned = false;
        }

        @Override
        int getMySize() {
            return 8;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.taggedDataId);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            super.putMyJSON(jSONObject);
            jSONObject.put("taggedData", Long.toUnsignedString(this.taggedDataId));
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Data.TAGGED_DATA_EXTEND;
        }

        public long getTaggedDataId() {
            return this.taggedDataId;
        }

        @Override
        public byte[] getHash() {
            if (this.hash == null) {
                this.hash = super.getHash();
            }
            if (this.hash == null) {
                TaggedDataUpload taggedDataUpload = (TaggedDataUpload)TransactionDb.findTransaction(this.taggedDataId).getAttachment();
                this.hash = taggedDataUpload.getHash();
            }
            return this.hash;
        }

        @Override
        long getTaggedDataId(Transaction transaction) {
            return this.taggedDataId;
        }

        boolean jsonIsPruned() {
            return this.jsonIsPruned;
        }

        @Override
        public void restorePrunableData(Transaction transaction, int n, int n2) {
        }
    }

    public static final class TaggedDataUpload
    extends TaggedDataAttachment {
        private final byte[] hash;

        static TaggedDataUpload parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(TransactionType.Data.TAGGED_DATA_UPLOAD.getName(), jSONObject)) {
                return null;
            }
            return new TaggedDataUpload(jSONObject);
        }

        TaggedDataUpload(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.hash = new byte[32];
            byteBuffer.get(this.hash);
        }

        TaggedDataUpload(JSONObject jSONObject) {
            super(jSONObject);
            String string = (String)jSONObject.get("data");
            this.hash = (byte[])(string == null ? Convert.parseHexString(Convert.emptyToNull((String)jSONObject.get("hash"))) : null);
        }

        public TaggedDataUpload(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, byte[] byArray) throws NxtException.NotValidException {
            super(string, string2, string3, string4, string5, bl, string6, byArray);
            this.hash = null;
            if (bl && !Arrays.equals(byArray, Convert.toBytes(Convert.toString(byArray)))) {
                throw new NxtException.NotValidException("Data is not UTF-8 text");
            }
        }

        @Override
        int getMySize() {
            return 32;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.put(this.getHash());
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            super.putMyJSON(jSONObject);
            jSONObject.put("hash", Convert.toHexString(this.getHash()));
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Data.TAGGED_DATA_UPLOAD;
        }

        @Override
        public byte[] getHash() {
            if (this.hash != null) {
                return this.hash;
            }
            return super.getHash();
        }

        @Override
        long getTaggedDataId(Transaction transaction) {
            return transaction.getId();
        }

        @Override
        public void restorePrunableData(Transaction transaction, int n, int n2) {
            TaggedData.restore(transaction, this, n, n2);
        }
    }

    public static abstract class TaggedDataAttachment
    extends AbstractAttachment
    implements Appendix.Prunable {
        private final String name;
        private final String description;
        private final String tags;
        private final String type;
        private final String channel;
        private final boolean isText;
        private final String filename;
        private final byte[] data;
        private volatile TaggedData taggedData;

        private TaggedDataAttachment(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.name = null;
            this.description = null;
            this.tags = null;
            this.type = null;
            this.channel = null;
            this.isText = false;
            this.filename = null;
            this.data = null;
        }

        private TaggedDataAttachment(JSONObject jSONObject) {
            super(jSONObject);
            String string = (String)jSONObject.get("data");
            if (string != null) {
                this.name = (String)jSONObject.get("name");
                this.description = (String)jSONObject.get("description");
                this.tags = (String)jSONObject.get("tags");
                this.type = (String)jSONObject.get("type");
                this.channel = Convert.nullToEmpty((String)jSONObject.get("channel"));
                this.isText = Boolean.TRUE.equals(jSONObject.get("isText"));
                this.data = this.isText ? Convert.toBytes(string) : Convert.parseHexString(string);
                this.filename = (String)jSONObject.get("filename");
            } else {
                this.name = null;
                this.description = null;
                this.tags = null;
                this.type = null;
                this.channel = null;
                this.isText = false;
                this.filename = null;
                this.data = null;
            }
        }

        private TaggedDataAttachment(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, byte[] byArray) {
            this.name = string;
            this.description = string2;
            this.tags = string3;
            this.type = string4;
            this.channel = string5;
            this.isText = bl;
            this.data = byArray;
            this.filename = string6;
        }

        @Override
        final int getMyFullSize() {
            if (this.getData() == null) {
                return 0;
            }
            return Convert.toBytes(this.getName()).length + Convert.toBytes(this.getDescription()).length + Convert.toBytes(this.getType()).length + Convert.toBytes(this.getChannel()).length + Convert.toBytes(this.getTags()).length + Convert.toBytes(this.getFilename()).length + this.getData().length;
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            if (this.taggedData != null) {
                jSONObject.put("name", this.taggedData.getName());
                jSONObject.put("description", this.taggedData.getDescription());
                jSONObject.put("tags", this.taggedData.getTags());
                jSONObject.put("type", this.taggedData.getType());
                jSONObject.put("channel", this.taggedData.getChannel());
                jSONObject.put("isText", this.taggedData.isText());
                jSONObject.put("filename", this.taggedData.getFilename());
                jSONObject.put("data", this.taggedData.isText() ? Convert.toString(this.taggedData.getData()) : Convert.toHexString(this.taggedData.getData()));
            } else if (this.data != null) {
                jSONObject.put("name", this.name);
                jSONObject.put("description", this.description);
                jSONObject.put("tags", this.tags);
                jSONObject.put("type", this.type);
                jSONObject.put("channel", this.channel);
                jSONObject.put("isText", this.isText);
                jSONObject.put("filename", this.filename);
                jSONObject.put("data", this.isText ? Convert.toString(this.data) : Convert.toHexString(this.data));
            }
        }

        @Override
        public byte[] getHash() {
            if (this.data == null) {
                return null;
            }
            MessageDigest messageDigest = Crypto.sha256();
            messageDigest.update(Convert.toBytes(this.name));
            messageDigest.update(Convert.toBytes(this.description));
            messageDigest.update(Convert.toBytes(this.tags));
            messageDigest.update(Convert.toBytes(this.type));
            messageDigest.update(Convert.toBytes(this.channel));
            messageDigest.update((byte)(this.isText ? 1 : 0));
            messageDigest.update(Convert.toBytes(this.filename));
            messageDigest.update(this.data);
            return messageDigest.digest();
        }

        public final String getName() {
            if (this.taggedData != null) {
                return this.taggedData.getName();
            }
            return this.name;
        }

        public final String getDescription() {
            if (this.taggedData != null) {
                return this.taggedData.getDescription();
            }
            return this.description;
        }

        public final String getTags() {
            if (this.taggedData != null) {
                return this.taggedData.getTags();
            }
            return this.tags;
        }

        public final String getType() {
            if (this.taggedData != null) {
                return this.taggedData.getType();
            }
            return this.type;
        }

        public final String getChannel() {
            if (this.taggedData != null) {
                return this.taggedData.getChannel();
            }
            return this.channel;
        }

        public final boolean isText() {
            if (this.taggedData != null) {
                return this.taggedData.isText();
            }
            return this.isText;
        }

        public final String getFilename() {
            if (this.taggedData != null) {
                return this.taggedData.getFilename();
            }
            return this.filename;
        }

        public final byte[] getData() {
            if (this.taggedData != null) {
                return this.taggedData.getData();
            }
            return this.data;
        }

        @Override
        void loadPrunable(Transaction transaction, boolean bl) {
            if (this.data == null && this.taggedData == null && this.shouldLoadPrunable(transaction, bl)) {
                this.taggedData = TaggedData.getData(this.getTaggedDataId(transaction));
            }
        }

        @Override
        public boolean hasPrunableData() {
            return this.taggedData != null || this.data != null;
        }

        abstract long getTaggedDataId(Transaction var1);
    }

    public static final class ShufflingCancellation
    extends AbstractShufflingAttachment {
        private final byte[][] blameData;
        private final byte[][] keySeeds;
        private final long cancellingAccountId;

        ShufflingCancellation(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            int n;
            int n2 = byteBuffer.get();
            if (n2 > 30 || n2 <= 0) {
                throw new NxtException.NotValidException("Invalid data count " + n2);
            }
            this.blameData = new byte[n2][];
            for (n = 0; n < n2; ++n) {
                int n3 = byteBuffer.getInt();
                if (n3 > Constants.MAX_PAYLOAD_LENGTH) {
                    throw new NxtException.NotValidException("Invalid data size " + n3);
                }
                this.blameData[n] = new byte[n3];
                byteBuffer.get(this.blameData[n]);
            }
            n2 = byteBuffer.get();
            if (n2 > 30 || n2 <= 0) {
                throw new NxtException.NotValidException("Invalid keySeeds count " + n2);
            }
            this.keySeeds = new byte[n2][];
            for (n = 0; n < n2; ++n) {
                this.keySeeds[n] = new byte[32];
                byteBuffer.get(this.keySeeds[n]);
            }
            this.cancellingAccountId = byteBuffer.getLong();
        }

        ShufflingCancellation(JSONObject jSONObject) {
            super(jSONObject);
            int n;
            JSONArray jSONArray = (JSONArray)jSONObject.get("blameData");
            this.blameData = new byte[jSONArray.size()][];
            for (n = 0; n < this.blameData.length; ++n) {
                this.blameData[n] = Convert.parseHexString((String)jSONArray.get(n));
            }
            jSONArray = (JSONArray)jSONObject.get("keySeeds");
            this.keySeeds = new byte[jSONArray.size()][];
            for (n = 0; n < this.keySeeds.length; ++n) {
                this.keySeeds[n] = Convert.parseHexString((String)jSONArray.get(n));
            }
            this.cancellingAccountId = Convert.parseUnsignedLong((String)jSONObject.get("cancellingAccount"));
        }

        ShufflingCancellation(long l, byte[][] byArray, byte[][] byArray2, byte[] byArray3, long l2) {
            super(l, byArray3);
            this.blameData = byArray;
            this.keySeeds = byArray2;
            this.cancellingAccountId = l2;
        }

        @Override
        public TransactionType getTransactionType() {
            return ShufflingTransaction.SHUFFLING_CANCELLATION;
        }

        @Override
        int getMySize() {
            int n = super.getMySize();
            ++n;
            for (byte[] byArray : this.blameData) {
                n += 4;
                n += byArray.length;
            }
            ++n;
            n += 32 * this.keySeeds.length;
            return n += 8;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            super.putMyBytes(byteBuffer);
            byteBuffer.put((byte)this.blameData.length);
            for (byte[] byArray : this.blameData) {
                byteBuffer.putInt(byArray.length);
                byteBuffer.put(byArray);
            }
            byteBuffer.put((byte)this.keySeeds.length);
            for (byte[] byArray : this.keySeeds) {
                byteBuffer.put(byArray);
            }
            byteBuffer.putLong(this.cancellingAccountId);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            super.putMyJSON(jSONObject);
            JSONArray jSONArray = new JSONArray();
            jSONObject.put("blameData", jSONArray);
            for (byte[] byArray : this.blameData) {
                jSONArray.add(Convert.toHexString(byArray));
            }
            jSONArray = new JSONArray();
            jSONObject.put("keySeeds", jSONArray);
            for (byte[] byArray : this.keySeeds) {
                jSONArray.add(Convert.toHexString(byArray));
            }
            if (this.cancellingAccountId != 0L) {
                jSONObject.put("cancellingAccount", Long.toUnsignedString(this.cancellingAccountId));
            }
        }

        public byte[][] getBlameData() {
            return this.blameData;
        }

        public byte[][] getKeySeeds() {
            return this.keySeeds;
        }

        public long getCancellingAccountId() {
            return this.cancellingAccountId;
        }

        byte[] getHash() {
            MessageDigest messageDigest = Crypto.sha256();
            for (byte[] byArray : this.blameData) {
                messageDigest.update(byArray);
            }
            return messageDigest.digest();
        }
    }

    public static final class ShufflingVerification
    extends AbstractShufflingAttachment {
        ShufflingVerification(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        ShufflingVerification(JSONObject jSONObject) {
            super(jSONObject);
        }

        public ShufflingVerification(long l, byte[] byArray) {
            super(l, byArray);
        }

        @Override
        public TransactionType getTransactionType() {
            return ShufflingTransaction.SHUFFLING_VERIFICATION;
        }
    }

    public static final class ShufflingRecipients
    extends AbstractShufflingAttachment {
        private final byte[][] recipientPublicKeys;

        ShufflingRecipients(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            int n = byteBuffer.get();
            if (n > 30 || n < 0) {
                throw new NxtException.NotValidException("Invalid data count " + n);
            }
            this.recipientPublicKeys = new byte[n][];
            for (int i = 0; i < n; ++i) {
                this.recipientPublicKeys[i] = new byte[32];
                byteBuffer.get(this.recipientPublicKeys[i]);
            }
        }

        ShufflingRecipients(JSONObject jSONObject) {
            super(jSONObject);
            JSONArray jSONArray = (JSONArray)jSONObject.get("recipientPublicKeys");
            this.recipientPublicKeys = new byte[jSONArray.size()][];
            for (int i = 0; i < this.recipientPublicKeys.length; ++i) {
                this.recipientPublicKeys[i] = Convert.parseHexString((String)jSONArray.get(i));
            }
        }

        ShufflingRecipients(long l, byte[][] byArray, byte[] byArray2) {
            super(l, byArray2);
            this.recipientPublicKeys = byArray;
        }

        @Override
        int getMySize() {
            int n = super.getMySize();
            ++n;
            return n += 32 * this.recipientPublicKeys.length;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            super.putMyBytes(byteBuffer);
            byteBuffer.put((byte)this.recipientPublicKeys.length);
            for (byte[] byArray : this.recipientPublicKeys) {
                byteBuffer.put(byArray);
            }
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            super.putMyJSON(jSONObject);
            JSONArray jSONArray = new JSONArray();
            jSONObject.put("recipientPublicKeys", jSONArray);
            for (byte[] byArray : this.recipientPublicKeys) {
                jSONArray.add(Convert.toHexString(byArray));
            }
        }

        @Override
        public TransactionType getTransactionType() {
            return ShufflingTransaction.SHUFFLING_RECIPIENTS;
        }

        public byte[][] getRecipientPublicKeys() {
            return this.recipientPublicKeys;
        }
    }

    public static final class ShufflingProcessing
    extends AbstractShufflingAttachment
    implements Appendix.Prunable {
        private static final byte[] emptyDataHash = Crypto.sha256().digest();
        private volatile byte[][] data;
        private final byte[] hash;

        static ShufflingProcessing parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(ShufflingTransaction.SHUFFLING_PROCESSING.getName(), jSONObject)) {
                return null;
            }
            return new ShufflingProcessing(jSONObject);
        }

        ShufflingProcessing(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.hash = new byte[32];
            byteBuffer.get(this.hash);
            this.data = (byte[][])(Arrays.equals(this.hash, emptyDataHash) ? Convert.EMPTY_BYTES : null);
        }

        ShufflingProcessing(JSONObject jSONObject) {
            super(jSONObject);
            JSONArray jSONArray = (JSONArray)jSONObject.get("data");
            if (jSONArray != null) {
                this.data = new byte[jSONArray.size()][];
                for (int i = 0; i < this.data.length; ++i) {
                    this.data[i] = Convert.parseHexString((String)jSONArray.get(i));
                }
                this.hash = null;
            } else {
                this.hash = Convert.parseHexString(Convert.emptyToNull((String)jSONObject.get("hash")));
                this.data = (byte[][])(Arrays.equals(this.hash, emptyDataHash) ? Convert.EMPTY_BYTES : null);
            }
        }

        ShufflingProcessing(long l, byte[][] byArray, byte[] byArray2) {
            super(l, byArray2);
            this.data = byArray;
            this.hash = null;
        }

        @Override
        int getMyFullSize() {
            int n = super.getMySize();
            if (this.data != null) {
                ++n;
                for (byte[] byArray : this.data) {
                    n += 4;
                    n += byArray.length;
                }
            }
            return n / 2;
        }

        @Override
        int getMySize() {
            return super.getMySize() + 32;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            super.putMyBytes(byteBuffer);
            byteBuffer.put(this.getHash());
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            super.putMyJSON(jSONObject);
            if (this.data != null) {
                JSONArray jSONArray = new JSONArray();
                jSONObject.put("data", jSONArray);
                for (byte[] byArray : this.data) {
                    jSONArray.add(Convert.toHexString(byArray));
                }
            }
            jSONObject.put("hash", Convert.toHexString(this.getHash()));
        }

        @Override
        public TransactionType getTransactionType() {
            return ShufflingTransaction.SHUFFLING_PROCESSING;
        }

        @Override
        public byte[] getHash() {
            if (this.hash != null) {
                return this.hash;
            }
            if (this.data != null) {
                MessageDigest messageDigest = Crypto.sha256();
                for (byte[] byArray : this.data) {
                    messageDigest.update(byArray);
                }
                return messageDigest.digest();
            }
            throw new IllegalStateException("Both hash and data are null");
        }

        public byte[][] getData() {
            return this.data;
        }

        @Override
        void loadPrunable(Transaction transaction, boolean bl) {
            if (this.data == null && this.shouldLoadPrunable(transaction, bl)) {
                this.data = ShufflingParticipant.getData(this.getShufflingId(), transaction.getSenderId());
            }
        }

        @Override
        public boolean hasPrunableData() {
            return this.data != null;
        }

        @Override
        public void restorePrunableData(Transaction transaction, int n, int n2) {
            ShufflingParticipant.restoreData(this.getShufflingId(), transaction.getSenderId(), this.getData(), transaction.getTimestamp(), n2);
        }
    }

    public static final class ShufflingRegistration
    extends AbstractAttachment
    implements ShufflingAttachment {
        private final byte[] shufflingFullHash;

        ShufflingRegistration(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.shufflingFullHash = new byte[32];
            byteBuffer.get(this.shufflingFullHash);
        }

        ShufflingRegistration(JSONObject jSONObject) {
            super(jSONObject);
            this.shufflingFullHash = Convert.parseHexString((String)jSONObject.get("shufflingFullHash"));
        }

        public ShufflingRegistration(byte[] byArray) {
            this.shufflingFullHash = byArray;
        }

        @Override
        public TransactionType getTransactionType() {
            return ShufflingTransaction.SHUFFLING_REGISTRATION;
        }

        @Override
        int getMySize() {
            return 32;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.put(this.shufflingFullHash);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("shufflingFullHash", Convert.toHexString(this.shufflingFullHash));
        }

        @Override
        public long getShufflingId() {
            return Convert.fullHashToId(this.shufflingFullHash);
        }

        @Override
        public byte[] getShufflingStateHash() {
            return this.shufflingFullHash;
        }
    }

    public static abstract class AbstractShufflingAttachment
    extends AbstractAttachment
    implements ShufflingAttachment {
        private final long shufflingId;
        private final byte[] shufflingStateHash;

        private AbstractShufflingAttachment(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.shufflingId = byteBuffer.getLong();
            this.shufflingStateHash = new byte[32];
            byteBuffer.get(this.shufflingStateHash);
        }

        private AbstractShufflingAttachment(JSONObject jSONObject) {
            super(jSONObject);
            this.shufflingId = Convert.parseUnsignedLong((String)jSONObject.get("shuffling"));
            this.shufflingStateHash = Convert.parseHexString((String)jSONObject.get("shufflingStateHash"));
        }

        private AbstractShufflingAttachment(long l, byte[] byArray) {
            this.shufflingId = l;
            this.shufflingStateHash = byArray;
        }

        @Override
        int getMySize() {
            return 40;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.shufflingId);
            byteBuffer.put(this.shufflingStateHash);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("shuffling", Long.toUnsignedString(this.shufflingId));
            jSONObject.put("shufflingStateHash", Convert.toHexString(this.shufflingStateHash));
        }

        @Override
        public final long getShufflingId() {
            return this.shufflingId;
        }

        @Override
        public final byte[] getShufflingStateHash() {
            return this.shufflingStateHash;
        }
    }

    public static interface ShufflingAttachment
    extends Attachment {
        public long getShufflingId();

        public byte[] getShufflingStateHash();
    }

    public static final class ShufflingCreation
    extends AbstractAttachment {
        private final long holdingId;
        private final HoldingType holdingType;
        private final long amount;
        private final byte participantCount;
        private final short registrationPeriod;

        ShufflingCreation(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.holdingId = byteBuffer.getLong();
            this.holdingType = HoldingType.get(byteBuffer.get());
            this.amount = byteBuffer.getLong();
            this.participantCount = byteBuffer.get();
            this.registrationPeriod = byteBuffer.getShort();
        }

        ShufflingCreation(JSONObject jSONObject) {
            super(jSONObject);
            this.holdingId = Convert.parseUnsignedLong((String)jSONObject.get("holding"));
            this.holdingType = HoldingType.get(((Long)jSONObject.get("holdingType")).byteValue());
            this.amount = Convert.parseLong(jSONObject.get("amount"));
            this.participantCount = ((Long)jSONObject.get("participantCount")).byteValue();
            this.registrationPeriod = ((Long)jSONObject.get("registrationPeriod")).shortValue();
        }

        public ShufflingCreation(long l, HoldingType holdingType, long l2, byte by, short s) {
            this.holdingId = l;
            this.holdingType = holdingType;
            this.amount = l2;
            this.participantCount = by;
            this.registrationPeriod = s;
        }

        @Override
        int getMySize() {
            return 20;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.holdingId);
            byteBuffer.put(this.holdingType.getCode());
            byteBuffer.putLong(this.amount);
            byteBuffer.put(this.participantCount);
            byteBuffer.putShort(this.registrationPeriod);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("holding", Long.toUnsignedString(this.holdingId));
            jSONObject.put("holdingType", this.holdingType.getCode());
            jSONObject.put("amount", this.amount);
            jSONObject.put("participantCount", this.participantCount);
            jSONObject.put("registrationPeriod", this.registrationPeriod);
        }

        @Override
        public TransactionType getTransactionType() {
            return ShufflingTransaction.SHUFFLING_CREATION;
        }

        public long getHoldingId() {
            return this.holdingId;
        }

        public HoldingType getHoldingType() {
            return this.holdingType;
        }

        public long getAmount() {
            return this.amount;
        }

        public byte getParticipantCount() {
            return this.participantCount;
        }

        public short getRegistrationPeriod() {
            return this.registrationPeriod;
        }
    }

    public static final class MonetarySystemCurrencyDeletion
    extends AbstractAttachment
    implements MonetarySystemAttachment {
        private final long currencyId;

        MonetarySystemCurrencyDeletion(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.currencyId = byteBuffer.getLong();
        }

        MonetarySystemCurrencyDeletion(JSONObject jSONObject) {
            super(jSONObject);
            this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get("currency"));
        }

        public MonetarySystemCurrencyDeletion(long l) {
            this.currencyId = l;
        }

        @Override
        int getMySize() {
            return 8;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.currencyId);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("currency", Long.toUnsignedString(this.currencyId));
        }

        @Override
        public TransactionType getTransactionType() {
            return MonetarySystem.CURRENCY_DELETION;
        }

        @Override
        public long getCurrencyId() {
            return this.currencyId;
        }
    }

    public static final class MonetarySystemCurrencyMinting
    extends AbstractAttachment
    implements MonetarySystemAttachment {
        private final long nonce;
        private final long currencyId;
        private final long units;
        private final long counter;

        MonetarySystemCurrencyMinting(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.nonce = byteBuffer.getLong();
            this.currencyId = byteBuffer.getLong();
            this.units = byteBuffer.getLong();
            this.counter = byteBuffer.getLong();
        }

        MonetarySystemCurrencyMinting(JSONObject jSONObject) {
            super(jSONObject);
            this.nonce = Convert.parseLong(jSONObject.get("nonce"));
            this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get("currency"));
            this.units = Convert.parseLong(jSONObject.get("units"));
            this.counter = Convert.parseLong(jSONObject.get("counter"));
        }

        public MonetarySystemCurrencyMinting(long l, long l2, long l3, long l4) {
            this.nonce = l;
            this.currencyId = l2;
            this.units = l3;
            this.counter = l4;
        }

        @Override
        int getMySize() {
            return 32;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.nonce);
            byteBuffer.putLong(this.currencyId);
            byteBuffer.putLong(this.units);
            byteBuffer.putLong(this.counter);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("nonce", this.nonce);
            jSONObject.put("currency", Long.toUnsignedString(this.currencyId));
            jSONObject.put("units", this.units);
            jSONObject.put("counter", this.counter);
        }

        @Override
        public TransactionType getTransactionType() {
            return MonetarySystem.CURRENCY_MINTING;
        }

        public long getNonce() {
            return this.nonce;
        }

        @Override
        public long getCurrencyId() {
            return this.currencyId;
        }

        public long getUnits() {
            return this.units;
        }

        public long getCounter() {
            return this.counter;
        }
    }

    public static final class MonetarySystemExchangeSell
    extends MonetarySystemExchange {
        MonetarySystemExchangeSell(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        MonetarySystemExchangeSell(JSONObject jSONObject) {
            super(jSONObject);
        }

        public MonetarySystemExchangeSell(long l, long l2, long l3) {
            super(l, l2, l3);
        }

        @Override
        public TransactionType getTransactionType() {
            return MonetarySystem.EXCHANGE_SELL;
        }
    }

    public static final class MonetarySystemExchangeBuy
    extends MonetarySystemExchange {
        MonetarySystemExchangeBuy(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        MonetarySystemExchangeBuy(JSONObject jSONObject) {
            super(jSONObject);
        }

        public MonetarySystemExchangeBuy(long l, long l2, long l3) {
            super(l, l2, l3);
        }

        @Override
        public TransactionType getTransactionType() {
            return MonetarySystem.EXCHANGE_BUY;
        }
    }

    public static abstract class MonetarySystemExchange
    extends AbstractAttachment
    implements MonetarySystemAttachment {
        private final long currencyId;
        private final long rateNQT;
        private final long units;

        private MonetarySystemExchange(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.currencyId = byteBuffer.getLong();
            this.rateNQT = byteBuffer.getLong();
            this.units = byteBuffer.getLong();
        }

        private MonetarySystemExchange(JSONObject jSONObject) {
            super(jSONObject);
            this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get("currency"));
            this.rateNQT = Convert.parseLong(jSONObject.get("rateNQT"));
            this.units = Convert.parseLong(jSONObject.get("units"));
        }

        private MonetarySystemExchange(long l, long l2, long l3) {
            this.currencyId = l;
            this.rateNQT = l2;
            this.units = l3;
        }

        @Override
        int getMySize() {
            return 24;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.currencyId);
            byteBuffer.putLong(this.rateNQT);
            byteBuffer.putLong(this.units);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("currency", Long.toUnsignedString(this.currencyId));
            jSONObject.put("rateNQT", this.rateNQT);
            jSONObject.put("units", this.units);
        }

        @Override
        public long getCurrencyId() {
            return this.currencyId;
        }

        public long getRateNQT() {
            return this.rateNQT;
        }

        public long getUnits() {
            return this.units;
        }
    }

    public static final class MonetarySystemPublishExchangeOffer
    extends AbstractAttachment
    implements MonetarySystemAttachment {
        private final long currencyId;
        private final long buyRateNQT;
        private final long sellRateNQT;
        private final long totalBuyLimit;
        private final long totalSellLimit;
        private final long initialBuySupply;
        private final long initialSellSupply;
        private final int expirationHeight;

        MonetarySystemPublishExchangeOffer(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.currencyId = byteBuffer.getLong();
            this.buyRateNQT = byteBuffer.getLong();
            this.sellRateNQT = byteBuffer.getLong();
            this.totalBuyLimit = byteBuffer.getLong();
            this.totalSellLimit = byteBuffer.getLong();
            this.initialBuySupply = byteBuffer.getLong();
            this.initialSellSupply = byteBuffer.getLong();
            this.expirationHeight = byteBuffer.getInt();
        }

        MonetarySystemPublishExchangeOffer(JSONObject jSONObject) {
            super(jSONObject);
            this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get("currency"));
            this.buyRateNQT = Convert.parseLong(jSONObject.get("buyRateNQT"));
            this.sellRateNQT = Convert.parseLong(jSONObject.get("sellRateNQT"));
            this.totalBuyLimit = Convert.parseLong(jSONObject.get("totalBuyLimit"));
            this.totalSellLimit = Convert.parseLong(jSONObject.get("totalSellLimit"));
            this.initialBuySupply = Convert.parseLong(jSONObject.get("initialBuySupply"));
            this.initialSellSupply = Convert.parseLong(jSONObject.get("initialSellSupply"));
            this.expirationHeight = ((Long)jSONObject.get("expirationHeight")).intValue();
        }

        public MonetarySystemPublishExchangeOffer(long l, long l2, long l3, long l4, long l5, long l6, long l7, int n) {
            this.currencyId = l;
            this.buyRateNQT = l2;
            this.sellRateNQT = l3;
            this.totalBuyLimit = l4;
            this.totalSellLimit = l5;
            this.initialBuySupply = l6;
            this.initialSellSupply = l7;
            this.expirationHeight = n;
        }

        @Override
        int getMySize() {
            return 60;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.currencyId);
            byteBuffer.putLong(this.buyRateNQT);
            byteBuffer.putLong(this.sellRateNQT);
            byteBuffer.putLong(this.totalBuyLimit);
            byteBuffer.putLong(this.totalSellLimit);
            byteBuffer.putLong(this.initialBuySupply);
            byteBuffer.putLong(this.initialSellSupply);
            byteBuffer.putInt(this.expirationHeight);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("currency", Long.toUnsignedString(this.currencyId));
            jSONObject.put("buyRateNQT", this.buyRateNQT);
            jSONObject.put("sellRateNQT", this.sellRateNQT);
            jSONObject.put("totalBuyLimit", this.totalBuyLimit);
            jSONObject.put("totalSellLimit", this.totalSellLimit);
            jSONObject.put("initialBuySupply", this.initialBuySupply);
            jSONObject.put("initialSellSupply", this.initialSellSupply);
            jSONObject.put("expirationHeight", this.expirationHeight);
        }

        @Override
        public TransactionType getTransactionType() {
            return MonetarySystem.PUBLISH_EXCHANGE_OFFER;
        }

        @Override
        public long getCurrencyId() {
            return this.currencyId;
        }

        public long getBuyRateNQT() {
            return this.buyRateNQT;
        }

        public long getSellRateNQT() {
            return this.sellRateNQT;
        }

        public long getTotalBuyLimit() {
            return this.totalBuyLimit;
        }

        public long getTotalSellLimit() {
            return this.totalSellLimit;
        }

        public long getInitialBuySupply() {
            return this.initialBuySupply;
        }

        public long getInitialSellSupply() {
            return this.initialSellSupply;
        }

        public int getExpirationHeight() {
            return this.expirationHeight;
        }
    }

    public static final class MonetarySystemCurrencyTransfer
    extends AbstractAttachment
    implements MonetarySystemAttachment {
        private final long currencyId;
        private final long units;

        MonetarySystemCurrencyTransfer(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.currencyId = byteBuffer.getLong();
            this.units = byteBuffer.getLong();
        }

        MonetarySystemCurrencyTransfer(JSONObject jSONObject) {
            super(jSONObject);
            this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get("currency"));
            this.units = Convert.parseLong(jSONObject.get("units"));
        }

        public MonetarySystemCurrencyTransfer(long l, long l2) {
            this.currencyId = l;
            this.units = l2;
        }

        @Override
        int getMySize() {
            return 16;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.currencyId);
            byteBuffer.putLong(this.units);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("currency", Long.toUnsignedString(this.currencyId));
            jSONObject.put("units", this.units);
        }

        @Override
        public TransactionType getTransactionType() {
            return MonetarySystem.CURRENCY_TRANSFER;
        }

        @Override
        public long getCurrencyId() {
            return this.currencyId;
        }

        public long getUnits() {
            return this.units;
        }
    }

    public static final class MonetarySystemReserveClaim
    extends AbstractAttachment
    implements MonetarySystemAttachment {
        private final long currencyId;
        private final long units;

        MonetarySystemReserveClaim(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.currencyId = byteBuffer.getLong();
            this.units = byteBuffer.getLong();
        }

        MonetarySystemReserveClaim(JSONObject jSONObject) {
            super(jSONObject);
            this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get("currency"));
            this.units = Convert.parseLong(jSONObject.get("units"));
        }

        public MonetarySystemReserveClaim(long l, long l2) {
            this.currencyId = l;
            this.units = l2;
        }

        @Override
        int getMySize() {
            return 16;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.currencyId);
            byteBuffer.putLong(this.units);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("currency", Long.toUnsignedString(this.currencyId));
            jSONObject.put("units", this.units);
        }

        @Override
        public TransactionType getTransactionType() {
            return MonetarySystem.RESERVE_CLAIM;
        }

        @Override
        public long getCurrencyId() {
            return this.currencyId;
        }

        public long getUnits() {
            return this.units;
        }
    }

    public static final class MonetarySystemReserveIncrease
    extends AbstractAttachment
    implements MonetarySystemAttachment {
        private final long currencyId;
        private final long amountPerUnitNQT;

        MonetarySystemReserveIncrease(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.currencyId = byteBuffer.getLong();
            this.amountPerUnitNQT = byteBuffer.getLong();
        }

        MonetarySystemReserveIncrease(JSONObject jSONObject) {
            super(jSONObject);
            this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get("currency"));
            this.amountPerUnitNQT = Convert.parseLong(jSONObject.get("amountPerUnitNQT"));
        }

        public MonetarySystemReserveIncrease(long l, long l2) {
            this.currencyId = l;
            this.amountPerUnitNQT = l2;
        }

        @Override
        int getMySize() {
            return 16;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.currencyId);
            byteBuffer.putLong(this.amountPerUnitNQT);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("currency", Long.toUnsignedString(this.currencyId));
            jSONObject.put("amountPerUnitNQT", this.amountPerUnitNQT);
        }

        @Override
        public TransactionType getTransactionType() {
            return MonetarySystem.RESERVE_INCREASE;
        }

        @Override
        public long getCurrencyId() {
            return this.currencyId;
        }

        public long getAmountPerUnitNQT() {
            return this.amountPerUnitNQT;
        }
    }

    public static final class MonetarySystemCurrencyIssuance
    extends AbstractAttachment {
        public static final StringRw NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 10);
        public static final StringRw CODE_RW = new StringRw(LengthRwPrimitiveType.BYTE, 5);
        public static final StringRw DESCRIPTION_RW = new StringRw(LengthRwPrimitiveType.SHORT, 1000);
        private final String name;
        private final String code;
        private final String description;
        private final byte type;
        private final long initialSupply;
        private final long reserveSupply;
        private final long maxSupply;
        private final int issuanceHeight;
        private final long minReservePerUnitNQT;
        private final int minDifficulty;
        private final int maxDifficulty;
        private final byte ruleset;
        private final byte algorithm;
        private final byte decimals;

        MonetarySystemCurrencyIssuance(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.name = NAME_RW.readFromBuffer(byteBuffer);
            this.code = CODE_RW.readFromBuffer(byteBuffer);
            this.description = DESCRIPTION_RW.readFromBuffer(byteBuffer);
            this.type = byteBuffer.get();
            this.initialSupply = byteBuffer.getLong();
            this.reserveSupply = byteBuffer.getLong();
            this.maxSupply = byteBuffer.getLong();
            this.issuanceHeight = byteBuffer.getInt();
            this.minReservePerUnitNQT = byteBuffer.getLong();
            this.minDifficulty = byteBuffer.get() & 0xFF;
            this.maxDifficulty = byteBuffer.get() & 0xFF;
            this.ruleset = byteBuffer.get();
            this.algorithm = byteBuffer.get();
            this.decimals = byteBuffer.get();
        }

        MonetarySystemCurrencyIssuance(JSONObject jSONObject) {
            super(jSONObject);
            this.name = (String)jSONObject.get("name");
            this.code = (String)jSONObject.get("code");
            this.description = (String)jSONObject.get("description");
            this.type = ((Long)jSONObject.get("type")).byteValue();
            this.initialSupply = Convert.parseLong(jSONObject.get("initialSupply"));
            this.reserveSupply = Convert.parseLong(jSONObject.get("reserveSupply"));
            this.maxSupply = Convert.parseLong(jSONObject.get("maxSupply"));
            this.issuanceHeight = ((Long)jSONObject.get("issuanceHeight")).intValue();
            this.minReservePerUnitNQT = Convert.parseLong(jSONObject.get("minReservePerUnitNQT"));
            this.minDifficulty = ((Long)jSONObject.get("minDifficulty")).intValue();
            this.maxDifficulty = ((Long)jSONObject.get("maxDifficulty")).intValue();
            this.ruleset = ((Long)jSONObject.get("ruleset")).byteValue();
            this.algorithm = ((Long)jSONObject.get("algorithm")).byteValue();
            this.decimals = ((Long)jSONObject.get("decimals")).byteValue();
        }

        public MonetarySystemCurrencyIssuance(String string, String string2, String string3, byte by, long l, long l2, long l3, int n, long l4, int n2, int n3, byte by2, byte by3, byte by4) {
            this.name = string;
            this.code = string2;
            this.description = string3;
            this.type = by;
            this.initialSupply = l;
            this.reserveSupply = l2;
            this.maxSupply = l3;
            this.issuanceHeight = n;
            this.minReservePerUnitNQT = l4;
            this.minDifficulty = n2;
            this.maxDifficulty = n3;
            this.ruleset = by2;
            this.algorithm = by3;
            this.decimals = by4;
        }

        @Override
        int getMySize() {
            return NAME_RW.getSize(this.name) + CODE_RW.getSize(this.code) + DESCRIPTION_RW.getSize(this.description) + 1 + 8 + 8 + 8 + 4 + 8 + 1 + 1 + 1 + 1 + 1;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            NAME_RW.writeToBuffer(this.name, byteBuffer);
            CODE_RW.writeToBuffer(this.code, byteBuffer);
            DESCRIPTION_RW.writeToBuffer(this.description, byteBuffer);
            byteBuffer.put(this.type);
            byteBuffer.putLong(this.initialSupply);
            byteBuffer.putLong(this.reserveSupply);
            byteBuffer.putLong(this.maxSupply);
            byteBuffer.putInt(this.issuanceHeight);
            byteBuffer.putLong(this.minReservePerUnitNQT);
            byteBuffer.put((byte)this.minDifficulty);
            byteBuffer.put((byte)this.maxDifficulty);
            byteBuffer.put(this.ruleset);
            byteBuffer.put(this.algorithm);
            byteBuffer.put(this.decimals);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("name", this.name);
            jSONObject.put("code", this.code);
            jSONObject.put("description", this.description);
            jSONObject.put("type", this.type);
            jSONObject.put("initialSupply", this.initialSupply);
            jSONObject.put("reserveSupply", this.reserveSupply);
            jSONObject.put("maxSupply", this.maxSupply);
            jSONObject.put("issuanceHeight", this.issuanceHeight);
            jSONObject.put("minReservePerUnitNQT", this.minReservePerUnitNQT);
            jSONObject.put("minDifficulty", this.minDifficulty);
            jSONObject.put("maxDifficulty", this.maxDifficulty);
            jSONObject.put("ruleset", this.ruleset);
            jSONObject.put("algorithm", this.algorithm);
            jSONObject.put("decimals", this.decimals);
        }

        @Override
        public TransactionType getTransactionType() {
            return MonetarySystem.CURRENCY_ISSUANCE;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public byte getType() {
            return this.type;
        }

        public long getInitialSupply() {
            return this.initialSupply;
        }

        public long getReserveSupply() {
            return this.reserveSupply;
        }

        public long getMaxSupply() {
            return this.maxSupply;
        }

        public int getIssuanceHeight() {
            return this.issuanceHeight;
        }

        public long getMinReservePerUnitNQT() {
            return this.minReservePerUnitNQT;
        }

        public int getMinDifficulty() {
            return this.minDifficulty;
        }

        public int getMaxDifficulty() {
            return this.maxDifficulty;
        }

        public byte getRuleset() {
            return this.ruleset;
        }

        public byte getAlgorithm() {
            return this.algorithm;
        }

        public byte getDecimals() {
            return this.decimals;
        }
    }

    public static interface MonetarySystemAttachment {
        public long getCurrencyId();
    }

    public static final class AccountControlEffectiveBalanceLeasing
    extends AbstractAttachment {
        private final int period;

        AccountControlEffectiveBalanceLeasing(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.period = Short.toUnsignedInt(byteBuffer.getShort());
        }

        AccountControlEffectiveBalanceLeasing(JSONObject jSONObject) {
            super(jSONObject);
            this.period = ((Long)jSONObject.get("period")).intValue();
        }

        public AccountControlEffectiveBalanceLeasing(int n) {
            this.period = n;
        }

        @Override
        int getMySize() {
            return 2;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putShort((short)this.period);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("period", this.period);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.AccountControl.EFFECTIVE_BALANCE_LEASING;
        }

        public int getPeriod() {
            return this.period;
        }
    }

    public static final class DigitalGoodsRefund
    extends AbstractAttachment {
        private final long purchaseId;
        private final long refundNQT;

        DigitalGoodsRefund(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.purchaseId = byteBuffer.getLong();
            this.refundNQT = byteBuffer.getLong();
        }

        DigitalGoodsRefund(JSONObject jSONObject) {
            super(jSONObject);
            this.purchaseId = Convert.parseUnsignedLong((String)jSONObject.get("purchase"));
            this.refundNQT = Convert.parseLong(jSONObject.get("refundNQT"));
        }

        public DigitalGoodsRefund(long l, long l2) {
            this.purchaseId = l;
            this.refundNQT = l2;
        }

        @Override
        int getMySize() {
            return 16;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.purchaseId);
            byteBuffer.putLong(this.refundNQT);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("purchase", Long.toUnsignedString(this.purchaseId));
            jSONObject.put("refundNQT", this.refundNQT);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.DigitalGoods.REFUND;
        }

        public long getPurchaseId() {
            return this.purchaseId;
        }

        public long getRefundNQT() {
            return this.refundNQT;
        }
    }

    public static final class DigitalGoodsFeedback
    extends AbstractAttachment {
        private final long purchaseId;

        DigitalGoodsFeedback(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.purchaseId = byteBuffer.getLong();
        }

        DigitalGoodsFeedback(JSONObject jSONObject) {
            super(jSONObject);
            this.purchaseId = Convert.parseUnsignedLong((String)jSONObject.get("purchase"));
        }

        public DigitalGoodsFeedback(long l) {
            this.purchaseId = l;
        }

        @Override
        int getMySize() {
            return 8;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.purchaseId);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("purchase", Long.toUnsignedString(this.purchaseId));
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.DigitalGoods.FEEDBACK;
        }

        public long getPurchaseId() {
            return this.purchaseId;
        }
    }

    public static final class UnencryptedDigitalGoodsDelivery
    extends DigitalGoodsDelivery
    implements Appendix.Encryptable {
        private final byte[] goodsToEncrypt;
        private final byte[] recipientPublicKey;

        UnencryptedDigitalGoodsDelivery(JSONObject jSONObject) {
            super(jSONObject);
            this.setGoods(null);
            String string = (String)jSONObject.get("goodsToEncrypt");
            this.goodsToEncrypt = this.goodsIsText() ? Convert.toBytes(string) : Convert.parseHexString(string);
            this.recipientPublicKey = Convert.parseHexString((String)jSONObject.get("recipientPublicKey"));
        }

        public UnencryptedDigitalGoodsDelivery(long l, byte[] byArray, boolean bl, long l2, byte[] byArray2) {
            super(l, null, bl, l2);
            this.goodsToEncrypt = byArray;
            this.recipientPublicKey = byArray2;
        }

        @Override
        int getMySize() {
            if (this.getGoods() == null) {
                return 12 + EncryptedData.getEncryptedSize(this.getPlaintext()) + 8;
            }
            return super.getMySize();
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            if (this.getGoods() == null) {
                throw new NxtException.NotYetEncryptedException("Goods not yet encrypted");
            }
            super.putMyBytes(byteBuffer);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            if (this.getGoods() == null) {
                jSONObject.put("goodsToEncrypt", this.goodsIsText() ? Convert.toString(this.goodsToEncrypt) : Convert.toHexString(this.goodsToEncrypt));
                jSONObject.put("recipientPublicKey", Convert.toHexString(this.recipientPublicKey));
                jSONObject.put("purchase", Long.toUnsignedString(this.getPurchaseId()));
                jSONObject.put("discountNQT", this.getDiscountNQT());
                jSONObject.put("goodsIsText", this.goodsIsText());
            } else {
                super.putMyJSON(jSONObject);
            }
        }

        @Override
        public void encrypt(String string) {
            this.setGoods(EncryptedData.encrypt(this.getPlaintext(), string, this.recipientPublicKey));
        }

        @Override
        int getGoodsDataLength() {
            return EncryptedData.getEncryptedDataLength(this.getPlaintext());
        }

        private byte[] getPlaintext() {
            return Convert.compress(this.goodsToEncrypt);
        }
    }

    public static class DigitalGoodsDelivery
    extends AbstractAttachment {
        private final long purchaseId;
        private EncryptedData goods;
        private final long discountNQT;
        private final boolean goodsIsText;

        DigitalGoodsDelivery(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.purchaseId = byteBuffer.getLong();
            int n = byteBuffer.getInt();
            boolean bl = this.goodsIsText = n < 0;
            if (n < 0) {
                n &= Integer.MAX_VALUE;
            }
            this.goods = EncryptedData.readEncryptedData(byteBuffer, n, 1000);
            this.discountNQT = byteBuffer.getLong();
        }

        DigitalGoodsDelivery(JSONObject jSONObject) {
            super(jSONObject);
            this.purchaseId = Convert.parseUnsignedLong((String)jSONObject.get("purchase"));
            this.goods = new EncryptedData(Convert.parseHexString((String)jSONObject.get("goodsData")), Convert.parseHexString((String)jSONObject.get("goodsNonce")));
            this.discountNQT = Convert.parseLong(jSONObject.get("discountNQT"));
            this.goodsIsText = Boolean.TRUE.equals(jSONObject.get("goodsIsText"));
        }

        public DigitalGoodsDelivery(long l, EncryptedData encryptedData, boolean bl, long l2) {
            this.purchaseId = l;
            this.goods = encryptedData;
            this.discountNQT = l2;
            this.goodsIsText = bl;
        }

        @Override
        int getMySize() {
            return 12 + this.goods.getSize() + 8;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.purchaseId);
            byteBuffer.putInt(this.goodsIsText ? this.goods.getData().length | Integer.MIN_VALUE : this.goods.getData().length);
            byteBuffer.put(this.goods.getData());
            byteBuffer.put(this.goods.getNonce());
            byteBuffer.putLong(this.discountNQT);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("purchase", Long.toUnsignedString(this.purchaseId));
            jSONObject.put("goodsData", Convert.toHexString(this.goods.getData()));
            jSONObject.put("goodsNonce", Convert.toHexString(this.goods.getNonce()));
            jSONObject.put("discountNQT", this.discountNQT);
            jSONObject.put("goodsIsText", this.goodsIsText);
        }

        @Override
        public final TransactionType getTransactionType() {
            return TransactionType.DigitalGoods.DELIVERY;
        }

        public final long getPurchaseId() {
            return this.purchaseId;
        }

        public final EncryptedData getGoods() {
            return this.goods;
        }

        final void setGoods(EncryptedData encryptedData) {
            this.goods = encryptedData;
        }

        int getGoodsDataLength() {
            return this.goods.getData().length;
        }

        public final long getDiscountNQT() {
            return this.discountNQT;
        }

        public final boolean goodsIsText() {
            return this.goodsIsText;
        }
    }

    public static final class DigitalGoodsPurchase
    extends AbstractAttachment {
        private final long goodsId;
        private final int quantity;
        private final long priceNQT;
        private final int deliveryDeadlineTimestamp;

        DigitalGoodsPurchase(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.goodsId = byteBuffer.getLong();
            this.quantity = byteBuffer.getInt();
            this.priceNQT = byteBuffer.getLong();
            this.deliveryDeadlineTimestamp = byteBuffer.getInt();
        }

        DigitalGoodsPurchase(JSONObject jSONObject) {
            super(jSONObject);
            this.goodsId = Convert.parseUnsignedLong((String)jSONObject.get("goods"));
            this.quantity = ((Long)jSONObject.get("quantity")).intValue();
            this.priceNQT = Convert.parseLong(jSONObject.get("priceNQT"));
            this.deliveryDeadlineTimestamp = ((Long)jSONObject.get("deliveryDeadlineTimestamp")).intValue();
        }

        public DigitalGoodsPurchase(long l, int n, long l2, int n2) {
            this.goodsId = l;
            this.quantity = n;
            this.priceNQT = l2;
            this.deliveryDeadlineTimestamp = n2;
        }

        @Override
        int getMySize() {
            return 24;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.goodsId);
            byteBuffer.putInt(this.quantity);
            byteBuffer.putLong(this.priceNQT);
            byteBuffer.putInt(this.deliveryDeadlineTimestamp);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("goods", Long.toUnsignedString(this.goodsId));
            jSONObject.put("quantity", this.quantity);
            jSONObject.put("priceNQT", this.priceNQT);
            jSONObject.put("deliveryDeadlineTimestamp", this.deliveryDeadlineTimestamp);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.DigitalGoods.PURCHASE;
        }

        public long getGoodsId() {
            return this.goodsId;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }

        public int getDeliveryDeadlineTimestamp() {
            return this.deliveryDeadlineTimestamp;
        }
    }

    public static final class DigitalGoodsQuantityChange
    extends AbstractAttachment {
        private final long goodsId;
        private final int deltaQuantity;

        DigitalGoodsQuantityChange(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.goodsId = byteBuffer.getLong();
            this.deltaQuantity = byteBuffer.getInt();
        }

        DigitalGoodsQuantityChange(JSONObject jSONObject) {
            super(jSONObject);
            this.goodsId = Convert.parseUnsignedLong((String)jSONObject.get("goods"));
            this.deltaQuantity = ((Long)jSONObject.get("deltaQuantity")).intValue();
        }

        public DigitalGoodsQuantityChange(long l, int n) {
            this.goodsId = l;
            this.deltaQuantity = n;
        }

        @Override
        int getMySize() {
            return 12;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.goodsId);
            byteBuffer.putInt(this.deltaQuantity);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("goods", Long.toUnsignedString(this.goodsId));
            jSONObject.put("deltaQuantity", this.deltaQuantity);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.DigitalGoods.QUANTITY_CHANGE;
        }

        public long getGoodsId() {
            return this.goodsId;
        }

        public int getDeltaQuantity() {
            return this.deltaQuantity;
        }
    }

    public static final class DigitalGoodsPriceChange
    extends AbstractAttachment {
        private final long goodsId;
        private final long priceNQT;

        DigitalGoodsPriceChange(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.goodsId = byteBuffer.getLong();
            this.priceNQT = byteBuffer.getLong();
        }

        DigitalGoodsPriceChange(JSONObject jSONObject) {
            super(jSONObject);
            this.goodsId = Convert.parseUnsignedLong((String)jSONObject.get("goods"));
            this.priceNQT = Convert.parseLong(jSONObject.get("priceNQT"));
        }

        public DigitalGoodsPriceChange(long l, long l2) {
            this.goodsId = l;
            this.priceNQT = l2;
        }

        @Override
        int getMySize() {
            return 16;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.goodsId);
            byteBuffer.putLong(this.priceNQT);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("goods", Long.toUnsignedString(this.goodsId));
            jSONObject.put("priceNQT", this.priceNQT);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.DigitalGoods.PRICE_CHANGE;
        }

        public long getGoodsId() {
            return this.goodsId;
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }
    }

    public static final class DigitalGoodsDelisting
    extends AbstractAttachment {
        private final long goodsId;

        DigitalGoodsDelisting(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.goodsId = byteBuffer.getLong();
        }

        DigitalGoodsDelisting(JSONObject jSONObject) {
            super(jSONObject);
            this.goodsId = Convert.parseUnsignedLong((String)jSONObject.get("goods"));
        }

        public DigitalGoodsDelisting(long l) {
            this.goodsId = l;
        }

        @Override
        int getMySize() {
            return 8;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.goodsId);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("goods", Long.toUnsignedString(this.goodsId));
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.DigitalGoods.DELISTING;
        }

        public long getGoodsId() {
            return this.goodsId;
        }
    }

    public static final class DigitalGoodsListing
    extends AbstractAttachment {
        private final String name;
        private final String description;
        private final String tags;
        private final int quantity;
        private final long priceNQT;

        DigitalGoodsListing(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.name = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
            this.description = Convert.readString(byteBuffer, byteBuffer.getShort(), 1000);
            this.tags = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
            this.quantity = byteBuffer.getInt();
            this.priceNQT = byteBuffer.getLong();
        }

        DigitalGoodsListing(JSONObject jSONObject) {
            super(jSONObject);
            this.name = (String)jSONObject.get("name");
            this.description = (String)jSONObject.get("description");
            this.tags = (String)jSONObject.get("tags");
            this.quantity = ((Long)jSONObject.get("quantity")).intValue();
            this.priceNQT = Convert.parseLong(jSONObject.get("priceNQT"));
        }

        public DigitalGoodsListing(String string, String string2, String string3, int n, long l) {
            this.name = string;
            this.description = string2;
            this.tags = string3;
            this.quantity = n;
            this.priceNQT = l;
        }

        @Override
        int getMySize() {
            return 2 + Convert.toBytes(this.name).length + 2 + Convert.toBytes(this.description).length + 2 + Convert.toBytes(this.tags).length + 4 + 8;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byte[] byArray = Convert.toBytes(this.name);
            byteBuffer.putShort((short)byArray.length);
            byteBuffer.put(byArray);
            byte[] byArray2 = Convert.toBytes(this.description);
            byteBuffer.putShort((short)byArray2.length);
            byteBuffer.put(byArray2);
            byte[] byArray3 = Convert.toBytes(this.tags);
            byteBuffer.putShort((short)byArray3.length);
            byteBuffer.put(byArray3);
            byteBuffer.putInt(this.quantity);
            byteBuffer.putLong(this.priceNQT);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("name", this.name);
            jSONObject.put("description", this.description);
            jSONObject.put("tags", this.tags);
            jSONObject.put("quantity", this.quantity);
            jSONObject.put("priceNQT", this.priceNQT);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.DigitalGoods.LISTING;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTags() {
            return this.tags;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }
    }

    public static final class ColoredCoinsDividendPayment
    extends AbstractAttachment {
        private final long assetId;
        private final int height;
        private final long amountNQTPerQNT;
        private final long holdingId;
        private final HoldingType holdingType;

        ColoredCoinsDividendPayment(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.holdingId = byteBuffer.getLong();
            this.holdingType = HoldingType.get(byteBuffer.get());
            this.assetId = byteBuffer.getLong();
            this.height = byteBuffer.getInt();
            this.amountNQTPerQNT = byteBuffer.getLong();
        }

        ColoredCoinsDividendPayment(JSONObject jSONObject) {
            super(jSONObject);
            this.assetId = Convert.parseUnsignedLong((String)jSONObject.get("asset"));
            this.height = ((Long)jSONObject.get("height")).intValue();
            this.amountNQTPerQNT = Convert.parseLong(jSONObject.get("amountNQTPerQNT"));
            this.holdingId = Convert.parseUnsignedLong((String)jSONObject.get("holding"));
            this.holdingType = HoldingType.get(((Long)jSONObject.get("holdingType")).byteValue());
        }

        public ColoredCoinsDividendPayment(long l, HoldingType holdingType, long l2, int n, long l3) {
            this.holdingId = l;
            this.holdingType = holdingType;
            this.assetId = l2;
            this.height = n;
            this.amountNQTPerQNT = l3;
        }

        @Override
        int getMySize() {
            return 29;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.holdingId);
            byteBuffer.put(this.holdingType.getCode());
            byteBuffer.putLong(this.assetId);
            byteBuffer.putInt(this.height);
            byteBuffer.putLong(this.amountNQTPerQNT);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("asset", Long.toUnsignedString(this.assetId));
            jSONObject.put("height", this.height);
            jSONObject.put("amountNQTPerQNT", this.amountNQTPerQNT);
            jSONObject.put("holding", Long.toUnsignedString(this.holdingId));
            jSONObject.put("holdingType", this.holdingType.getCode());
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.DIVIDEND_PAYMENT;
        }

        public long getAssetId() {
            return this.assetId;
        }

        public int getHeight() {
            return this.height;
        }

        public long getAmountNQTPerQNT() {
            return this.amountNQTPerQNT;
        }

        public long getHoldingId() {
            return this.holdingId;
        }

        public HoldingType getHoldingType() {
            return this.holdingType;
        }
    }

    public static final class ColoredCoinsBidOrderCancellation
    extends ColoredCoinsOrderCancellation {
        ColoredCoinsBidOrderCancellation(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        ColoredCoinsBidOrderCancellation(JSONObject jSONObject) {
            super(jSONObject);
        }

        public ColoredCoinsBidOrderCancellation(long l) {
            super(l);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.BID_ORDER_CANCELLATION;
        }
    }

    public static final class ColoredCoinsAskOrderCancellation
    extends ColoredCoinsOrderCancellation {
        ColoredCoinsAskOrderCancellation(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        ColoredCoinsAskOrderCancellation(JSONObject jSONObject) {
            super(jSONObject);
        }

        public ColoredCoinsAskOrderCancellation(long l) {
            super(l);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.ASK_ORDER_CANCELLATION;
        }
    }

    public static abstract class ColoredCoinsOrderCancellation
    extends AbstractAttachment {
        private final long orderId;

        private ColoredCoinsOrderCancellation(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.orderId = byteBuffer.getLong();
        }

        private ColoredCoinsOrderCancellation(JSONObject jSONObject) {
            super(jSONObject);
            this.orderId = Convert.parseUnsignedLong((String)jSONObject.get("order"));
        }

        private ColoredCoinsOrderCancellation(long l) {
            this.orderId = l;
        }

        @Override
        int getMySize() {
            return 8;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.orderId);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("order", Long.toUnsignedString(this.orderId));
        }

        public long getOrderId() {
            return this.orderId;
        }
    }

    public static final class ColoredCoinsBidOrderPlacement
    extends ColoredCoinsOrderPlacement {
        ColoredCoinsBidOrderPlacement(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        ColoredCoinsBidOrderPlacement(JSONObject jSONObject) {
            super(jSONObject);
        }

        public ColoredCoinsBidOrderPlacement(long l, long l2, long l3) {
            super(l, l2, l3);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.BID_ORDER_PLACEMENT;
        }
    }

    public static final class ColoredCoinsAskOrderPlacement
    extends ColoredCoinsOrderPlacement {
        ColoredCoinsAskOrderPlacement(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        ColoredCoinsAskOrderPlacement(JSONObject jSONObject) {
            super(jSONObject);
        }

        public ColoredCoinsAskOrderPlacement(long l, long l2, long l3) {
            super(l, l2, l3);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.ASK_ORDER_PLACEMENT;
        }
    }

    public static abstract class ColoredCoinsOrderPlacement
    extends AbstractAttachment {
        private final long assetId;
        private final long quantityQNT;
        private final long priceNQT;

        private ColoredCoinsOrderPlacement(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.assetId = byteBuffer.getLong();
            this.quantityQNT = byteBuffer.getLong();
            this.priceNQT = byteBuffer.getLong();
        }

        private ColoredCoinsOrderPlacement(JSONObject jSONObject) {
            super(jSONObject);
            this.assetId = Convert.parseUnsignedLong((String)jSONObject.get("asset"));
            this.quantityQNT = Convert.parseLong(jSONObject.get("quantityQNT"));
            this.priceNQT = Convert.parseLong(jSONObject.get("priceNQT"));
        }

        private ColoredCoinsOrderPlacement(long l, long l2, long l3) {
            this.assetId = l;
            this.quantityQNT = l2;
            this.priceNQT = l3;
        }

        @Override
        int getMySize() {
            return 24;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.assetId);
            byteBuffer.putLong(this.quantityQNT);
            byteBuffer.putLong(this.priceNQT);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("asset", Long.toUnsignedString(this.assetId));
            jSONObject.put("quantityQNT", this.quantityQNT);
            jSONObject.put("priceNQT", this.priceNQT);
        }

        public long getAssetId() {
            return this.assetId;
        }

        public long getQuantityQNT() {
            return this.quantityQNT;
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }
    }

    public static final class ColoredCoinsAssetPropertyDelete
    extends PropertyDeleteAttachment {
        ColoredCoinsAssetPropertyDelete(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        ColoredCoinsAssetPropertyDelete(JSONObject jSONObject) {
            super(jSONObject);
        }

        public ColoredCoinsAssetPropertyDelete(long l) {
            super(l);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.ASSET_PROPERTY_DELETE;
        }
    }

    public static final class ColoredCoinsAssetProperty
    extends AbstractAttachment {
        public static final StringRw PROPERTY_NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 32);
        public static final StringRw PROPERTY_VALUE_RW = new StringRw(LengthRwPrimitiveType.UBYTE, 160);
        private final long assetId;
        private final String property;
        private final String value;

        public ColoredCoinsAssetProperty(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.assetId = byteBuffer.getLong();
            this.property = PROPERTY_NAME_RW.readFromBuffer(byteBuffer).trim();
            this.value = PROPERTY_VALUE_RW.readFromBuffer(byteBuffer).trim();
        }

        public ColoredCoinsAssetProperty(JSONObject jSONObject) {
            super(jSONObject);
            this.assetId = Convert.parseUnsignedLong((String)jSONObject.get("asset"));
            this.property = Convert.nullToEmpty((String)jSONObject.get("property")).trim();
            this.value = Convert.nullToEmpty((String)jSONObject.get("value")).trim();
        }

        public ColoredCoinsAssetProperty(long l, String string, String string2) {
            this.assetId = l;
            this.property = string.trim();
            this.value = Convert.nullToEmpty(string2).trim();
        }

        @Override
        int getMySize() {
            return 8 + PROPERTY_NAME_RW.getSize(this.property) + PROPERTY_VALUE_RW.getSize(this.value);
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.assetId);
            PROPERTY_NAME_RW.writeToBuffer(this.property, byteBuffer);
            PROPERTY_VALUE_RW.writeToBuffer(this.value, byteBuffer);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("asset", Long.toUnsignedString(this.assetId));
            jSONObject.put("property", this.property);
            jSONObject.put("value", this.value);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.ASSET_PROPERTY_SET;
        }

        public long getAssetId() {
            return this.assetId;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static final class ColoredCoinsAssetIncrease
    extends ColoredCoinsAssetQuantity {
        ColoredCoinsAssetIncrease(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        ColoredCoinsAssetIncrease(JSONObject jSONObject) {
            super(jSONObject);
        }

        public ColoredCoinsAssetIncrease(long l, long l2) {
            super(l, l2);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.ASSET_INCREASE;
        }
    }

    public static final class ColoredCoinsAssetDelete
    extends ColoredCoinsAssetQuantity {
        ColoredCoinsAssetDelete(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        ColoredCoinsAssetDelete(JSONObject jSONObject) {
            super(jSONObject);
        }

        public ColoredCoinsAssetDelete(long l, long l2) {
            super(l, l2);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.ASSET_DELETE;
        }
    }

    public static abstract class ColoredCoinsAssetQuantity
    extends AbstractAttachment {
        private final long assetId;
        private final long quantityQNT;

        ColoredCoinsAssetQuantity(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.assetId = byteBuffer.getLong();
            this.quantityQNT = byteBuffer.getLong();
        }

        ColoredCoinsAssetQuantity(JSONObject jSONObject) {
            super(jSONObject);
            this.assetId = Convert.parseUnsignedLong((String)jSONObject.get("asset"));
            this.quantityQNT = Convert.parseLong(jSONObject.get("quantityQNT"));
        }

        public ColoredCoinsAssetQuantity(long l, long l2) {
            this.assetId = l;
            this.quantityQNT = l2;
        }

        @Override
        int getMySize() {
            return 16;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.assetId);
            byteBuffer.putLong(this.quantityQNT);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("asset", Long.toUnsignedString(this.assetId));
            jSONObject.put("quantityQNT", this.quantityQNT);
        }

        public long getAssetId() {
            return this.assetId;
        }

        public long getQuantityQNT() {
            return this.quantityQNT;
        }
    }

    public static final class ColoredCoinsAssetTransfer
    extends AbstractAttachment {
        private final long assetId;
        private final long quantityQNT;

        ColoredCoinsAssetTransfer(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.assetId = byteBuffer.getLong();
            this.quantityQNT = byteBuffer.getLong();
        }

        ColoredCoinsAssetTransfer(JSONObject jSONObject) {
            super(jSONObject);
            this.assetId = Convert.parseUnsignedLong((String)jSONObject.get("asset"));
            this.quantityQNT = Convert.parseLong(jSONObject.get("quantityQNT"));
        }

        public ColoredCoinsAssetTransfer(long l, long l2) {
            this.assetId = l;
            this.quantityQNT = l2;
        }

        @Override
        int getMySize() {
            return 16;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.assetId);
            byteBuffer.putLong(this.quantityQNT);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("asset", Long.toUnsignedString(this.assetId));
            jSONObject.put("quantityQNT", this.quantityQNT);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.ASSET_TRANSFER;
        }

        public long getAssetId() {
            return this.assetId;
        }

        public long getQuantityQNT() {
            return this.quantityQNT;
        }
    }

    public static final class ColoredCoinsAssetIssuance
    extends AbstractAttachment {
        public static final StringRw NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 10);
        public static final StringRw DESCRIPTION_RW = new StringRw(LengthRwPrimitiveType.SHORT, 1000);
        private final String name;
        private final String description;
        private final long quantityQNT;
        private final byte decimals;

        ColoredCoinsAssetIssuance(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.name = NAME_RW.readFromBuffer(byteBuffer);
            this.description = DESCRIPTION_RW.readFromBuffer(byteBuffer);
            this.quantityQNT = byteBuffer.getLong();
            this.decimals = byteBuffer.get();
        }

        ColoredCoinsAssetIssuance(JSONObject jSONObject) {
            super(jSONObject);
            this.name = (String)jSONObject.get("name");
            this.description = Convert.nullToEmpty((String)jSONObject.get("description"));
            this.quantityQNT = Convert.parseLong(jSONObject.get("quantityQNT"));
            this.decimals = ((Long)jSONObject.get("decimals")).byteValue();
        }

        public ColoredCoinsAssetIssuance(String string, String string2, long l, byte by) {
            this.name = string;
            this.description = Convert.nullToEmpty(string2);
            this.quantityQNT = l;
            this.decimals = by;
        }

        @Override
        int getMySize() {
            return NAME_RW.getSize(this.name) + DESCRIPTION_RW.getSize(this.description) + 8 + 1;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            NAME_RW.writeToBuffer(this.name, byteBuffer);
            DESCRIPTION_RW.writeToBuffer(this.description, byteBuffer);
            byteBuffer.putLong(this.quantityQNT);
            byteBuffer.put(this.decimals);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("name", this.name);
            jSONObject.put("description", this.description);
            jSONObject.put("quantityQNT", this.quantityQNT);
            jSONObject.put("decimals", this.decimals);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.ColoredCoins.ASSET_ISSUANCE;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public long getQuantityQNT() {
            return this.quantityQNT;
        }

        public byte getDecimals() {
            return this.decimals;
        }
    }

    public static final class MessagingAccountPropertyDelete
    extends PropertyDeleteAttachment {
        MessagingAccountPropertyDelete(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        MessagingAccountPropertyDelete(JSONObject jSONObject) {
            super(jSONObject);
        }

        public MessagingAccountPropertyDelete(long l) {
            super(l);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.ACCOUNT_PROPERTY_DELETE;
        }
    }

    public static final class MessagingAccountProperty
    extends AbstractAttachment {
        public static final StringRw PROPERTY_NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 32);
        public static final StringRw PROPERTY_VALUE_RW = new StringRw(LengthRwPrimitiveType.BYTE, 160);
        private final String property;
        private final String value;

        MessagingAccountProperty(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.property = PROPERTY_NAME_RW.readFromBuffer(byteBuffer).trim();
            this.value = PROPERTY_VALUE_RW.readFromBuffer(byteBuffer).trim();
        }

        MessagingAccountProperty(JSONObject jSONObject) {
            super(jSONObject);
            this.property = Convert.nullToEmpty((String)jSONObject.get("property")).trim();
            this.value = Convert.nullToEmpty((String)jSONObject.get("value")).trim();
        }

        public MessagingAccountProperty(String string, String string2) {
            this.property = string.trim();
            this.value = Convert.nullToEmpty(string2).trim();
        }

        @Override
        int getMySize() {
            return PROPERTY_NAME_RW.getSize(this.property) + PROPERTY_VALUE_RW.getSize(this.value);
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            PROPERTY_NAME_RW.writeToBuffer(this.property, byteBuffer);
            PROPERTY_VALUE_RW.writeToBuffer(this.value, byteBuffer);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("property", this.property);
            jSONObject.put("value", this.value);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.ACCOUNT_PROPERTY;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static final class MessagingAccountInfo
    extends AbstractAttachment {
        public static final StringRw NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 100);
        public static final StringRw DESCRIPTION_RW = new StringRw(LengthRwPrimitiveType.SHORT, 1000);
        private final String name;
        private final String description;

        MessagingAccountInfo(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.name = NAME_RW.readFromBuffer(byteBuffer);
            this.description = DESCRIPTION_RW.readFromBuffer(byteBuffer);
        }

        MessagingAccountInfo(JSONObject jSONObject) {
            super(jSONObject);
            this.name = Convert.nullToEmpty((String)jSONObject.get("name"));
            this.description = Convert.nullToEmpty((String)jSONObject.get("description"));
        }

        public MessagingAccountInfo(String string, String string2) {
            this.name = string;
            this.description = string2;
        }

        @Override
        int getMySize() {
            return NAME_RW.getSize(this.name) + DESCRIPTION_RW.getSize(this.description);
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            NAME_RW.writeToBuffer(this.name, byteBuffer);
            DESCRIPTION_RW.writeToBuffer(this.description, byteBuffer);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("name", this.name);
            jSONObject.put("description", this.description);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.ACCOUNT_INFO;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static final class MessagingPhasingVoteCasting
    extends AbstractAttachment {
        private final List<byte[]> transactionFullHashes;
        private final byte[] revealedSecret;

        MessagingPhasingVoteCasting(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            int n;
            int n2 = byteBuffer.get();
            this.transactionFullHashes = new ArrayList<byte[]>(n2);
            for (n = 0; n < n2; ++n) {
                byte[] byArray = new byte[32];
                byteBuffer.get(byArray);
                this.transactionFullHashes.add(byArray);
            }
            n = byteBuffer.getInt();
            if (n > 100) {
                throw new NxtException.NotValidException("Invalid revealed secret length " + n);
            }
            if (n > 0) {
                this.revealedSecret = new byte[n];
                byteBuffer.get(this.revealedSecret);
            } else {
                this.revealedSecret = Convert.EMPTY_BYTE;
            }
        }

        MessagingPhasingVoteCasting(JSONObject jSONObject) {
            super(jSONObject);
            JSONArray jSONArray = (JSONArray)jSONObject.get("transactionFullHashes");
            this.transactionFullHashes = new ArrayList<byte[]>(jSONArray.size());
            jSONArray.forEach(object -> this.transactionFullHashes.add(Convert.parseHexString((String)object)));
            String string = Convert.emptyToNull((String)jSONObject.get("revealedSecret"));
            this.revealedSecret = string != null ? Convert.parseHexString(string) : Convert.EMPTY_BYTE;
        }

        public MessagingPhasingVoteCasting(List<byte[]> list, byte[] byArray) {
            this.transactionFullHashes = list;
            this.revealedSecret = byArray;
        }

        @Override
        int getMySize() {
            return 1 + 32 * this.transactionFullHashes.size() + 4 + this.revealedSecret.length;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.put((byte)this.transactionFullHashes.size());
            this.transactionFullHashes.forEach(byteBuffer::put);
            byteBuffer.putInt(this.revealedSecret.length);
            byteBuffer.put(this.revealedSecret);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            JSONArray jSONArray = new JSONArray();
            this.transactionFullHashes.forEach(byArray -> jSONArray.add(Convert.toHexString(byArray)));
            jSONObject.put("transactionFullHashes", jSONArray);
            if (this.revealedSecret.length > 0) {
                jSONObject.put("revealedSecret", Convert.toHexString(this.revealedSecret));
            }
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.PHASING_VOTE_CASTING;
        }

        public List<byte[]> getTransactionFullHashes() {
            return this.transactionFullHashes;
        }

        public byte[] getRevealedSecret() {
            return this.revealedSecret;
        }
    }

    public static final class MessagingVoteCasting
    extends AbstractAttachment {
        private final long pollId;
        private final byte[] pollVote;

        public MessagingVoteCasting(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.pollId = byteBuffer.getLong();
            byte by = byteBuffer.get();
            if (by > 100) {
                throw new NxtException.NotValidException("More than 100 options in a vote");
            }
            this.pollVote = new byte[by];
            byteBuffer.get(this.pollVote);
        }

        public MessagingVoteCasting(JSONObject jSONObject) {
            super(jSONObject);
            this.pollId = Convert.parseUnsignedLong((String)jSONObject.get("poll"));
            JSONArray jSONArray = (JSONArray)jSONObject.get("vote");
            this.pollVote = new byte[jSONArray.size()];
            for (int i = 0; i < this.pollVote.length; ++i) {
                this.pollVote[i] = ((Long)jSONArray.get(i)).byteValue();
            }
        }

        public MessagingVoteCasting(long l, byte[] byArray) {
            this.pollId = l;
            this.pollVote = byArray;
        }

        @Override
        int getMySize() {
            return 9 + this.pollVote.length;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.pollId);
            byteBuffer.put((byte)this.pollVote.length);
            byteBuffer.put(this.pollVote);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("poll", Long.toUnsignedString(this.pollId));
            JSONArray jSONArray = new JSONArray();
            if (this.pollVote != null) {
                for (byte by : this.pollVote) {
                    jSONArray.add(by);
                }
            }
            jSONObject.put("vote", jSONArray);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.VOTE_CASTING;
        }

        public long getPollId() {
            return this.pollId;
        }

        public byte[] getPollVote() {
            return this.pollVote;
        }
    }

    public static final class MessagingPollCreation
    extends AbstractAttachment {
        private final String pollName;
        private final String pollDescription;
        private final String[] pollOptions;
        private final int finishHeight;
        private final byte minNumberOfOptions;
        private final byte maxNumberOfOptions;
        private final byte minRangeValue;
        private final byte maxRangeValue;
        private final VoteWeighting voteWeighting;

        MessagingPollCreation(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            int n;
            this.pollName = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
            this.pollDescription = Convert.readString(byteBuffer, byteBuffer.getShort(), 1000);
            this.finishHeight = byteBuffer.getInt();
            int n2 = byteBuffer.get();
            if (n2 > 100) {
                throw new NxtException.NotValidException("Invalid number of poll options: " + n2);
            }
            this.pollOptions = new String[n2];
            for (n = 0; n < n2; ++n) {
                this.pollOptions[n] = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
            }
            n = byteBuffer.get();
            this.minNumberOfOptions = byteBuffer.get();
            this.maxNumberOfOptions = byteBuffer.get();
            this.minRangeValue = byteBuffer.get();
            this.maxRangeValue = byteBuffer.get();
            long l = byteBuffer.getLong();
            byte by = byteBuffer.get();
            long l2 = byteBuffer.getLong();
            this.voteWeighting = new VoteWeighting((byte)n, l2, l, by);
        }

        MessagingPollCreation(JSONObject jSONObject) {
            super(jSONObject);
            byte by;
            this.pollName = ((String)jSONObject.get("name")).trim();
            this.pollDescription = ((String)jSONObject.get("description")).trim();
            this.finishHeight = ((Long)jSONObject.get("finishHeight")).intValue();
            JSONArray jSONArray = (JSONArray)jSONObject.get("options");
            this.pollOptions = new String[jSONArray.size()];
            for (by = 0; by < this.pollOptions.length; ++by) {
                this.pollOptions[by] = ((String)jSONArray.get(by)).trim();
            }
            by = ((Long)jSONObject.get("votingModel")).byteValue();
            this.minNumberOfOptions = ((Long)jSONObject.get("minNumberOfOptions")).byteValue();
            this.maxNumberOfOptions = ((Long)jSONObject.get("maxNumberOfOptions")).byteValue();
            this.minRangeValue = ((Long)jSONObject.get("minRangeValue")).byteValue();
            this.maxRangeValue = ((Long)jSONObject.get("maxRangeValue")).byteValue();
            long l = Convert.parseLong(jSONObject.get("minBalance"));
            byte by2 = ((Long)jSONObject.get("minBalanceModel")).byteValue();
            long l2 = Convert.parseUnsignedLong((String)jSONObject.get("holding"));
            this.voteWeighting = new VoteWeighting(by, l2, l, by2);
        }

        private MessagingPollCreation(PollBuilder pollBuilder) {
            this.pollName = pollBuilder.pollName;
            this.pollDescription = pollBuilder.pollDescription;
            this.pollOptions = pollBuilder.pollOptions;
            this.finishHeight = pollBuilder.finishHeight;
            this.minNumberOfOptions = pollBuilder.minNumberOfOptions;
            this.maxNumberOfOptions = pollBuilder.maxNumberOfOptions;
            this.minRangeValue = pollBuilder.minRangeValue;
            this.maxRangeValue = pollBuilder.maxRangeValue;
            this.voteWeighting = new VoteWeighting(pollBuilder.votingModel, pollBuilder.holdingId, pollBuilder.minBalance, pollBuilder.minBalanceModel);
        }

        @Override
        int getMySize() {
            int n = 2 + Convert.toBytes(this.pollName).length + 2 + Convert.toBytes(this.pollDescription).length + 1;
            for (String string : this.pollOptions) {
                n += 2 + Convert.toBytes(string).length;
            }
            return n += 26;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            byte[] byArray = Convert.toBytes(this.pollName);
            byte[] byArray2 = Convert.toBytes(this.pollDescription);
            byte[][] byArrayArray = new byte[this.pollOptions.length][];
            for (int i = 0; i < this.pollOptions.length; ++i) {
                byArrayArray[i] = Convert.toBytes(this.pollOptions[i]);
            }
            byteBuffer.putShort((short)byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.putShort((short)byArray2.length);
            byteBuffer.put(byArray2);
            byteBuffer.putInt(this.finishHeight);
            byteBuffer.put((byte)byArrayArray.length);
            for (byte[] byArray3 : byArrayArray) {
                byteBuffer.putShort((short)byArray3.length);
                byteBuffer.put(byArray3);
            }
            byteBuffer.put(this.voteWeighting.getVotingModel().getCode());
            byteBuffer.put(this.minNumberOfOptions);
            byteBuffer.put(this.maxNumberOfOptions);
            byteBuffer.put(this.minRangeValue);
            byteBuffer.put(this.maxRangeValue);
            byteBuffer.putLong(this.voteWeighting.getMinBalance());
            byteBuffer.put(this.voteWeighting.getMinBalanceModel().getCode());
            byteBuffer.putLong(this.voteWeighting.getHoldingId());
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("name", this.pollName);
            jSONObject.put("description", this.pollDescription);
            jSONObject.put("finishHeight", this.finishHeight);
            JSONArray jSONArray = new JSONArray();
            if (this.pollOptions != null) {
                Collections.addAll(jSONArray, this.pollOptions);
            }
            jSONObject.put("options", jSONArray);
            jSONObject.put("minNumberOfOptions", this.minNumberOfOptions);
            jSONObject.put("maxNumberOfOptions", this.maxNumberOfOptions);
            jSONObject.put("minRangeValue", this.minRangeValue);
            jSONObject.put("maxRangeValue", this.maxRangeValue);
            jSONObject.put("votingModel", this.voteWeighting.getVotingModel().getCode());
            jSONObject.put("minBalance", this.voteWeighting.getMinBalance());
            jSONObject.put("minBalanceModel", this.voteWeighting.getMinBalanceModel().getCode());
            jSONObject.put("holding", Long.toUnsignedString(this.voteWeighting.getHoldingId()));
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.POLL_CREATION;
        }

        public String getPollName() {
            return this.pollName;
        }

        public String getPollDescription() {
            return this.pollDescription;
        }

        public int getFinishHeight() {
            return this.finishHeight;
        }

        public String[] getPollOptions() {
            return this.pollOptions;
        }

        public byte getMinNumberOfOptions() {
            return this.minNumberOfOptions;
        }

        public byte getMaxNumberOfOptions() {
            return this.maxNumberOfOptions;
        }

        public byte getMinRangeValue() {
            return this.minRangeValue;
        }

        public byte getMaxRangeValue() {
            return this.maxRangeValue;
        }

        public VoteWeighting getVoteWeighting() {
            return this.voteWeighting;
        }

        public static final class PollBuilder {
            private final String pollName;
            private final String pollDescription;
            private final String[] pollOptions;
            private final int finishHeight;
            private final byte votingModel;
            private long minBalance = 0L;
            private byte minBalanceModel;
            private final byte minNumberOfOptions;
            private final byte maxNumberOfOptions;
            private final byte minRangeValue;
            private final byte maxRangeValue;
            private long holdingId;

            public PollBuilder(String string, String string2, String[] stringArray, int n, byte by, byte by2, byte by3, byte by4, byte by5) {
                this.pollName = string;
                this.pollDescription = string2;
                this.pollOptions = stringArray;
                this.finishHeight = n;
                this.votingModel = by;
                this.minNumberOfOptions = by2;
                this.maxNumberOfOptions = by3;
                this.minRangeValue = by4;
                this.maxRangeValue = by5;
                this.minBalanceModel = VoteWeighting.VotingModel.get(by).getMinBalanceModel().getCode();
            }

            public PollBuilder minBalance(byte by, long l) {
                this.minBalanceModel = by;
                this.minBalance = l;
                return this;
            }

            public PollBuilder holdingId(long l) {
                this.holdingId = l;
                return this;
            }

            public MessagingPollCreation build() {
                return new MessagingPollCreation(this);
            }
        }
    }

    public static final class MessagingAliasDelete
    extends AbstractAttachment {
        private final String aliasName;

        MessagingAliasDelete(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.aliasName = MessagingAliasAssignment.ALIAS_NAME_RW.readFromBuffer(byteBuffer);
        }

        MessagingAliasDelete(JSONObject jSONObject) {
            super(jSONObject);
            this.aliasName = Convert.nullToEmpty((String)jSONObject.get("alias"));
        }

        public MessagingAliasDelete(String string) {
            this.aliasName = string;
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.ALIAS_DELETE;
        }

        @Override
        int getMySize() {
            return MessagingAliasAssignment.ALIAS_NAME_RW.getSize(this.aliasName);
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            MessagingAliasAssignment.ALIAS_NAME_RW.writeToBuffer(this.aliasName, byteBuffer);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("alias", this.aliasName);
        }

        public String getAliasName() {
            return this.aliasName;
        }
    }

    public static final class MessagingAliasBuy
    extends AbstractAttachment {
        private final String aliasName;

        MessagingAliasBuy(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.aliasName = MessagingAliasAssignment.ALIAS_NAME_RW.readFromBuffer(byteBuffer);
        }

        MessagingAliasBuy(JSONObject jSONObject) {
            super(jSONObject);
            this.aliasName = Convert.nullToEmpty((String)jSONObject.get("alias"));
        }

        public MessagingAliasBuy(String string) {
            this.aliasName = string;
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.ALIAS_BUY;
        }

        @Override
        int getMySize() {
            return MessagingAliasAssignment.ALIAS_NAME_RW.getSize(this.aliasName);
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            MessagingAliasAssignment.ALIAS_NAME_RW.writeToBuffer(this.aliasName, byteBuffer);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("alias", this.aliasName);
        }

        public String getAliasName() {
            return this.aliasName;
        }
    }

    public static final class MessagingAliasSell
    extends AbstractAttachment {
        private final String aliasName;
        private final long priceNQT;

        MessagingAliasSell(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.aliasName = MessagingAliasAssignment.ALIAS_NAME_RW.readFromBuffer(byteBuffer);
            this.priceNQT = byteBuffer.getLong();
        }

        MessagingAliasSell(JSONObject jSONObject) {
            super(jSONObject);
            this.aliasName = Convert.nullToEmpty((String)jSONObject.get("alias"));
            this.priceNQT = Convert.parseLong(jSONObject.get("priceNQT"));
        }

        public MessagingAliasSell(String string, long l) {
            this.aliasName = string;
            this.priceNQT = l;
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.ALIAS_SELL;
        }

        @Override
        int getMySize() {
            return MessagingAliasAssignment.ALIAS_NAME_RW.getSize(this.aliasName) + 8;
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            MessagingAliasAssignment.ALIAS_NAME_RW.writeToBuffer(this.aliasName, byteBuffer);
            byteBuffer.putLong(this.priceNQT);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("alias", this.aliasName);
            jSONObject.put("priceNQT", this.priceNQT);
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }
    }

    public static final class MessagingAliasAssignment
    extends AbstractAttachment {
        public static final StringRw ALIAS_NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 100);
        public static final StringRw ALIAS_URI_RW = new StringRw(LengthRwPrimitiveType.SHORT, 1000);
        private final String aliasName;
        private final String aliasURI;

        MessagingAliasAssignment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            super(byteBuffer);
            this.aliasName = ALIAS_NAME_RW.readFromBuffer(byteBuffer).trim();
            this.aliasURI = ALIAS_URI_RW.readFromBuffer(byteBuffer).trim();
        }

        MessagingAliasAssignment(JSONObject jSONObject) {
            super(jSONObject);
            this.aliasName = Convert.nullToEmpty((String)jSONObject.get("alias")).trim();
            this.aliasURI = Convert.nullToEmpty((String)jSONObject.get("uri")).trim();
        }

        public MessagingAliasAssignment(String string, String string2) {
            this.aliasName = string.trim();
            this.aliasURI = string2.trim();
        }

        @Override
        int getMySize() {
            return ALIAS_NAME_RW.getSize(this.aliasName) + ALIAS_URI_RW.getSize(this.aliasURI);
        }

        @Override
        void putMyBytes(ByteBuffer byteBuffer) {
            ALIAS_NAME_RW.writeToBuffer(this.aliasName, byteBuffer);
            ALIAS_URI_RW.writeToBuffer(this.aliasURI, byteBuffer);
        }

        @Override
        void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("alias", this.aliasName);
            jSONObject.put("uri", this.aliasURI);
        }

        @Override
        public TransactionType getTransactionType() {
            return TransactionType.Messaging.ALIAS_ASSIGNMENT;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public String getAliasURI() {
            return this.aliasURI;
        }
    }

    public static abstract class PropertyDeleteAttachment
    extends AbstractAttachment {
        private final long propertyId;

        protected PropertyDeleteAttachment(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.propertyId = byteBuffer.getLong();
        }

        protected PropertyDeleteAttachment(JSONObject jSONObject) {
            super(jSONObject);
            this.propertyId = Convert.parseUnsignedLong((String)jSONObject.get("property"));
        }

        public PropertyDeleteAttachment(long l) {
            this.propertyId = l;
        }

        @Override
        protected int getMySize() {
            return 8;
        }

        @Override
        protected void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.propertyId);
        }

        @Override
        protected void putMyJSON(JSONObject jSONObject) {
            jSONObject.put("property", Long.toUnsignedString(this.propertyId));
        }

        public long getPropertyId() {
            return this.propertyId;
        }
    }

    public static abstract class EmptyAttachment
    extends AbstractAttachment {
        private EmptyAttachment() {
            super(0);
        }

        @Override
        final int getMySize() {
            return 0;
        }

        @Override
        final void putMyBytes(ByteBuffer byteBuffer) {
        }

        @Override
        final void putMyJSON(JSONObject jSONObject) {
        }

        @Override
        final boolean verifyVersion() {
            return this.getVersion() == 0;
        }
    }

    public static abstract class AbstractAttachment
    extends Appendix.AbstractAppendix
    implements Attachment {
        private AbstractAttachment(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        private AbstractAttachment(JSONObject jSONObject) {
            super(jSONObject);
        }

        private AbstractAttachment(int n) {
            super(n);
        }

        private AbstractAttachment() {
        }

        @Override
        final String getAppendixName() {
            return this.getTransactionType().getName();
        }

        @Override
        final void validate(Transaction transaction) throws NxtException.ValidationException {
            this.getTransactionType().validateAttachment(transaction);
        }

        @Override
        final void apply(Transaction transaction, Account account, Account account2) {
            this.getTransactionType().apply((TransactionImpl)transaction, account, account2);
        }

        @Override
        public final Fee getBaselineFee(Transaction transaction) {
            return this.getTransactionType().getBaselineFee(transaction);
        }

        @Override
        public final Fee getNextFee(Transaction transaction) {
            return this.getTransactionType().getNextFee(transaction);
        }

        @Override
        public final int getBaselineFeeHeight() {
            return this.getTransactionType().getBaselineFeeHeight();
        }

        @Override
        public final int getNextFeeHeight() {
            return this.getTransactionType().getNextFeeHeight();
        }

        @Override
        final boolean isPhasable() {
            return !(this instanceof Appendix.Prunable) && this.getTransactionType().isPhasable();
        }

        final int getFinishValidationHeight(Transaction transaction) {
            return this.isPhased(transaction) ? transaction.getPhasing().getFinishHeight() - 1 : Nxt.getBlockchain().getHeight();
        }
    }
}

