/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import nxt.Block;
import nxt.BlockImpl;
import nxt.Blockchain;
import nxt.BlockchainProcessor;
import nxt.BlockchainProcessorImpl;
import nxt.Db;
import nxt.Nxt;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.db.DbUtils;
import nxt.util.Logger;

final class BlockDb {
    static final int BLOCK_CACHE_SIZE = 10;
    static final Map<Long, BlockImpl> blockCache = new HashMap<Long, BlockImpl>();
    static final SortedMap<Integer, BlockImpl> heightMap = new TreeMap<Integer, BlockImpl>();
    static final Map<Long, TransactionImpl> transactionCache = new HashMap<Long, TransactionImpl>();
    static final Blockchain blockchain = Nxt.getBlockchain();

    BlockDb() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearBlockCache() {
        Map<Long, BlockImpl> map = blockCache;
        synchronized (map) {
            blockCache.clear();
            heightMap.clear();
            transactionCache.clear();
        }
    }

    /*
     * Exception decompiling
     */
    static BlockImpl findBlock(long var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean hasBlock(long l) {
        return BlockDb.hasBlock(l, Integer.MAX_VALUE);
    }

    /*
     * Exception decompiling
     */
    static boolean hasBlock(long var0, int var2_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static long findBlockIdAtHeight(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static BlockImpl findBlockAtHeight(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static BlockImpl findLastBlock() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static BlockImpl findLastBlock(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static Set<Long> getBlockGenerators(int n) {
        HashSet<Long> hashSet = new HashSet<Long>();
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT generator_id, COUNT(generator_id) AS count FROM block WHERE height >= ? GROUP BY generator_id");){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    if (resultSet.getInt("count") <= 1) continue;
                    hashSet.add(resultSet.getLong("generator_id"));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        return hashSet;
    }

    static BlockImpl loadBlock(Connection connection, ResultSet resultSet) {
        return BlockDb.loadBlock(connection, resultSet, false);
    }

    static BlockImpl loadBlock(Connection connection, ResultSet resultSet, boolean bl) {
        try {
            int n = resultSet.getInt("version");
            int n2 = resultSet.getInt("timestamp");
            long l = resultSet.getLong("previous_block_id");
            long l2 = resultSet.getLong("total_amount");
            long l3 = resultSet.getLong("total_fee");
            int n3 = resultSet.getInt("payload_length");
            long l4 = resultSet.getLong("generator_id");
            byte[] byArray = resultSet.getBytes("previous_block_hash");
            BigInteger bigInteger = new BigInteger(resultSet.getBytes("cumulative_difficulty"));
            long l5 = resultSet.getLong("base_target");
            long l6 = resultSet.getLong("next_block_id");
            if (l6 == 0L && !resultSet.wasNull()) {
                throw new IllegalStateException("Attempting to load invalid block");
            }
            int n4 = resultSet.getInt("height");
            byte[] byArray2 = resultSet.getBytes("generation_signature");
            byte[] byArray3 = resultSet.getBytes("block_signature");
            byte[] byArray4 = resultSet.getBytes("payload_hash");
            long l7 = resultSet.getLong("id");
            return new BlockImpl(n, n2, l, l2, l3, n3, byArray4, l4, byArray2, byArray3, byArray, bigInteger, l5, l6, n4, l7, bl ? TransactionDb.findBlockTransactions(connection, l7) : null);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveBlock(Connection connection, BlockImpl blockImpl) {
        block19: {
            try {
                try (Object object = connection.prepareStatement("INSERT INTO block (id, version, timestamp, previous_block_id, total_amount, total_fee, payload_length, previous_block_hash, next_block_id, cumulative_difficulty, base_target, height, generation_signature, block_signature, payload_hash, generator_id)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                    int n = 0;
                    object.setLong(++n, blockImpl.getId());
                    object.setInt(++n, blockImpl.getVersion());
                    object.setInt(++n, blockImpl.getTimestamp());
                    DbUtils.setLongZeroToNull((PreparedStatement)object, ++n, blockImpl.getPreviousBlockId());
                    object.setLong(++n, blockImpl.getTotalAmountNQT());
                    object.setLong(++n, blockImpl.getTotalFeeNQT());
                    object.setInt(++n, blockImpl.getPayloadLength());
                    object.setBytes(++n, blockImpl.getPreviousBlockHash());
                    object.setLong(++n, 0L);
                    object.setBytes(++n, blockImpl.getCumulativeDifficulty().toByteArray());
                    object.setLong(++n, blockImpl.getBaseTarget());
                    object.setInt(++n, blockImpl.getHeight());
                    object.setBytes(++n, blockImpl.getGenerationSignature());
                    object.setBytes(++n, blockImpl.getBlockSignature());
                    object.setBytes(++n, blockImpl.getPayloadHash());
                    object.setLong(++n, blockImpl.getGeneratorId());
                    object.executeUpdate();
                    TransactionDb.saveTransactions(connection, blockImpl.getTransactions());
                }
                if (blockImpl.getPreviousBlockId() == 0L) break block19;
                object = connection.prepareStatement("UPDATE block SET next_block_id = ? WHERE id = ?");
                try {
                    object.setLong(1, blockImpl.getId());
                    object.setLong(2, blockImpl.getPreviousBlockId());
                    object.executeUpdate();
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                Map<Long, BlockImpl> map = blockCache;
                synchronized (map) {
                    object = blockCache.get(blockImpl.getPreviousBlockId());
                }
                if (object != null) {
                    ((BlockImpl)object).setNextBlockId(blockImpl.getId());
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
        }
    }

    static void commit(Block block) {
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("UPDATE block SET next_block_id = NULL WHERE id = ?");){
            preparedStatement.setLong(1, block.getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    static void deleteBlocksFromHeight(int n) {
        long l;
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT id FROM block WHERE height = ?");){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    return;
                }
                l = resultSet.getLong("id");
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        Logger.logDebugMessage("Deleting blocks starting from height %s", n);
        BlockDb.deleteBlocksFrom(l);
    }

    /*
     * Exception decompiling
     */
    static BlockImpl deleteBlocksFrom(long var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void deleteAll() {
        if (!Db.db.isInTransaction()) {
            try {
                Db.db.beginTransaction();
                BlockDb.deleteAll();
                Db.db.commitTransaction();
            }
            catch (Exception exception) {
                Db.db.rollbackTransaction();
                throw exception;
            }
            finally {
                Db.db.endTransaction();
            }
            return;
        }
        Logger.logMessage("Deleting blockchain...");
        try (Connection connection = Db.db.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.executeUpdate("SET REFERENTIAL_INTEGRITY FALSE");
                statement.executeUpdate("TRUNCATE TABLE transaction");
                statement.executeUpdate("TRUNCATE TABLE block");
                BlockchainProcessorImpl.getInstance().getDerivedTables().forEach(derivedDbTable -> {
                    try {
                        statement.executeUpdate("TRUNCATE TABLE " + derivedDbTable.toString());
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                });
                statement.executeUpdate("SET REFERENTIAL_INTEGRITY TRUE");
                Db.db.commitTransaction();
            }
            catch (SQLException sQLException) {
                Db.db.rollbackTransaction();
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            BlockDb.clearBlockCache();
        }
    }

    static {
        Nxt.getBlockchainProcessor().addListener(block -> {
            Map<Long, BlockImpl> map = blockCache;
            synchronized (map) {
                int n = block.getHeight();
                Iterator<BlockImpl> iterator = blockCache.values().iterator();
                while (iterator.hasNext()) {
                    Block block2 = iterator.next();
                    int n2 = block2.getHeight();
                    if (n2 > n - 10 && n2 < n) continue;
                    block2.getTransactions().forEach(transaction -> transactionCache.remove(transaction.getId()));
                    heightMap.remove(n2);
                    iterator.remove();
                }
                block.getTransactions().forEach(transaction -> transactionCache.put(transaction.getId(), (TransactionImpl)transaction));
                heightMap.put(n, (BlockImpl)block);
                blockCache.put(block.getId(), (BlockImpl)block);
            }
        }, BlockchainProcessor.Event.BLOCK_PUSHED);
    }
}

