/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Appendix;
import nxt.Attachment;
import nxt.Block;
import nxt.BlockDb;
import nxt.BlockImpl;
import nxt.BlockchainImpl;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Db;
import nxt.Generator;
import nxt.Genesis;
import nxt.Nxt;
import nxt.NxtException;
import nxt.PhasingPoll;
import nxt.PrunableMessage;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.TransactionProcessor;
import nxt.TransactionProcessorImpl;
import nxt.TransactionType;
import nxt.UnconfirmedTransaction;
import nxt.crypto.Crypto;
import nxt.db.DbIterator;
import nxt.db.DerivedDbTable;
import nxt.db.FilteringIterator;
import nxt.db.FullTextTrigger;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;

final class BlockchainProcessorImpl
implements BlockchainProcessor {
    private static final NavigableMap<Integer, byte[]> checksums;
    private static final boolean LOG_DOWNLOADING_STATS = true;
    private int statsTotalTxCount;
    private int[] statsTxByType = new int[8];
    private long statsProcessingTime;
    private static final BlockchainProcessorImpl instance;
    private final BlockchainImpl blockchain = BlockchainImpl.getInstance();
    private final ExecutorService networkService = Executors.newCachedThreadPool();
    private final List<DerivedDbTable> derivedTables = new CopyOnWriteArrayList<DerivedDbTable>();
    private final boolean trimDerivedTables = Nxt.getBooleanProperty("nxt.trimDerivedTables");
    private final int defaultNumberOfForkConfirmations = Nxt.getIntProperty(Constants.isTestnet ? "nxt.testnetNumberOfForkConfirmations" : "nxt.numberOfForkConfirmations");
    private final boolean simulateEndlessDownload = Nxt.getBooleanProperty("nxt.simulateEndlessDownload");
    private int initialScanHeight;
    private volatile int lastTrimHeight;
    private volatile int lastRestoreTime = 0;
    private final Set<Long> prunableTransactions = new HashSet<Long>();
    private final Listeners<Block, BlockchainProcessor.Event> blockListeners = new Listeners();
    private volatile Peer lastBlockchainFeeder;
    private volatile int lastBlockchainFeederHeight;
    private volatile boolean getMoreBlocks = true;
    private volatile boolean isShuttingDown;
    private volatile boolean isTrimming;
    private volatile boolean isScanning;
    private volatile boolean isDownloading;
    private volatile boolean isProcessingBlock;
    private volatile boolean isRestoring;
    private volatile boolean alreadyInitialized = false;
    private volatile long genesisBlockId;
    private final Runnable getMoreBlocksThread = new Runnable(){
        private final JSONStreamAware getCumulativeDifficultyRequest;
        private boolean peerHasMore;
        private List<Peer> connectedPublicPeers;
        private List<Long> chainBlockIds;
        private long totalTime;
        private long totalBlocks;
        {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("requestType", "getCumulativeDifficulty");
            this.getCumulativeDifficultyRequest = JSON.prepareRequest(jSONObject);
            this.totalTime = 1L;
        }

        @Override
        public void run() {
            try {
                int n;
                do {
                    if (!BlockchainProcessorImpl.this.getMoreBlocks) {
                        return;
                    }
                    n = BlockchainProcessorImpl.this.blockchain.getHeight();
                    this.downloadPeer();
                } while (BlockchainProcessorImpl.this.blockchain.getHeight() != n);
                if (BlockchainProcessorImpl.this.isDownloading && !BlockchainProcessorImpl.this.simulateEndlessDownload) {
                    Logger.logMessage("Finished blockchain download");
                    BlockchainProcessorImpl.this.isDownloading = false;
                }
                n = Nxt.getEpochTime();
                if (!BlockchainProcessorImpl.this.isRestoring && !BlockchainProcessorImpl.this.prunableTransactions.isEmpty() && n - BlockchainProcessorImpl.this.lastRestoreTime > 3600) {
                    BlockchainProcessorImpl.this.isRestoring = true;
                    BlockchainProcessorImpl.this.lastRestoreTime = n;
                    BlockchainProcessorImpl.this.networkService.submit(new RestorePrunableDataTask());
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.logDebugMessage("Blockchain download thread interrupted");
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString(), throwable);
                System.exit(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadPeer() throws InterruptedException {
            try {
                long l = System.currentTimeMillis();
                int n = BlockchainProcessorImpl.this.blockchain.getHeight() > -720 ? BlockchainProcessorImpl.this.defaultNumberOfForkConfirmations : Math.min(1, BlockchainProcessorImpl.this.defaultNumberOfForkConfirmations);
                this.connectedPublicPeers = Peers.getPublicPeers(Peer.State.CONNECTED, true);
                if (this.connectedPublicPeers.size() <= n) {
                    return;
                }
                this.peerHasMore = true;
                Peer peer = Peers.getWeightedPeer(this.connectedPublicPeers);
                if (peer == null) {
                    return;
                }
                JSONObject jSONObject = peer.send(this.getCumulativeDifficultyRequest);
                if (jSONObject == null) {
                    return;
                }
                BigInteger bigInteger = BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty();
                String string = (String)jSONObject.get("cumulativeDifficulty");
                if (string == null) {
                    return;
                }
                BigInteger bigInteger2 = new BigInteger(string);
                if (bigInteger2.compareTo(bigInteger) < 0) {
                    return;
                }
                if (jSONObject.get("blockchainHeight") != null) {
                    BlockchainProcessorImpl.this.lastBlockchainFeeder = peer;
                    BlockchainProcessorImpl.this.lastBlockchainFeederHeight = ((Long)jSONObject.get("blockchainHeight")).intValue();
                }
                if (bigInteger2.equals(bigInteger)) {
                    return;
                }
                long l2 = BlockchainProcessorImpl.this.genesisBlockId;
                if (BlockchainProcessorImpl.this.blockchain.getHeight() > 0) {
                    l2 = this.getCommonMilestoneBlockId(peer);
                }
                if (l2 == 0L || !this.peerHasMore) {
                    return;
                }
                this.chainBlockIds = this.getBlockIdsAfterCommon(peer, l2, false);
                if (this.chainBlockIds.size() < 2 || !this.peerHasMore) {
                    if (l2 == BlockchainProcessorImpl.this.genesisBlockId) {
                        Logger.logInfoMessage(String.format("Cannot load blocks after genesis block %d from peer %s, perhaps using different Genesis block", l2, peer.getAnnouncedAddress()));
                    }
                    return;
                }
                long l3 = this.chainBlockIds.get(0);
                BlockImpl blockImpl = BlockchainProcessorImpl.this.blockchain.getBlock(l3);
                if (blockImpl == null || BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl.getHeight() >= 720) {
                    if (blockImpl != null) {
                        Logger.logDebugMessage(peer + " advertised chain with better difficulty, but the last common block is at height " + blockImpl.getHeight());
                    }
                    return;
                }
                if (BlockchainProcessorImpl.this.simulateEndlessDownload) {
                    BlockchainProcessorImpl.this.isDownloading = true;
                    return;
                }
                if (!BlockchainProcessorImpl.this.isDownloading && BlockchainProcessorImpl.this.lastBlockchainFeederHeight - blockImpl.getHeight() > 10) {
                    Logger.logMessage("Blockchain download in progress");
                    BlockchainProcessorImpl.this.isDownloading = true;
                }
                BlockchainProcessorImpl.this.blockchain.updateLock();
                try {
                    if (bigInteger2.compareTo(BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty()) <= 0) {
                        return;
                    }
                    long l4 = BlockchainProcessorImpl.this.blockchain.getLastBlock().getId();
                    this.downloadBlockchain(peer, blockImpl, blockImpl.getHeight());
                    if (BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl.getHeight() <= 10) {
                        return;
                    }
                    int n2 = 0;
                    for (Peer peer2 : this.connectedPublicPeers) {
                        String string2;
                        JSONObject jSONObject2;
                        if (n2 >= n) break;
                        if (peer.getHost().equals(peer2.getHost())) continue;
                        this.chainBlockIds = this.getBlockIdsAfterCommon(peer2, l3, true);
                        if (this.chainBlockIds.isEmpty()) continue;
                        long l5 = this.chainBlockIds.get(0);
                        if (l5 == BlockchainProcessorImpl.this.blockchain.getLastBlock().getId()) {
                            ++n2;
                            continue;
                        }
                        BlockImpl blockImpl2 = BlockchainProcessorImpl.this.blockchain.getBlock(l5);
                        if (BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl2.getHeight() >= 720 || (jSONObject2 = peer.send(this.getCumulativeDifficultyRequest)) == null || (string2 = (String)jSONObject.get("cumulativeDifficulty")) == null || new BigInteger(string2).compareTo(BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty()) <= 0) continue;
                        Logger.logDebugMessage("Found a peer with better difficulty");
                        this.downloadBlockchain(peer2, blockImpl2, blockImpl.getHeight());
                    }
                    Logger.logDebugMessage("Got " + n2 + " confirmations");
                    if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() != l4) {
                        long l6 = System.currentTimeMillis() - l;
                        this.totalTime += l6;
                        int n3 = BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl.getHeight();
                        this.totalBlocks += (long)n3;
                        Logger.logMessage("Downloaded " + n3 + " blocks in " + l6 / 1000L + " s, " + this.totalBlocks * 1000L / this.totalTime + " per s, " + this.totalTime * (long)(BlockchainProcessorImpl.this.lastBlockchainFeederHeight - BlockchainProcessorImpl.this.blockchain.getHeight()) / (this.totalBlocks * 1000L * 60L) + " min left");
                        Logger.logMessage("Tx total: " + BlockchainProcessorImpl.this.statsTotalTxCount + " by type: " + Arrays.toString(BlockchainProcessorImpl.this.statsTxByType) + " processing time: " + BlockchainProcessorImpl.this.statsProcessingTime + "ms");
                        BlockchainProcessorImpl.this.statsTotalTxCount = 0;
                        Arrays.fill(BlockchainProcessorImpl.this.statsTxByType, 0);
                        BlockchainProcessorImpl.this.statsProcessingTime = 0L;
                    } else {
                        Logger.logDebugMessage("Did not accept peer's blocks, back to our own fork");
                    }
                }
                finally {
                    BlockchainProcessorImpl.this.blockchain.updateUnlock();
                }
            }
            catch (NxtException.StopException stopException) {
                Logger.logMessage("Blockchain download stopped: " + stopException.getMessage());
                throw new InterruptedException("Blockchain download stopped");
            }
            catch (Exception exception) {
                Logger.logMessage("Error in blockchain download thread", exception);
            }
        }

        private long getCommonMilestoneBlockId(Peer peer) {
            String string = null;
            block0: while (true) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("requestType", "getMilestoneBlockIds");
                if (string == null) {
                    jSONObject.put("lastBlockId", BlockchainProcessorImpl.this.blockchain.getLastBlock().getStringId());
                } else {
                    jSONObject.put("lastMilestoneBlockId", string);
                }
                JSONObject jSONObject2 = peer.send(JSON.prepareRequest(jSONObject));
                if (jSONObject2 == null) {
                    return 0L;
                }
                JSONArray jSONArray = (JSONArray)jSONObject2.get("milestoneBlockIds");
                if (jSONArray == null) {
                    return 0L;
                }
                if (jSONArray.isEmpty()) {
                    return BlockchainProcessorImpl.this.genesisBlockId;
                }
                if (jSONArray.size() > 20) {
                    Logger.logDebugMessage("Obsolete or rogue peer " + peer.getHost() + " sends too many milestoneBlockIds, blacklisting");
                    peer.blacklist("Too many milestoneBlockIds");
                    return 0L;
                }
                if (Boolean.TRUE.equals(jSONObject2.get("last"))) {
                    this.peerHasMore = false;
                }
                Iterator iterator = jSONArray.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    Object e = iterator.next();
                    long l = Convert.parseUnsignedLong((String)e);
                    if (BlockDb.hasBlock(l)) {
                        if (string == null && jSONArray.size() > 1) {
                            this.peerHasMore = false;
                        }
                        return l;
                    }
                    string = (String)e;
                }
                break;
            }
        }

        private List<Long> getBlockIdsAfterCommon(Peer peer, long l, boolean bl) {
            boolean bl2;
            long l2 = l;
            ArrayList<Long> arrayList = new ArrayList<Long>(720);
            boolean bl3 = false;
            int n = bl ? 720 : 1440;
            block0: do {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("requestType", "getNextBlockIds");
                jSONObject.put("blockId", Long.toUnsignedString(l2));
                jSONObject.put("limit", n);
                JSONObject jSONObject2 = peer.send(JSON.prepareRequest(jSONObject));
                if (jSONObject2 == null) {
                    return Collections.emptyList();
                }
                JSONArray jSONArray = (JSONArray)jSONObject2.get("nextBlockIds");
                if (jSONArray == null || jSONArray.size() == 0) break;
                if (jSONArray.size() > n) {
                    Logger.logDebugMessage("Obsolete or rogue peer " + peer.getHost() + " sends too many nextBlockIds, blacklisting");
                    peer.blacklist("Too many nextBlockIds");
                    return Collections.emptyList();
                }
                bl2 = true;
                int n2 = 0;
                for (Object e : jSONArray) {
                    long l3 = Convert.parseUnsignedLong((String)e);
                    if (bl2) {
                        if (BlockDb.hasBlock(l3)) {
                            l2 = l3;
                            bl3 = true;
                        } else {
                            arrayList.add(l2);
                            arrayList.add(l3);
                            bl2 = false;
                        }
                    } else {
                        arrayList.add(l3);
                        if (arrayList.size() >= 720) continue block0;
                    }
                    if (!bl || ++n2 < 720) continue;
                    continue block0;
                }
            } while (bl2 && !bl);
            if (arrayList.isEmpty() && bl3) {
                arrayList.add(l2);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadBlockchain(Peer peer, Block block, int n) throws InterruptedException {
            Object object;
            Object object2;
            Object object3;
            int n2;
            HashMap<Long, PeerBlock> hashMap = new HashMap<Long, PeerBlock>();
            ArrayList<GetNextBlocks> arrayList = new ArrayList<GetNextBlocks>();
            int n3 = 36;
            int n4 = this.chainBlockIds.size() - 1;
            for (n2 = 0; n2 < n4; n2 += n3) {
                arrayList.add(new GetNextBlocks(this.chainBlockIds, n2, Math.min(n2 + n3, n4)));
            }
            n2 = ThreadLocalRandom.current().nextInt(this.connectedPublicPeers.size());
            long l = 0L;
            Peer peer2 = null;
            block8: while (!arrayList.isEmpty()) {
                for (GetNextBlocks getNextBlocks : arrayList) {
                    if (getNextBlocks.getRequestCount() > 1) break block8;
                    if (getNextBlocks.getStart() == 0 || getNextBlocks.getRequestCount() != 0) {
                        object3 = peer;
                    } else {
                        if (n2 >= this.connectedPublicPeers.size()) {
                            n2 = 0;
                        }
                        object3 = this.connectedPublicPeers.get(n2++);
                    }
                    if (getNextBlocks.getPeer() == object3) break block8;
                    getNextBlocks.setPeer((Peer)object3);
                    object2 = BlockchainProcessorImpl.this.networkService.submit(getNextBlocks);
                    getNextBlocks.setFuture((Future<List<BlockImpl>>)object2);
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    BlockImpl blockImpl;
                    GetNextBlocks getNextBlocks;
                    getNextBlocks = (GetNextBlocks)object.next();
                    try {
                        object3 = getNextBlocks.getFuture().get();
                    }
                    catch (ExecutionException executionException) {
                        throw new RuntimeException(executionException.getMessage(), executionException);
                    }
                    if (object3 == null) {
                        getNextBlocks.getPeer().deactivate();
                        continue;
                    }
                    object2 = getNextBlocks.getPeer();
                    int n5 = getNextBlocks.getStart() + 1;
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext() && (blockImpl = (BlockImpl)iterator.next()).getId() == this.chainBlockIds.get(n5).longValue()) {
                        hashMap.put(blockImpl.getId(), new PeerBlock((Peer)object2, blockImpl));
                        ++n5;
                    }
                    if (n5 > getNextBlocks.getStop()) {
                        object.remove();
                    } else {
                        getNextBlocks.setStart(n5 - 1);
                    }
                    if (getNextBlocks.getResponseTime() <= l) continue;
                    l = getNextBlocks.getResponseTime();
                    peer2 = getNextBlocks.getPeer();
                }
            }
            if (peer2 != null && this.connectedPublicPeers.size() >= Peers.maxNumberOfConnectedPublicPeers && this.chainBlockIds.size() > 360) {
                Logger.logDebugMessage(peer2.getHost() + " took " + l + " ms, disconnecting");
                peer2.deactivate();
            }
            BlockchainProcessorImpl.this.blockchain.writeLock();
            try {
                int n6;
                object = new ArrayList();
                for (n6 = 1; n6 < this.chainBlockIds.size() && BlockchainProcessorImpl.this.blockchain.getHeight() - n < 720 && (object3 = (PeerBlock)hashMap.get(this.chainBlockIds.get(n6))) != null && BlockchainProcessorImpl.this.getMoreBlocks; ++n6) {
                    object2 = ((PeerBlock)object3).getBlock();
                    if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() == ((BlockImpl)object2).getPreviousBlockId()) {
                        try {
                            long l2 = System.currentTimeMillis();
                            BlockchainProcessorImpl.this.pushBlock((BlockImpl)object2);
                            BlockchainProcessorImpl.this.statsProcessingTime += System.currentTimeMillis() - l2;
                        }
                        catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                            ((PeerBlock)object3).getPeer().blacklist(blockNotAcceptedException);
                        }
                        continue;
                    }
                    object.add(object2);
                }
                n6 = BlockchainProcessorImpl.this.blockchain.getHeight() - n;
                if (!object.isEmpty() && n6 < 720) {
                    Logger.logDebugMessage("Will process a fork of " + object.size() + " blocks, mine is " + n6);
                    this.processFork(peer, (List<BlockImpl>)object, block);
                }
            }
            finally {
                BlockchainProcessorImpl.this.blockchain.writeUnlock();
            }
        }

        private void processFork(Peer peer, List<BlockImpl> list, Block block) {
            BigInteger bigInteger = BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty();
            List<BlockImpl> list2 = BlockchainProcessorImpl.this.popOffTo(block);
            int n = 0;
            if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() == block.getId()) {
                for (BlockImpl object2 : list) {
                    if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() != object2.getPreviousBlockId()) continue;
                    try {
                        BlockchainProcessorImpl.this.pushBlock(object2);
                        ++n;
                    }
                    catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                        peer.blacklist(blockNotAcceptedException);
                        break;
                    }
                }
            }
            if (n > 0 && BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty().compareTo(bigInteger) < 0) {
                Logger.logDebugMessage("Pop off caused by peer " + peer.getHost() + ", blacklisting");
                peer.blacklist("Pop off");
                List<BlockImpl> list3 = BlockchainProcessorImpl.this.popOffTo(block);
                n = 0;
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    BlockImpl blockImpl = (BlockImpl)iterator.next();
                    TransactionProcessorImpl.getInstance().processLater(blockImpl.getTransactions());
                }
            }
            if (n == 0) {
                Logger.logDebugMessage("Didn't accept any blocks, pushing back my previous blocks");
                for (int i = list2.size() - 1; i >= 0; --i) {
                    BlockImpl blockImpl = list2.remove(i);
                    try {
                        BlockchainProcessorImpl.this.pushBlock(blockImpl);
                        continue;
                    }
                    catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                        Logger.logErrorMessage("Popped off block no longer acceptable: " + blockImpl.getJSONObject().toJSONString(), blockNotAcceptedException);
                        break;
                    }
                }
            } else {
                Logger.logDebugMessage("Switched to peer's fork");
                for (BlockImpl blockImpl : list2) {
                    TransactionProcessorImpl.getInstance().processLater(blockImpl.getTransactions());
                }
            }
        }
    };
    private final Listener<Block> checksumListener = block -> {
        byte[] byArray = (byte[])checksums.get(block.getHeight());
        if (byArray == null) {
            return;
        }
        int n = block.getHeight();
        int n2 = checksums.lowerKey(n);
        byte[] byArray2 = Crypto.sha256().digest(block.getBytes());
        if (byArray.length == 0) {
            Logger.logMessage("Checksum calculated:\n" + Arrays.toString(byArray2));
        } else if (!Arrays.equals(byArray2, byArray)) {
            Logger.logErrorMessage("Checksum failed at block " + n + ": " + Arrays.toString(byArray2));
            if (this.isScanning) {
                throw new RuntimeException("Invalid checksum, interrupting rescan");
            }
            this.popOffTo(n2);
        } else {
            Logger.logMessage("Checksum passed at block " + n);
        }
    };
    private static final Comparator<Transaction> finishingTransactionsComparator;
    private static final Comparator<UnconfirmedTransaction> transactionArrivalComparator;

    static BlockchainProcessorImpl getInstance() {
        return instance;
    }

    private BlockchainProcessorImpl() {
        int n = Nxt.getIntProperty("nxt.trimFrequency");
        this.blockListeners.addListener((T block) -> {
            if (block.getHeight() % 5000 == 0) {
                Logger.logMessage("processed block " + block.getHeight());
            }
            if (this.trimDerivedTables && block.getHeight() % n == 0) {
                this.doTrimDerivedTables();
            }
        }, BlockchainProcessor.Event.BLOCK_SCANNED);
        this.blockListeners.addListener((T block) -> {
            if (this.trimDerivedTables && block.getHeight() % n == 0 && !this.isTrimming) {
                this.isTrimming = true;
                this.networkService.submit(() -> {
                    this.trimDerivedTables();
                    this.isTrimming = false;
                });
            }
            if (block.getHeight() % 5000 == 0) {
                Logger.logMessage("received block " + block.getHeight());
                if (!this.isDownloading || block.getHeight() % 50000 == 0) {
                    Logger.logMessage("Analyzing tables");
                    this.networkService.submit(Db.db::analyzeTables);
                }
            }
        }, BlockchainProcessor.Event.BLOCK_PUSHED);
        this.blockListeners.addListener(this.checksumListener, BlockchainProcessor.Event.BLOCK_PUSHED);
        this.blockListeners.addListener((T block) -> Db.db.analyzeTables(), BlockchainProcessor.Event.RESCAN_END);
        int n2 = Nxt.getIntProperty("nxt.stopDownloadHeight");
        if (n2 > 0) {
            this.blockListeners.addListener((T block) -> {
                if (block.getHeight() == n2) {
                    this.setGetMoreBlocks(false);
                    Peers.disableNetworking();
                    throw new NxtException.StopException(String.format("Reached height %d, stopping download and going offline", n2));
                }
            }, BlockchainProcessor.Event.BLOCK_PUSHED);
        }
        ThreadPool.runBeforeStart(() -> {
            this.alreadyInitialized = true;
            this.addGenesisBlock();
            if (Nxt.getBooleanProperty("nxt.forceScan")) {
                this.scan(0, Nxt.getBooleanProperty("nxt.forceValidate"));
            } else {
                int n;
                boolean bl;
                boolean bl2;
                try (Connection connection = Db.db.getConnection();
                     Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery("SELECT * FROM scan");){
                    resultSet.next();
                    bl2 = resultSet.getBoolean("rescan");
                    bl = resultSet.getBoolean("validate");
                    n = resultSet.getInt("height");
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString(), sQLException);
                }
                if (bl2) {
                    this.scan(n, bl);
                }
            }
        }, false);
        if (!Constants.isLightClient && !Constants.isOffline) {
            ThreadPool.scheduleThread("GetMoreBlocks", this.getMoreBlocksThread, 1);
        }
    }

    @Override
    public boolean addListener(Listener<Block> listener, BlockchainProcessor.Event event) {
        return this.blockListeners.addListener(listener, event);
    }

    @Override
    public boolean removeListener(Listener<Block> listener, BlockchainProcessor.Event event) {
        return this.blockListeners.removeListener(listener, event);
    }

    @Override
    public void registerDerivedTable(DerivedDbTable derivedDbTable) {
        if (this.alreadyInitialized) {
            throw new IllegalStateException("Too late to register table " + derivedDbTable + ", must have done it in Nxt.Init");
        }
        this.derivedTables.add(derivedDbTable);
    }

    @Override
    public void trimDerivedTables() {
        try {
            Db.db.beginTransaction();
            this.doTrimDerivedTables();
            Db.db.commitTransaction();
        }
        catch (Exception exception) {
            Logger.logMessage(exception.toString(), exception);
            Db.db.rollbackTransaction();
            throw exception;
        }
        finally {
            Db.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTrimDerivedTables() {
        this.lastTrimHeight = Math.max(this.blockchain.getHeight() - Constants.MAX_ROLLBACK, 0);
        if (this.lastTrimHeight > 0) {
            for (DerivedDbTable derivedDbTable : this.derivedTables) {
                if (this.isShuttingDown) break;
                this.blockchain.readLock();
                try {
                    long l = System.currentTimeMillis();
                    derivedDbTable.trim(this.lastTrimHeight);
                    l = System.currentTimeMillis() - l;
                    if (l > 300L) {
                        Logger.logDebugMessage("Trimming " + derivedDbTable + " took " + l + "ms");
                    }
                    Db.db.commitTransaction();
                }
                finally {
                    this.blockchain.readUnlock();
                }
            }
        }
    }

    List<DerivedDbTable> getDerivedTables() {
        return this.derivedTables;
    }

    @Override
    public Peer getLastBlockchainFeeder() {
        return this.lastBlockchainFeeder;
    }

    @Override
    public int getLastBlockchainFeederHeight() {
        return this.lastBlockchainFeederHeight;
    }

    @Override
    public boolean isScanning() {
        return this.isScanning;
    }

    @Override
    public int getInitialScanHeight() {
        return this.initialScanHeight;
    }

    @Override
    public boolean isDownloading() {
        return this.isDownloading;
    }

    @Override
    public boolean isProcessingBlock() {
        return this.isProcessingBlock;
    }

    @Override
    public int getMinRollbackHeight() {
        return this.trimDerivedTables ? (this.lastTrimHeight > 0 ? this.lastTrimHeight : Math.max(this.blockchain.getHeight() - Constants.MAX_ROLLBACK, 0)) : 0;
    }

    @Override
    public long getGenesisBlockId() {
        return this.genesisBlockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPeerBlock(JSONObject jSONObject) throws NxtException {
        BlockImpl blockImpl = BlockImpl.parseBlock(jSONObject);
        BlockImpl blockImpl2 = this.blockchain.getLastBlock();
        if (blockImpl.getPreviousBlockId() == blockImpl2.getId()) {
            this.pushBlock(blockImpl);
        } else if (blockImpl.getPreviousBlockId() == blockImpl2.getPreviousBlockId() && blockImpl.getTimestamp() < blockImpl2.getTimestamp()) {
            this.blockchain.writeLock();
            try {
                if (blockImpl2.getId() != this.blockchain.getLastBlock().getId()) {
                    return;
                }
                BlockImpl blockImpl3 = this.blockchain.getBlock(blockImpl2.getPreviousBlockId());
                blockImpl2 = this.popOffTo(blockImpl3).get(0);
                try {
                    this.pushBlock(blockImpl);
                    TransactionProcessorImpl.getInstance().processLater(blockImpl2.getTransactions());
                    Logger.logDebugMessage("Last block " + blockImpl2.getStringId() + " was replaced by " + blockImpl.getStringId());
                }
                catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                    Logger.logDebugMessage("Replacement block failed to be accepted, pushing back our last block");
                    this.pushBlock(blockImpl2);
                    TransactionProcessorImpl.getInstance().processLater(blockImpl.getTransactions());
                }
            }
            finally {
                this.blockchain.writeUnlock();
            }
        }
    }

    public List<BlockImpl> popOffTo(int n) {
        if (n <= 0) {
            this.fullReset();
        } else if (n < this.blockchain.getHeight()) {
            return this.popOffTo(this.blockchain.getBlockAtHeight(n));
        }
        return Collections.emptyList();
    }

    @Override
    public void fullReset() {
        this.blockchain.writeLock();
        try {
            try {
                this.setGetMoreBlocks(false);
                BlockDb.deleteAll();
                this.addGenesisBlock();
            }
            finally {
                this.setGetMoreBlocks(true);
            }
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    @Override
    public void setGetMoreBlocks(boolean bl) {
        this.getMoreBlocks = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int restorePrunedData() {
        Object object;
        Db.db.beginTransaction();
        try {
            object = Db.db.getConnection();
            try {
                int n = Nxt.getEpochTime();
                int n2 = Math.max(1, n - Constants.MAX_PRUNABLE_LIFETIME);
                int n3 = Math.max(n2, n - Constants.MIN_PRUNABLE_LIFETIME) - 1;
                List<TransactionDb.PrunableTransaction> list = TransactionDb.findPrunableTransactions((Connection)object, n2, n3);
                list.forEach(prunableTransaction -> {
                    long l = prunableTransaction.getId();
                    if (prunableTransaction.hasPrunableAttachment() && prunableTransaction.getTransactionType().isPruned(l) || PrunableMessage.isPruned(l, prunableTransaction.hasPrunablePlainMessage(), prunableTransaction.hasPrunableEncryptedMessage())) {
                        Set<Long> set = this.prunableTransactions;
                        synchronized (set) {
                            this.prunableTransactions.add(l);
                        }
                    }
                });
                if (!this.prunableTransactions.isEmpty()) {
                    this.lastRestoreTime = 0;
                }
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            Db.db.endTransaction();
        }
        object = this.prunableTransactions;
        synchronized (object) {
            return this.prunableTransactions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction restorePrunedTransaction(long l) {
        TransactionImpl transactionImpl = TransactionDb.findTransaction(l);
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Transaction not found");
        }
        boolean bl = false;
        for (Appendix.AbstractAppendix object2 : transactionImpl.getAppendages(true)) {
            if (!(object2 instanceof Appendix.Prunable) || ((Appendix.Prunable)((Object)object2)).hasPrunableData()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return transactionImpl;
        }
        List<Peer> list = Peers.getPeers(peer -> peer.providesService(Peer.Service.PRUNABLE) && !peer.isBlacklisted() && peer.getAnnouncedAddress() != null);
        if (list.isEmpty()) {
            Logger.logDebugMessage("Cannot find any archive peers");
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONArray.add(Long.toUnsignedString(l));
        jSONObject.put("requestType", "getTransactions");
        jSONObject.put("transactionIds", jSONArray);
        JSONStreamAware jSONStreamAware = JSON.prepareRequest(jSONObject);
        for (Peer peer2 : list) {
            JSONArray jSONArray2;
            if (peer2.getState() != Peer.State.CONNECTED) {
                Peers.connectPeer(peer2);
            }
            if (peer2.getState() != Peer.State.CONNECTED) continue;
            Logger.logDebugMessage("Connected to archive peer " + peer2.getHost());
            JSONObject jSONObject2 = peer2.send(jSONStreamAware);
            if (jSONObject2 == null || (jSONArray2 = (JSONArray)jSONObject2.get("transactions")) == null || jSONArray2.isEmpty()) continue;
            try {
                List<Transaction> notValidException = Nxt.getTransactionProcessor().restorePrunableData(jSONArray2);
                if (notValidException.isEmpty()) continue;
                Set<Long> set = this.prunableTransactions;
                synchronized (set) {
                    this.prunableTransactions.remove(l);
                }
                return notValidException.get(0);
            }
            catch (NxtException.NotValidException notValidException) {
                Logger.logErrorMessage("Peer " + peer2.getHost() + " returned invalid prunable transaction", notValidException);
                peer2.blacklist(notValidException);
            }
        }
        return null;
    }

    void shutdown() {
        this.isShuttingDown = true;
        ThreadPool.shutdownExecutor("networkService", this.networkService, 10);
    }

    private void addBlock(BlockImpl blockImpl) {
        try (Connection connection = Db.db.getConnection();){
            BlockDb.saveBlock(connection, blockImpl);
            this.blockchain.setLastBlock(blockImpl);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private void addGenesisBlock() {
        BlockImpl blockImpl = BlockDb.findLastBlock();
        if (blockImpl != null) {
            Logger.logMessage("Genesis block already in database");
            this.blockchain.setLastBlock(blockImpl);
            if (blockImpl.getHeight() > 0) {
                Logger.logDebugMessage("Will pop-off block " + blockImpl.getStringId());
                blockImpl = BlockDb.findBlock(blockImpl.getPreviousBlockId());
            }
            BlockDb.deleteBlocksFromHeight(blockImpl.getHeight() + 1);
            this.popOffTo(blockImpl);
            this.genesisBlockId = BlockDb.findBlockIdAtHeight(0);
            Logger.logMessage("Last block height: " + blockImpl.getHeight());
            return;
        }
        Logger.logMessage("Genesis block not in database, starting from scratch");
        try (Connection connection = Db.db.beginTransaction();){
            BlockImpl blockImpl2 = Genesis.newGenesisBlock();
            this.addBlock(blockImpl2);
            this.genesisBlockId = blockImpl2.getId();
            Genesis.apply();
            for (DerivedDbTable derivedDbTable : this.derivedTables) {
                derivedDbTable.createSearchIndex(connection);
            }
            BlockDb.commit(blockImpl2);
            Db.db.commitTransaction();
        }
        catch (SQLException sQLException) {
            Db.db.rollbackTransaction();
            Logger.logMessage(sQLException.getMessage());
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            Db.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushBlock(BlockImpl blockImpl) throws BlockchainProcessor.BlockNotAcceptedException {
        int n = Nxt.getEpochTime();
        this.blockchain.writeLock();
        try {
            BlockImpl blockImpl2 = null;
            try {
                Db.db.beginTransaction();
                blockImpl2 = this.blockchain.getLastBlock();
                this.validate(blockImpl, blockImpl2, n);
                long l = Generator.getNextHitTime(blockImpl2.getId(), n);
                if (l > 0L && (long)blockImpl.getTimestamp() > l + 1L) {
                    String string = "Rejecting block " + blockImpl.getStringId() + " at height " + blockImpl2.getHeight() + " block timestamp " + blockImpl.getTimestamp() + " next hit time " + l + " current time " + n;
                    Logger.logDebugMessage(string);
                    Generator.setDelay(-Constants.FORGING_SPEEDUP);
                    throw new BlockchainProcessor.BlockOutOfOrderException(string, blockImpl);
                }
                HashMap<TransactionType, Map<String, Integer>> hashMap = new HashMap<TransactionType, Map<String, Integer>>();
                ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
                ArrayList<TransactionImpl> arrayList2 = new ArrayList<TransactionImpl>();
                this.validatePhasedTransactions(blockImpl2.getHeight(), arrayList, arrayList2, hashMap);
                this.validateTransactions(blockImpl, blockImpl2, n, hashMap, blockImpl2.getHeight() >= 0);
                blockImpl.setPrevious(blockImpl2);
                this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BEFORE_BLOCK_ACCEPT);
                TransactionProcessorImpl.getInstance().requeueAllUnconfirmedTransactions();
                try {
                    this.addBlock(blockImpl);
                    this.accept(blockImpl, arrayList, arrayList2, hashMap);
                    Db.db.commitTransaction();
                }
                catch (Exception exception) {
                    Logger.logInfoMessage("Failed to accept an already validated block", exception);
                    Db.db.rollbackTransaction();
                    BlockDb.deleteBlocksFrom(blockImpl.getId());
                    this.blockchain.setLastBlock(blockImpl2);
                    for (DerivedDbTable derivedDbTable : this.derivedTables) {
                        derivedDbTable.popOffTo(blockImpl2.getHeight());
                    }
                    Db.db.clearCache();
                    Db.db.commitTransaction();
                    throw exception;
                }
            }
            finally {
                Db.db.endTransaction();
            }
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        }
        finally {
            this.blockchain.writeUnlock();
        }
        if (blockImpl.getTimestamp() >= n - 600) {
            Peers.sendToSomePeers(blockImpl);
        }
        this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BLOCK_PUSHED);
    }

    private void validatePhasedTransactions(int n, List<TransactionImpl> list, List<TransactionImpl> list2, Map<TransactionType, Map<String, Integer>> map) {
        try (DbIterator<TransactionImpl> dbIterator = PhasingPoll.getFinishingTransactions(n + 1);){
            for (TransactionImpl transactionImpl : dbIterator) {
                if (PhasingPoll.getResult(transactionImpl.getId()) != null) continue;
                try {
                    transactionImpl.validate();
                    if (!transactionImpl.attachmentIsDuplicate(map, false)) {
                        list.add(transactionImpl);
                        continue;
                    }
                    Logger.logDebugMessage("At height " + n + " phased transaction " + transactionImpl.getStringId() + " is duplicate, will not apply");
                    list2.add(transactionImpl);
                }
                catch (NxtException.ValidationException validationException) {
                    Logger.logDebugMessage("At height " + n + " phased transaction " + transactionImpl.getStringId() + " no longer passes validation: " + validationException.getMessage() + ", will not apply");
                    list2.add(transactionImpl);
                }
            }
        }
    }

    private void validate(BlockImpl blockImpl, BlockImpl blockImpl2, int n) throws BlockchainProcessor.BlockNotAcceptedException {
        if (blockImpl2.getId() != blockImpl.getPreviousBlockId()) {
            throw new BlockchainProcessor.BlockOutOfOrderException("Previous block id doesn't match", blockImpl);
        }
        if (blockImpl.getVersion() != this.getBlockVersion(blockImpl2.getHeight())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Invalid version " + blockImpl.getVersion(), blockImpl);
        }
        if (blockImpl.getTimestamp() > n + 15) {
            Logger.logWarningMessage("Received block " + blockImpl.getStringId() + " from the future, timestamp " + blockImpl.getTimestamp() + " generator " + Long.toUnsignedString(blockImpl.getGeneratorId()) + " current time " + n + ", system clock may be off");
            throw new BlockchainProcessor.BlockOutOfOrderException("Invalid timestamp: " + blockImpl.getTimestamp() + " current time is " + n, blockImpl);
        }
        if (blockImpl.getTimestamp() <= blockImpl2.getTimestamp()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Block timestamp " + blockImpl.getTimestamp() + " is before previous block timestamp " + blockImpl2.getTimestamp(), blockImpl);
        }
        if (!Arrays.equals(Crypto.sha256().digest(blockImpl2.bytes()), blockImpl.getPreviousBlockHash())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Previous block hash doesn't match", blockImpl);
        }
        if (blockImpl.getId() == 0L || BlockDb.hasBlock(blockImpl.getId(), blockImpl2.getHeight())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Duplicate block or invalid id", blockImpl);
        }
        if (!blockImpl.verifyGenerationSignature() && !Generator.allowsFakeForging(blockImpl.getGeneratorPublicKey())) {
            Account account = Account.getAccount(blockImpl.getGeneratorId());
            long l = account == null ? 0L : account.getEffectiveBalanceNXT();
            throw new BlockchainProcessor.BlockNotAcceptedException("Generation signature verification failed, effective balance " + l, blockImpl);
        }
        if (!blockImpl.verifyBlockSignature()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Block signature verification failed", blockImpl);
        }
        if (blockImpl.getTransactions().size() > Constants.MAX_NUMBER_OF_TRANSACTIONS) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Invalid block transaction count " + blockImpl.getTransactions().size(), blockImpl);
        }
        if (blockImpl.getPayloadLength() > Constants.MAX_PAYLOAD_LENGTH || blockImpl.getPayloadLength() < 0) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Invalid block payload length " + blockImpl.getPayloadLength(), blockImpl);
        }
    }

    private void validateTransactions(BlockImpl blockImpl, BlockImpl blockImpl2, int n, Map<TransactionType, Map<String, Integer>> map, boolean bl) throws BlockchainProcessor.BlockNotAcceptedException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        MessageDigest messageDigest = Crypto.sha256();
        boolean bl2 = false;
        for (TransactionImpl transactionImpl : blockImpl.getTransactions()) {
            if (transactionImpl.getTimestamp() > n + 15) {
                throw new BlockchainProcessor.BlockOutOfOrderException("Invalid transaction timestamp: " + transactionImpl.getTimestamp() + ", current time is " + n, blockImpl);
            }
            if (!transactionImpl.verifySignature()) {
                throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction signature verification failed at height " + blockImpl2.getHeight(), transactionImpl);
            }
            if (bl) {
                if (transactionImpl.getTimestamp() > blockImpl.getTimestamp() + 15 || transactionImpl.getExpiration() < blockImpl.getTimestamp()) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Invalid transaction timestamp " + transactionImpl.getTimestamp() + ", current time is " + n + ", block timestamp is " + blockImpl.getTimestamp(), transactionImpl);
                }
                if (TransactionDb.hasTransaction(transactionImpl.getId(), blockImpl2.getHeight())) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction is already in the blockchain", transactionImpl);
                }
                if (transactionImpl.referencedTransactionFullHash() != null && !this.hasAllReferencedTransactions(transactionImpl, transactionImpl.getTimestamp(), 0)) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Missing or invalid referenced transaction " + transactionImpl.getReferencedTransactionFullHash(), transactionImpl);
                }
                if (transactionImpl.getVersion() != this.getTransactionVersion(blockImpl2.getHeight())) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Invalid transaction version " + transactionImpl.getVersion() + " at height " + blockImpl2.getHeight(), transactionImpl);
                }
                if (transactionImpl.getId() == 0L) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Invalid transaction id 0", transactionImpl);
                }
                try {
                    transactionImpl.validate();
                }
                catch (NxtException.ValidationException validationException) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException(validationException.getMessage(), transactionImpl);
                }
            }
            if (transactionImpl.attachmentIsDuplicate(map, true)) {
                throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction is a duplicate", transactionImpl);
            }
            if (!bl2) {
                for (Appendix.AbstractAppendix abstractAppendix : transactionImpl.getAppendages()) {
                    if (!(abstractAppendix instanceof Appendix.Prunable) || ((Appendix.Prunable)((Object)abstractAppendix)).hasPrunableData()) continue;
                    bl2 = true;
                    break;
                }
            }
            l2 += transactionImpl.getAmountNQT();
            l3 += transactionImpl.getFeeNQT();
            l += (long)transactionImpl.getFullSize();
            messageDigest.update(transactionImpl.bytes());
        }
        if (l2 != blockImpl.getTotalAmountNQT() || l3 != blockImpl.getTotalFeeNQT()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Total amount or fee don't match transaction totals", blockImpl);
        }
        if (!Arrays.equals(messageDigest.digest(), blockImpl.getPayloadHash())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Payload hash doesn't match", blockImpl);
        }
        if (bl2 ? l > (long)blockImpl.getPayloadLength() : l != (long)blockImpl.getPayloadLength()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Transaction payload length " + l + " does not match block payload length " + blockImpl.getPayloadLength(), blockImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accept(BlockImpl blockImpl, List<TransactionImpl> list, List<TransactionImpl> list2, Map<TransactionType, Map<String, Integer>> map) throws BlockchainProcessor.TransactionNotAcceptedException {
        try {
            this.isProcessingBlock = true;
            for (TransactionImpl transactionImpl2 : blockImpl.getTransactions()) {
                ++this.statsTotalTxCount;
                byte by = transactionImpl2.getType().getType();
                this.statsTxByType[by] = this.statsTxByType[by] + 1;
                if (transactionImpl2.applyUnconfirmed()) continue;
                throw new BlockchainProcessor.TransactionNotAcceptedException("Double spending", transactionImpl2);
            }
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BEFORE_BLOCK_APPLY);
            blockImpl.apply();
            list.forEach(transactionImpl -> transactionImpl.getPhasing().countVotes((TransactionImpl)transactionImpl));
            list2.forEach(transactionImpl -> transactionImpl.getPhasing().reject((TransactionImpl)transactionImpl));
            int n = Nxt.getEpochTime() - Constants.MAX_PRUNABLE_LIFETIME;
            int n2 = 0;
            for (TransactionImpl object2 : blockImpl.getTransactions()) {
                try {
                    object2.apply();
                    if (object2.getTimestamp() > n) {
                        for (Appendix.AbstractAppendix validationException : object2.getAppendages(true)) {
                            if (!(validationException instanceof Appendix.Prunable) || ((Appendix.Prunable)((Object)validationException)).hasPrunableData()) continue;
                            Set<Long> set = this.prunableTransactions;
                            synchronized (set) {
                                this.prunableTransactions.add(object2.getId());
                            }
                            this.lastRestoreTime = 0;
                            break;
                        }
                    }
                    if (++n2 % Constants.BATCH_COMMIT_SIZE != 0) continue;
                    Db.db.commitTransaction();
                }
                catch (RuntimeException runtimeException) {
                    Logger.logErrorMessage(runtimeException.toString(), runtimeException);
                    throw new BlockchainProcessor.TransactionNotAcceptedException((Throwable)runtimeException, object2);
                }
            }
            TreeSet<Transaction> treeSet = new TreeSet<Transaction>(finishingTransactionsComparator);
            blockImpl.getTransactions().forEach(transactionImpl -> {
                PhasingPoll.getLinkedPhasedTransactions(transactionImpl.fullHash()).forEach(transaction -> {
                    if (transaction.getPhasing().getFinishHeight() > blockImpl.getHeight()) {
                        treeSet.add((TransactionImpl)transaction);
                    }
                });
                if (transactionImpl.getType() == TransactionType.Messaging.PHASING_VOTE_CASTING && !transactionImpl.attachmentIsPhased()) {
                    Attachment.MessagingPhasingVoteCasting messagingPhasingVoteCasting = (Attachment.MessagingPhasingVoteCasting)transactionImpl.getAttachment();
                    messagingPhasingVoteCasting.getTransactionFullHashes().forEach(byArray -> {
                        PhasingPoll phasingPoll = PhasingPoll.getPoll(Convert.fullHashToId(byArray));
                        if (phasingPoll.allowEarlyFinish() && phasingPoll.getFinishHeight() > blockImpl.getHeight()) {
                            treeSet.add(TransactionDb.findTransaction(phasingPoll.getId()));
                        }
                    });
                }
            });
            list.forEach(transactionImpl -> {
                PhasingPoll.PhasingPollResult phasingPollResult;
                if (transactionImpl.getType() == TransactionType.Messaging.PHASING_VOTE_CASTING && (phasingPollResult = PhasingPoll.getResult(transactionImpl.getId())) != null && phasingPollResult.isApproved()) {
                    Attachment.MessagingPhasingVoteCasting messagingPhasingVoteCasting = (Attachment.MessagingPhasingVoteCasting)transactionImpl.getAttachment();
                    messagingPhasingVoteCasting.getTransactionFullHashes().forEach(byArray -> {
                        PhasingPoll phasingPoll = PhasingPoll.getPoll(Convert.fullHashToId(byArray));
                        if (phasingPoll.allowEarlyFinish() && phasingPoll.getFinishHeight() > blockImpl.getHeight()) {
                            treeSet.add(TransactionDb.findTransaction(phasingPoll.getId()));
                        }
                    });
                }
            });
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                TransactionImpl runtimeException = (TransactionImpl)iterator.next();
                if (PhasingPoll.getResult(runtimeException.getId()) != null) continue;
                try {
                    runtimeException.validate();
                    runtimeException.getPhasing().tryCountVotes(runtimeException, map);
                    if (++n2 % Constants.BATCH_COMMIT_SIZE != 0) continue;
                    Db.db.commitTransaction();
                }
                catch (NxtException.ValidationException validationException) {
                    Logger.logDebugMessage("At height " + blockImpl.getHeight() + " phased transaction " + runtimeException.getStringId() + " no longer passes validation: " + validationException.getMessage() + ", cannot finish early");
                }
            }
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
            if (blockImpl.getTransactions().size() > 0) {
                TransactionProcessorImpl.getInstance().notifyListeners(blockImpl.getTransactions(), TransactionProcessor.Event.ADDED_CONFIRMED_TRANSACTIONS);
            }
            AccountLedger.commitEntries();
        }
        finally {
            this.isProcessingBlock = false;
            AccountLedger.clearEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<BlockImpl> popOffTo(Block block) {
        this.blockchain.writeLock();
        try {
            Object object;
            if (!Db.db.isInTransaction()) {
                try {
                    Db.db.beginTransaction();
                    List<BlockImpl> list = this.popOffTo(block);
                    return list;
                }
                finally {
                    Db.db.endTransaction();
                }
            }
            if (block.getHeight() < this.getMinRollbackHeight()) {
                Logger.logMessage("Rollback to height " + block.getHeight() + " not supported, will do a full rescan");
                this.popOffWithRescan(block.getHeight() + 1);
                List<BlockImpl> list = Collections.emptyList();
                return list;
            }
            if (!this.blockchain.hasBlock(block.getId())) {
                Logger.logDebugMessage("Block " + block.getStringId() + " not found in blockchain, nothing to pop off");
                List<BlockImpl> list = Collections.emptyList();
                return list;
            }
            ArrayList<BlockImpl> arrayList = new ArrayList<BlockImpl>();
            try {
                object = this.blockchain.getLastBlock();
                ((BlockImpl)object).loadTransactions();
                Logger.logDebugMessage("Rollback from block " + ((BlockImpl)object).getStringId() + " at height " + ((BlockImpl)object).getHeight() + " to " + block.getStringId() + " at " + block.getHeight());
                while (((BlockImpl)object).getId() != block.getId() && ((BlockImpl)object).getHeight() > 0) {
                    arrayList.add((BlockImpl)object);
                    object = this.popLastBlock();
                }
                for (DerivedDbTable derivedDbTable : this.derivedTables) {
                    derivedDbTable.popOffTo(block.getHeight());
                }
                Db.db.clearCache();
                Db.db.commitTransaction();
            }
            catch (RuntimeException runtimeException) {
                Logger.logErrorMessage("Error popping off to " + block.getHeight() + ", " + runtimeException.toString(), runtimeException);
                Db.db.rollbackTransaction();
                BlockImpl blockImpl = BlockDb.findLastBlock();
                this.blockchain.setLastBlock(blockImpl);
                Iterator<DerivedDbTable> iterator = this.derivedTables.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        Db.db.clearCache();
                        Db.db.commitTransaction();
                        throw runtimeException;
                    }
                    DerivedDbTable derivedDbTable = iterator.next();
                    derivedDbTable.popOffTo(blockImpl.getHeight());
                }
            }
            object = arrayList;
            return object;
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    private BlockImpl popLastBlock() {
        BlockImpl blockImpl = this.blockchain.getLastBlock();
        if (blockImpl.getHeight() == 0) {
            throw new RuntimeException("Cannot pop off genesis block");
        }
        BlockImpl blockImpl2 = BlockDb.deleteBlocksFrom(blockImpl.getId());
        blockImpl2.loadTransactions();
        this.blockchain.setLastBlock(blockImpl2);
        this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BLOCK_POPPED);
        return blockImpl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popOffWithRescan(int n) {
        this.blockchain.writeLock();
        try {
            try {
                this.scheduleScan(0, false);
                BlockImpl blockImpl = BlockDb.deleteBlocksFrom(BlockDb.findBlockIdAtHeight(n));
                this.blockchain.setLastBlock(blockImpl);
                this.popOffTo(blockImpl);
                Logger.logDebugMessage("Deleted blocks starting from height %s", n);
            }
            finally {
                this.scan(0, false);
            }
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    private int getBlockVersion(int n) {
        return 3;
    }

    private int getTransactionVersion(int n) {
        return 1;
    }

    SortedSet<UnconfirmedTransaction> selectUnconfirmedTransactions(Map<TransactionType, Map<String, Integer>> map, Block block, int n) {
        ArrayList<UnconfirmedTransaction> arrayList = new ArrayList<UnconfirmedTransaction>();
        try (Iterable<UnconfirmedTransaction> iterable = new FilteringIterator<UnconfirmedTransaction>(TransactionProcessorImpl.getInstance().getAllUnconfirmedTransactions(), unconfirmedTransaction -> this.hasAllReferencedTransactions(unconfirmedTransaction.getTransaction(), unconfirmedTransaction.getTimestamp(), 0));){
            for (UnconfirmedTransaction unconfirmedTransaction2 : iterable) {
                arrayList.add(unconfirmedTransaction2);
            }
        }
        iterable = new TreeSet<UnconfirmedTransaction>(transactionArrivalComparator);
        int n2 = 0;
        while (n2 <= Constants.MAX_PAYLOAD_LENGTH && iterable.size() <= Constants.MAX_NUMBER_OF_TRANSACTIONS) {
            int n3 = iterable.size();
            for (UnconfirmedTransaction unconfirmedTransaction3 : arrayList) {
                int n4 = unconfirmedTransaction3.getTransaction().getFullSize();
                if (iterable.contains(unconfirmedTransaction3) || n2 + n4 > Constants.MAX_PAYLOAD_LENGTH || unconfirmedTransaction3.getVersion() != this.getTransactionVersion(block.getHeight()) || n > 0 && (unconfirmedTransaction3.getTimestamp() > n + 15 || unconfirmedTransaction3.getExpiration() < n)) continue;
                try {
                    unconfirmedTransaction3.getTransaction().validate();
                }
                catch (NxtException.ValidationException validationException) {
                    continue;
                }
                if (unconfirmedTransaction3.getTransaction().attachmentIsDuplicate(map, true)) continue;
                iterable.add((UnconfirmedTransaction)unconfirmedTransaction3);
                n2 += n4;
            }
            if (iterable.size() != n3) continue;
            break;
        }
        return iterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateBlock(String string, int n) throws BlockchainProcessor.BlockNotAcceptedException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<TransactionType, Map<String, Integer>> hashMap = new HashMap<TransactionType, Map<String, Integer>>();
        try (Object object5 = PhasingPoll.getFinishingTransactions(this.blockchain.getHeight() + 1);){
            object4 = ((DbIterator)object5).iterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                try {
                    ((TransactionImpl)object3).validate();
                    ((TransactionImpl)object3).attachmentIsDuplicate(hashMap, false);
                }
                catch (NxtException.ValidationException validationException) {}
            }
        }
        object5 = this.blockchain.getLastBlock();
        TransactionProcessorImpl.getInstance().processWaitingTransactions();
        object4 = this.selectUnconfirmedTransactions(hashMap, (Block)object5, n);
        object3 = new ArrayList();
        MessageDigest messageDigest = Crypto.sha256();
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        Object object6 = object4.iterator();
        while (object6.hasNext()) {
            object2 = (UnconfirmedTransaction)object6.next();
            object = ((UnconfirmedTransaction)object2).getTransaction();
            object3.add(object);
            messageDigest.update(((TransactionImpl)object).bytes());
            l += ((TransactionImpl)object).getAmountNQT();
            l2 += ((TransactionImpl)object).getFeeNQT();
            n2 += ((TransactionImpl)object).getFullSize();
        }
        object6 = messageDigest.digest();
        messageDigest.update(((BlockImpl)object5).getGenerationSignature());
        object2 = Crypto.getPublicKey(string);
        object = messageDigest.digest((byte[])object2);
        byte[] byArray = Crypto.sha256().digest(((BlockImpl)object5).bytes());
        BlockImpl blockImpl = new BlockImpl(this.getBlockVersion(((BlockImpl)object5).getHeight()), n, ((BlockImpl)object5).getId(), l, l2, n2, (byte[])object6, (byte[])object2, (byte[])object, byArray, (List<TransactionImpl>)object3, string);
        try {
            this.pushBlock(blockImpl);
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BLOCK_GENERATED);
            Logger.logDebugMessage("Account " + Long.toUnsignedString(blockImpl.getGeneratorId()) + " generated block " + blockImpl.getStringId() + " at height " + blockImpl.getHeight() + " timestamp " + blockImpl.getTimestamp() + " fee " + (float)blockImpl.getTotalFeeNQT() / 1.0E8f);
        }
        catch (BlockchainProcessor.TransactionNotAcceptedException transactionNotAcceptedException) {
            Logger.logDebugMessage("Generate block failed: " + transactionNotAcceptedException.getMessage());
            TransactionProcessorImpl.getInstance().processWaitingTransactions();
            TransactionImpl transactionImpl = transactionNotAcceptedException.getTransaction();
            Logger.logDebugMessage("Removing invalid transaction: " + transactionImpl.getStringId());
            this.blockchain.writeLock();
            try {
                TransactionProcessorImpl.getInstance().removeUnconfirmedTransaction(transactionImpl);
            }
            finally {
                this.blockchain.writeUnlock();
            }
            throw transactionNotAcceptedException;
        }
        catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
            Logger.logDebugMessage("Generate block failed: " + blockNotAcceptedException.getMessage());
            throw blockNotAcceptedException;
        }
    }

    private boolean hasAllReferencedTransactions(TransactionImpl transactionImpl, int n, int n2) {
        if (transactionImpl.referencedTransactionFullHash() == null) {
            return n - transactionImpl.getTimestamp() < 5184000 && n2 < 10;
        }
        TransactionImpl transactionImpl2 = TransactionDb.findTransactionByFullHash(transactionImpl.referencedTransactionFullHash());
        return transactionImpl2 != null && transactionImpl2.getHeight() < transactionImpl.getHeight() && this.hasAllReferencedTransactions(transactionImpl2, n, n2 + 1);
    }

    void scheduleScan(int n, boolean bl) {
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("UPDATE scan SET rescan = TRUE, height = ?, validate = ?");){
            preparedStatement.setInt(1, n);
            preparedStatement.setBoolean(2, bl);
            preparedStatement.executeUpdate();
            Logger.logDebugMessage("Scheduled scan starting from height " + n + (bl ? ", with validation" : ""));
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    @Override
    public void scan(int n, boolean bl) {
        this.scan(n, bl, false);
    }

    @Override
    public void fullScanWithShutdown() {
        this.scan(0, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scan(int n, boolean bl, boolean bl2) {
        this.blockchain.writeLock();
        try {
            if (!Db.db.isInTransaction()) {
                try {
                    Db.db.beginTransaction();
                    if (bl) {
                        this.blockListeners.addListener(this.checksumListener, BlockchainProcessor.Event.BLOCK_SCANNED);
                    }
                    this.scan(n, bl, bl2);
                    Db.db.commitTransaction();
                    return;
                }
                catch (Exception exception) {
                    Db.db.rollbackTransaction();
                    throw exception;
                }
                finally {
                    Db.db.endTransaction();
                    this.blockListeners.removeListener(this.checksumListener, BlockchainProcessor.Event.BLOCK_SCANNED);
                }
            }
            this.scheduleScan(n, bl);
            if (n > 0 && n < this.getMinRollbackHeight()) {
                Logger.logMessage("Rollback to height less than " + this.getMinRollbackHeight() + " not supported, will do a full scan");
                n = 0;
            }
            if (n < 0) {
                n = 0;
            }
            Logger.logMessage("Scanning blockchain starting from height " + n + "...");
            if (bl) {
                Logger.logDebugMessage("Also verifying signatures and validating transactions...");
            }
            try (Connection connection = Db.db.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block WHERE " + (n > 0 ? "height >= ? AND " : "") + " db_id >= ? ORDER BY db_id ASC LIMIT 50000");
                 PreparedStatement preparedStatement2 = connection.prepareStatement("UPDATE scan SET rescan = FALSE, height = 0, validate = FALSE");){
                this.isScanning = true;
                this.initialScanHeight = this.blockchain.getHeight();
                if (n > this.blockchain.getHeight() + 1) {
                    Logger.logMessage("Rollback height " + (n - 1) + " exceeds current blockchain height of " + this.blockchain.getHeight() + ", no scan needed");
                    preparedStatement2.executeUpdate();
                    Db.db.commitTransaction();
                    return;
                }
                if (n == 0) {
                    Logger.logDebugMessage("Dropping all full text search indexes");
                    FullTextTrigger.dropAll(connection);
                    this.lastTrimHeight = 0;
                }
                for (DerivedDbTable derivedDbTable : this.derivedTables) {
                    if (n == 0) {
                        derivedDbTable.truncate();
                        continue;
                    }
                    derivedDbTable.rollback(n - 1);
                }
                Db.db.clearCache();
                Db.db.commitTransaction();
                Logger.logDebugMessage("Rolled back derived tables");
                Object object = BlockDb.findBlockAtHeight(n);
                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.RESCAN_BEGIN);
                long l = ((BlockImpl)object).getId();
                if (n == 0) {
                    this.blockchain.setLastBlock((BlockImpl)object);
                    Genesis.apply();
                } else {
                    this.blockchain.setLastBlock(BlockDb.findBlockAtHeight(n - 1));
                }
                if (bl2) {
                    Logger.logMessage("Scan will be performed at next start");
                    new Thread(() -> System.exit(0)).start();
                    return;
                }
                int n2 = 1;
                if (n > 0) {
                    preparedStatement.setInt(n2++, n);
                }
                long l2 = Long.MIN_VALUE;
                boolean bl3 = true;
                block48: while (bl3) {
                    bl3 = false;
                    preparedStatement.setLong(n2, l2);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        Object object2;
                        try {
                            l2 = resultSet.getLong("db_id");
                            object = BlockDb.loadBlock(connection, resultSet, true);
                            int n3 = Nxt.getEpochTime();
                            if (((BlockImpl)object).getHeight() > 0) {
                                ((BlockImpl)object).loadTransactions();
                                if (((BlockImpl)object).getId() != l) throw new NxtException.NotValidException("Database blocks in the wrong order!");
                                if (((BlockImpl)object).getHeight() > this.blockchain.getHeight() + 1) {
                                    throw new NxtException.NotValidException("Database blocks in the wrong order!");
                                }
                                object2 = new HashMap();
                                ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
                                ArrayList<TransactionImpl> arrayList2 = new ArrayList<TransactionImpl>();
                                this.validatePhasedTransactions(this.blockchain.getHeight(), arrayList, arrayList2, (Map<TransactionType, Map<String, Integer>>)object2);
                                this.validateTransactions((BlockImpl)object, this.blockchain.getLastBlock(), n3, (Map<TransactionType, Map<String, Integer>>)object2, bl);
                                if (bl) {
                                    this.validate((BlockImpl)object, this.blockchain.getLastBlock(), n3);
                                    byte[] byArray = ((BlockImpl)object).bytes();
                                    JSONObject jSONObject = (JSONObject)JSONValue.parse(((BlockImpl)object).getJSONObject().toJSONString());
                                    if (!Arrays.equals(byArray, BlockImpl.parseBlock(jSONObject).bytes())) {
                                        throw new NxtException.NotValidException("Block JSON cannot be parsed back to the same block");
                                    }
                                    for (TransactionImpl transactionImpl : ((BlockImpl)object).getTransactions()) {
                                        byte[] byArray2 = transactionImpl.bytes();
                                        if (!Arrays.equals(byArray2, TransactionImpl.newTransactionBuilder(byArray2).build().bytes())) {
                                            throw new NxtException.NotValidException("Transaction bytes cannot be parsed back to the same transaction: " + transactionImpl.getJSONObject().toJSONString());
                                        }
                                        JSONObject jSONObject2 = (JSONObject)JSONValue.parse(transactionImpl.getJSONObject().toJSONString());
                                        if (Arrays.equals(byArray2, TransactionImpl.newTransactionBuilder(jSONObject2).build().bytes())) continue;
                                        throw new NxtException.NotValidException("Transaction JSON cannot be parsed back to the same transaction: " + transactionImpl.getJSONObject().toJSONString());
                                    }
                                }
                                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.BEFORE_BLOCK_ACCEPT);
                                this.blockchain.setLastBlock((BlockImpl)object);
                                this.accept((BlockImpl)object, arrayList, arrayList2, (Map<TransactionType, Map<String, Integer>>)object2);
                                Db.db.clearCache();
                                Db.db.commitTransaction();
                                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
                                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.BLOCK_SCANNED);
                            }
                            bl3 = true;
                            l = ((BlockImpl)object).getNextBlockId();
                        }
                        catch (RuntimeException | NxtException exception) {
                            Db.db.rollbackTransaction();
                            Logger.logDebugMessage(exception.toString(), exception);
                            Logger.logDebugMessage("Applying block " + Long.toUnsignedString(l) + " at height " + ((BlockImpl)object).getHeight() + " failed, deleting from database");
                            object2 = BlockDb.deleteBlocksFrom(l);
                            this.blockchain.setLastBlock((BlockImpl)object2);
                            this.popOffTo((Block)object2);
                            if (resultSet == null) break block48;
                            resultSet.close();
                            break block48;
                        }
                    }
                    ++l2;
                }
                if (n == 0) {
                    for (DerivedDbTable derivedDbTable : this.derivedTables) {
                        derivedDbTable.createSearchIndex(connection);
                    }
                }
                preparedStatement2.executeUpdate();
                Db.db.commitTransaction();
                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.RESCAN_END);
                Logger.logMessage("...done at height " + this.blockchain.getHeight());
                if (n == 0 && bl) {
                    Logger.logMessage("SUCCESSFULLY PERFORMED FULL RESCAN WITH VALIDATION");
                }
                this.lastRestoreTime = 0;
                return;
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
            finally {
                this.isScanning = false;
            }
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    static {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, null);
        checksums = Collections.unmodifiableNavigableMap(treeMap);
        instance = new BlockchainProcessorImpl();
        finishingTransactionsComparator = Comparator.comparingInt(Transaction::getHeight).thenComparingInt(Transaction::getIndex).thenComparingLong(Transaction::getId);
        transactionArrivalComparator = Comparator.comparingLong(UnconfirmedTransaction::getArrivalTimestamp).thenComparingInt(UnconfirmedTransaction::getHeight).thenComparingLong(UnconfirmedTransaction::getId);
    }

    private class RestorePrunableDataTask
    implements Runnable {
        private RestorePrunableDataTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Peer peer2 = null;
            try {
                Object object;
                List<Peer> list = Peers.getPeers(peer -> peer.providesService(Peer.Service.PRUNABLE) && !peer.isBlacklisted() && peer.getAnnouncedAddress() != null);
                while (!list.isEmpty()) {
                    if (!Peers.isNetworkingEnabled()) {
                        return;
                    }
                    object = list.get(ThreadLocalRandom.current().nextInt(list.size()));
                    if (object.getState() != Peer.State.CONNECTED) {
                        Peers.connectPeer((Peer)object);
                    }
                    if (object.getState() != Peer.State.CONNECTED) continue;
                    peer2 = object;
                    break;
                }
                if (peer2 == null) {
                    Logger.logDebugMessage("Cannot find any archive peers");
                    return;
                }
                Logger.logDebugMessage("Connected to archive peer " + peer2.getHost());
                Object object2 = BlockchainProcessorImpl.this.prunableTransactions;
                synchronized (object2) {
                    object = new HashSet(BlockchainProcessorImpl.this.prunableTransactions.size());
                    object.addAll(BlockchainProcessorImpl.this.prunableTransactions);
                }
                Logger.logDebugMessage("Need to restore " + object.size() + " pruned data");
                while (!object.isEmpty()) {
                    Object object3;
                    if (!Peers.isNetworkingEnabled()) {
                        Logger.logDebugMessage("Peers networking was disabled while retrieving prunable data");
                        return;
                    }
                    object2 = new JSONObject();
                    JSONArray jSONArray = new JSONArray();
                    Object object4 = BlockchainProcessorImpl.this.prunableTransactions;
                    synchronized (object4) {
                        object3 = object.iterator();
                        while (object3.hasNext()) {
                            long l = (Long)object3.next();
                            jSONArray.add(Long.toUnsignedString(l));
                            object3.remove();
                            if (jSONArray.size() != 100) continue;
                            break;
                        }
                    }
                    ((HashMap)object2).put("requestType", "getTransactions");
                    ((HashMap)object2).put("transactionIds", jSONArray);
                    object4 = peer2.send(JSON.prepareRequest((JSONObject)object2), 0xA00000);
                    if (object4 == null) {
                        return;
                    }
                    object3 = (JSONArray)((HashMap)object4).get("transactions");
                    if (object3 == null || ((ArrayList)object3).isEmpty()) {
                        return;
                    }
                    List<Transaction> list2 = Nxt.getTransactionProcessor().restorePrunableData((JSONArray)object3);
                    Set<Long> set = BlockchainProcessorImpl.this.prunableTransactions;
                    synchronized (set) {
                        list2.forEach(transaction -> BlockchainProcessorImpl.this.prunableTransactions.remove(transaction.getId()));
                    }
                }
                Logger.logDebugMessage("Done retrieving prunable transactions from " + peer2.getHost());
            }
            catch (NxtException.ValidationException validationException) {
                Logger.logErrorMessage("Peer " + peer2.getHost() + " returned invalid prunable transaction", validationException);
                peer2.blacklist(validationException);
            }
            catch (RuntimeException runtimeException) {
                Logger.logErrorMessage("Unable to restore prunable data", runtimeException);
            }
            finally {
                BlockchainProcessorImpl.this.isRestoring = false;
                Logger.logDebugMessage("Remaining " + BlockchainProcessorImpl.this.prunableTransactions.size() + " pruned transactions");
            }
        }
    }

    private static class PeerBlock {
        private final Peer peer;
        private final BlockImpl block;

        public PeerBlock(Peer peer, BlockImpl blockImpl) {
            this.peer = peer;
            this.block = blockImpl;
        }

        public Peer getPeer() {
            return this.peer;
        }

        public BlockImpl getBlock() {
            return this.block;
        }
    }

    private static class GetNextBlocks
    implements Callable<List<BlockImpl>> {
        private Future<List<BlockImpl>> future;
        private Peer peer;
        private final List<Long> blockIds;
        private int start;
        private int stop;
        private int requestCount;
        private long responseTime;

        public GetNextBlocks(List<Long> list, int n, int n2) {
            this.blockIds = list;
            this.start = n;
            this.stop = n2;
            this.requestCount = 0;
        }

        @Override
        public List<BlockImpl> call() {
            ++this.requestCount;
            JSONArray jSONArray = new JSONArray();
            for (int i = this.start + 1; i <= this.stop; ++i) {
                jSONArray.add(Long.toUnsignedString(this.blockIds.get(i)));
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("requestType", "getNextBlocks");
            jSONObject.put("blockIds", jSONArray);
            jSONObject.put("blockId", Long.toUnsignedString(this.blockIds.get(this.start)));
            long l = System.currentTimeMillis();
            JSONObject jSONObject2 = this.peer.send(JSON.prepareRequest(jSONObject), 0xA00000);
            this.responseTime = System.currentTimeMillis() - l;
            if (jSONObject2 == null) {
                return null;
            }
            List list = (List)jSONObject2.get("nextBlocks");
            if (list == null) {
                return null;
            }
            if (list.size() > 36) {
                Logger.logDebugMessage("Obsolete or rogue peer " + this.peer.getHost() + " sends too many nextBlocks, blacklisting");
                this.peer.blacklist("Too many nextBlocks");
                return null;
            }
            ArrayList<BlockImpl> arrayList = new ArrayList<BlockImpl>(list.size());
            try {
                int n = this.stop - this.start;
                for (JSONObject jSONObject3 : list) {
                    arrayList.add(BlockImpl.parseBlock(jSONObject3));
                    if (--n > 0) continue;
                    break;
                }
            }
            catch (RuntimeException | NxtException.NotValidException exception) {
                Logger.logDebugMessage("Failed to parse block: " + exception.toString(), exception);
                this.peer.blacklist(exception);
                this.stop = this.start + arrayList.size();
            }
            return arrayList;
        }

        public Future<List<BlockImpl>> getFuture() {
            return this.future;
        }

        public void setFuture(Future<List<BlockImpl>> future) {
            this.future = future;
        }

        public Peer getPeer() {
            return this.peer;
        }

        public void setPeer(Peer peer) {
            this.peer = peer;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n) {
            this.start = n;
        }

        public int getStop() {
            return this.stop;
        }

        public int getRequestCount() {
            return this.requestCount;
        }

        public long getResponseTime() {
            return this.responseTime;
        }
    }
}

