/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Appendix;
import nxt.Attachment;
import nxt.Block;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Nxt;
import nxt.Transaction;
import nxt.crypto.EncryptedData;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.db.VersionedValuesDbTable;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Search;

public final class DigitalGoodsStore {
    private static final Listeners<Goods, Event> goodsListeners;
    private static final Listeners<Purchase, Event> purchaseListeners;

    public static boolean addGoodsListener(Listener<Goods> listener, Event event) {
        return goodsListeners.addListener(listener, event);
    }

    public static boolean removeGoodsListener(Listener<Goods> listener, Event event) {
        return goodsListeners.removeListener(listener, event);
    }

    public static boolean addPurchaseListener(Listener<Purchase> listener, Event event) {
        return purchaseListeners.addListener(listener, event);
    }

    public static boolean removePurchaseListener(Listener<Purchase> listener, Event event) {
        return purchaseListeners.removeListener(listener, event);
    }

    static void init() {
        Tag.init();
        Goods.init();
        Purchase.init();
    }

    static void listGoods(Transaction transaction, Attachment.DigitalGoodsListing digitalGoodsListing) {
        Goods goods = new Goods(transaction, digitalGoodsListing);
        Tag.add(goods);
        Goods.goodsTable.insert(goods);
        goodsListeners.notify(goods, Event.GOODS_LISTED);
    }

    static void delistGoods(long l) {
        Goods goods = (Goods)Goods.goodsTable.get(Goods.goodsDbKeyFactory.newKey(l));
        if (goods.isDelisted()) {
            throw new IllegalStateException("Goods already delisted");
        }
        goods.setDelisted(true);
        goodsListeners.notify(goods, Event.GOODS_DELISTED);
    }

    static void changePrice(long l, long l2) {
        Goods goods = (Goods)Goods.goodsTable.get(Goods.goodsDbKeyFactory.newKey(l));
        if (goods.isDelisted()) {
            throw new IllegalStateException("Can't change price of delisted goods");
        }
        goods.changePrice(l2);
        goodsListeners.notify(goods, Event.GOODS_PRICE_CHANGE);
    }

    static void changeQuantity(long l, int n) {
        Goods goods = (Goods)Goods.goodsTable.get(Goods.goodsDbKeyFactory.newKey(l));
        if (goods.isDelisted()) {
            throw new IllegalStateException("Can't change quantity of delisted goods");
        }
        goods.changeQuantity(n);
        goodsListeners.notify(goods, Event.GOODS_QUANTITY_CHANGE);
    }

    static void purchase(Transaction transaction, Attachment.DigitalGoodsPurchase digitalGoodsPurchase) {
        Goods goods = (Goods)Goods.goodsTable.get(Goods.goodsDbKeyFactory.newKey(digitalGoodsPurchase.getGoodsId()));
        if (!goods.isDelisted() && digitalGoodsPurchase.getQuantity() <= goods.getQuantity() && digitalGoodsPurchase.getPriceNQT() == goods.getPriceNQT()) {
            goods.changeQuantity(-digitalGoodsPurchase.getQuantity());
            Purchase purchase = new Purchase(transaction, digitalGoodsPurchase, goods.getSellerId());
            Purchase.purchaseTable.insert(purchase);
            purchaseListeners.notify(purchase, Event.PURCHASE);
        } else {
            Account account = Account.getAccount(transaction.getSenderId());
            account.addToUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.DIGITAL_GOODS_DELISTED, transaction.getId(), Math.multiplyExact((long)digitalGoodsPurchase.getQuantity(), digitalGoodsPurchase.getPriceNQT()));
        }
    }

    static void deliver(Transaction transaction, Attachment.DigitalGoodsDelivery digitalGoodsDelivery) {
        Purchase purchase = Purchase.getPendingPurchase(digitalGoodsDelivery.getPurchaseId());
        purchase.setPending(false);
        long l = Math.multiplyExact((long)purchase.getQuantity(), purchase.getPriceNQT());
        Account account = Account.getAccount(purchase.getBuyerId());
        long l2 = transaction.getId();
        account.addToBalanceNQT(AccountLedger.LedgerEvent.DIGITAL_GOODS_DELIVERY, l2, Math.subtractExact(digitalGoodsDelivery.getDiscountNQT(), l));
        account.addToUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.DIGITAL_GOODS_DELIVERY, l2, digitalGoodsDelivery.getDiscountNQT());
        Account account2 = Account.getAccount(transaction.getSenderId());
        account2.addToBalanceAndUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.DIGITAL_GOODS_DELIVERY, l2, Math.subtractExact(l, digitalGoodsDelivery.getDiscountNQT()));
        purchase.setEncryptedGoods(digitalGoodsDelivery.getGoods(), digitalGoodsDelivery.goodsIsText());
        purchase.setDiscountNQT(digitalGoodsDelivery.getDiscountNQT());
        purchaseListeners.notify(purchase, Event.DELIVERY);
    }

    static void refund(AccountLedger.LedgerEvent ledgerEvent, long l, long l2, long l3, long l4, Appendix.EncryptedMessage encryptedMessage) {
        Purchase purchase = (Purchase)Purchase.purchaseTable.get(Purchase.purchaseDbKeyFactory.newKey(l3));
        Account account = Account.getAccount(l2);
        account.addToBalanceNQT(ledgerEvent, l, -l4);
        Account account2 = Account.getAccount(purchase.getBuyerId());
        account2.addToBalanceAndUnconfirmedBalanceNQT(ledgerEvent, l, l4);
        if (encryptedMessage != null) {
            purchase.setRefundNote(encryptedMessage.getEncryptedData());
        }
        purchase.setRefundNQT(l4);
        purchaseListeners.notify(purchase, Event.REFUND);
    }

    static void feedback(long l, Appendix.EncryptedMessage encryptedMessage, Appendix.Message message) {
        Purchase purchase = (Purchase)Purchase.purchaseTable.get(Purchase.purchaseDbKeyFactory.newKey(l));
        if (encryptedMessage != null) {
            purchase.addFeedbackNote(encryptedMessage.getEncryptedData());
        }
        if (message != null) {
            purchase.addPublicFeedback(Convert.toString(message.getMessage()));
        }
        purchaseListeners.notify(purchase, Event.FEEDBACK);
    }

    private static EncryptedData loadEncryptedData(ResultSet resultSet, String string, String string2) throws SQLException {
        byte[] byArray = resultSet.getBytes(string);
        if (byArray == null) {
            return null;
        }
        return new EncryptedData(byArray, resultSet.getBytes(string2));
    }

    private static int setEncryptedData(PreparedStatement preparedStatement, EncryptedData encryptedData, int n) throws SQLException {
        if (encryptedData == null) {
            preparedStatement.setNull(n++, -3);
            preparedStatement.setNull(n++, -3);
        } else {
            preparedStatement.setBytes(n++, encryptedData.getData());
            preparedStatement.setBytes(n++, encryptedData.getNonce());
        }
        return n;
    }

    static {
        Nxt.getBlockchainProcessor().addListener(block -> {
            if (block.getHeight() == 0) {
                return;
            }
            ArrayList<Purchase> arrayList = new ArrayList<Purchase>();
            try (Iterator<Purchase> iterator = Purchase.getExpiredPendingPurchases(block);){
                while (((DbIterator)iterator).hasNext()) {
                    arrayList.add((Purchase)((DbIterator)iterator).next());
                }
            }
            for (Purchase purchase : arrayList) {
                Account account = Account.getAccount(purchase.getBuyerId());
                account.addToUnconfirmedBalanceNQT(AccountLedger.LedgerEvent.DIGITAL_GOODS_PURCHASE_EXPIRED, purchase.getId(), Math.multiplyExact((long)purchase.getQuantity(), purchase.getPriceNQT()));
                Goods.getGoods(purchase.getGoodsId()).changeQuantity(purchase.getQuantity());
                purchase.setPending(false);
            }
        }, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
        goodsListeners = new Listeners();
        purchaseListeners = new Listeners();
    }

    private static final class SellerDbClause
    extends DbClause {
        private final long sellerId;

        private SellerDbClause(long l, boolean bl) {
            super(" seller_id = ? " + (bl ? "AND delisted = FALSE AND quantity > 0" : ""));
            this.sellerId = l;
        }

        @Override
        public int set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n++, this.sellerId);
            return n;
        }
    }

    public static final class Purchase {
        private static final DbKey.LongKeyFactory<Purchase> purchaseDbKeyFactory = new DbKey.LongKeyFactory<Purchase>("id"){

            @Override
            public DbKey newKey(Purchase purchase) {
                return purchase.dbKey;
            }
        };
        private static final VersionedEntityDbTable<Purchase> purchaseTable = new VersionedEntityDbTable<Purchase>("purchase", purchaseDbKeyFactory){

            @Override
            protected Purchase load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Purchase(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Purchase purchase) throws SQLException {
                purchase.save(connection);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY timestamp DESC, id ASC ";
            }
        };
        private static final DbKey.LongKeyFactory<Purchase> feedbackDbKeyFactory = new DbKey.LongKeyFactory<Purchase>("id"){

            @Override
            public DbKey newKey(Purchase purchase) {
                return purchase.dbKey == null ? this.newKey(purchase.id) : purchase.dbKey;
            }
        };
        private static final VersionedValuesDbTable<Purchase, EncryptedData> feedbackTable = new VersionedValuesDbTable<Purchase, EncryptedData>("purchase_feedback", feedbackDbKeyFactory){

            @Override
            protected EncryptedData load(Connection connection, ResultSet resultSet) throws SQLException {
                byte[] byArray = resultSet.getBytes("feedback_data");
                byte[] byArray2 = resultSet.getBytes("feedback_nonce");
                return new EncryptedData(byArray, byArray2);
            }

            @Override
            protected void save(Connection connection, Purchase purchase, EncryptedData encryptedData) throws SQLException {
                try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO purchase_feedback (id, feedback_data, feedback_nonce, height, latest) VALUES (?, ?, ?, ?, TRUE)");){
                    int n = 0;
                    preparedStatement.setLong(++n, purchase.getId());
                    ++n;
                    n = DigitalGoodsStore.setEncryptedData(preparedStatement, encryptedData, n);
                    preparedStatement.setInt(n, Nxt.getBlockchain().getHeight());
                    preparedStatement.executeUpdate();
                }
            }
        };
        private static final DbKey.LongKeyFactory<Purchase> publicFeedbackDbKeyFactory = new DbKey.LongKeyFactory<Purchase>("id"){

            @Override
            public DbKey newKey(Purchase purchase) {
                return purchase.dbKey == null ? this.newKey(purchase.id) : purchase.dbKey;
            }
        };
        private static final VersionedValuesDbTable<Purchase, String> publicFeedbackTable = new VersionedValuesDbTable<Purchase, String>("purchase_public_feedback", publicFeedbackDbKeyFactory){

            @Override
            protected String load(Connection connection, ResultSet resultSet) throws SQLException {
                return resultSet.getString("public_feedback");
            }

            @Override
            protected void save(Connection connection, Purchase purchase, String string) throws SQLException {
                try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO purchase_public_feedback (id, public_feedback, height, latest) VALUES (?, ?, ?, TRUE)");){
                    int n = 0;
                    preparedStatement.setLong(++n, purchase.getId());
                    preparedStatement.setString(++n, string);
                    preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                    preparedStatement.executeUpdate();
                }
            }
        };
        private final long id;
        private final DbKey dbKey;
        private final long buyerId;
        private final long goodsId;
        private final long sellerId;
        private final int quantity;
        private final long priceNQT;
        private final int deadline;
        private final EncryptedData note;
        private final int timestamp;
        private boolean isPending;
        private EncryptedData encryptedGoods;
        private boolean goodsIsText;
        private EncryptedData refundNote;
        private boolean hasFeedbackNotes;
        private List<EncryptedData> feedbackNotes;
        private boolean hasPublicFeedbacks;
        private List<String> publicFeedbacks;
        private long discountNQT;
        private long refundNQT;

        public static int getCount() {
            return purchaseTable.getCount();
        }

        public static int getCount(boolean bl, boolean bl2) {
            return purchaseTable.getCount(new PurchasesClause(" TRUE ", bl, bl2));
        }

        public static DbIterator<Purchase> getAllPurchases(int n, int n2) {
            return purchaseTable.getAll(n, n2);
        }

        public static DbIterator<Purchase> getPurchases(boolean bl, boolean bl2, int n, int n2) {
            return purchaseTable.getManyBy(new PurchasesClause(" TRUE ", bl, bl2), n, n2);
        }

        public static DbIterator<Purchase> getSellerPurchases(long l, boolean bl, boolean bl2, int n, int n2) {
            return purchaseTable.getManyBy(new LongPurchasesClause("seller_id", l, bl, bl2), n, n2);
        }

        public static int getSellerPurchaseCount(long l, boolean bl, boolean bl2) {
            return purchaseTable.getCount(new LongPurchasesClause("seller_id", l, bl, bl2));
        }

        public static DbIterator<Purchase> getBuyerPurchases(long l, boolean bl, boolean bl2, int n, int n2) {
            return purchaseTable.getManyBy(new LongPurchasesClause("buyer_id", l, bl, bl2), n, n2);
        }

        public static int getBuyerPurchaseCount(long l, boolean bl, boolean bl2) {
            return purchaseTable.getCount(new LongPurchasesClause("buyer_id", l, bl, bl2));
        }

        public static DbIterator<Purchase> getSellerBuyerPurchases(long l, long l2, boolean bl, boolean bl2, int n, int n2) {
            return purchaseTable.getManyBy(new SellerBuyerPurchasesClause(l, l2, bl, bl2), n, n2);
        }

        public static int getSellerBuyerPurchaseCount(long l, long l2, boolean bl, boolean bl2) {
            return purchaseTable.getCount(new SellerBuyerPurchasesClause(l, l2, bl, bl2));
        }

        public static DbIterator<Purchase> getGoodsPurchases(long l, long l2, boolean bl, boolean bl2, int n, int n2) {
            DbClause dbClause = new LongPurchasesClause("goods_id", l, bl, bl2);
            if (l2 != 0L) {
                dbClause = dbClause.and(new DbClause.LongClause("buyer_id", l2));
            }
            return purchaseTable.getManyBy(dbClause, n, n2);
        }

        public static int getGoodsPurchaseCount(long l, boolean bl, boolean bl2) {
            return purchaseTable.getCount(new LongPurchasesClause("goods_id", l, bl, bl2));
        }

        public static Purchase getPurchase(long l) {
            return (Purchase)purchaseTable.get(purchaseDbKeyFactory.newKey(l));
        }

        public static DbIterator<Purchase> getPendingSellerPurchases(long l, int n, int n2) {
            DbClause dbClause = new DbClause.LongClause("seller_id", l).and(new DbClause.BooleanClause("pending", true));
            return purchaseTable.getManyBy(dbClause, n, n2);
        }

        public static DbIterator<Purchase> getExpiredSellerPurchases(long l, int n, int n2) {
            DbClause dbClause = new DbClause.LongClause("seller_id", l).and(new DbClause.BooleanClause("pending", false)).and(new DbClause.NullClause("goods"));
            return purchaseTable.getManyBy(dbClause, n, n2);
        }

        static Purchase getPendingPurchase(long l) {
            Purchase purchase = Purchase.getPurchase(l);
            return purchase == null || !purchase.isPending() ? null : purchase;
        }

        private static DbIterator<Purchase> getExpiredPendingPurchases(Block block) {
            int n = block.getTimestamp();
            int n2 = Nxt.getBlockchain().getBlock(block.getPreviousBlockId()).getTimestamp();
            DbClause dbClause = new DbClause.LongClause("deadline", DbClause.Op.LT, n).and(new DbClause.LongClause("deadline", DbClause.Op.GTE, n2)).and(new DbClause.BooleanClause("pending", true));
            return purchaseTable.getManyBy(dbClause, 0, -1);
        }

        private static void init() {
        }

        private Purchase(Transaction transaction, Attachment.DigitalGoodsPurchase digitalGoodsPurchase, long l) {
            this.id = transaction.getId();
            this.dbKey = purchaseDbKeyFactory.newKey(this.id);
            this.buyerId = transaction.getSenderId();
            this.goodsId = digitalGoodsPurchase.getGoodsId();
            this.sellerId = l;
            this.quantity = digitalGoodsPurchase.getQuantity();
            this.priceNQT = digitalGoodsPurchase.getPriceNQT();
            this.deadline = digitalGoodsPurchase.getDeliveryDeadlineTimestamp();
            this.note = transaction.getEncryptedMessage() == null ? null : transaction.getEncryptedMessage().getEncryptedData();
            this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
            this.isPending = true;
        }

        private Purchase(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.buyerId = resultSet.getLong("buyer_id");
            this.goodsId = resultSet.getLong("goods_id");
            this.sellerId = resultSet.getLong("seller_id");
            this.quantity = resultSet.getInt("quantity");
            this.priceNQT = resultSet.getLong("price");
            this.deadline = resultSet.getInt("deadline");
            this.note = DigitalGoodsStore.loadEncryptedData(resultSet, "note", "nonce");
            this.timestamp = resultSet.getInt("timestamp");
            this.isPending = resultSet.getBoolean("pending");
            this.encryptedGoods = DigitalGoodsStore.loadEncryptedData(resultSet, "goods", "goods_nonce");
            this.refundNote = DigitalGoodsStore.loadEncryptedData(resultSet, "refund_note", "refund_nonce");
            this.hasFeedbackNotes = resultSet.getBoolean("has_feedback_notes");
            this.hasPublicFeedbacks = resultSet.getBoolean("has_public_feedbacks");
            this.discountNQT = resultSet.getLong("discount");
            this.refundNQT = resultSet.getLong("refund");
            this.goodsIsText = resultSet.getBoolean("goods_is_text");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO purchase (id, buyer_id, goods_id, seller_id, quantity, price, deadline, note, nonce, timestamp, pending, goods, goods_nonce, goods_is_text, refund_note, refund_nonce, has_feedback_notes, has_public_feedbacks, discount, refund, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setLong(++n, this.buyerId);
                preparedStatement.setLong(++n, this.goodsId);
                preparedStatement.setLong(++n, this.sellerId);
                preparedStatement.setInt(++n, this.quantity);
                preparedStatement.setLong(++n, this.priceNQT);
                preparedStatement.setInt(++n, this.deadline);
                ++n;
                n = DigitalGoodsStore.setEncryptedData(preparedStatement, this.note, n);
                preparedStatement.setInt(n, this.timestamp);
                preparedStatement.setBoolean(++n, this.isPending);
                ++n;
                n = DigitalGoodsStore.setEncryptedData(preparedStatement, this.encryptedGoods, n);
                preparedStatement.setBoolean(n, this.goodsIsText);
                ++n;
                n = DigitalGoodsStore.setEncryptedData(preparedStatement, this.refundNote, n);
                preparedStatement.setBoolean(n, this.hasFeedbackNotes);
                preparedStatement.setBoolean(++n, this.hasPublicFeedbacks);
                preparedStatement.setLong(++n, this.discountNQT);
                preparedStatement.setLong(++n, this.refundNQT);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public long getBuyerId() {
            return this.buyerId;
        }

        public long getGoodsId() {
            return this.goodsId;
        }

        public long getSellerId() {
            return this.sellerId;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }

        public int getDeliveryDeadlineTimestamp() {
            return this.deadline;
        }

        public EncryptedData getNote() {
            return this.note;
        }

        public boolean isPending() {
            return this.isPending;
        }

        private void setPending(boolean bl) {
            this.isPending = bl;
            purchaseTable.insert(this);
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public EncryptedData getEncryptedGoods() {
            return this.encryptedGoods;
        }

        public boolean goodsIsText() {
            return this.goodsIsText;
        }

        private void setEncryptedGoods(EncryptedData encryptedData, boolean bl) {
            this.encryptedGoods = encryptedData;
            this.goodsIsText = bl;
            purchaseTable.insert(this);
        }

        public EncryptedData getRefundNote() {
            return this.refundNote;
        }

        private void setRefundNote(EncryptedData encryptedData) {
            this.refundNote = encryptedData;
            purchaseTable.insert(this);
        }

        public boolean hasFeedbackNotes() {
            return this.hasFeedbackNotes;
        }

        public List<EncryptedData> getFeedbackNotes() {
            if (!this.hasFeedbackNotes) {
                return null;
            }
            this.feedbackNotes = feedbackTable.get(feedbackDbKeyFactory.newKey(this));
            return this.feedbackNotes;
        }

        private void addFeedbackNote(EncryptedData encryptedData) {
            if (this.getFeedbackNotes() == null) {
                this.feedbackNotes = new ArrayList<EncryptedData>();
            }
            this.feedbackNotes.add(encryptedData);
            if (!this.hasFeedbackNotes) {
                this.hasFeedbackNotes = true;
                purchaseTable.insert(this);
            }
            feedbackTable.insert(this, this.feedbackNotes);
        }

        public boolean hasPublicFeedbacks() {
            return this.hasPublicFeedbacks;
        }

        public List<String> getPublicFeedbacks() {
            if (!this.hasPublicFeedbacks) {
                return null;
            }
            this.publicFeedbacks = publicFeedbackTable.get(publicFeedbackDbKeyFactory.newKey(this));
            return this.publicFeedbacks;
        }

        private void addPublicFeedback(String string) {
            if (this.getPublicFeedbacks() == null) {
                this.publicFeedbacks = new ArrayList<String>();
            }
            this.publicFeedbacks.add(string);
            if (!this.hasPublicFeedbacks) {
                this.hasPublicFeedbacks = true;
                purchaseTable.insert(this);
            }
            publicFeedbackTable.insert(this, this.publicFeedbacks);
        }

        public long getDiscountNQT() {
            return this.discountNQT;
        }

        private void setDiscountNQT(long l) {
            this.discountNQT = l;
            purchaseTable.insert(this);
        }

        public long getRefundNQT() {
            return this.refundNQT;
        }

        private void setRefundNQT(long l) {
            this.refundNQT = l;
            purchaseTable.insert(this);
        }

        private static final class SellerBuyerPurchasesClause
        extends PurchasesClause {
            private final long sellerId;
            private final long buyerId;

            private SellerBuyerPurchasesClause(long l, long l2, boolean bl, boolean bl2) {
                super(" seller_id = ? AND buyer_id = ? ", bl, bl2);
                this.sellerId = l;
                this.buyerId = l2;
            }

            @Override
            protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
                preparedStatement.setLong(n++, this.sellerId);
                preparedStatement.setLong(n++, this.buyerId);
                return n;
            }
        }

        private static final class LongPurchasesClause
        extends PurchasesClause {
            private final long value;

            private LongPurchasesClause(String string, long l, boolean bl, boolean bl2) {
                super(string + " = ? ", bl, bl2);
                this.value = l;
            }

            @Override
            protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
                preparedStatement.setLong(n++, this.value);
                return n;
            }
        }

        private static class PurchasesClause
        extends DbClause {
            private PurchasesClause(String string, boolean bl, boolean bl2) {
                super(string + (bl2 ? " AND goods IS NOT NULL " : " ") + (bl ? " AND has_public_feedbacks = TRUE " : " "));
            }

            @Override
            protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
                return n;
            }
        }
    }

    public static final class Goods {
        private static final DbKey.LongKeyFactory<Goods> goodsDbKeyFactory = new DbKey.LongKeyFactory<Goods>("id"){

            @Override
            public DbKey newKey(Goods goods) {
                return goods.dbKey;
            }
        };
        private static final VersionedEntityDbTable<Goods> goodsTable = new VersionedEntityDbTable<Goods>("goods", goodsDbKeyFactory, "name,description,tags"){

            @Override
            protected Goods load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Goods(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Goods goods) throws SQLException {
                goods.save(connection);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY timestamp DESC, id ASC ";
            }
        };
        private static final DbClause inStockClause = new DbClause.BooleanClause("goods.delisted", false).and(new DbClause.LongClause("goods.quantity", DbClause.Op.GT, 0L));
        private final long id;
        private final DbKey dbKey;
        private final long sellerId;
        private final String name;
        private final String description;
        private final String tags;
        private final String[] parsedTags;
        private final int timestamp;
        private final boolean hasImage;
        private int quantity;
        private long priceNQT;
        private boolean delisted;

        public static int getCount() {
            return goodsTable.getCount();
        }

        public static int getCountInStock() {
            return goodsTable.getCount(inStockClause);
        }

        public static Goods getGoods(long l) {
            return (Goods)goodsTable.get(goodsDbKeyFactory.newKey(l));
        }

        public static DbIterator<Goods> getAllGoods(int n, int n2) {
            return goodsTable.getAll(n, n2);
        }

        public static DbIterator<Goods> getGoodsInStock(int n, int n2) {
            return goodsTable.getManyBy(inStockClause, n, n2);
        }

        public static DbIterator<Goods> getSellerGoods(long l, boolean bl, int n, int n2) {
            return goodsTable.getManyBy((DbClause)new SellerDbClause(l, bl), n, n2, " ORDER BY name ASC, timestamp DESC, id ASC ");
        }

        public static int getSellerGoodsCount(long l, boolean bl) {
            return goodsTable.getCount(new SellerDbClause(l, bl));
        }

        public static DbIterator<Goods> searchGoods(String string, boolean bl, int n, int n2) {
            return goodsTable.search(string, bl ? inStockClause : DbClause.EMPTY_CLAUSE, n, n2, " ORDER BY ft.score DESC, goods.timestamp DESC ");
        }

        public static DbIterator<Goods> searchSellerGoods(String string, long l, boolean bl, int n, int n2) {
            return goodsTable.search(string, new SellerDbClause(l, bl), n, n2, " ORDER BY ft.score DESC, goods.name ASC, goods.timestamp DESC ");
        }

        private static void init() {
        }

        private Goods(Transaction transaction, Attachment.DigitalGoodsListing digitalGoodsListing) {
            byte[] byArray;
            this.id = transaction.getId();
            this.dbKey = goodsDbKeyFactory.newKey(this.id);
            this.sellerId = transaction.getSenderId();
            this.name = digitalGoodsListing.getName();
            this.description = digitalGoodsListing.getDescription();
            this.tags = digitalGoodsListing.getTags();
            this.parsedTags = Search.parseTags(this.tags, 3, 20, 3);
            this.quantity = digitalGoodsListing.getQuantity();
            this.priceNQT = digitalGoodsListing.getPriceNQT();
            this.delisted = false;
            this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
            boolean bl = false;
            Appendix.PrunablePlainMessage prunablePlainMessage = transaction.getPrunablePlainMessage();
            if (!Constants.DISABLE_METADATA_DETECTION && prunablePlainMessage != null && (byArray = prunablePlainMessage.getMessage()) != null) {
                String string = Search.detectMimeType(byArray);
                bl = string != null && string.startsWith("image/");
            }
            this.hasImage = bl;
        }

        private Goods(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.sellerId = resultSet.getLong("seller_id");
            this.name = resultSet.getString("name");
            this.description = resultSet.getString("description");
            this.tags = resultSet.getString("tags");
            this.parsedTags = (String[])DbUtils.getArray(resultSet, "parsed_tags", String[].class);
            this.quantity = resultSet.getInt("quantity");
            this.priceNQT = resultSet.getLong("price");
            this.delisted = resultSet.getBoolean("delisted");
            this.timestamp = resultSet.getInt("timestamp");
            this.hasImage = resultSet.getBoolean("has_image");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO goods (id, seller_id, name, description, tags, parsed_tags, timestamp, quantity, price, delisted, has_image, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setLong(++n, this.sellerId);
                preparedStatement.setString(++n, this.name);
                preparedStatement.setString(++n, this.description);
                preparedStatement.setString(++n, this.tags);
                DbUtils.setArray(preparedStatement, ++n, this.parsedTags);
                preparedStatement.setInt(++n, this.timestamp);
                preparedStatement.setInt(++n, this.quantity);
                preparedStatement.setLong(++n, this.priceNQT);
                preparedStatement.setBoolean(++n, this.delisted);
                preparedStatement.setBoolean(++n, this.hasImage);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public long getSellerId() {
            return this.sellerId;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTags() {
            return this.tags;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public int getQuantity() {
            return this.quantity;
        }

        private void changeQuantity(int n) {
            if (this.quantity == 0 && n > 0) {
                Tag.add(this);
            }
            this.quantity += n;
            if (this.quantity < 0) {
                this.quantity = 0;
            } else if (this.quantity > 1000000000) {
                this.quantity = 1000000000;
            }
            if (this.quantity == 0) {
                Tag.delist(this);
            }
            goodsTable.insert(this);
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }

        private void changePrice(long l) {
            this.priceNQT = l;
            goodsTable.insert(this);
        }

        public boolean isDelisted() {
            return this.delisted;
        }

        private void setDelisted(boolean bl) {
            this.delisted = bl;
            if (this.quantity > 0) {
                Tag.delist(this);
            }
            goodsTable.insert(this);
        }

        public String[] getParsedTags() {
            return this.parsedTags;
        }

        public boolean hasImage() {
            return this.hasImage;
        }
    }

    public static final class Tag {
        private static final DbKey.StringKeyFactory<Tag> tagDbKeyFactory = new DbKey.StringKeyFactory<Tag>("tag"){

            @Override
            public DbKey newKey(Tag tag) {
                return tag.dbKey;
            }
        };
        private static final VersionedEntityDbTable<Tag> tagTable = new VersionedEntityDbTable<Tag>("tag", tagDbKeyFactory){

            @Override
            protected Tag load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Tag(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Tag tag) throws SQLException {
                tag.save(connection);
            }

            @Override
            public String defaultSort() {
                return " ORDER BY in_stock_count DESC, total_count DESC, tag ASC ";
            }
        };
        private static final DbClause inStockOnlyClause = new DbClause.IntClause("in_stock_count", DbClause.Op.GT, 0);
        private final String tag;
        private final DbKey dbKey;
        private int inStockCount;
        private int totalCount;

        public static int getCount() {
            return tagTable.getCount();
        }

        public static int getCountInStock() {
            return tagTable.getCount(inStockOnlyClause);
        }

        public static DbIterator<Tag> getAllTags(int n, int n2) {
            return tagTable.getAll(n, n2);
        }

        public static DbIterator<Tag> getInStockTags(int n, int n2) {
            return tagTable.getManyBy(inStockOnlyClause, n, n2);
        }

        public static DbIterator<Tag> getTagsLike(String string, boolean bl, int n, int n2) {
            DbClause dbClause = new DbClause.LikeClause("tag", string);
            if (bl) {
                dbClause = dbClause.and(inStockOnlyClause);
            }
            return tagTable.getManyBy(dbClause, n, n2, " ORDER BY tag ");
        }

        private static void init() {
        }

        private static void add(Goods goods) {
            for (String string : goods.getParsedTags()) {
                Tag tag = (Tag)tagTable.get(tagDbKeyFactory.newKey(string));
                if (tag == null) {
                    tag = new Tag(string);
                }
                ++tag.inStockCount;
                ++tag.totalCount;
                tagTable.insert(tag);
            }
        }

        private static void delist(Goods goods) {
            for (String string : goods.getParsedTags()) {
                Tag tag = (Tag)tagTable.get(tagDbKeyFactory.newKey(string));
                if (tag == null) {
                    throw new IllegalStateException("Unknown tag " + string);
                }
                --tag.inStockCount;
                tagTable.insert(tag);
            }
        }

        private Tag(String string) {
            this.tag = string;
            this.dbKey = tagDbKeyFactory.newKey(this.tag);
        }

        private Tag(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.tag = resultSet.getString("tag");
            this.dbKey = dbKey;
            this.inStockCount = resultSet.getInt("in_stock_count");
            this.totalCount = resultSet.getInt("total_count");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO tag (tag, in_stock_count, total_count, height, latest) KEY (tag, height) VALUES (?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setString(++n, this.tag);
                preparedStatement.setInt(++n, this.inStockCount);
                preparedStatement.setInt(++n, this.totalCount);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public String getTag() {
            return this.tag;
        }

        public int getInStockCount() {
            return this.inStockCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }

    public static enum Event {
        GOODS_LISTED,
        GOODS_DELISTED,
        GOODS_PRICE_CHANGE,
        GOODS_QUANTITY_CHANGE,
        PURCHASE,
        DELIVERY,
        REFUND,
        FEEDBACK;

    }
}

