/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Attachment;
import nxt.Block;
import nxt.Nxt;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.EntityDbTable;

public final class ExchangeRequest {
    private static final DbKey.LongKeyFactory<ExchangeRequest> exchangeRequestDbKeyFactory = new DbKey.LongKeyFactory<ExchangeRequest>("id"){

        @Override
        public DbKey newKey(ExchangeRequest exchangeRequest) {
            return exchangeRequest.dbKey;
        }
    };
    private static final EntityDbTable<ExchangeRequest> exchangeRequestTable = new EntityDbTable<ExchangeRequest>("exchange_request", exchangeRequestDbKeyFactory){

        @Override
        protected ExchangeRequest load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new ExchangeRequest(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, ExchangeRequest exchangeRequest) throws SQLException {
            exchangeRequest.save(connection);
        }
    };
    private final long id;
    private final long accountId;
    private final long currencyId;
    private final int height;
    private final int timestamp;
    private final DbKey dbKey;
    private final long units;
    private final long rate;
    private final boolean isBuy;

    public static DbIterator<ExchangeRequest> getAllExchangeRequests(int n, int n2) {
        return exchangeRequestTable.getAll(n, n2);
    }

    public static int getCount() {
        return exchangeRequestTable.getCount();
    }

    public static ExchangeRequest getExchangeRequest(long l) {
        return exchangeRequestTable.get(exchangeRequestDbKeyFactory.newKey(l));
    }

    public static DbIterator<ExchangeRequest> getCurrencyExchangeRequests(long l, int n, int n2) {
        return exchangeRequestTable.getManyBy(new DbClause.LongClause("currency_id", l), n, n2);
    }

    public static DbIterator<ExchangeRequest> getAccountExchangeRequests(long l, int n, int n2) {
        return exchangeRequestTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    public static DbIterator<ExchangeRequest> getAccountCurrencyExchangeRequests(long l, long l2, int n, int n2) {
        return exchangeRequestTable.getManyBy(new DbClause.LongClause("account_id", l).and(new DbClause.LongClause("currency_id", l2)), n, n2);
    }

    static void addExchangeRequest(Transaction transaction, Attachment.MonetarySystemExchangeBuy monetarySystemExchangeBuy) {
        ExchangeRequest exchangeRequest = new ExchangeRequest(transaction, monetarySystemExchangeBuy);
        exchangeRequestTable.insert(exchangeRequest);
    }

    static void addExchangeRequest(Transaction transaction, Attachment.MonetarySystemExchangeSell monetarySystemExchangeSell) {
        ExchangeRequest exchangeRequest = new ExchangeRequest(transaction, monetarySystemExchangeSell);
        exchangeRequestTable.insert(exchangeRequest);
    }

    static void init() {
    }

    private ExchangeRequest(Transaction transaction, Attachment.MonetarySystemExchangeBuy monetarySystemExchangeBuy) {
        this(transaction, monetarySystemExchangeBuy, true);
    }

    private ExchangeRequest(Transaction transaction, Attachment.MonetarySystemExchangeSell monetarySystemExchangeSell) {
        this(transaction, monetarySystemExchangeSell, false);
    }

    private ExchangeRequest(Transaction transaction, Attachment.MonetarySystemExchange monetarySystemExchange, boolean bl) {
        this.id = transaction.getId();
        this.dbKey = exchangeRequestDbKeyFactory.newKey(this.id);
        this.accountId = transaction.getSenderId();
        this.currencyId = monetarySystemExchange.getCurrencyId();
        this.units = monetarySystemExchange.getUnits();
        this.rate = monetarySystemExchange.getRateNQT();
        this.isBuy = bl;
        Block block = Nxt.getBlockchain().getLastBlock();
        this.height = block.getHeight();
        this.timestamp = block.getTimestamp();
    }

    private ExchangeRequest(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.accountId = resultSet.getLong("account_id");
        this.currencyId = resultSet.getLong("currency_id");
        this.units = resultSet.getLong("units");
        this.rate = resultSet.getLong("rate");
        this.isBuy = resultSet.getBoolean("is_buy");
        this.timestamp = resultSet.getInt("timestamp");
        this.height = resultSet.getInt("height");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO exchange_request (id, account_id, currency_id, units, rate, is_buy, timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setLong(++n, this.currencyId);
            preparedStatement.setLong(++n, this.units);
            preparedStatement.setLong(++n, this.rate);
            preparedStatement.setBoolean(++n, this.isBuy);
            preparedStatement.setInt(++n, this.timestamp);
            preparedStatement.setInt(++n, this.height);
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getUnits() {
        return this.units;
    }

    public long getRate() {
        return this.rate;
    }

    public boolean isBuy() {
        return this.isBuy;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getHeight() {
        return this.height;
    }
}

