/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Map;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Attachment;
import nxt.Currency;
import nxt.CurrencyExchangeOffer;
import nxt.CurrencyMint;
import nxt.CurrencyMinting;
import nxt.CurrencyTransfer;
import nxt.CurrencyType;
import nxt.ExchangeRequest;
import nxt.Fee;
import nxt.Genesis;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.TransactionType;
import org.json.simple.JSONObject;

public abstract class MonetarySystem
extends TransactionType {
    private static final byte SUBTYPE_MONETARY_SYSTEM_CURRENCY_ISSUANCE = 0;
    private static final byte SUBTYPE_MONETARY_SYSTEM_RESERVE_INCREASE = 1;
    private static final byte SUBTYPE_MONETARY_SYSTEM_RESERVE_CLAIM = 2;
    private static final byte SUBTYPE_MONETARY_SYSTEM_CURRENCY_TRANSFER = 3;
    private static final byte SUBTYPE_MONETARY_SYSTEM_PUBLISH_EXCHANGE_OFFER = 4;
    private static final byte SUBTYPE_MONETARY_SYSTEM_EXCHANGE_BUY = 5;
    private static final byte SUBTYPE_MONETARY_SYSTEM_EXCHANGE_SELL = 6;
    private static final byte SUBTYPE_MONETARY_SYSTEM_CURRENCY_MINTING = 7;
    private static final byte SUBTYPE_MONETARY_SYSTEM_CURRENCY_DELETION = 8;
    public static final TransactionType CURRENCY_ISSUANCE = new MonetarySystem(){
        private final Fee FIVE_LETTER_CURRENCY_ISSUANCE_FEE = new Fee.ConstantFee(2500000000000L);
        private final Fee FOUR_LETTER_CURRENCY_ISSUANCE_FEE = new Fee.ConstantFee(2500000000000L);
        private final Fee THREE_LETTER_CURRENCY_ISSUANCE_FEE = new Fee.ConstantFee(2500000000000L);

        @Override
        public byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_ISSUANCE;
        }

        @Override
        public String getName() {
            return "CurrencyIssuance";
        }

        @Override
        Fee getBaselineFee(Transaction transaction) {
            Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)transaction.getAttachment();
            int n = Math.min(monetarySystemCurrencyIssuance.getCode().length(), monetarySystemCurrencyIssuance.getName().length());
            int n2 = Integer.MAX_VALUE;
            Currency currency = Currency.getCurrencyByCode(monetarySystemCurrencyIssuance.getCode());
            if (currency != null) {
                n2 = Math.min(n2, Math.min(currency.getCode().length(), currency.getName().length()));
            }
            if ((currency = Currency.getCurrencyByCode(monetarySystemCurrencyIssuance.getName())) != null) {
                n2 = Math.min(n2, Math.min(currency.getCode().length(), currency.getName().length()));
            }
            if ((currency = Currency.getCurrencyByName(monetarySystemCurrencyIssuance.getName())) != null) {
                n2 = Math.min(n2, Math.min(currency.getCode().length(), currency.getName().length()));
            }
            if ((currency = Currency.getCurrencyByName(monetarySystemCurrencyIssuance.getCode())) != null) {
                n2 = Math.min(n2, Math.min(currency.getCode().length(), currency.getName().length()));
            }
            if (n >= n2) {
                return this.FIVE_LETTER_CURRENCY_ISSUANCE_FEE;
            }
            switch (n) {
                case 3: {
                    return this.THREE_LETTER_CURRENCY_ISSUANCE_FEE;
                }
                case 4: {
                    return this.FOUR_LETTER_CURRENCY_ISSUANCE_FEE;
                }
                case 5: {
                    return this.FIVE_LETTER_CURRENCY_ISSUANCE_FEE;
                }
            }
            return this.THREE_LETTER_CURRENCY_ISSUANCE_FEE;
        }

        @Override
        long[] getBackFees(Transaction transaction) {
            long l = transaction.getFeeNQT();
            return new long[]{l * 3L / 10L, l * 2L / 10L, l / 10L};
        }

        @Override
        Attachment.MonetarySystemCurrencyIssuance parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new Attachment.MonetarySystemCurrencyIssuance(byteBuffer);
        }

        @Override
        Attachment.MonetarySystemCurrencyIssuance parseAttachment(JSONObject jSONObject) {
            return new Attachment.MonetarySystemCurrencyIssuance(jSONObject);
        }

        @Override
        boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)transaction.getAttachment();
            String string = monetarySystemCurrencyIssuance.getName().toLowerCase(Locale.ROOT);
            String string2 = monetarySystemCurrencyIssuance.getCode().toLowerCase(Locale.ROOT);
            boolean bl = TransactionType.isDuplicate(CURRENCY_ISSUANCE, string, map, true);
            if (!string.equals(string2)) {
                bl = bl || TransactionType.isDuplicate(CURRENCY_ISSUANCE, string2, map, true);
            }
            return bl;
        }

        @Override
        boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            return 1.isDuplicate(CURRENCY_ISSUANCE, this.getName(), map, true);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)transaction.getAttachment();
            if (monetarySystemCurrencyIssuance.getMaxSupply() > 100000000000000000L || monetarySystemCurrencyIssuance.getMaxSupply() <= 0L || monetarySystemCurrencyIssuance.getInitialSupply() < 0L || monetarySystemCurrencyIssuance.getInitialSupply() > monetarySystemCurrencyIssuance.getMaxSupply() || monetarySystemCurrencyIssuance.getReserveSupply() < 0L || monetarySystemCurrencyIssuance.getReserveSupply() > monetarySystemCurrencyIssuance.getMaxSupply() || monetarySystemCurrencyIssuance.getIssuanceHeight() < 0 || monetarySystemCurrencyIssuance.getMinReservePerUnitNQT() < 0L || monetarySystemCurrencyIssuance.getDecimals() < 0 || monetarySystemCurrencyIssuance.getDecimals() > 8 || monetarySystemCurrencyIssuance.getRuleset() != 0) {
                throw new NxtException.NotValidException("Invalid currency issuance: " + monetarySystemCurrencyIssuance.getJSONObject());
            }
            int n = 1;
            for (int i = 0; i < 32; ++i) {
                if ((n & monetarySystemCurrencyIssuance.getType()) != 0 && CurrencyType.get(n) == null) {
                    throw new NxtException.NotValidException("Invalid currency type: " + monetarySystemCurrencyIssuance.getType());
                }
                n <<= 1;
            }
            CurrencyType.validate(monetarySystemCurrencyIssuance.getType(), transaction);
            CurrencyType.validateCurrencyNaming(transaction.getSenderId(), monetarySystemCurrencyIssuance);
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)transaction.getAttachment();
            long l = transaction.getId();
            Currency.addCurrency(this.getLedgerEvent(), l, transaction, account, monetarySystemCurrencyIssuance);
            account.addToCurrencyAndUnconfirmedCurrencyUnits(this.getLedgerEvent(), l, l, monetarySystemCurrencyIssuance.getInitialSupply());
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }
    };
    public static final TransactionType RESERVE_INCREASE = new MonetarySystem(){

        @Override
        public byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_RESERVE_INCREASE;
        }

        @Override
        public String getName() {
            return "ReserveIncrease";
        }

        @Override
        Attachment.MonetarySystemReserveIncrease parseAttachment(ByteBuffer byteBuffer) {
            return new Attachment.MonetarySystemReserveIncrease(byteBuffer);
        }

        @Override
        Attachment.MonetarySystemReserveIncrease parseAttachment(JSONObject jSONObject) {
            return new Attachment.MonetarySystemReserveIncrease(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.MonetarySystemReserveIncrease monetarySystemReserveIncrease = (Attachment.MonetarySystemReserveIncrease)transaction.getAttachment();
            if (monetarySystemReserveIncrease.getAmountPerUnitNQT() <= 0L) {
                throw new NxtException.NotValidException("Reserve increase amount must be positive: " + monetarySystemReserveIncrease.getAmountPerUnitNQT());
            }
            CurrencyType.validate(Currency.getCurrency(monetarySystemReserveIncrease.getCurrencyId()), transaction);
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemReserveIncrease monetarySystemReserveIncrease = (Attachment.MonetarySystemReserveIncrease)transaction.getAttachment();
            Currency currency = Currency.getCurrency(monetarySystemReserveIncrease.getCurrencyId());
            if (account.getUnconfirmedBalanceNQT() >= Math.multiplyExact(currency.getReserveSupply(), monetarySystemReserveIncrease.getAmountPerUnitNQT())) {
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), -Math.multiplyExact(currency.getReserveSupply(), monetarySystemReserveIncrease.getAmountPerUnitNQT()));
                return true;
            }
            return false;
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            long l;
            Attachment.MonetarySystemReserveIncrease monetarySystemReserveIncrease = (Attachment.MonetarySystemReserveIncrease)transaction.getAttachment();
            Currency currency = Currency.getCurrency(monetarySystemReserveIncrease.getCurrencyId());
            if (currency != null) {
                l = currency.getReserveSupply();
            } else {
                Transaction transaction2 = Nxt.getBlockchain().getTransaction(monetarySystemReserveIncrease.getCurrencyId());
                Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)transaction2.getAttachment();
                l = monetarySystemCurrencyIssuance.getReserveSupply();
            }
            account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), Math.multiplyExact(l, monetarySystemReserveIncrease.getAmountPerUnitNQT()));
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.MonetarySystemReserveIncrease monetarySystemReserveIncrease = (Attachment.MonetarySystemReserveIncrease)transaction.getAttachment();
            Currency.increaseReserve(this.getLedgerEvent(), transaction.getId(), account, monetarySystemReserveIncrease.getCurrencyId(), monetarySystemReserveIncrease.getAmountPerUnitNQT());
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }
    };
    public static final TransactionType RESERVE_CLAIM = new MonetarySystem(){

        @Override
        public byte getSubtype() {
            return 2;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_RESERVE_CLAIM;
        }

        @Override
        public String getName() {
            return "ReserveClaim";
        }

        @Override
        Attachment.MonetarySystemReserveClaim parseAttachment(ByteBuffer byteBuffer) {
            return new Attachment.MonetarySystemReserveClaim(byteBuffer);
        }

        @Override
        Attachment.MonetarySystemReserveClaim parseAttachment(JSONObject jSONObject) {
            return new Attachment.MonetarySystemReserveClaim(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.MonetarySystemReserveClaim monetarySystemReserveClaim = (Attachment.MonetarySystemReserveClaim)transaction.getAttachment();
            if (monetarySystemReserveClaim.getUnits() <= 0L) {
                throw new NxtException.NotValidException("Reserve claim number of units must be positive: " + monetarySystemReserveClaim.getUnits());
            }
            CurrencyType.validate(Currency.getCurrency(monetarySystemReserveClaim.getCurrencyId()), transaction);
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemReserveClaim monetarySystemReserveClaim = (Attachment.MonetarySystemReserveClaim)transaction.getAttachment();
            if (account.getUnconfirmedCurrencyUnits(monetarySystemReserveClaim.getCurrencyId()) >= monetarySystemReserveClaim.getUnits()) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), transaction.getId(), monetarySystemReserveClaim.getCurrencyId(), -monetarySystemReserveClaim.getUnits());
                return true;
            }
            return false;
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemReserveClaim monetarySystemReserveClaim = (Attachment.MonetarySystemReserveClaim)transaction.getAttachment();
            Currency currency = Currency.getCurrency(monetarySystemReserveClaim.getCurrencyId());
            if (currency != null) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), transaction.getId(), monetarySystemReserveClaim.getCurrencyId(), monetarySystemReserveClaim.getUnits());
            }
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.MonetarySystemReserveClaim monetarySystemReserveClaim = (Attachment.MonetarySystemReserveClaim)transaction.getAttachment();
            Currency.claimReserve(this.getLedgerEvent(), transaction.getId(), account, monetarySystemReserveClaim.getCurrencyId(), monetarySystemReserveClaim.getUnits());
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }
    };
    public static final TransactionType CURRENCY_TRANSFER = new MonetarySystem(){

        @Override
        public byte getSubtype() {
            return 3;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_TRANSFER;
        }

        @Override
        public String getName() {
            return "CurrencyTransfer";
        }

        @Override
        Attachment.MonetarySystemCurrencyTransfer parseAttachment(ByteBuffer byteBuffer) {
            return new Attachment.MonetarySystemCurrencyTransfer(byteBuffer);
        }

        @Override
        Attachment.MonetarySystemCurrencyTransfer parseAttachment(JSONObject jSONObject) {
            return new Attachment.MonetarySystemCurrencyTransfer(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.MonetarySystemCurrencyTransfer monetarySystemCurrencyTransfer = (Attachment.MonetarySystemCurrencyTransfer)transaction.getAttachment();
            if (monetarySystemCurrencyTransfer.getUnits() <= 0L) {
                throw new NxtException.NotValidException("Invalid currency transfer: " + monetarySystemCurrencyTransfer.getJSONObject());
            }
            if (transaction.getRecipientId() == Genesis.CREATOR_ID) {
                throw new NxtException.NotValidException("Currency transfer to genesis account not allowed");
            }
            Currency currency = Currency.getCurrency(monetarySystemCurrencyTransfer.getCurrencyId());
            CurrencyType.validate(currency, transaction);
            if (!currency.isActive()) {
                throw new NxtException.NotCurrentlyValidException("Currency not currently active: " + monetarySystemCurrencyTransfer.getJSONObject());
            }
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemCurrencyTransfer monetarySystemCurrencyTransfer = (Attachment.MonetarySystemCurrencyTransfer)transaction.getAttachment();
            if (monetarySystemCurrencyTransfer.getUnits() > account.getUnconfirmedCurrencyUnits(monetarySystemCurrencyTransfer.getCurrencyId())) {
                return false;
            }
            account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), transaction.getId(), monetarySystemCurrencyTransfer.getCurrencyId(), -monetarySystemCurrencyTransfer.getUnits());
            return true;
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemCurrencyTransfer monetarySystemCurrencyTransfer = (Attachment.MonetarySystemCurrencyTransfer)transaction.getAttachment();
            Currency currency = Currency.getCurrency(monetarySystemCurrencyTransfer.getCurrencyId());
            if (currency != null) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), transaction.getId(), monetarySystemCurrencyTransfer.getCurrencyId(), monetarySystemCurrencyTransfer.getUnits());
            }
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.MonetarySystemCurrencyTransfer monetarySystemCurrencyTransfer = (Attachment.MonetarySystemCurrencyTransfer)transaction.getAttachment();
            Currency.transferCurrency(this.getLedgerEvent(), transaction.getId(), account, account2, monetarySystemCurrencyTransfer.getCurrencyId(), monetarySystemCurrencyTransfer.getUnits());
            CurrencyTransfer.addTransfer(transaction, monetarySystemCurrencyTransfer);
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }
    };
    public static final TransactionType PUBLISH_EXCHANGE_OFFER = new MonetarySystem(){

        @Override
        public byte getSubtype() {
            return 4;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_PUBLISH_EXCHANGE_OFFER;
        }

        @Override
        public String getName() {
            return "PublishExchangeOffer";
        }

        @Override
        Attachment.MonetarySystemPublishExchangeOffer parseAttachment(ByteBuffer byteBuffer) {
            return new Attachment.MonetarySystemPublishExchangeOffer(byteBuffer);
        }

        @Override
        Attachment.MonetarySystemPublishExchangeOffer parseAttachment(JSONObject jSONObject) {
            return new Attachment.MonetarySystemPublishExchangeOffer(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
            if (monetarySystemPublishExchangeOffer.getBuyRateNQT() <= 0L || monetarySystemPublishExchangeOffer.getSellRateNQT() <= 0L || monetarySystemPublishExchangeOffer.getBuyRateNQT() > monetarySystemPublishExchangeOffer.getSellRateNQT()) {
                throw new NxtException.NotValidException(String.format("Invalid exchange offer, buy rate %d and sell rate %d has to be larger than 0, buy rate cannot be larger than sell rate", monetarySystemPublishExchangeOffer.getBuyRateNQT(), monetarySystemPublishExchangeOffer.getSellRateNQT()));
            }
            if (monetarySystemPublishExchangeOffer.getTotalBuyLimit() < 0L || monetarySystemPublishExchangeOffer.getTotalSellLimit() < 0L || monetarySystemPublishExchangeOffer.getInitialBuySupply() < 0L || monetarySystemPublishExchangeOffer.getInitialSellSupply() < 0L || monetarySystemPublishExchangeOffer.getExpirationHeight() < 0) {
                throw new NxtException.NotValidException("Invalid exchange offer, units and height cannot be negative: " + monetarySystemPublishExchangeOffer.getJSONObject());
            }
            if (monetarySystemPublishExchangeOffer.getTotalBuyLimit() < monetarySystemPublishExchangeOffer.getInitialBuySupply() || monetarySystemPublishExchangeOffer.getTotalSellLimit() < monetarySystemPublishExchangeOffer.getInitialSellSupply()) {
                throw new NxtException.NotValidException("Initial supplies must not exceed total limits");
            }
            if (monetarySystemPublishExchangeOffer.getTotalBuyLimit() == 0L && monetarySystemPublishExchangeOffer.getTotalSellLimit() == 0L) {
                throw new NxtException.NotValidException("Total buy and sell limits cannot be both 0");
            }
            if (monetarySystemPublishExchangeOffer.getInitialBuySupply() == 0L && monetarySystemPublishExchangeOffer.getInitialSellSupply() == 0L) {
                throw new NxtException.NotValidException("Initial buy and sell supply cannot be both 0");
            }
            if (monetarySystemPublishExchangeOffer.getExpirationHeight() <= monetarySystemPublishExchangeOffer.getFinishValidationHeight(transaction)) {
                throw new NxtException.NotCurrentlyValidException("Expiration height must be after transaction execution height");
            }
            Currency currency = Currency.getCurrency(monetarySystemPublishExchangeOffer.getCurrencyId());
            CurrencyType.validate(currency, transaction);
            if (!currency.isActive()) {
                throw new NxtException.NotCurrentlyValidException("Currency not currently active: " + monetarySystemPublishExchangeOffer.getJSONObject());
            }
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
            if (account.getUnconfirmedBalanceNQT() >= Math.multiplyExact(monetarySystemPublishExchangeOffer.getInitialBuySupply(), monetarySystemPublishExchangeOffer.getBuyRateNQT()) && account.getUnconfirmedCurrencyUnits(monetarySystemPublishExchangeOffer.getCurrencyId()) >= monetarySystemPublishExchangeOffer.getInitialSellSupply()) {
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), -Math.multiplyExact(monetarySystemPublishExchangeOffer.getInitialBuySupply(), monetarySystemPublishExchangeOffer.getBuyRateNQT()));
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), transaction.getId(), monetarySystemPublishExchangeOffer.getCurrencyId(), -monetarySystemPublishExchangeOffer.getInitialSellSupply());
                return true;
            }
            return false;
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
            account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), Math.multiplyExact(monetarySystemPublishExchangeOffer.getInitialBuySupply(), monetarySystemPublishExchangeOffer.getBuyRateNQT()));
            Currency currency = Currency.getCurrency(monetarySystemPublishExchangeOffer.getCurrencyId());
            if (currency != null) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), transaction.getId(), monetarySystemPublishExchangeOffer.getCurrencyId(), monetarySystemPublishExchangeOffer.getInitialSellSupply());
            }
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
            CurrencyExchangeOffer.publishOffer(transaction, monetarySystemPublishExchangeOffer);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }
    };
    public static final TransactionType EXCHANGE_BUY = new MonetarySystemExchange(){

        @Override
        public byte getSubtype() {
            return 5;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_EXCHANGE_BUY;
        }

        @Override
        public String getName() {
            return "ExchangeBuy";
        }

        @Override
        Attachment.MonetarySystemExchangeBuy parseAttachment(ByteBuffer byteBuffer) {
            return new Attachment.MonetarySystemExchangeBuy(byteBuffer);
        }

        @Override
        Attachment.MonetarySystemExchangeBuy parseAttachment(JSONObject jSONObject) {
            return new Attachment.MonetarySystemExchangeBuy(jSONObject);
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemExchangeBuy monetarySystemExchangeBuy = (Attachment.MonetarySystemExchangeBuy)transaction.getAttachment();
            if (account.getUnconfirmedBalanceNQT() >= Math.multiplyExact(monetarySystemExchangeBuy.getUnits(), monetarySystemExchangeBuy.getRateNQT())) {
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), -Math.multiplyExact(monetarySystemExchangeBuy.getUnits(), monetarySystemExchangeBuy.getRateNQT()));
                return true;
            }
            return false;
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemExchangeBuy monetarySystemExchangeBuy = (Attachment.MonetarySystemExchangeBuy)transaction.getAttachment();
            account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), Math.multiplyExact(monetarySystemExchangeBuy.getUnits(), monetarySystemExchangeBuy.getRateNQT()));
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.MonetarySystemExchangeBuy monetarySystemExchangeBuy = (Attachment.MonetarySystemExchangeBuy)transaction.getAttachment();
            ExchangeRequest.addExchangeRequest(transaction, monetarySystemExchangeBuy);
            CurrencyExchangeOffer.exchangeNXTForCurrency(transaction, account, monetarySystemExchangeBuy.getCurrencyId(), monetarySystemExchangeBuy.getRateNQT(), monetarySystemExchangeBuy.getUnits());
        }
    };
    public static final TransactionType EXCHANGE_SELL = new MonetarySystemExchange(){

        @Override
        public byte getSubtype() {
            return 6;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_EXCHANGE_SELL;
        }

        @Override
        public String getName() {
            return "ExchangeSell";
        }

        @Override
        Attachment.MonetarySystemExchangeSell parseAttachment(ByteBuffer byteBuffer) {
            return new Attachment.MonetarySystemExchangeSell(byteBuffer);
        }

        @Override
        Attachment.MonetarySystemExchangeSell parseAttachment(JSONObject jSONObject) {
            return new Attachment.MonetarySystemExchangeSell(jSONObject);
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemExchangeSell monetarySystemExchangeSell = (Attachment.MonetarySystemExchangeSell)transaction.getAttachment();
            if (account.getUnconfirmedCurrencyUnits(monetarySystemExchangeSell.getCurrencyId()) >= monetarySystemExchangeSell.getUnits()) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), transaction.getId(), monetarySystemExchangeSell.getCurrencyId(), -monetarySystemExchangeSell.getUnits());
                return true;
            }
            return false;
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.MonetarySystemExchangeSell monetarySystemExchangeSell = (Attachment.MonetarySystemExchangeSell)transaction.getAttachment();
            Currency currency = Currency.getCurrency(monetarySystemExchangeSell.getCurrencyId());
            if (currency != null) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), transaction.getId(), monetarySystemExchangeSell.getCurrencyId(), monetarySystemExchangeSell.getUnits());
            }
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.MonetarySystemExchangeSell monetarySystemExchangeSell = (Attachment.MonetarySystemExchangeSell)transaction.getAttachment();
            ExchangeRequest.addExchangeRequest(transaction, monetarySystemExchangeSell);
            CurrencyExchangeOffer.exchangeCurrencyForNXT(transaction, account, monetarySystemExchangeSell.getCurrencyId(), monetarySystemExchangeSell.getRateNQT(), monetarySystemExchangeSell.getUnits());
        }
    };
    public static final TransactionType CURRENCY_MINTING = new MonetarySystem(){

        @Override
        public byte getSubtype() {
            return 7;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_MINTING;
        }

        @Override
        public String getName() {
            return "CurrencyMinting";
        }

        @Override
        Attachment.MonetarySystemCurrencyMinting parseAttachment(ByteBuffer byteBuffer) {
            return new Attachment.MonetarySystemCurrencyMinting(byteBuffer);
        }

        @Override
        Attachment.MonetarySystemCurrencyMinting parseAttachment(JSONObject jSONObject) {
            return new Attachment.MonetarySystemCurrencyMinting(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.MonetarySystemCurrencyMinting monetarySystemCurrencyMinting = (Attachment.MonetarySystemCurrencyMinting)transaction.getAttachment();
            Currency currency = Currency.getCurrency(monetarySystemCurrencyMinting.getCurrencyId());
            CurrencyType.validate(currency, transaction);
            if (monetarySystemCurrencyMinting.getUnits() <= 0L) {
                throw new NxtException.NotValidException("Invalid number of units: " + monetarySystemCurrencyMinting.getUnits());
            }
            if (monetarySystemCurrencyMinting.getUnits() > (currency.getMaxSupply() - currency.getReserveSupply()) / 10000L) {
                throw new NxtException.NotValidException(String.format("Cannot mint more than 1/%d of the total units supply in a single request", 10000));
            }
            if (!currency.isActive()) {
                throw new NxtException.NotCurrentlyValidException("Currency not currently active " + monetarySystemCurrencyMinting.getJSONObject());
            }
            long l = CurrencyMint.getCounter(monetarySystemCurrencyMinting.getCurrencyId(), transaction.getSenderId());
            if (monetarySystemCurrencyMinting.getCounter() <= l) {
                throw new NxtException.NotCurrentlyValidException(String.format("Counter %d has to be bigger than %d", monetarySystemCurrencyMinting.getCounter(), l));
            }
            if (!CurrencyMinting.meetsTarget(transaction.getSenderId(), currency, monetarySystemCurrencyMinting)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Hash doesn't meet target %s", monetarySystemCurrencyMinting.getJSONObject()));
            }
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.MonetarySystemCurrencyMinting monetarySystemCurrencyMinting = (Attachment.MonetarySystemCurrencyMinting)transaction.getAttachment();
            CurrencyMint.mintCurrency(this.getLedgerEvent(), transaction.getId(), account, monetarySystemCurrencyMinting);
        }

        @Override
        boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            Attachment.MonetarySystemCurrencyMinting monetarySystemCurrencyMinting = (Attachment.MonetarySystemCurrencyMinting)transaction.getAttachment();
            return TransactionType.isDuplicate(CURRENCY_MINTING, monetarySystemCurrencyMinting.getCurrencyId() + ":" + transaction.getSenderId(), map, true) || super.isDuplicate(transaction, map);
        }

        @Override
        boolean isUnconfirmedDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            Attachment.MonetarySystemCurrencyMinting monetarySystemCurrencyMinting = (Attachment.MonetarySystemCurrencyMinting)transaction.getAttachment();
            return TransactionType.isDuplicate(CURRENCY_MINTING, monetarySystemCurrencyMinting.getCurrencyId() + ":" + transaction.getSenderId(), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }
    };
    public static final TransactionType CURRENCY_DELETION = new MonetarySystem(){

        @Override
        public byte getSubtype() {
            return 8;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_DELETION;
        }

        @Override
        public String getName() {
            return "CurrencyDeletion";
        }

        @Override
        Attachment.MonetarySystemCurrencyDeletion parseAttachment(ByteBuffer byteBuffer) {
            return new Attachment.MonetarySystemCurrencyDeletion(byteBuffer);
        }

        @Override
        Attachment.MonetarySystemCurrencyDeletion parseAttachment(JSONObject jSONObject) {
            return new Attachment.MonetarySystemCurrencyDeletion(jSONObject);
        }

        @Override
        boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            Attachment.MonetarySystemCurrencyDeletion monetarySystemCurrencyDeletion = (Attachment.MonetarySystemCurrencyDeletion)transaction.getAttachment();
            Currency currency = Currency.getCurrency(monetarySystemCurrencyDeletion.getCurrencyId());
            String string = currency.getName().toLowerCase(Locale.ROOT);
            String string2 = currency.getCode().toLowerCase(Locale.ROOT);
            boolean bl = TransactionType.isDuplicate(CURRENCY_ISSUANCE, string, map, true);
            if (!string.equals(string2)) {
                bl = bl || TransactionType.isDuplicate(CURRENCY_ISSUANCE, string2, map, true);
            }
            return bl;
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.MonetarySystemCurrencyDeletion monetarySystemCurrencyDeletion = (Attachment.MonetarySystemCurrencyDeletion)transaction.getAttachment();
            Currency currency = Currency.getCurrency(monetarySystemCurrencyDeletion.getCurrencyId());
            CurrencyType.validate(currency, transaction);
            if (!currency.canBeDeletedBy(transaction.getSenderId())) {
                throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(currency.getId()) + " cannot be deleted by account " + Long.toUnsignedString(transaction.getSenderId()));
            }
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.MonetarySystemCurrencyDeletion monetarySystemCurrencyDeletion = (Attachment.MonetarySystemCurrencyDeletion)transaction.getAttachment();
            Currency currency = Currency.getCurrency(monetarySystemCurrencyDeletion.getCurrencyId());
            currency.delete(this.getLedgerEvent(), transaction.getId(), account);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }
    };

    static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return CURRENCY_ISSUANCE;
            }
            case 1: {
                return RESERVE_INCREASE;
            }
            case 2: {
                return RESERVE_CLAIM;
            }
            case 3: {
                return CURRENCY_TRANSFER;
            }
            case 4: {
                return PUBLISH_EXCHANGE_OFFER;
            }
            case 5: {
                return EXCHANGE_BUY;
            }
            case 6: {
                return EXCHANGE_SELL;
            }
            case 7: {
                return CURRENCY_MINTING;
            }
            case 8: {
                return CURRENCY_DELETION;
            }
        }
        return null;
    }

    private MonetarySystem() {
    }

    @Override
    public final byte getType() {
        return 5;
    }

    @Override
    boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        Attachment.MonetarySystemAttachment monetarySystemAttachment = (Attachment.MonetarySystemAttachment)((Object)transaction.getAttachment());
        Currency currency = Currency.getCurrency(monetarySystemAttachment.getCurrencyId());
        String string = currency.getName().toLowerCase(Locale.ROOT);
        String string2 = currency.getCode().toLowerCase(Locale.ROOT);
        boolean bl = TransactionType.isDuplicate(CURRENCY_ISSUANCE, string, map, false);
        if (!string.equals(string2)) {
            bl = bl || TransactionType.isDuplicate(CURRENCY_ISSUANCE, string2, map, false);
        }
        return bl;
    }

    @Override
    public final boolean isPhasingSafe() {
        return false;
    }

    static abstract class MonetarySystemExchange
    extends MonetarySystem {
        MonetarySystemExchange() {
        }

        @Override
        final void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.MonetarySystemExchange monetarySystemExchange = (Attachment.MonetarySystemExchange)transaction.getAttachment();
            if (monetarySystemExchange.getRateNQT() <= 0L || monetarySystemExchange.getUnits() == 0L) {
                throw new NxtException.NotValidException("Invalid exchange: " + monetarySystemExchange.getJSONObject());
            }
            Currency currency = Currency.getCurrency(monetarySystemExchange.getCurrencyId());
            CurrencyType.validate(currency, transaction);
            if (!currency.isActive()) {
                throw new NxtException.NotCurrentlyValidException("Currency not active: " + monetarySystemExchange.getJSONObject());
            }
        }

        @Override
        public final boolean canHaveRecipient() {
            return false;
        }
    }
}

