/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nxt.Account;
import nxt.AccountLedger;
import nxt.AccountRestrictions;
import nxt.Alias;
import nxt.Asset;
import nxt.AssetDividend;
import nxt.AssetHistory;
import nxt.AssetTransfer;
import nxt.Attachment;
import nxt.Blockchain;
import nxt.BlockchainImpl;
import nxt.BlockchainProcessor;
import nxt.BlockchainProcessorImpl;
import nxt.Constants;
import nxt.Currency;
import nxt.CurrencyBuyOffer;
import nxt.CurrencyFounder;
import nxt.CurrencyMint;
import nxt.CurrencySellOffer;
import nxt.CurrencyTransfer;
import nxt.Db;
import nxt.DebugTrace;
import nxt.DigitalGoodsStore;
import nxt.Exchange;
import nxt.ExchangeRequest;
import nxt.FundingMonitor;
import nxt.Generator;
import nxt.NxtException;
import nxt.Order;
import nxt.PhasingPoll;
import nxt.PhasingVote;
import nxt.Poll;
import nxt.PrunableMessage;
import nxt.Shuffling;
import nxt.ShufflingParticipant;
import nxt.TaggedData;
import nxt.Trade;
import nxt.Transaction;
import nxt.TransactionImpl;
import nxt.TransactionProcessor;
import nxt.TransactionProcessorImpl;
import nxt.Vote;
import nxt.addons.AddOns;
import nxt.crypto.Crypto;
import nxt.env.DirProvider;
import nxt.env.RuntimeEnvironment;
import nxt.env.RuntimeMode;
import nxt.env.ServerStatus;
import nxt.http.API;
import nxt.http.APIProxy;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.ResourceLookup;
import nxt.util.ThreadPool;
import nxt.util.Time;
import org.json.simple.JSONObject;

public final class Nxt {
    public static final String VERSION = "1.12.2";
    public static final String APPLICATION = "CoopNetwork";
    private static volatile Time time = new Time.EpochTime();
    public static final String NXT_DEFAULT_PROPERTIES = "nxt-default.properties";
    public static final String NXT_PROPERTIES = "nxt.properties";
    public static final String NXT_INSTALLER_PROPERTIES = "nxt-installer.properties";
    public static final String CONFIG_DIR = "conf";
    private static final RuntimeMode runtimeMode;
    private static final DirProvider dirProvider;
    private static final Properties defaultProperties;
    private static final Properties properties;

    private static void redirectSystemStreams(String string) {
        Object object;
        String string2 = System.getProperty("nxt.redirect.system." + string);
        Path path = null;
        if (string2 != null) {
            try {
                path = Files.createTempFile("nxt.system." + string + ".", ".log", new FileAttribute[0]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        } else {
            object = System.getProperty("nxt.system." + string);
            if (object != null) {
                path = Paths.get((String)object, new String[0]);
            }
        }
        if (path != null) {
            try {
                object = new PrintStream(Files.newOutputStream(path, new OpenOption[0]));
                if (string.equals("out")) {
                    System.setOut(new PrintStream((OutputStream)object));
                } else {
                    System.setErr(new PrintStream((OutputStream)object));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void loadProperties(Properties properties, String string, boolean bl) {
        block30: {
            try {
                String string2 = System.getProperty(string);
                if (string2 != null) {
                    System.out.printf("Loading %s from %s\n", string, string2);
                    try (FileInputStream fileInputStream = new FileInputStream(string2);){
                        properties.load(fileInputStream);
                        break block30;
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException(String.format("Error loading %s from %s", string, string2));
                    }
                }
                try (InputStream inputStream = ResourceLookup.getSystemResourceAsStream(string);){
                    Path path;
                    Path path2;
                    if (inputStream != null) {
                        System.out.printf("Loading %s from classpath\n", string);
                        properties.load(inputStream);
                        if (bl) {
                            return;
                        }
                    }
                    if (!dirProvider.isLoadPropertyFileFromUserDir()) {
                        return;
                    }
                    String string3 = dirProvider.getUserHomeDir();
                    if (!Files.isReadable(Paths.get(string3, new String[0]))) {
                        System.out.printf("Creating dir %s\n", string3);
                        try {
                            Files.createDirectory(Paths.get(string3, new String[0]), new FileAttribute[0]);
                        }
                        catch (Exception exception) {
                            if (!(exception instanceof NoSuchFileException)) {
                                throw exception;
                            }
                            Files.createDirectory(Paths.get(string3, new String[0]).getParent(), new FileAttribute[0]);
                            Files.createDirectory(Paths.get(string3, new String[0]), new FileAttribute[0]);
                        }
                    }
                    if (!Files.isReadable(path2 = Paths.get(string3, CONFIG_DIR))) {
                        System.out.printf("Creating dir %s\n", path2);
                        Files.createDirectory(path2, new FileAttribute[0]);
                    }
                    if (Files.isReadable(path = Paths.get(path2.toString(), new String[0]).resolve(Paths.get(string, new String[0])))) {
                        System.out.printf("Loading %s from dir %s\n", string, path2);
                        properties.load(Files.newInputStream(path, new OpenOption[0]));
                    } else {
                        System.out.printf("Creating property file %s\n", path);
                        Files.createFile(path, new FileAttribute[0]);
                        Files.write(path, Convert.toBytes("# use this file for workstation specific " + string), new OpenOption[0]);
                    }
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Error loading " + string, iOException);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                throw illegalArgumentException;
            }
        }
    }

    private static void printCommandLineArguments() {
        try {
            List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
            if (list == null || list.size() <= 0) {
                return;
            }
            System.out.println("Command line arguments");
            list.forEach(System.out::println);
        }
        catch (NoClassDefFoundError | AccessControlException throwable) {
            System.out.println("Cannot read input arguments " + throwable.getMessage());
        }
    }

    public static int getIntProperty(String string) {
        return Nxt.getIntProperty(string, 0);
    }

    public static int getIntProperty(String string, int n) {
        try {
            int n2 = Integer.parseInt(properties.getProperty(string));
            Logger.logMessage(string + " = \"" + n2 + "\"");
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            Logger.logMessage(string + " not defined or not numeric, using default value " + n);
            return n;
        }
    }

    public static String getStringProperty(String string) {
        return Nxt.getStringProperty(string, null, false);
    }

    public static String getStringProperty(String string, String string2) {
        return Nxt.getStringProperty(string, string2, false);
    }

    public static String getStringProperty(String string, String string2, boolean bl) {
        return Nxt.getStringProperty(string, string2, bl, null);
    }

    public static String getStringProperty(String string, String string2, boolean bl, String string3) {
        String string4 = properties.getProperty(string);
        if (string4 != null && !"".equals(string4)) {
            Logger.logMessage(string + " = \"" + (bl ? "{not logged}" : string4) + "\"");
        } else {
            Logger.logMessage(string + " not defined");
            string4 = string2;
        }
        if (string3 == null || string4 == null) {
            return string4;
        }
        try {
            return new String(string4.getBytes("ISO-8859-1"), string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static List<String> getStringListProperty(String string) {
        String string2 = Nxt.getStringProperty(string);
        if (string2 == null || string2.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : string2.split(";")) {
            if ((string3 = string3.trim()).length() <= 0) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static boolean getBooleanProperty(String string) {
        return Nxt.getBooleanProperty(string, false);
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = properties.getProperty(string);
        if (Boolean.TRUE.toString().equals(string2)) {
            Logger.logMessage(string + " = \"true\"");
            return true;
        }
        if (Boolean.FALSE.toString().equals(string2)) {
            Logger.logMessage(string + " = \"false\"");
            return false;
        }
        Logger.logMessage(string + " not defined, using default " + bl);
        return bl;
    }

    public static Blockchain getBlockchain() {
        return BlockchainImpl.getInstance();
    }

    public static BlockchainProcessor getBlockchainProcessor() {
        return BlockchainProcessorImpl.getInstance();
    }

    public static TransactionProcessor getTransactionProcessor() {
        return TransactionProcessorImpl.getInstance();
    }

    public static Transaction.Builder newTransactionBuilder(byte[] byArray, long l, long l2, short s, Attachment attachment) {
        return new TransactionImpl.BuilderImpl(1, byArray, l, l2, s, (Attachment.AbstractAttachment)attachment);
    }

    public static Transaction.Builder newTransactionBuilder(byte[] byArray) throws NxtException.NotValidException {
        return TransactionImpl.newTransactionBuilder(byArray);
    }

    public static Transaction.Builder newTransactionBuilder(JSONObject jSONObject) throws NxtException.NotValidException {
        return TransactionImpl.newTransactionBuilder(jSONObject);
    }

    public static Transaction.Builder newTransactionBuilder(byte[] byArray, JSONObject jSONObject) throws NxtException.NotValidException {
        return TransactionImpl.newTransactionBuilder(byArray, jSONObject);
    }

    public static int getEpochTime() {
        return time.getTime();
    }

    static void setTime(Time time) {
        Nxt.time = time;
    }

    public static void main(String[] stringArray) {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(Nxt::shutdown));
            Nxt.init();
        }
        catch (Throwable throwable) {
            System.out.println("Fatal error: " + throwable.toString());
            throwable.printStackTrace();
        }
    }

    public static void init(Properties properties) {
        Nxt.properties.putAll((Map<?, ?>)properties);
        Nxt.init();
    }

    public static void init() {
        Init.init();
    }

    public static void shutdown() {
        Logger.logShutdownMessage("Shutting down...");
        AddOns.shutdown();
        API.shutdown();
        FundingMonitor.shutdown();
        BlockchainProcessorImpl.getInstance().setGetMoreBlocks(false);
        ThreadPool.shutdown();
        BlockchainProcessorImpl.getInstance().shutdown();
        Peers.shutdown();
        Db.shutdown();
        Logger.logShutdownMessage("CoopNetwork server 1.12.2 stopped.");
        Logger.shutdown();
        runtimeMode.shutdown();
    }

    private static void setSystemProperties() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"socksProxyHost", "socksProxyPort"}) {
            String string2 = Nxt.getStringProperty(string);
            if (string2 == null) continue;
            System.setProperty(string, string2);
        }
    }

    private static void logSystemProperties() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"java.version", "java.vm.version", "java.vm.name", "java.vendor", "java.vm.vendor", "java.home", "java.library.path", "java.class.path", "os.arch", "sun.arch.data.model", "os.name", "file.encoding", "java.security.policy", "java.security.manager", "nxt.runtime.mode", "nxt.runtime.dirProvider"}) {
            Logger.logDebugMessage(String.format("%s = %s", string, System.getProperty(string)));
        }
        Logger.logDebugMessage(String.format("availableProcessors = %s", Runtime.getRuntime().availableProcessors()));
        Logger.logDebugMessage(String.format("maxMemory = %s", Runtime.getRuntime().maxMemory()));
        Logger.logDebugMessage(String.format("processId = %s", Nxt.getProcessId()));
    }

    private static Thread initSecureRandom() {
        Thread thread = new Thread(() -> Crypto.getSecureRandom().nextBytes(new byte[1024]));
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private static void testSecureRandom() {
        Thread thread = new Thread(() -> Crypto.getSecureRandom().nextBytes(new byte[1024]));
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join(2000L);
            if (thread.isAlive()) {
                throw new RuntimeException("SecureRandom implementation too slow!!! Install haveged if on linux, or set nxt.useStrongSecureRandom=false.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getProcessId() {
        String string;
        try {
            string = ManagementFactory.getRuntimeMXBean().getName();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return "";
        }
        if (string == null) {
            return "";
        }
        String[] stringArray = string.split("@");
        if (stringArray.length == 2) {
            return stringArray[0];
        }
        return "";
    }

    public static String getDbDir(String string) {
        return dirProvider.getDbDir(string);
    }

    public static void updateLogFileHandler(Properties properties) {
        dirProvider.updateLogFileHandler(properties);
    }

    public static String getUserHomeDir() {
        return dirProvider.getUserHomeDir();
    }

    public static File getConfDir() {
        return dirProvider.getConfDir();
    }

    private static void setServerStatus(ServerStatus serverStatus, URI uRI) {
        runtimeMode.setServerStatus(serverStatus, uRI, dirProvider.getLogFileDir());
    }

    public static boolean isDesktopApplicationEnabled() {
        return RuntimeEnvironment.isDesktopApplicationEnabled() && Nxt.getBooleanProperty("nxt.launchDesktopApplication");
    }

    private static void launchDesktopApplication() {
        runtimeMode.launchDesktopApplication();
    }

    private Nxt() {
    }

    static {
        defaultProperties = new Properties();
        Nxt.redirectSystemStreams("out");
        Nxt.redirectSystemStreams("err");
        System.out.println("Initializing CoopNetwork server version 1.12.2");
        Nxt.printCommandLineArguments();
        runtimeMode = RuntimeEnvironment.getRuntimeMode();
        System.out.printf("Runtime mode %s\n", runtimeMode.getClass().getName());
        dirProvider = RuntimeEnvironment.getDirProvider();
        System.out.println("User home folder " + dirProvider.getUserHomeDir());
        Nxt.loadProperties(defaultProperties, NXT_DEFAULT_PROPERTIES, true);
        if (!VERSION.equals(defaultProperties.getProperty("nxt.version"))) {
            throw new RuntimeException("Using an nxt-default.properties file from a version other than 1.12.2 is not supported!!!");
        }
        properties = new Properties(defaultProperties);
        Nxt.loadProperties(properties, NXT_INSTALLER_PROPERTIES, true);
        Nxt.loadProperties(properties, NXT_PROPERTIES, false);
    }

    private static class Init {
        private static volatile boolean initialized = false;

        private static void init() {
            if (initialized) {
                throw new RuntimeException("Nxt.init has already been called");
            }
            initialized = true;
        }

        private Init() {
        }

        static {
            try {
                long l = System.currentTimeMillis();
                Logger.init();
                Nxt.setSystemProperties();
                Nxt.logSystemProperties();
                runtimeMode.init();
                Thread thread = Nxt.initSecureRandom();
                Nxt.setServerStatus(ServerStatus.BEFORE_DATABASE, null);
                Db.init();
                Nxt.setServerStatus(ServerStatus.AFTER_DATABASE, null);
                TransactionProcessorImpl.getInstance();
                BlockchainProcessorImpl.getInstance();
                Account.init();
                AccountRestrictions.init();
                AccountLedger.init();
                Alias.init();
                Asset.init();
                DigitalGoodsStore.init();
                Order.init();
                Poll.init();
                PhasingPoll.init();
                Trade.init();
                AssetTransfer.init();
                AssetHistory.init();
                AssetDividend.init();
                Vote.init();
                PhasingVote.init();
                Currency.init();
                CurrencyBuyOffer.init();
                CurrencySellOffer.init();
                CurrencyFounder.init();
                CurrencyMint.init();
                CurrencyTransfer.init();
                Exchange.init();
                ExchangeRequest.init();
                Shuffling.init();
                ShufflingParticipant.init();
                PrunableMessage.init();
                TaggedData.init();
                Peers.init();
                APIProxy.init();
                Generator.init();
                AddOns.init();
                API.init();
                DebugTrace.init();
                int n = Constants.isTestnet && Constants.isOffline ? Math.max(Nxt.getIntProperty("nxt.timeMultiplier"), 1) : 1;
                ThreadPool.start(n);
                if (n > 1) {
                    Nxt.setTime(new Time.FasterTime(Math.max(Nxt.getEpochTime(), Nxt.getBlockchain().getLastBlock().getTimestamp()), n));
                    Logger.logMessage("TIME WILL FLOW " + n + " TIMES FASTER!");
                }
                try {
                    thread.join(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Nxt.testSecureRandom();
                long l2 = System.currentTimeMillis();
                Logger.logMessage("Initialization took " + (l2 - l) / 1000L + " seconds");
                Logger.logMessage("CoopNetwork server 1.12.2 started successfully.");
                Logger.logMessage("Copyright \u00a9 2013-2016 The Nxt Core Developers.");
                Logger.logMessage("Copyright \u00a9 2016-2020 Jelurida IP B.V.");
                Logger.logMessage("Distributed under the Jelurida Public License version 1.2 for the Nxt Public Blockchain Platform, with ABSOLUTELY NO WARRANTY.");
                if (API.getWelcomePageUri() != null) {
                    Logger.logMessage("Client UI is at " + API.getWelcomePageUri());
                }
                Nxt.setServerStatus(ServerStatus.STARTED, API.getWelcomePageUri());
                if (Nxt.isDesktopApplicationEnabled()) {
                    Nxt.launchDesktopApplication();
                }
                if (Constants.isTestnet) {
                    Logger.logMessage("RUNNING ON TESTNET - DO NOT USE REAL ACCOUNTS!");
                }
            }
            catch (Exception exception) {
                Logger.logErrorMessage(exception.getMessage(), exception);
                runtimeMode.alert(exception.getMessage() + "\nSee additional information in " + dirProvider.getLogFileDir() + System.getProperty("file.separator") + "nxt.log");
                System.exit(1);
            }
        }
    }
}

