/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.nio.ByteBuffer;
import java.util.Arrays;
import nxt.Asset;
import nxt.Currency;
import nxt.NxtException;
import nxt.VoteWeighting;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class PhasingParams {
    private final long quorum;
    private final long[] whitelist;
    private final VoteWeighting voteWeighting;

    PhasingParams(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        this.quorum = byteBuffer.getLong();
        long l = byteBuffer.getLong();
        int n = byteBuffer.get();
        if (n > 0) {
            this.whitelist = new long[n];
            for (int i = 0; i < n; ++i) {
                this.whitelist[i] = byteBuffer.getLong();
            }
        } else {
            this.whitelist = Convert.EMPTY_LONG;
        }
        long l2 = byteBuffer.getLong();
        byte by2 = byteBuffer.get();
        this.voteWeighting = new VoteWeighting(by, l2, l, by2);
    }

    PhasingParams(JSONObject jSONObject) {
        int n;
        this.quorum = Convert.parseLong(jSONObject.get("phasingQuorum"));
        long l = Convert.parseLong(jSONObject.get("phasingMinBalance"));
        byte by = ((Long)jSONObject.get("phasingVotingModel")).byteValue();
        long l2 = Convert.parseUnsignedLong((String)jSONObject.get("phasingHolding"));
        JSONArray jSONArray = (JSONArray)jSONObject.get("phasingWhitelist");
        if (jSONArray != null && jSONArray.size() > 0) {
            this.whitelist = new long[jSONArray.size()];
            for (n = 0; n < this.whitelist.length; ++n) {
                this.whitelist[n] = Convert.parseUnsignedLong((String)jSONArray.get(n));
            }
        } else {
            this.whitelist = Convert.EMPTY_LONG;
        }
        n = ((Long)jSONObject.get("phasingMinBalanceModel")).byteValue();
        this.voteWeighting = new VoteWeighting(by, l2, l, (byte)n);
    }

    public PhasingParams(byte by, long l, long l2, long l3, byte by2, long[] lArray) {
        this.quorum = l2;
        this.whitelist = Convert.nullToEmpty(lArray);
        if (this.whitelist.length > 0) {
            Arrays.sort(this.whitelist);
        }
        this.voteWeighting = new VoteWeighting(by, l, l3, by2);
    }

    int getMySize() {
        return 18 + 8 * this.whitelist.length + 8 + 1;
    }

    void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put(this.voteWeighting.getVotingModel().getCode());
        byteBuffer.putLong(this.quorum);
        byteBuffer.putLong(this.voteWeighting.getMinBalance());
        byteBuffer.put((byte)this.whitelist.length);
        for (long l : this.whitelist) {
            byteBuffer.putLong(l);
        }
        byteBuffer.putLong(this.voteWeighting.getHoldingId());
        byteBuffer.put(this.voteWeighting.getMinBalanceModel().getCode());
    }

    void putMyJSON(JSONObject jSONObject) {
        jSONObject.put("phasingQuorum", this.quorum);
        jSONObject.put("phasingMinBalance", this.voteWeighting.getMinBalance());
        jSONObject.put("phasingVotingModel", this.voteWeighting.getVotingModel().getCode());
        jSONObject.put("phasingHolding", Long.toUnsignedString(this.voteWeighting.getHoldingId()));
        jSONObject.put("phasingMinBalanceModel", this.voteWeighting.getMinBalanceModel().getCode());
        if (this.whitelist.length > 0) {
            JSONArray jSONArray = new JSONArray();
            for (long l : this.whitelist) {
                jSONArray.add(Long.toUnsignedString(l));
            }
            jSONObject.put("phasingWhitelist", jSONArray);
        }
    }

    void validate() throws NxtException.ValidationException {
        Object object;
        if (this.whitelist.length > 10) {
            throw new NxtException.NotValidException("Whitelist is too big");
        }
        long l = 0L;
        for (long l2 : this.whitelist) {
            if (l2 == 0L) {
                throw new NxtException.NotValidException("Invalid accountId 0 in whitelist");
            }
            if (l != 0L && l2 < l) {
                throw new NxtException.NotValidException("Whitelist not sorted " + Arrays.toString(this.whitelist));
            }
            if (l2 == l) {
                throw new NxtException.NotValidException("Duplicate accountId " + Long.toUnsignedString(l2) + " in whitelist");
            }
            l = l2;
        }
        if (this.quorum <= 0L && this.voteWeighting.getVotingModel() != VoteWeighting.VotingModel.NONE) {
            throw new NxtException.NotValidException("quorum <= 0");
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.NONE) {
            if (this.quorum != 0L) {
                throw new NxtException.NotValidException("Quorum must be 0 for no-voting phased transaction");
            }
            if (this.whitelist.length != 0) {
                throw new NxtException.NotValidException("No whitelist needed for no-voting phased transaction");
            }
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.ACCOUNT && this.whitelist.length > 0 && this.quorum > (long)this.whitelist.length) {
            throw new NxtException.NotValidException("Quorum of " + this.quorum + " cannot be achieved in by-account voting with whitelist of length " + this.whitelist.length);
        }
        this.voteWeighting.validate();
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.CURRENCY) {
            object = Currency.getCurrency(this.voteWeighting.getHoldingId());
            if (object == null) {
                throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(this.voteWeighting.getHoldingId()) + " not found");
            }
            if (this.quorum > ((Currency)object).getMaxSupply()) {
                throw new NxtException.NotCurrentlyValidException("Quorum of " + this.quorum + " exceeds max currency supply " + ((Currency)object).getMaxSupply());
            }
            if (this.voteWeighting.getMinBalance() > ((Currency)object).getMaxSupply()) {
                throw new NxtException.NotCurrentlyValidException("MinBalance of " + this.voteWeighting.getMinBalance() + " exceeds max currency supply " + ((Currency)object).getMaxSupply());
            }
        } else if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.ASSET) {
            object = Asset.getAsset(this.voteWeighting.getHoldingId());
            if (this.quorum > ((Asset)object).getInitialQuantityQNT()) {
                throw new NxtException.NotCurrentlyValidException("Quorum of " + this.quorum + " exceeds total initial asset quantity " + ((Asset)object).getInitialQuantityQNT());
            }
            if (this.voteWeighting.getMinBalance() > ((Asset)object).getInitialQuantityQNT()) {
                throw new NxtException.NotCurrentlyValidException("MinBalance of " + this.voteWeighting.getMinBalance() + " exceeds total initial asset quantity " + ((Asset)object).getInitialQuantityQNT());
            }
        } else if (this.voteWeighting.getMinBalance() > 0L) {
            if (this.voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.ASSET) {
                object = Asset.getAsset(this.voteWeighting.getHoldingId());
                if (this.voteWeighting.getMinBalance() > ((Asset)object).getInitialQuantityQNT()) {
                    throw new NxtException.NotCurrentlyValidException("MinBalance of " + this.voteWeighting.getMinBalance() + " exceeds total initial asset quantity " + ((Asset)object).getInitialQuantityQNT());
                }
            } else if (this.voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.CURRENCY) {
                object = Currency.getCurrency(this.voteWeighting.getHoldingId());
                if (object == null) {
                    throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(this.voteWeighting.getHoldingId()) + " not found");
                }
                if (this.voteWeighting.getMinBalance() > ((Currency)object).getMaxSupply()) {
                    throw new NxtException.NotCurrentlyValidException("MinBalance of " + this.voteWeighting.getMinBalance() + " exceeds max currency supply " + ((Currency)object).getMaxSupply());
                }
            }
        }
    }

    void checkApprovable() throws NxtException.NotCurrentlyValidException {
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.CURRENCY && Currency.getCurrency(this.voteWeighting.getHoldingId()) == null) {
            throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(this.voteWeighting.getHoldingId()) + " not found");
        }
        if (this.voteWeighting.getMinBalance() > 0L && this.voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.CURRENCY && Currency.getCurrency(this.voteWeighting.getHoldingId()) == null) {
            throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(this.voteWeighting.getHoldingId()) + " not found");
        }
    }

    public long getQuorum() {
        return this.quorum;
    }

    public long[] getWhitelist() {
        return this.whitelist;
    }

    public VoteWeighting getVoteWeighting() {
        return this.voteWeighting;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PhasingParams)) {
            return false;
        }
        PhasingParams phasingParams = (PhasingParams)object;
        return phasingParams.quorum == this.quorum && phasingParams.voteWeighting.equals(this.voteWeighting) && Arrays.equals(phasingParams.whitelist, this.whitelist);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + Long.hashCode(this.quorum);
        for (long l : this.whitelist) {
            n = 31 * n + Long.hashCode(l);
        }
        n = 31 * n + this.voteWeighting.hashCode();
        return n;
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        this.putMyJSON(jSONObject);
        return jSONObject.toJSONString();
    }
}

