/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import nxt.AbstractPoll;
import nxt.Attachment;
import nxt.BlockchainProcessor;
import nxt.Nxt;
import nxt.Transaction;
import nxt.Vote;
import nxt.VoteWeighting;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.EntityDbTable;
import nxt.db.ValuesDbTable;
import nxt.util.Logger;

public final class Poll
extends AbstractPoll {
    private static final boolean isPollsProcessing = Nxt.getBooleanProperty("nxt.processPolls");
    private static final DbKey.LongKeyFactory<Poll> pollDbKeyFactory = new DbKey.LongKeyFactory<Poll>("id"){

        @Override
        public DbKey newKey(Poll poll) {
            return poll.dbKey == null ? this.newKey(poll.id) : poll.dbKey;
        }
    };
    private static final EntityDbTable<Poll> pollTable = new EntityDbTable<Poll>("poll", pollDbKeyFactory, "name,description"){

        @Override
        protected Poll load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Poll(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Poll poll) throws SQLException {
            poll.save(connection);
        }
    };
    private static final DbKey.LongKeyFactory<Poll> pollResultsDbKeyFactory = new DbKey.LongKeyFactory<Poll>("poll_id"){

        @Override
        public DbKey newKey(Poll poll) {
            return poll.dbKey;
        }
    };
    private static final ValuesDbTable<Poll, OptionResult> pollResultsTable = new ValuesDbTable<Poll, OptionResult>("poll_result", pollResultsDbKeyFactory){

        @Override
        protected OptionResult load(Connection connection, ResultSet resultSet) throws SQLException {
            long l = resultSet.getLong("weight");
            return l == 0L ? null : new OptionResult(resultSet.getLong("result"), l);
        }

        @Override
        protected void save(Connection connection, Poll poll, OptionResult optionResult) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO poll_result (poll_id, result, weight, height) VALUES (?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, poll.getId());
                if (optionResult != null) {
                    preparedStatement.setLong(++n, optionResult.result);
                    preparedStatement.setLong(++n, optionResult.weight);
                } else {
                    preparedStatement.setNull(++n, -5);
                    preparedStatement.setLong(++n, 0L);
                }
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    };
    private final DbKey dbKey;
    private final String name;
    private final String description;
    private final String[] options;
    private final byte minNumberOfOptions;
    private final byte maxNumberOfOptions;
    private final byte minRangeValue;
    private final byte maxRangeValue;
    private final int timestamp;

    public static Poll getPoll(long l) {
        return pollTable.get(pollDbKeyFactory.newKey(l));
    }

    public static DbIterator<Poll> getPollsFinishingAtOrBefore(int n, int n2, int n3) {
        return pollTable.getManyBy(new DbClause.IntClause("finish_height", DbClause.Op.LTE, n), n2, n3);
    }

    public static DbIterator<Poll> getPollsFinishingBetween(int n, int n2, int n3, int n4) {
        return pollTable.getManyBy(new DbClause.IntClause("finish_height", DbClause.Op.LTE, n2).and(new DbClause.IntClause("finish_height", DbClause.Op.GT, n)), n3, n4);
    }

    public static DbIterator<Poll> getAllPolls(int n, int n2) {
        return pollTable.getAll(n, n2);
    }

    public static DbIterator<Poll> getActivePolls(int n, int n2) {
        return pollTable.getManyBy(new DbClause.IntClause("finish_height", DbClause.Op.GT, Nxt.getBlockchain().getHeight()), n, n2);
    }

    public static DbIterator<Poll> getPollsByAccount(long l, boolean bl, boolean bl2, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("account_id", l);
        if (bl2) {
            dbClause = dbClause.and(new DbClause.IntClause("finish_height", DbClause.Op.LTE, Nxt.getBlockchain().getHeight()));
        } else if (!bl) {
            dbClause = dbClause.and(new DbClause.IntClause("finish_height", DbClause.Op.GT, Nxt.getBlockchain().getHeight()));
        }
        return pollTable.getManyBy(dbClause, n, n2);
    }

    public static DbIterator<Poll> getPollsFinishingAt(int n) {
        return pollTable.getManyBy(new DbClause.IntClause("finish_height", n), 0, Integer.MAX_VALUE);
    }

    public static DbIterator<Poll> searchPolls(String string, boolean bl, int n, int n2) {
        DbClause dbClause = bl ? DbClause.EMPTY_CLAUSE : new DbClause.IntClause("finish_height", DbClause.Op.GT, Nxt.getBlockchain().getHeight());
        return pollTable.search(string, dbClause, n, n2, " ORDER BY ft.score DESC, poll.height DESC, poll.db_id DESC ");
    }

    public static int getCount() {
        return pollTable.getCount();
    }

    static void addPoll(Transaction transaction, Attachment.MessagingPollCreation messagingPollCreation) {
        Poll poll = new Poll(transaction, messagingPollCreation);
        pollTable.insert(poll);
    }

    static void init() {
    }

    private static void checkPolls(int n) {
        try (DbIterator<Poll> dbIterator = Poll.getPollsFinishingAt(n);){
            for (Poll poll : dbIterator) {
                try {
                    List<OptionResult> list = poll.countResults(poll.getVoteWeighting(), n);
                    pollResultsTable.insert(poll, list);
                    Logger.logDebugMessage("Poll " + Long.toUnsignedString(poll.getId()) + " has been finished");
                }
                catch (RuntimeException runtimeException) {
                    Logger.logErrorMessage("Couldn't count votes for poll " + Long.toUnsignedString(poll.getId()));
                }
            }
        }
    }

    private Poll(Transaction transaction, Attachment.MessagingPollCreation messagingPollCreation) {
        super(transaction.getId(), transaction.getSenderId(), messagingPollCreation.getFinishHeight(), messagingPollCreation.getVoteWeighting());
        this.dbKey = pollDbKeyFactory.newKey(this.id);
        this.name = messagingPollCreation.getPollName();
        this.description = messagingPollCreation.getPollDescription();
        this.options = messagingPollCreation.getPollOptions();
        this.minNumberOfOptions = messagingPollCreation.getMinNumberOfOptions();
        this.maxNumberOfOptions = messagingPollCreation.getMaxNumberOfOptions();
        this.minRangeValue = messagingPollCreation.getMinRangeValue();
        this.maxRangeValue = messagingPollCreation.getMaxRangeValue();
        this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
    }

    private Poll(ResultSet resultSet, DbKey dbKey) throws SQLException {
        super(resultSet);
        this.dbKey = dbKey;
        this.name = resultSet.getString("name");
        this.description = resultSet.getString("description");
        this.options = (String[])DbUtils.getArray(resultSet, "options", String[].class);
        this.minNumberOfOptions = resultSet.getByte("min_num_options");
        this.maxNumberOfOptions = resultSet.getByte("max_num_options");
        this.minRangeValue = resultSet.getByte("min_range_value");
        this.maxRangeValue = resultSet.getByte("max_range_value");
        this.timestamp = resultSet.getInt("timestamp");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO poll (id, account_id, name, description, options, finish_height, voting_model, min_balance, min_balance_model, holding_id, min_num_options, max_num_options, min_range_value, max_range_value, timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setString(++n, this.name);
            preparedStatement.setString(++n, this.description);
            DbUtils.setArray(preparedStatement, ++n, this.options);
            preparedStatement.setInt(++n, this.finishHeight);
            preparedStatement.setByte(++n, this.voteWeighting.getVotingModel().getCode());
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.voteWeighting.getMinBalance());
            preparedStatement.setByte(++n, this.voteWeighting.getMinBalanceModel().getCode());
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.voteWeighting.getHoldingId());
            preparedStatement.setByte(++n, this.minNumberOfOptions);
            preparedStatement.setByte(++n, this.maxNumberOfOptions);
            preparedStatement.setByte(++n, this.minRangeValue);
            preparedStatement.setByte(++n, this.maxRangeValue);
            preparedStatement.setInt(++n, this.timestamp);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public List<OptionResult> getResults(VoteWeighting voteWeighting) {
        if (this.voteWeighting.equals(voteWeighting)) {
            return this.getResults();
        }
        return this.countResults(voteWeighting);
    }

    public List<OptionResult> getResults() {
        if (isPollsProcessing && this.isFinished()) {
            return pollResultsTable.get(pollDbKeyFactory.newKey(this));
        }
        return this.countResults(this.voteWeighting);
    }

    public DbIterator<Vote> getVotes() {
        return Vote.getVotes(this.getId(), 0, -1);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getOptions() {
        return this.options;
    }

    public byte getMinNumberOfOptions() {
        return this.minNumberOfOptions;
    }

    public byte getMaxNumberOfOptions() {
        return this.maxNumberOfOptions;
    }

    public byte getMinRangeValue() {
        return this.minRangeValue;
    }

    public byte getMaxRangeValue() {
        return this.maxRangeValue;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public boolean isFinished() {
        return this.finishHeight <= Nxt.getBlockchain().getHeight();
    }

    private List<OptionResult> countResults(VoteWeighting voteWeighting) {
        int n = Math.min(this.finishHeight, Nxt.getBlockchain().getHeight());
        if (n < Nxt.getBlockchainProcessor().getMinRollbackHeight()) {
            return null;
        }
        return this.countResults(voteWeighting, n);
    }

    private List<OptionResult> countResults(VoteWeighting voteWeighting, int n) {
        OptionResult[] optionResultArray = new OptionResult[this.options.length];
        VoteWeighting.VotingModel votingModel = voteWeighting.getVotingModel();
        try (DbIterator<Vote> dbIterator = Vote.getVotes(this.getId(), 0, -1);){
            for (Vote vote : dbIterator) {
                long l = votingModel.calcWeight(voteWeighting, vote.getVoterId(), n);
                if (l <= 0L) continue;
                long[] lArray = this.countVote(vote, l);
                for (int i = 0; i < lArray.length; ++i) {
                    if (lArray[i] == Long.MIN_VALUE) continue;
                    if (optionResultArray[i] == null) {
                        optionResultArray[i] = new OptionResult(lArray[i], l);
                        continue;
                    }
                    optionResultArray[i].add(lArray[i], l);
                }
            }
        }
        return Arrays.asList(optionResultArray);
    }

    private long[] countVote(Vote vote, long l) {
        long[] lArray = new long[this.options.length];
        byte[] byArray = vote.getVoteBytes();
        for (int i = 0; i < byArray.length; ++i) {
            lArray[i] = byArray[i] != -128 ? (long)byArray[i] * l : Long.MIN_VALUE;
        }
        return lArray;
    }

    static {
        if (isPollsProcessing) {
            Nxt.getBlockchainProcessor().addListener(block -> {
                int n = block.getHeight();
                Poll.checkPolls(n);
            }, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
        }
    }

    public static final class OptionResult {
        private long result;
        private long weight;

        private OptionResult(long l, long l2) {
            this.result = l;
            this.weight = l2;
        }

        public long getResult() {
            return this.result;
        }

        public long getWeight() {
            return this.weight;
        }

        private void add(long l, long l2) {
            this.result += l;
            this.weight += l2;
        }
    }
}

