/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nxt.Account;
import nxt.AccountLedger;
import nxt.AccountRestrictions;
import nxt.Alias;
import nxt.Appendix;
import nxt.Asset;
import nxt.AssetDividend;
import nxt.AssetTransfer;
import nxt.Attachment;
import nxt.Constants;
import nxt.Currency;
import nxt.CurrencyType;
import nxt.DigitalGoodsStore;
import nxt.Fee;
import nxt.Genesis;
import nxt.HoldingType;
import nxt.MonetarySystem;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Order;
import nxt.PhasingPoll;
import nxt.PhasingVote;
import nxt.Poll;
import nxt.ShufflingTransaction;
import nxt.TaggedData;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.Vote;
import nxt.VoteWeighting;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class TransactionType {
    private static final byte TYPE_PAYMENT = 0;
    private static final byte TYPE_MESSAGING = 1;
    private static final byte TYPE_COLORED_COINS = 2;
    private static final byte TYPE_DIGITAL_GOODS = 3;
    private static final byte TYPE_ACCOUNT_CONTROL = 4;
    static final byte TYPE_MONETARY_SYSTEM = 5;
    private static final byte TYPE_DATA = 6;
    static final byte TYPE_SHUFFLING = 7;
    private static final byte SUBTYPE_PAYMENT_ORDINARY_PAYMENT = 0;
    private static final byte SUBTYPE_MESSAGING_ARBITRARY_MESSAGE = 0;
    private static final byte SUBTYPE_MESSAGING_ALIAS_ASSIGNMENT = 1;
    private static final byte SUBTYPE_MESSAGING_POLL_CREATION = 2;
    private static final byte SUBTYPE_MESSAGING_VOTE_CASTING = 3;
    private static final byte SUBTYPE_MESSAGING_HUB_ANNOUNCEMENT = 4;
    private static final byte SUBTYPE_MESSAGING_ACCOUNT_INFO = 5;
    private static final byte SUBTYPE_MESSAGING_ALIAS_SELL = 6;
    private static final byte SUBTYPE_MESSAGING_ALIAS_BUY = 7;
    private static final byte SUBTYPE_MESSAGING_ALIAS_DELETE = 8;
    private static final byte SUBTYPE_MESSAGING_PHASING_VOTE_CASTING = 9;
    private static final byte SUBTYPE_MESSAGING_ACCOUNT_PROPERTY = 10;
    private static final byte SUBTYPE_MESSAGING_ACCOUNT_PROPERTY_DELETE = 11;
    private static final byte SUBTYPE_COLORED_COINS_ASSET_ISSUANCE = 0;
    private static final byte SUBTYPE_COLORED_COINS_ASSET_TRANSFER = 1;
    private static final byte SUBTYPE_COLORED_COINS_ASK_ORDER_PLACEMENT = 2;
    private static final byte SUBTYPE_COLORED_COINS_BID_ORDER_PLACEMENT = 3;
    private static final byte SUBTYPE_COLORED_COINS_ASK_ORDER_CANCELLATION = 4;
    private static final byte SUBTYPE_COLORED_COINS_BID_ORDER_CANCELLATION = 5;
    private static final byte SUBTYPE_COLORED_COINS_DIVIDEND_PAYMENT = 6;
    private static final byte SUBTYPE_COLORED_COINS_ASSET_DELETE = 7;
    private static final byte SUBTYPE_COLORED_COINS_ASSET_INCREASE = 8;
    private static final byte SUBTYPE_COLORED_COINS_PROPERTY_SET = 10;
    private static final byte SUBTYPE_COLORED_COINS_PROPERTY_DELETE = 11;
    private static final byte SUBTYPE_DIGITAL_GOODS_LISTING = 0;
    private static final byte SUBTYPE_DIGITAL_GOODS_DELISTING = 1;
    private static final byte SUBTYPE_DIGITAL_GOODS_PRICE_CHANGE = 2;
    private static final byte SUBTYPE_DIGITAL_GOODS_QUANTITY_CHANGE = 3;
    private static final byte SUBTYPE_DIGITAL_GOODS_PURCHASE = 4;
    private static final byte SUBTYPE_DIGITAL_GOODS_DELIVERY = 5;
    private static final byte SUBTYPE_DIGITAL_GOODS_FEEDBACK = 6;
    private static final byte SUBTYPE_DIGITAL_GOODS_REFUND = 7;
    private static final byte SUBTYPE_ACCOUNT_CONTROL_EFFECTIVE_BALANCE_LEASING = 0;
    private static final byte SUBTYPE_ACCOUNT_CONTROL_PHASING_ONLY = 1;
    private static final byte SUBTYPE_DATA_TAGGED_DATA_UPLOAD = 0;
    private static final byte SUBTYPE_DATA_TAGGED_DATA_EXTEND = 1;

    public static TransactionType findTransactionType(byte by, byte by2) {
        switch (by) {
            case 0: {
                switch (by2) {
                    case 0: {
                        return Payment.ORDINARY;
                    }
                }
                return null;
            }
            case 1: {
                switch (by2) {
                    case 0: {
                        return Messaging.ARBITRARY_MESSAGE;
                    }
                    case 1: {
                        return Messaging.ALIAS_ASSIGNMENT;
                    }
                    case 2: {
                        return Messaging.POLL_CREATION;
                    }
                    case 3: {
                        return Messaging.VOTE_CASTING;
                    }
                    case 4: {
                        throw new IllegalArgumentException("Hub Announcement no longer supported");
                    }
                    case 5: {
                        return Messaging.ACCOUNT_INFO;
                    }
                    case 6: {
                        return Messaging.ALIAS_SELL;
                    }
                    case 7: {
                        return Messaging.ALIAS_BUY;
                    }
                    case 8: {
                        return Messaging.ALIAS_DELETE;
                    }
                    case 9: {
                        return Messaging.PHASING_VOTE_CASTING;
                    }
                    case 10: {
                        return Messaging.ACCOUNT_PROPERTY;
                    }
                    case 11: {
                        return Messaging.ACCOUNT_PROPERTY_DELETE;
                    }
                }
                return null;
            }
            case 2: {
                switch (by2) {
                    case 0: {
                        return ColoredCoins.ASSET_ISSUANCE;
                    }
                    case 1: {
                        return ColoredCoins.ASSET_TRANSFER;
                    }
                    case 2: {
                        return ColoredCoins.ASK_ORDER_PLACEMENT;
                    }
                    case 3: {
                        return ColoredCoins.BID_ORDER_PLACEMENT;
                    }
                    case 4: {
                        return ColoredCoins.ASK_ORDER_CANCELLATION;
                    }
                    case 5: {
                        return ColoredCoins.BID_ORDER_CANCELLATION;
                    }
                    case 6: {
                        return ColoredCoins.DIVIDEND_PAYMENT;
                    }
                    case 7: {
                        return ColoredCoins.ASSET_DELETE;
                    }
                    case 8: {
                        return ColoredCoins.ASSET_INCREASE;
                    }
                    case 10: {
                        return ColoredCoins.ASSET_PROPERTY_SET;
                    }
                    case 11: {
                        return ColoredCoins.ASSET_PROPERTY_DELETE;
                    }
                }
                return null;
            }
            case 3: {
                switch (by2) {
                    case 0: {
                        return DigitalGoods.LISTING;
                    }
                    case 1: {
                        return DigitalGoods.DELISTING;
                    }
                    case 2: {
                        return DigitalGoods.PRICE_CHANGE;
                    }
                    case 3: {
                        return DigitalGoods.QUANTITY_CHANGE;
                    }
                    case 4: {
                        return DigitalGoods.PURCHASE;
                    }
                    case 5: {
                        return DigitalGoods.DELIVERY;
                    }
                    case 6: {
                        return DigitalGoods.FEEDBACK;
                    }
                    case 7: {
                        return DigitalGoods.REFUND;
                    }
                }
                return null;
            }
            case 4: {
                switch (by2) {
                    case 0: {
                        return AccountControl.EFFECTIVE_BALANCE_LEASING;
                    }
                    case 1: {
                        return AccountControl.SET_PHASING_ONLY;
                    }
                }
                return null;
            }
            case 5: {
                return MonetarySystem.findTransactionType(by2);
            }
            case 6: {
                switch (by2) {
                    case 0: {
                        return Data.TAGGED_DATA_UPLOAD;
                    }
                    case 1: {
                        return Data.TAGGED_DATA_EXTEND;
                    }
                }
                return null;
            }
            case 7: {
                return ShufflingTransaction.findTransactionType(by2);
            }
        }
        return null;
    }

    TransactionType() {
    }

    public abstract byte getType();

    public abstract byte getSubtype();

    public abstract AccountLedger.LedgerEvent getLedgerEvent();

    abstract Attachment.AbstractAttachment parseAttachment(ByteBuffer var1) throws NxtException.NotValidException;

    abstract Attachment.AbstractAttachment parseAttachment(JSONObject var1) throws NxtException.NotValidException;

    abstract void validateAttachment(Transaction var1) throws NxtException.ValidationException;

    final boolean applyUnconfirmed(TransactionImpl transactionImpl, Account account) {
        long l = transactionImpl.getAmountNQT();
        long l2 = transactionImpl.getFeeNQT();
        if (transactionImpl.referencedTransactionFullHash() != null) {
            l2 = Math.addExact(l2, Constants.UNCONFIRMED_POOL_DEPOSIT_NQT);
        }
        long l3 = Math.addExact(l, l2);
        if (account.getUnconfirmedBalanceNQT() < l3) {
            return false;
        }
        account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transactionImpl.getId(), -l, -l2);
        if (!this.applyAttachmentUnconfirmed(transactionImpl, account)) {
            account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transactionImpl.getId(), l, l2);
            return false;
        }
        return true;
    }

    abstract boolean applyAttachmentUnconfirmed(Transaction var1, Account var2);

    final void apply(TransactionImpl transactionImpl, Account account, Account account2) {
        long l = transactionImpl.getAmountNQT();
        long l2 = transactionImpl.getId();
        if (!transactionImpl.attachmentIsPhased()) {
            account.addToBalanceNQT(this.getLedgerEvent(), l2, -l, -transactionImpl.getFeeNQT());
        } else {
            account.addToBalanceNQT(this.getLedgerEvent(), l2, -l);
        }
        if (account2 != null) {
            account2.addToBalanceAndUnconfirmedBalanceNQT(this.getLedgerEvent(), l2, l);
        }
        this.applyAttachment(transactionImpl, account, account2);
    }

    abstract void applyAttachment(Transaction var1, Account var2, Account var3);

    final void undoUnconfirmed(TransactionImpl transactionImpl, Account account) {
        this.undoAttachmentUnconfirmed(transactionImpl, account);
        account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transactionImpl.getId(), transactionImpl.getAmountNQT(), transactionImpl.getFeeNQT());
        if (transactionImpl.referencedTransactionFullHash() != null) {
            account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transactionImpl.getId(), 0L, Constants.UNCONFIRMED_POOL_DEPOSIT_NQT);
        }
    }

    abstract void undoAttachmentUnconfirmed(Transaction var1, Account var2);

    boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        return false;
    }

    boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        return false;
    }

    boolean isUnconfirmedDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        return false;
    }

    static boolean isDuplicate(TransactionType transactionType, String string, Map<TransactionType, Map<String, Integer>> map, boolean bl) {
        return TransactionType.isDuplicate(transactionType, string, map, bl ? 0 : Integer.MAX_VALUE);
    }

    static boolean isDuplicate(TransactionType transactionType2, String string, Map<TransactionType, Map<String, Integer>> map, int n) {
        Map map2 = map.computeIfAbsent(transactionType2, transactionType -> new HashMap());
        Integer n2 = (Integer)map2.get(string);
        if (n2 == null) {
            map2.put(string, n > 0 ? 1 : 0);
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        if (n2 < n) {
            map2.put(string, n2 + 1);
            return false;
        }
        return true;
    }

    boolean isPruned(long l) {
        return false;
    }

    public abstract boolean canHaveRecipient();

    public boolean mustHaveRecipient() {
        return this.canHaveRecipient();
    }

    public abstract boolean isPhasingSafe();

    public boolean isPhasable() {
        return true;
    }

    Fee getBaselineFee(Transaction transaction) {
        return Fee.DEFAULT_FEE;
    }

    Fee getNextFee(Transaction transaction) {
        return this.getBaselineFee(transaction);
    }

    int getBaselineFeeHeight() {
        return 1;
    }

    int getNextFeeHeight() {
        return Integer.MAX_VALUE;
    }

    long[] getBackFees(Transaction transaction) {
        return Convert.EMPTY_LONG;
    }

    public abstract String getName();

    public final String toString() {
        return this.getName() + " type: " + this.getType() + ", subtype: " + this.getSubtype();
    }

    public static abstract class Data
    extends TransactionType {
        private static final Fee TAGGED_DATA_FEE = new Fee.SizeBasedFee(100000000L, 10000000L){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                return appendix.getFullSize();
            }
        };
        public static final TransactionType TAGGED_DATA_UPLOAD = new Data(){

            @Override
            public byte getSubtype() {
                return 0;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.TAGGED_DATA_UPLOAD;
            }

            @Override
            Attachment.TaggedDataUpload parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.TaggedDataUpload(byteBuffer);
            }

            @Override
            Attachment.TaggedDataUpload parseAttachment(JSONObject jSONObject) {
                return new Attachment.TaggedDataUpload(jSONObject);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.TaggedDataUpload taggedDataUpload = (Attachment.TaggedDataUpload)transaction.getAttachment();
                if (taggedDataUpload.getData() == null && Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MIN_PRUNABLE_LIFETIME) {
                    throw new NxtException.NotCurrentlyValidException("Data has been pruned prematurely");
                }
                if (taggedDataUpload.getData() != null) {
                    if (taggedDataUpload.getName().length() == 0 || taggedDataUpload.getName().length() > 100) {
                        throw new NxtException.NotValidException("Invalid name length: " + taggedDataUpload.getName().length());
                    }
                    if (taggedDataUpload.getDescription().length() > 1000) {
                        throw new NxtException.NotValidException("Invalid description length: " + taggedDataUpload.getDescription().length());
                    }
                    if (taggedDataUpload.getTags().length() > 100) {
                        throw new NxtException.NotValidException("Invalid tags length: " + taggedDataUpload.getTags().length());
                    }
                    if (taggedDataUpload.getType().length() > 100) {
                        throw new NxtException.NotValidException("Invalid type length: " + taggedDataUpload.getType().length());
                    }
                    if (taggedDataUpload.getChannel().length() > 100) {
                        throw new NxtException.NotValidException("Invalid channel length: " + taggedDataUpload.getChannel().length());
                    }
                    if (taggedDataUpload.getFilename().length() > 100) {
                        throw new NxtException.NotValidException("Invalid filename length: " + taggedDataUpload.getFilename().length());
                    }
                    if (taggedDataUpload.getData().length == 0 || taggedDataUpload.getData().length > 43008) {
                        throw new NxtException.NotValidException("Invalid data length: " + taggedDataUpload.getData().length);
                    }
                }
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.TaggedDataUpload taggedDataUpload = (Attachment.TaggedDataUpload)transaction.getAttachment();
                TaggedData.add((TransactionImpl)transaction, taggedDataUpload);
            }

            @Override
            public String getName() {
                return "TaggedDataUpload";
            }

            @Override
            boolean isPruned(long l) {
                return TaggedData.isPruned(l);
            }
        };
        public static final TransactionType TAGGED_DATA_EXTEND = new Data(){

            @Override
            public byte getSubtype() {
                return 1;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.TAGGED_DATA_EXTEND;
            }

            @Override
            Attachment.TaggedDataExtend parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.TaggedDataExtend(byteBuffer);
            }

            @Override
            Attachment.TaggedDataExtend parseAttachment(JSONObject jSONObject) {
                return new Attachment.TaggedDataExtend(jSONObject);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Object object;
                Attachment.TaggedDataExtend taggedDataExtend = (Attachment.TaggedDataExtend)transaction.getAttachment();
                if ((taggedDataExtend.jsonIsPruned() || taggedDataExtend.getData() == null) && Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MIN_PRUNABLE_LIFETIME) {
                    throw new NxtException.NotCurrentlyValidException("Data has been pruned prematurely");
                }
                TransactionImpl transactionImpl = TransactionDb.findTransaction(taggedDataExtend.getTaggedDataId(), Nxt.getBlockchain().getHeight());
                if (transactionImpl == null) {
                    throw new NxtException.NotCurrentlyValidException("No such tagged data upload " + Long.toUnsignedString(taggedDataExtend.getTaggedDataId()));
                }
                if (transactionImpl.getType() != TAGGED_DATA_UPLOAD) {
                    throw new NxtException.NotValidException("Transaction " + Long.toUnsignedString(taggedDataExtend.getTaggedDataId()) + " is not a tagged data upload");
                }
                if (taggedDataExtend.getData() != null) {
                    object = (Attachment.TaggedDataUpload)transactionImpl.getAttachment();
                    if (!Arrays.equals(taggedDataExtend.getHash(), ((Attachment.TaggedDataUpload)object).getHash())) {
                        throw new NxtException.NotValidException("Hashes don't match! Extend hash: " + Convert.toHexString(taggedDataExtend.getHash()) + " upload hash: " + Convert.toHexString(((Attachment.TaggedDataUpload)object).getHash()));
                    }
                }
                if ((object = TaggedData.getData(taggedDataExtend.getTaggedDataId())) != null && ((TaggedData)object).getTransactionTimestamp() > Nxt.getEpochTime() + 6 * Constants.MIN_PRUNABLE_LIFETIME) {
                    throw new NxtException.NotCurrentlyValidException("Data already extended, timestamp is " + ((TaggedData)object).getTransactionTimestamp());
                }
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.TaggedDataExtend taggedDataExtend = (Attachment.TaggedDataExtend)transaction.getAttachment();
                TaggedData.extend(transaction, taggedDataExtend);
            }

            @Override
            public String getName() {
                return "TaggedDataExtend";
            }

            @Override
            boolean isPruned(long l) {
                return false;
            }
        };

        private Data() {
        }

        @Override
        public final byte getType() {
            return 6;
        }

        @Override
        final Fee getBaselineFee(Transaction transaction) {
            return TAGGED_DATA_FEE;
        }

        @Override
        final boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        final void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }

        @Override
        public final boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return false;
        }

        @Override
        public final boolean isPhasable() {
            return false;
        }
    }

    public static abstract class AccountControl
    extends TransactionType {
        public static final TransactionType EFFECTIVE_BALANCE_LEASING = new AccountControl(){

            @Override
            public final byte getSubtype() {
                return 0;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ACCOUNT_CONTROL_EFFECTIVE_BALANCE_LEASING;
            }

            @Override
            public String getName() {
                return "EffectiveBalanceLeasing";
            }

            @Override
            Attachment.AccountControlEffectiveBalanceLeasing parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.AccountControlEffectiveBalanceLeasing(byteBuffer);
            }

            @Override
            Attachment.AccountControlEffectiveBalanceLeasing parseAttachment(JSONObject jSONObject) {
                return new Attachment.AccountControlEffectiveBalanceLeasing(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.AccountControlEffectiveBalanceLeasing accountControlEffectiveBalanceLeasing = (Attachment.AccountControlEffectiveBalanceLeasing)transaction.getAttachment();
                Account.getAccount(transaction.getSenderId()).leaseEffectiveBalance(transaction.getRecipientId(), accountControlEffectiveBalanceLeasing.getPeriod());
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.AccountControlEffectiveBalanceLeasing accountControlEffectiveBalanceLeasing = (Attachment.AccountControlEffectiveBalanceLeasing)transaction.getAttachment();
                if (transaction.getSenderId() == transaction.getRecipientId()) {
                    throw new NxtException.NotValidException("Account cannot lease balance to itself");
                }
                if (transaction.getAmountNQT() != 0L) {
                    throw new NxtException.NotValidException("Transaction amount must be 0 for effective balance leasing");
                }
                if (accountControlEffectiveBalanceLeasing.getPeriod() < Constants.LEASING_DELAY || accountControlEffectiveBalanceLeasing.getPeriod() > 65535) {
                    throw new NxtException.NotValidException("Invalid effective balance leasing period: " + accountControlEffectiveBalanceLeasing.getPeriod());
                }
                byte[] byArray = Account.getPublicKey(transaction.getRecipientId());
                if (byArray == null) {
                    throw new NxtException.NotCurrentlyValidException("Invalid effective balance leasing:  recipient account " + Long.toUnsignedString(transaction.getRecipientId()) + " not found or no public key published");
                }
                if (transaction.getRecipientId() == Genesis.CREATOR_ID) {
                    throw new NxtException.NotValidException("Leasing to Genesis account not allowed");
                }
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };
        public static final TransactionType SET_PHASING_ONLY = new AccountControl(){

            @Override
            public byte getSubtype() {
                return 1;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ACCOUNT_CONTROL_PHASING_ONLY;
            }

            @Override
            Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.SetPhasingOnly(byteBuffer);
            }

            @Override
            Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
                return new Attachment.SetPhasingOnly(jSONObject);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.SetPhasingOnly setPhasingOnly = (Attachment.SetPhasingOnly)transaction.getAttachment();
                VoteWeighting.VotingModel votingModel = setPhasingOnly.getPhasingParams().getVoteWeighting().getVotingModel();
                setPhasingOnly.getPhasingParams().validate();
                if (votingModel == VoteWeighting.VotingModel.NONE) {
                    Account account = Account.getAccount(transaction.getSenderId());
                    if (account == null || !account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
                        throw new NxtException.NotCurrentlyValidException("Phasing only account control is not currently enabled");
                    }
                } else if (votingModel == VoteWeighting.VotingModel.TRANSACTION || votingModel == VoteWeighting.VotingModel.HASH) {
                    throw new NxtException.NotValidException("Invalid voting model " + votingModel + " for account control");
                }
                long l = setPhasingOnly.getMaxFees();
                long l2 = (long)(setPhasingOnly.getPhasingParams().getVoteWeighting().isBalanceIndependent() ? 3 : 22) * 100000000L;
                if (l < 0L || l > 0L && l < l2 || l > 100000000000000000L) {
                    throw new NxtException.NotValidException(String.format("Invalid max fees %f %s", (double)l / 1.0E8, "GMD"));
                }
                short s = setPhasingOnly.getMinDuration();
                if (s < 0 || s > 0 && s < 3 || s >= 20160) {
                    throw new NxtException.NotValidException("Invalid min duration " + setPhasingOnly.getMinDuration());
                }
                short s2 = setPhasingOnly.getMaxDuration();
                if (s2 < 0 || s2 > 0 && s2 < 3 || s2 >= 20160) {
                    throw new NxtException.NotValidException("Invalid max duration " + s2);
                }
                if (s > s2) {
                    throw new NxtException.NotValidException(String.format("Min duration %d cannot exceed max duration %d ", s, s2));
                }
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                return TransactionType.isDuplicate(SET_PHASING_ONLY, Long.toUnsignedString(transaction.getSenderId()), map, true);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.SetPhasingOnly setPhasingOnly = (Attachment.SetPhasingOnly)transaction.getAttachment();
                AccountRestrictions.PhasingOnly.set(account, setPhasingOnly);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public String getName() {
                return "SetPhasingOnly";
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };

        private AccountControl() {
        }

        @Override
        public final byte getType() {
            return 4;
        }

        @Override
        final boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        final void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }
    }

    public static abstract class DigitalGoods
    extends TransactionType {
        public static final TransactionType LISTING = new DigitalGoods(){
            private final Fee DGS_LISTING_FEE = new Fee.SizeBasedFee(200000000L, 200000000L, 32){

                @Override
                public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                    Attachment.DigitalGoodsListing digitalGoodsListing = (Attachment.DigitalGoodsListing)transactionImpl.getAttachment();
                    return digitalGoodsListing.getName().length() + digitalGoodsListing.getDescription().length();
                }
            };

            @Override
            public final byte getSubtype() {
                return 0;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.DIGITAL_GOODS_LISTING;
            }

            @Override
            public String getName() {
                return "DigitalGoodsListing";
            }

            @Override
            Fee getBaselineFee(Transaction transaction) {
                return this.DGS_LISTING_FEE;
            }

            @Override
            Attachment.DigitalGoodsListing parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.DigitalGoodsListing(byteBuffer);
            }

            @Override
            Attachment.DigitalGoodsListing parseAttachment(JSONObject jSONObject) {
                return new Attachment.DigitalGoodsListing(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.DigitalGoodsListing digitalGoodsListing = (Attachment.DigitalGoodsListing)transaction.getAttachment();
                DigitalGoodsStore.listGoods(transaction, digitalGoodsListing);
            }

            @Override
            void doValidateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.DigitalGoodsListing digitalGoodsListing = (Attachment.DigitalGoodsListing)transaction.getAttachment();
                if (digitalGoodsListing.getName().length() == 0 || digitalGoodsListing.getName().length() > 100 || digitalGoodsListing.getDescription().length() > 1000 || digitalGoodsListing.getTags().length() > 100 || digitalGoodsListing.getQuantity() < 0 || digitalGoodsListing.getQuantity() > 1000000000 || digitalGoodsListing.getPriceNQT() <= 0L || digitalGoodsListing.getPriceNQT() > 100000000000000000L) {
                    throw new NxtException.NotValidException("Invalid digital goods listing: " + digitalGoodsListing.getJSONObject());
                }
            }

            @Override
            boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                return 1.isDuplicate(LISTING, this.getName(), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };
        public static final TransactionType DELISTING = new DigitalGoods(){

            @Override
            public final byte getSubtype() {
                return 1;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.DIGITAL_GOODS_DELISTING;
            }

            @Override
            public String getName() {
                return "DigitalGoodsDelisting";
            }

            @Override
            Attachment.DigitalGoodsDelisting parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.DigitalGoodsDelisting(byteBuffer);
            }

            @Override
            Attachment.DigitalGoodsDelisting parseAttachment(JSONObject jSONObject) {
                return new Attachment.DigitalGoodsDelisting(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.DigitalGoodsDelisting digitalGoodsDelisting = (Attachment.DigitalGoodsDelisting)transaction.getAttachment();
                DigitalGoodsStore.delistGoods(digitalGoodsDelisting.getGoodsId());
            }

            @Override
            void doValidateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.DigitalGoodsDelisting digitalGoodsDelisting = (Attachment.DigitalGoodsDelisting)transaction.getAttachment();
                DigitalGoodsStore.Goods goods = DigitalGoodsStore.Goods.getGoods(digitalGoodsDelisting.getGoodsId());
                if (goods != null && transaction.getSenderId() != goods.getSellerId()) {
                    throw new NxtException.NotValidException("Invalid digital goods delisting - seller is different: " + digitalGoodsDelisting.getJSONObject());
                }
                if (goods == null || goods.isDelisted()) {
                    throw new NxtException.NotCurrentlyValidException("Goods " + Long.toUnsignedString(digitalGoodsDelisting.getGoodsId()) + "not yet listed or already delisted");
                }
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.DigitalGoodsDelisting digitalGoodsDelisting = (Attachment.DigitalGoodsDelisting)transaction.getAttachment();
                return 2.isDuplicate(DELISTING, Long.toUnsignedString(digitalGoodsDelisting.getGoodsId()), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };
        public static final TransactionType PRICE_CHANGE = new DigitalGoods(){

            @Override
            public final byte getSubtype() {
                return 2;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.DIGITAL_GOODS_PRICE_CHANGE;
            }

            @Override
            public String getName() {
                return "DigitalGoodsPriceChange";
            }

            @Override
            Attachment.DigitalGoodsPriceChange parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.DigitalGoodsPriceChange(byteBuffer);
            }

            @Override
            Attachment.DigitalGoodsPriceChange parseAttachment(JSONObject jSONObject) {
                return new Attachment.DigitalGoodsPriceChange(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.DigitalGoodsPriceChange digitalGoodsPriceChange = (Attachment.DigitalGoodsPriceChange)transaction.getAttachment();
                DigitalGoodsStore.changePrice(digitalGoodsPriceChange.getGoodsId(), digitalGoodsPriceChange.getPriceNQT());
            }

            @Override
            void doValidateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.DigitalGoodsPriceChange digitalGoodsPriceChange = (Attachment.DigitalGoodsPriceChange)transaction.getAttachment();
                DigitalGoodsStore.Goods goods = DigitalGoodsStore.Goods.getGoods(digitalGoodsPriceChange.getGoodsId());
                if (digitalGoodsPriceChange.getPriceNQT() <= 0L || digitalGoodsPriceChange.getPriceNQT() > 100000000000000000L || goods != null && transaction.getSenderId() != goods.getSellerId()) {
                    throw new NxtException.NotValidException("Invalid digital goods price change: " + digitalGoodsPriceChange.getJSONObject());
                }
                if (goods == null || goods.isDelisted()) {
                    throw new NxtException.NotCurrentlyValidException("Goods " + Long.toUnsignedString(digitalGoodsPriceChange.getGoodsId()) + "not yet listed or already delisted");
                }
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.DigitalGoodsPriceChange digitalGoodsPriceChange = (Attachment.DigitalGoodsPriceChange)transaction.getAttachment();
                return 3.isDuplicate(DELISTING, Long.toUnsignedString(digitalGoodsPriceChange.getGoodsId()), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType QUANTITY_CHANGE = new DigitalGoods(){

            @Override
            public final byte getSubtype() {
                return 3;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.DIGITAL_GOODS_QUANTITY_CHANGE;
            }

            @Override
            public String getName() {
                return "DigitalGoodsQuantityChange";
            }

            @Override
            Attachment.DigitalGoodsQuantityChange parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.DigitalGoodsQuantityChange(byteBuffer);
            }

            @Override
            Attachment.DigitalGoodsQuantityChange parseAttachment(JSONObject jSONObject) {
                return new Attachment.DigitalGoodsQuantityChange(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.DigitalGoodsQuantityChange digitalGoodsQuantityChange = (Attachment.DigitalGoodsQuantityChange)transaction.getAttachment();
                DigitalGoodsStore.changeQuantity(digitalGoodsQuantityChange.getGoodsId(), digitalGoodsQuantityChange.getDeltaQuantity());
            }

            @Override
            void doValidateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.DigitalGoodsQuantityChange digitalGoodsQuantityChange = (Attachment.DigitalGoodsQuantityChange)transaction.getAttachment();
                DigitalGoodsStore.Goods goods = DigitalGoodsStore.Goods.getGoods(digitalGoodsQuantityChange.getGoodsId());
                if (digitalGoodsQuantityChange.getDeltaQuantity() < -1000000000 || digitalGoodsQuantityChange.getDeltaQuantity() > 1000000000 || goods != null && transaction.getSenderId() != goods.getSellerId()) {
                    throw new NxtException.NotValidException("Invalid digital goods quantity change: " + digitalGoodsQuantityChange.getJSONObject());
                }
                if (goods == null || goods.isDelisted()) {
                    throw new NxtException.NotCurrentlyValidException("Goods " + Long.toUnsignedString(digitalGoodsQuantityChange.getGoodsId()) + "not yet listed or already delisted");
                }
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.DigitalGoodsQuantityChange digitalGoodsQuantityChange = (Attachment.DigitalGoodsQuantityChange)transaction.getAttachment();
                return 4.isDuplicate(DELISTING, Long.toUnsignedString(digitalGoodsQuantityChange.getGoodsId()), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType PURCHASE = new DigitalGoods(){

            @Override
            public final byte getSubtype() {
                return 4;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.DIGITAL_GOODS_PURCHASE;
            }

            @Override
            public String getName() {
                return "DigitalGoodsPurchase";
            }

            @Override
            Attachment.DigitalGoodsPurchase parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.DigitalGoodsPurchase(byteBuffer);
            }

            @Override
            Attachment.DigitalGoodsPurchase parseAttachment(JSONObject jSONObject) {
                return new Attachment.DigitalGoodsPurchase(jSONObject);
            }

            @Override
            boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.DigitalGoodsPurchase digitalGoodsPurchase = (Attachment.DigitalGoodsPurchase)transaction.getAttachment();
                if (account.getUnconfirmedBalanceNQT() >= Math.multiplyExact((long)digitalGoodsPurchase.getQuantity(), digitalGoodsPurchase.getPriceNQT())) {
                    account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), -Math.multiplyExact((long)digitalGoodsPurchase.getQuantity(), digitalGoodsPurchase.getPriceNQT()));
                    return true;
                }
                return false;
            }

            @Override
            void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.DigitalGoodsPurchase digitalGoodsPurchase = (Attachment.DigitalGoodsPurchase)transaction.getAttachment();
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), Math.multiplyExact((long)digitalGoodsPurchase.getQuantity(), digitalGoodsPurchase.getPriceNQT()));
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.DigitalGoodsPurchase digitalGoodsPurchase = (Attachment.DigitalGoodsPurchase)transaction.getAttachment();
                DigitalGoodsStore.purchase(transaction, digitalGoodsPurchase);
            }

            @Override
            void doValidateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.DigitalGoodsPurchase digitalGoodsPurchase = (Attachment.DigitalGoodsPurchase)transaction.getAttachment();
                DigitalGoodsStore.Goods goods = DigitalGoodsStore.Goods.getGoods(digitalGoodsPurchase.getGoodsId());
                if (digitalGoodsPurchase.getQuantity() <= 0 || digitalGoodsPurchase.getQuantity() > 1000000000 || digitalGoodsPurchase.getPriceNQT() <= 0L || digitalGoodsPurchase.getPriceNQT() > 100000000000000000L || goods != null && goods.getSellerId() != transaction.getRecipientId()) {
                    throw new NxtException.NotValidException("Invalid digital goods purchase: " + digitalGoodsPurchase.getJSONObject());
                }
                if (transaction.getEncryptedMessage() != null && !transaction.getEncryptedMessage().isText()) {
                    throw new NxtException.NotValidException("Only text encrypted messages allowed");
                }
                if (goods == null || goods.isDelisted()) {
                    throw new NxtException.NotCurrentlyValidException("Goods " + Long.toUnsignedString(digitalGoodsPurchase.getGoodsId()) + "not yet listed or already delisted");
                }
                if (digitalGoodsPurchase.getQuantity() > goods.getQuantity() || digitalGoodsPurchase.getPriceNQT() != goods.getPriceNQT()) {
                    throw new NxtException.NotCurrentlyValidException("Goods price or quantity changed: " + digitalGoodsPurchase.getJSONObject());
                }
                if (digitalGoodsPurchase.getDeliveryDeadlineTimestamp() <= Nxt.getBlockchain().getLastBlockTimestamp()) {
                    throw new NxtException.NotCurrentlyValidException("Delivery deadline has already expired: " + digitalGoodsPurchase.getDeliveryDeadlineTimestamp());
                }
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.DigitalGoodsPurchase digitalGoodsPurchase = (Attachment.DigitalGoodsPurchase)transaction.getAttachment();
                return 5.isDuplicate(DELISTING, Long.toUnsignedString(digitalGoodsPurchase.getGoodsId()), map, false);
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType DELIVERY = new DigitalGoods(){
            private final Fee DGS_DELIVERY_FEE = new Fee.SizeBasedFee(100000000L, 200000000L, 32){

                @Override
                public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                    Attachment.DigitalGoodsDelivery digitalGoodsDelivery = (Attachment.DigitalGoodsDelivery)transactionImpl.getAttachment();
                    return digitalGoodsDelivery.getGoodsDataLength() - 16;
                }
            };

            @Override
            public final byte getSubtype() {
                return 5;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.DIGITAL_GOODS_DELIVERY;
            }

            @Override
            public String getName() {
                return "DigitalGoodsDelivery";
            }

            @Override
            Fee getBaselineFee(Transaction transaction) {
                return this.DGS_DELIVERY_FEE;
            }

            @Override
            Attachment.DigitalGoodsDelivery parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.DigitalGoodsDelivery(byteBuffer);
            }

            @Override
            Attachment.DigitalGoodsDelivery parseAttachment(JSONObject jSONObject) {
                if (jSONObject.get("goodsData") == null) {
                    return new Attachment.UnencryptedDigitalGoodsDelivery(jSONObject);
                }
                return new Attachment.DigitalGoodsDelivery(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.DigitalGoodsDelivery digitalGoodsDelivery = (Attachment.DigitalGoodsDelivery)transaction.getAttachment();
                DigitalGoodsStore.deliver(transaction, digitalGoodsDelivery);
            }

            @Override
            void doValidateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.DigitalGoodsDelivery digitalGoodsDelivery = (Attachment.DigitalGoodsDelivery)transaction.getAttachment();
                DigitalGoodsStore.Purchase purchase = DigitalGoodsStore.Purchase.getPendingPurchase(digitalGoodsDelivery.getPurchaseId());
                if (digitalGoodsDelivery.getGoodsDataLength() > 1000) {
                    throw new NxtException.NotValidException("Invalid digital goods delivery data length: " + digitalGoodsDelivery.getGoodsDataLength());
                }
                if (digitalGoodsDelivery.getGoods() != null && (digitalGoodsDelivery.getGoods().getData().length == 0 || digitalGoodsDelivery.getGoods().getNonce().length != 32)) {
                    throw new NxtException.NotValidException("Invalid digital goods delivery: " + digitalGoodsDelivery.getJSONObject());
                }
                if (digitalGoodsDelivery.getDiscountNQT() < 0L || digitalGoodsDelivery.getDiscountNQT() > 100000000000000000L || purchase != null && (purchase.getBuyerId() != transaction.getRecipientId() || transaction.getSenderId() != purchase.getSellerId() || digitalGoodsDelivery.getDiscountNQT() > Math.multiplyExact(purchase.getPriceNQT(), (long)purchase.getQuantity()))) {
                    throw new NxtException.NotValidException("Invalid digital goods delivery: " + digitalGoodsDelivery.getJSONObject());
                }
                if (purchase == null || purchase.getEncryptedGoods() != null) {
                    throw new NxtException.NotCurrentlyValidException("Purchase does not exist yet, or already delivered: " + digitalGoodsDelivery.getJSONObject());
                }
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.DigitalGoodsDelivery digitalGoodsDelivery = (Attachment.DigitalGoodsDelivery)transaction.getAttachment();
                return 6.isDuplicate(DELIVERY, Long.toUnsignedString(digitalGoodsDelivery.getPurchaseId()), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType FEEDBACK = new DigitalGoods(){

            @Override
            public final byte getSubtype() {
                return 6;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.DIGITAL_GOODS_FEEDBACK;
            }

            @Override
            public String getName() {
                return "DigitalGoodsFeedback";
            }

            @Override
            Attachment.DigitalGoodsFeedback parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.DigitalGoodsFeedback(byteBuffer);
            }

            @Override
            Attachment.DigitalGoodsFeedback parseAttachment(JSONObject jSONObject) {
                return new Attachment.DigitalGoodsFeedback(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.DigitalGoodsFeedback digitalGoodsFeedback = (Attachment.DigitalGoodsFeedback)transaction.getAttachment();
                DigitalGoodsStore.feedback(digitalGoodsFeedback.getPurchaseId(), transaction.getEncryptedMessage(), transaction.getMessage());
            }

            @Override
            void doValidateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.DigitalGoodsFeedback digitalGoodsFeedback = (Attachment.DigitalGoodsFeedback)transaction.getAttachment();
                DigitalGoodsStore.Purchase purchase = DigitalGoodsStore.Purchase.getPurchase(digitalGoodsFeedback.getPurchaseId());
                if (purchase != null && (purchase.getSellerId() != transaction.getRecipientId() || transaction.getSenderId() != purchase.getBuyerId())) {
                    throw new NxtException.NotValidException("Invalid digital goods feedback: " + digitalGoodsFeedback.getJSONObject());
                }
                if (transaction.getEncryptedMessage() == null && transaction.getMessage() == null) {
                    throw new NxtException.NotValidException("Missing feedback message");
                }
                if (transaction.getEncryptedMessage() != null && !transaction.getEncryptedMessage().isText()) {
                    throw new NxtException.NotValidException("Only text encrypted messages allowed");
                }
                if (transaction.getMessage() != null && !transaction.getMessage().isText()) {
                    throw new NxtException.NotValidException("Only text public messages allowed");
                }
                if (purchase == null || purchase.getEncryptedGoods() == null) {
                    throw new NxtException.NotCurrentlyValidException("Purchase does not exist yet or not yet delivered");
                }
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType REFUND = new DigitalGoods(){

            @Override
            public final byte getSubtype() {
                return 7;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.DIGITAL_GOODS_REFUND;
            }

            @Override
            public String getName() {
                return "DigitalGoodsRefund";
            }

            @Override
            Attachment.DigitalGoodsRefund parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.DigitalGoodsRefund(byteBuffer);
            }

            @Override
            Attachment.DigitalGoodsRefund parseAttachment(JSONObject jSONObject) {
                return new Attachment.DigitalGoodsRefund(jSONObject);
            }

            @Override
            boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.DigitalGoodsRefund digitalGoodsRefund = (Attachment.DigitalGoodsRefund)transaction.getAttachment();
                if (account.getUnconfirmedBalanceNQT() >= digitalGoodsRefund.getRefundNQT()) {
                    account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), -digitalGoodsRefund.getRefundNQT());
                    return true;
                }
                return false;
            }

            @Override
            void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.DigitalGoodsRefund digitalGoodsRefund = (Attachment.DigitalGoodsRefund)transaction.getAttachment();
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), digitalGoodsRefund.getRefundNQT());
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.DigitalGoodsRefund digitalGoodsRefund = (Attachment.DigitalGoodsRefund)transaction.getAttachment();
                DigitalGoodsStore.refund(this.getLedgerEvent(), transaction.getId(), transaction.getSenderId(), digitalGoodsRefund.getPurchaseId(), digitalGoodsRefund.getRefundNQT(), transaction.getEncryptedMessage());
            }

            @Override
            void doValidateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.DigitalGoodsRefund digitalGoodsRefund = (Attachment.DigitalGoodsRefund)transaction.getAttachment();
                DigitalGoodsStore.Purchase purchase = DigitalGoodsStore.Purchase.getPurchase(digitalGoodsRefund.getPurchaseId());
                if (digitalGoodsRefund.getRefundNQT() < 0L || digitalGoodsRefund.getRefundNQT() > 100000000000000000L || purchase != null && (purchase.getBuyerId() != transaction.getRecipientId() || transaction.getSenderId() != purchase.getSellerId())) {
                    throw new NxtException.NotValidException("Invalid digital goods refund: " + digitalGoodsRefund.getJSONObject());
                }
                if (transaction.getEncryptedMessage() != null && !transaction.getEncryptedMessage().isText()) {
                    throw new NxtException.NotValidException("Only text encrypted messages allowed");
                }
                if (purchase == null || purchase.getEncryptedGoods() == null || purchase.getRefundNQT() != 0L) {
                    throw new NxtException.NotCurrentlyValidException("Purchase does not exist or is not delivered or is already refunded");
                }
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.DigitalGoodsRefund digitalGoodsRefund = (Attachment.DigitalGoodsRefund)transaction.getAttachment();
                return 8.isDuplicate(REFUND, Long.toUnsignedString(digitalGoodsRefund.getPurchaseId()), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };

        private DigitalGoods() {
        }

        @Override
        public final byte getType() {
            return 3;
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }

        @Override
        final void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            if (transaction.getAmountNQT() != 0L) {
                throw new NxtException.NotValidException("Invalid digital goods transaction");
            }
            this.doValidateAttachment(transaction);
        }

        abstract void doValidateAttachment(Transaction var1) throws NxtException.ValidationException;
    }

    public static abstract class ColoredCoins
    extends TransactionType {
        public static final TransactionType ASSET_ISSUANCE = new ColoredCoins(){
            private final Fee SINGLETON_ASSET_FEE = new Fee.SizeBasedFee(100000000L, 100000000L, 32){

                @Override
                public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                    Attachment.ColoredCoinsAssetIssuance coloredCoinsAssetIssuance = (Attachment.ColoredCoinsAssetIssuance)transactionImpl.getAttachment();
                    return coloredCoinsAssetIssuance.getDescription().length();
                }
            };
            private final Fee ASSET_ISSUANCE_FEE = (transactionImpl, appendix) -> this.isSingletonIssuance(transactionImpl) ? this.SINGLETON_ASSET_FEE.getFee(transactionImpl, appendix) : 100000000000L;

            @Override
            public final byte getSubtype() {
                return 0;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_ISSUANCE;
            }

            @Override
            public String getName() {
                return "AssetIssuance";
            }

            @Override
            Fee getBaselineFee(Transaction transaction) {
                return this.ASSET_ISSUANCE_FEE;
            }

            @Override
            long[] getBackFees(Transaction transaction) {
                if (this.isSingletonIssuance(transaction)) {
                    return Convert.EMPTY_LONG;
                }
                long l = transaction.getFeeNQT();
                return new long[]{l * 3L / 10L, l * 2L / 10L, l / 10L};
            }

            @Override
            Attachment.ColoredCoinsAssetIssuance parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.ColoredCoinsAssetIssuance(byteBuffer);
            }

            @Override
            Attachment.ColoredCoinsAssetIssuance parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsAssetIssuance(jSONObject);
            }

            @Override
            boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                return true;
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.ColoredCoinsAssetIssuance coloredCoinsAssetIssuance = (Attachment.ColoredCoinsAssetIssuance)transaction.getAttachment();
                long l = transaction.getId();
                Asset.addAsset(transaction, coloredCoinsAssetIssuance);
                account.addToAssetAndUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), l, l, coloredCoinsAssetIssuance.getQuantityQNT());
            }

            @Override
            void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.ColoredCoinsAssetIssuance coloredCoinsAssetIssuance = (Attachment.ColoredCoinsAssetIssuance)transaction.getAttachment();
                if (coloredCoinsAssetIssuance.getName().length() < 3 || !Attachment.ColoredCoinsAssetIssuance.NAME_RW.validate(coloredCoinsAssetIssuance.getName()) || !Attachment.ColoredCoinsAssetIssuance.DESCRIPTION_RW.validate(coloredCoinsAssetIssuance.getName()) || coloredCoinsAssetIssuance.getDecimals() < 0 || coloredCoinsAssetIssuance.getDecimals() > 8 || coloredCoinsAssetIssuance.getQuantityQNT() <= 0L || coloredCoinsAssetIssuance.getQuantityQNT() > 100000000000000000L) {
                    throw new NxtException.NotValidException("Invalid asset issuance: " + coloredCoinsAssetIssuance.getJSONObject());
                }
                String string = coloredCoinsAssetIssuance.getName().toLowerCase(Locale.ROOT);
                for (int i = 0; i < string.length(); ++i) {
                    if ("0123456789abcdefghijklmnopqrstuvwxyz".indexOf(string.charAt(i)) >= 0) continue;
                    throw new NxtException.NotValidException("Invalid asset name: " + string);
                }
            }

            @Override
            boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                return !this.isSingletonIssuance(transaction) && 1.isDuplicate(ASSET_ISSUANCE, this.getName(), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }

            private boolean isSingletonIssuance(Transaction transaction) {
                Attachment.ColoredCoinsAssetIssuance coloredCoinsAssetIssuance = (Attachment.ColoredCoinsAssetIssuance)transaction.getAttachment();
                return coloredCoinsAssetIssuance.getQuantityQNT() == 1L && coloredCoinsAssetIssuance.getDecimals() == 0 && coloredCoinsAssetIssuance.getDescription().length() <= 160;
            }
        };
        public static final TransactionType ASSET_TRANSFER = new ColoredCoins(){

            @Override
            public final byte getSubtype() {
                return 1;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_TRANSFER;
            }

            @Override
            public String getName() {
                return "AssetTransfer";
            }

            @Override
            Attachment.ColoredCoinsAssetTransfer parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.ColoredCoinsAssetTransfer(byteBuffer);
            }

            @Override
            Attachment.ColoredCoinsAssetTransfer parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsAssetTransfer(jSONObject);
            }

            @Override
            boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.ColoredCoinsAssetTransfer coloredCoinsAssetTransfer = (Attachment.ColoredCoinsAssetTransfer)transaction.getAttachment();
                long l = account.getUnconfirmedAssetBalanceQNT(coloredCoinsAssetTransfer.getAssetId());
                if (l >= 0L && l >= coloredCoinsAssetTransfer.getQuantityQNT()) {
                    account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), coloredCoinsAssetTransfer.getAssetId(), -coloredCoinsAssetTransfer.getQuantityQNT());
                    return true;
                }
                return false;
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.ColoredCoinsAssetTransfer coloredCoinsAssetTransfer = (Attachment.ColoredCoinsAssetTransfer)transaction.getAttachment();
                account.addToAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), coloredCoinsAssetTransfer.getAssetId(), -coloredCoinsAssetTransfer.getQuantityQNT());
                if (account2.getId() == Genesis.CREATOR_ID) {
                    Asset.deleteAsset(transaction, coloredCoinsAssetTransfer.getAssetId(), coloredCoinsAssetTransfer.getQuantityQNT());
                } else {
                    account2.addToAssetAndUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), coloredCoinsAssetTransfer.getAssetId(), coloredCoinsAssetTransfer.getQuantityQNT());
                    AssetTransfer.addAssetTransfer(transaction, coloredCoinsAssetTransfer);
                }
            }

            @Override
            void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.ColoredCoinsAssetTransfer coloredCoinsAssetTransfer = (Attachment.ColoredCoinsAssetTransfer)transaction.getAttachment();
                account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), coloredCoinsAssetTransfer.getAssetId(), coloredCoinsAssetTransfer.getQuantityQNT());
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.ColoredCoinsAssetTransfer coloredCoinsAssetTransfer = (Attachment.ColoredCoinsAssetTransfer)transaction.getAttachment();
                if (transaction.getAmountNQT() != 0L || coloredCoinsAssetTransfer.getAssetId() == 0L) {
                    throw new NxtException.NotValidException("Invalid asset transfer amount or asset: " + coloredCoinsAssetTransfer.getJSONObject());
                }
                if (transaction.getRecipientId() == Genesis.CREATOR_ID) {
                    throw new NxtException.NotValidException("Asset transfer to Genesis not allowed, use asset delete attachment instead");
                }
                Asset asset = Asset.getAsset(coloredCoinsAssetTransfer.getAssetId());
                if (coloredCoinsAssetTransfer.getQuantityQNT() <= 0L || asset != null && coloredCoinsAssetTransfer.getQuantityQNT() > asset.getInitialQuantityQNT()) {
                    throw new NxtException.NotValidException("Invalid asset transfer asset or quantity: " + coloredCoinsAssetTransfer.getJSONObject());
                }
                if (asset == null) {
                    throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(coloredCoinsAssetTransfer.getAssetId()) + " does not exist yet");
                }
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };
        public static final TransactionType ASSET_DELETE = new ColoredCoins(){

            @Override
            public final byte getSubtype() {
                return 7;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_DELETE;
            }

            @Override
            public String getName() {
                return "AssetDelete";
            }

            @Override
            Attachment.ColoredCoinsAssetDelete parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.ColoredCoinsAssetDelete(byteBuffer);
            }

            @Override
            Attachment.ColoredCoinsAssetDelete parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsAssetDelete(jSONObject);
            }

            @Override
            boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.ColoredCoinsAssetDelete coloredCoinsAssetDelete = (Attachment.ColoredCoinsAssetDelete)transaction.getAttachment();
                long l = account.getUnconfirmedAssetBalanceQNT(coloredCoinsAssetDelete.getAssetId());
                if (l >= 0L && l >= coloredCoinsAssetDelete.getQuantityQNT()) {
                    account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), coloredCoinsAssetDelete.getAssetId(), -coloredCoinsAssetDelete.getQuantityQNT());
                    return true;
                }
                return false;
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.ColoredCoinsAssetDelete coloredCoinsAssetDelete = (Attachment.ColoredCoinsAssetDelete)transaction.getAttachment();
                account.addToAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), coloredCoinsAssetDelete.getAssetId(), -coloredCoinsAssetDelete.getQuantityQNT());
                Asset.deleteAsset(transaction, coloredCoinsAssetDelete.getAssetId(), coloredCoinsAssetDelete.getQuantityQNT());
            }

            @Override
            void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.ColoredCoinsAssetDelete coloredCoinsAssetDelete = (Attachment.ColoredCoinsAssetDelete)transaction.getAttachment();
                account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), coloredCoinsAssetDelete.getAssetId(), coloredCoinsAssetDelete.getQuantityQNT());
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.ColoredCoinsAssetDelete coloredCoinsAssetDelete = (Attachment.ColoredCoinsAssetDelete)transaction.getAttachment();
                if (coloredCoinsAssetDelete.getAssetId() == 0L) {
                    throw new NxtException.NotValidException("Invalid asset identifier: " + coloredCoinsAssetDelete.getJSONObject());
                }
                Asset asset = Asset.getAsset(coloredCoinsAssetDelete.getAssetId());
                if (coloredCoinsAssetDelete.getQuantityQNT() <= 0L || asset != null && coloredCoinsAssetDelete.getQuantityQNT() > asset.getInitialQuantityQNT()) {
                    throw new NxtException.NotValidException("Invalid asset delete asset or quantity: " + coloredCoinsAssetDelete.getJSONObject());
                }
                if (asset == null) {
                    throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(coloredCoinsAssetDelete.getAssetId()) + " does not exist yet");
                }
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };
        public static final TransactionType ASSET_INCREASE = new ColoredCoins(){

            @Override
            public final byte getSubtype() {
                return 8;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_INCREASE;
            }

            @Override
            public String getName() {
                return "AssetIncrease";
            }

            @Override
            public Fee getBaselineFee(Transaction transaction) {
                return new Fee.ConstantFee(1000000000L);
            }

            @Override
            Attachment.ColoredCoinsAssetIncrease parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.ColoredCoinsAssetIncrease(byteBuffer);
            }

            @Override
            Attachment.ColoredCoinsAssetIncrease parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsAssetIncrease(jSONObject);
            }

            @Override
            boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                return true;
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.ColoredCoinsAssetIncrease coloredCoinsAssetIncrease = (Attachment.ColoredCoinsAssetIncrease)transaction.getAttachment();
                account.addToAssetAndUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), coloredCoinsAssetIncrease.getAssetId(), coloredCoinsAssetIncrease.getQuantityQNT());
                Asset.increaseAsset(transaction, coloredCoinsAssetIncrease.getAssetId(), coloredCoinsAssetIncrease.getQuantityQNT());
            }

            @Override
            void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.ColoredCoinsAssetIncrease coloredCoinsAssetIncrease = (Attachment.ColoredCoinsAssetIncrease)transaction.getAttachment();
                if (coloredCoinsAssetIncrease.getAssetId() == 0L) {
                    throw new NxtException.NotValidException("Invalid asset identifier: " + coloredCoinsAssetIncrease.getJSONObject());
                }
                long l = coloredCoinsAssetIncrease.getQuantityQNT();
                if (l <= 0L || l > 100000000000000000L) {
                    throw new NxtException.NotValidException("Invalid asset increase quantity: " + coloredCoinsAssetIncrease.getJSONObject());
                }
                Asset asset = Asset.getAsset(coloredCoinsAssetIncrease.getAssetId());
                if (asset == null) {
                    throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(coloredCoinsAssetIncrease.getAssetId()) + " does not exist yet");
                }
                if (100000000000000000L - l < asset.getQuantityQNT()) {
                    throw new NxtException.NotCurrentlyValidException("Invalid asset increase quantity: " + coloredCoinsAssetIncrease.getJSONObject());
                }
                if (asset.getQuantityQNT() == 1L) {
                    throw new NxtException.NotCurrentlyValidException("No quantity increase allowed for single share assets");
                }
                if (asset.getQuantityQNT() == 0L) {
                    throw new NxtException.NotCurrentlyValidException("No quantity increase allowed for deleted assets");
                }
                if (transaction.getSenderId() != asset.getAccountId()) {
                    throw new NxtException.NotValidException("Only asset issuer can increase asset quantity");
                }
            }

            @Override
            public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.ColoredCoinsAssetIncrease coloredCoinsAssetIncrease = (Attachment.ColoredCoinsAssetIncrease)transaction.getAttachment();
                return 4.isDuplicate(ASSET_INCREASE, Long.toUnsignedString(coloredCoinsAssetIncrease.getAssetId()), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType ASK_ORDER_PLACEMENT = new ColoredCoinsOrderPlacement(){

            @Override
            public final byte getSubtype() {
                return 2;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_ASK_ORDER_PLACEMENT;
            }

            @Override
            public String getName() {
                return "AskOrderPlacement";
            }

            @Override
            Attachment.ColoredCoinsAskOrderPlacement parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.ColoredCoinsAskOrderPlacement(byteBuffer);
            }

            @Override
            Attachment.ColoredCoinsAskOrderPlacement parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsAskOrderPlacement(jSONObject);
            }

            @Override
            boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.ColoredCoinsAskOrderPlacement coloredCoinsAskOrderPlacement = (Attachment.ColoredCoinsAskOrderPlacement)transaction.getAttachment();
                long l = account.getUnconfirmedAssetBalanceQNT(coloredCoinsAskOrderPlacement.getAssetId());
                if (l >= 0L && l >= coloredCoinsAskOrderPlacement.getQuantityQNT()) {
                    account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), coloredCoinsAskOrderPlacement.getAssetId(), -coloredCoinsAskOrderPlacement.getQuantityQNT());
                    return true;
                }
                return false;
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.ColoredCoinsAskOrderPlacement coloredCoinsAskOrderPlacement = (Attachment.ColoredCoinsAskOrderPlacement)transaction.getAttachment();
                Order.Ask.addOrder(transaction, coloredCoinsAskOrderPlacement);
            }

            @Override
            void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.ColoredCoinsAskOrderPlacement coloredCoinsAskOrderPlacement = (Attachment.ColoredCoinsAskOrderPlacement)transaction.getAttachment();
                account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), coloredCoinsAskOrderPlacement.getAssetId(), coloredCoinsAskOrderPlacement.getQuantityQNT());
            }
        };
        public static final TransactionType BID_ORDER_PLACEMENT = new ColoredCoinsOrderPlacement(){

            @Override
            public final byte getSubtype() {
                return 3;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_BID_ORDER_PLACEMENT;
            }

            @Override
            public String getName() {
                return "BidOrderPlacement";
            }

            @Override
            Attachment.ColoredCoinsBidOrderPlacement parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.ColoredCoinsBidOrderPlacement(byteBuffer);
            }

            @Override
            Attachment.ColoredCoinsBidOrderPlacement parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsBidOrderPlacement(jSONObject);
            }

            @Override
            boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.ColoredCoinsBidOrderPlacement coloredCoinsBidOrderPlacement = (Attachment.ColoredCoinsBidOrderPlacement)transaction.getAttachment();
                if (account.getUnconfirmedBalanceNQT() >= Math.multiplyExact(coloredCoinsBidOrderPlacement.getQuantityQNT(), coloredCoinsBidOrderPlacement.getPriceNQT())) {
                    account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), -Math.multiplyExact(coloredCoinsBidOrderPlacement.getQuantityQNT(), coloredCoinsBidOrderPlacement.getPriceNQT()));
                    return true;
                }
                return false;
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.ColoredCoinsBidOrderPlacement coloredCoinsBidOrderPlacement = (Attachment.ColoredCoinsBidOrderPlacement)transaction.getAttachment();
                Order.Bid.addOrder(transaction, coloredCoinsBidOrderPlacement);
            }

            @Override
            void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.ColoredCoinsBidOrderPlacement coloredCoinsBidOrderPlacement = (Attachment.ColoredCoinsBidOrderPlacement)transaction.getAttachment();
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), Math.multiplyExact(coloredCoinsBidOrderPlacement.getQuantityQNT(), coloredCoinsBidOrderPlacement.getPriceNQT()));
            }
        };
        public static final TransactionType ASK_ORDER_CANCELLATION = new ColoredCoinsOrderCancellation(){

            @Override
            public final byte getSubtype() {
                return 4;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_ASK_ORDER_CANCELLATION;
            }

            @Override
            public String getName() {
                return "AskOrderCancellation";
            }

            @Override
            Attachment.ColoredCoinsAskOrderCancellation parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.ColoredCoinsAskOrderCancellation(byteBuffer);
            }

            @Override
            Attachment.ColoredCoinsAskOrderCancellation parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsAskOrderCancellation(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.ColoredCoinsAskOrderCancellation coloredCoinsAskOrderCancellation = (Attachment.ColoredCoinsAskOrderCancellation)transaction.getAttachment();
                Order.Ask ask = Order.Ask.getAskOrder(coloredCoinsAskOrderCancellation.getOrderId());
                Order.Ask.removeOrder(coloredCoinsAskOrderCancellation.getOrderId());
                if (ask != null) {
                    account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), transaction.getId(), ask.getAssetId(), ask.getQuantityQNT());
                }
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.ColoredCoinsAskOrderCancellation coloredCoinsAskOrderCancellation = (Attachment.ColoredCoinsAskOrderCancellation)transaction.getAttachment();
                Order.Ask ask = Order.Ask.getAskOrder(coloredCoinsAskOrderCancellation.getOrderId());
                if (ask == null) {
                    throw new NxtException.NotCurrentlyValidException("Invalid ask order: " + Long.toUnsignedString(coloredCoinsAskOrderCancellation.getOrderId()));
                }
                if (ask.getAccountId() != transaction.getSenderId()) {
                    throw new NxtException.NotValidException("Order " + Long.toUnsignedString(coloredCoinsAskOrderCancellation.getOrderId()) + " was created by account " + Long.toUnsignedString(ask.getAccountId()));
                }
            }
        };
        public static final TransactionType BID_ORDER_CANCELLATION = new ColoredCoinsOrderCancellation(){

            @Override
            public final byte getSubtype() {
                return 5;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_BID_ORDER_CANCELLATION;
            }

            @Override
            public String getName() {
                return "BidOrderCancellation";
            }

            @Override
            Attachment.ColoredCoinsBidOrderCancellation parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.ColoredCoinsBidOrderCancellation(byteBuffer);
            }

            @Override
            Attachment.ColoredCoinsBidOrderCancellation parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsBidOrderCancellation(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.ColoredCoinsBidOrderCancellation coloredCoinsBidOrderCancellation = (Attachment.ColoredCoinsBidOrderCancellation)transaction.getAttachment();
                Order.Bid bid = Order.Bid.getBidOrder(coloredCoinsBidOrderCancellation.getOrderId());
                Order.Bid.removeOrder(coloredCoinsBidOrderCancellation.getOrderId());
                if (bid != null) {
                    account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), Math.multiplyExact(bid.getQuantityQNT(), bid.getPriceNQT()));
                }
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.ColoredCoinsBidOrderCancellation coloredCoinsBidOrderCancellation = (Attachment.ColoredCoinsBidOrderCancellation)transaction.getAttachment();
                Order.Bid bid = Order.Bid.getBidOrder(coloredCoinsBidOrderCancellation.getOrderId());
                if (bid == null) {
                    throw new NxtException.NotCurrentlyValidException("Invalid bid order: " + Long.toUnsignedString(coloredCoinsBidOrderCancellation.getOrderId()));
                }
                if (bid.getAccountId() != transaction.getSenderId()) {
                    throw new NxtException.NotValidException("Order " + Long.toUnsignedString(coloredCoinsBidOrderCancellation.getOrderId()) + " was created by account " + Long.toUnsignedString(bid.getAccountId()));
                }
            }
        };
        public static final TransactionType DIVIDEND_PAYMENT = new ColoredCoins(){

            @Override
            public final byte getSubtype() {
                return 6;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_DIVIDEND_PAYMENT;
            }

            @Override
            public String getName() {
                return "DividendPayment";
            }

            @Override
            Attachment.ColoredCoinsDividendPayment parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.ColoredCoinsDividendPayment(byteBuffer);
            }

            @Override
            Attachment.ColoredCoinsDividendPayment parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsDividendPayment(jSONObject);
            }

            @Override
            boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.ColoredCoinsDividendPayment coloredCoinsDividendPayment = (Attachment.ColoredCoinsDividendPayment)transaction.getAttachment();
                long l = coloredCoinsDividendPayment.getAssetId();
                Asset asset = Asset.getAsset(l, coloredCoinsDividendPayment.getHeight());
                if (asset == null) {
                    return true;
                }
                HoldingType holdingType = coloredCoinsDividendPayment.getHoldingType();
                long l2 = asset.getQuantityQNT() - account.getAssetBalanceQNT(l, coloredCoinsDividendPayment.getHeight());
                long l3 = Math.multiplyExact(coloredCoinsDividendPayment.getAmountNQTPerQNT(), l2);
                if (holdingType.getUnconfirmedBalance(account, coloredCoinsDividendPayment.getHoldingId()) >= l3) {
                    holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), transaction.getId(), coloredCoinsDividendPayment.getHoldingId(), -l3);
                    return true;
                }
                return false;
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.ColoredCoinsDividendPayment coloredCoinsDividendPayment = (Attachment.ColoredCoinsDividendPayment)transaction.getAttachment();
                account.payDividends(transaction.getId(), coloredCoinsDividendPayment);
            }

            @Override
            void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
                Attachment.ColoredCoinsDividendPayment coloredCoinsDividendPayment = (Attachment.ColoredCoinsDividendPayment)transaction.getAttachment();
                long l = coloredCoinsDividendPayment.getAssetId();
                Asset asset = Asset.getAsset(l, coloredCoinsDividendPayment.getHeight());
                if (asset == null) {
                    return;
                }
                HoldingType holdingType = coloredCoinsDividendPayment.getHoldingType();
                long l2 = asset.getQuantityQNT() - account.getAssetBalanceQNT(l, coloredCoinsDividendPayment.getHeight());
                long l3 = Math.multiplyExact(coloredCoinsDividendPayment.getAmountNQTPerQNT(), l2);
                holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), transaction.getId(), coloredCoinsDividendPayment.getHoldingId(), l3);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.ColoredCoinsDividendPayment coloredCoinsDividendPayment = (Attachment.ColoredCoinsDividendPayment)transaction.getAttachment();
                if (coloredCoinsDividendPayment.getHeight() > Nxt.getBlockchain().getHeight()) {
                    throw new NxtException.NotCurrentlyValidException("Invalid dividend payment height: " + coloredCoinsDividendPayment.getHeight() + ", must not exceed current blockchain height " + Nxt.getBlockchain().getHeight());
                }
                if (coloredCoinsDividendPayment.getHeight() <= coloredCoinsDividendPayment.getFinishValidationHeight(transaction) - 1441) {
                    throw new NxtException.NotCurrentlyValidException("Invalid dividend payment height: " + coloredCoinsDividendPayment.getHeight() + ", must be less than 1441 blocks before " + coloredCoinsDividendPayment.getFinishValidationHeight(transaction));
                }
                Asset asset = Asset.getAsset(coloredCoinsDividendPayment.getAssetId(), coloredCoinsDividendPayment.getHeight());
                if (asset == null) {
                    throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(coloredCoinsDividendPayment.getAssetId()) + " for dividend payment doesn't exist yet");
                }
                if (asset.getAccountId() != transaction.getSenderId() || coloredCoinsDividendPayment.getAmountNQTPerQNT() <= 0L) {
                    throw new NxtException.NotValidException("Invalid dividend payment sender or amount " + coloredCoinsDividendPayment.getJSONObject());
                }
                AssetDividend assetDividend = AssetDividend.getLastDividend(coloredCoinsDividendPayment.getAssetId());
                if (assetDividend != null && assetDividend.getHeight() > Nxt.getBlockchain().getHeight() - 60) {
                    throw new NxtException.NotCurrentlyValidException("Last dividend payment for asset " + Long.toUnsignedString(coloredCoinsDividendPayment.getAssetId()) + " was less than 60 blocks ago at " + assetDividend.getHeight() + ", current height is " + Nxt.getBlockchain().getHeight() + ", limit is one dividend per 60 blocks");
                }
                HoldingType holdingType = coloredCoinsDividendPayment.getHoldingType();
                switch (holdingType) {
                    case NXT: {
                        if (coloredCoinsDividendPayment.getHoldingId() == 0L) break;
                        throw new NxtException.NotValidException("Holding id must be 0 for holding type NXT");
                    }
                    case ASSET: {
                        Asset asset2 = Asset.getAsset(coloredCoinsDividendPayment.getHoldingId());
                        if (asset2 != null) break;
                        throw new NxtException.NotCurrentlyValidException("Unknown asset " + Long.toUnsignedString(coloredCoinsDividendPayment.getHoldingId()));
                    }
                    case CURRENCY: {
                        Currency currency = Currency.getCurrency(coloredCoinsDividendPayment.getHoldingId());
                        CurrencyType.validate(currency, transaction);
                        if (currency.isActive()) break;
                        throw new NxtException.NotCurrentlyValidException("Currency is not active: " + currency.getCode());
                    }
                    default: {
                        throw new RuntimeException("Unsupported holding type " + holdingType);
                    }
                }
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.ColoredCoinsDividendPayment coloredCoinsDividendPayment = (Attachment.ColoredCoinsDividendPayment)transaction.getAttachment();
                return 9.isDuplicate(DIVIDEND_PAYMENT, Long.toUnsignedString(coloredCoinsDividendPayment.getAssetId()), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType ASSET_PROPERTY_SET = new ColoredCoinsAssetPropertyTransactionType(){
            private final Fee ASSET_PROPERTY_FEE = new Fee.SizeBasedFee(100000000L, 100000000L, 32){

                @Override
                public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                    Attachment.ColoredCoinsAssetProperty coloredCoinsAssetProperty = (Attachment.ColoredCoinsAssetProperty)transactionImpl.getAttachment();
                    return coloredCoinsAssetProperty.getValue().length();
                }
            };

            @Override
            public byte getSubtype() {
                return 10;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_PROPERTY_SET;
            }

            @Override
            public String getName() {
                return "AssetProperty";
            }

            @Override
            Fee getBaselineFee(Transaction transaction) {
                return this.ASSET_PROPERTY_FEE;
            }

            @Override
            Attachment.ColoredCoinsAssetProperty parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.ColoredCoinsAssetProperty(byteBuffer);
            }

            @Override
            Attachment.ColoredCoinsAssetProperty parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsAssetProperty(jSONObject);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.ColoredCoinsAssetProperty coloredCoinsAssetProperty = (Attachment.ColoredCoinsAssetProperty)transaction.getAttachment();
                if (!Attachment.ColoredCoinsAssetProperty.PROPERTY_NAME_RW.validate(coloredCoinsAssetProperty.getProperty()) || coloredCoinsAssetProperty.getProperty().length() == 0 || !Attachment.ColoredCoinsAssetProperty.PROPERTY_VALUE_RW.validate(coloredCoinsAssetProperty.getValue())) {
                    throw new NxtException.NotValidException("Invalid asset property: " + coloredCoinsAssetProperty.getJSONObject());
                }
                this.checkRecipient(Asset.getAsset(coloredCoinsAssetProperty.getAssetId()), transaction.getRecipientId());
                if (transaction.getAmountNQT() != 0L) {
                    throw new NxtException.NotValidException("Asset property transaction cannot be used to send money");
                }
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.ColoredCoinsAssetProperty coloredCoinsAssetProperty = (Attachment.ColoredCoinsAssetProperty)transaction.getAttachment();
                Asset.getAsset(coloredCoinsAssetProperty.getAssetId()).setProperty(transaction.getId(), account, coloredCoinsAssetProperty.getProperty(), coloredCoinsAssetProperty.getValue());
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };
        public static final TransactionType ASSET_PROPERTY_DELETE = new ColoredCoinsAssetPropertyTransactionType(){

            @Override
            public byte getSubtype() {
                return 11;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ASSET_PROPERTY_DELETE;
            }

            @Override
            public String getName() {
                return "AssetPropertyDelete";
            }

            @Override
            Attachment.PropertyDeleteAttachment parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.ColoredCoinsAssetPropertyDelete(byteBuffer);
            }

            @Override
            Attachment.PropertyDeleteAttachment parseAttachment(JSONObject jSONObject) {
                return new Attachment.ColoredCoinsAssetPropertyDelete(jSONObject);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.PropertyDeleteAttachment propertyDeleteAttachment = (Attachment.PropertyDeleteAttachment)transaction.getAttachment();
                Asset.AssetProperty assetProperty = Asset.getProperty(propertyDeleteAttachment.getPropertyId());
                if (assetProperty == null) {
                    throw new NxtException.NotCurrentlyValidException("No such property " + Long.toUnsignedString(propertyDeleteAttachment.getPropertyId()));
                }
                Asset asset = Asset.getAsset(assetProperty.getAssetId());
                if (asset.getAccountId() != transaction.getSenderId() && assetProperty.getSetterId() != transaction.getSenderId()) {
                    throw new NxtException.NotValidException("Account " + Long.toUnsignedString(transaction.getSenderId()) + " cannot delete property " + Long.toUnsignedString(propertyDeleteAttachment.getPropertyId()));
                }
                this.checkRecipient(asset, transaction.getRecipientId());
                if (transaction.getAmountNQT() != 0L) {
                    throw new NxtException.NotValidException("Asset property transaction cannot be used to send money");
                }
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.PropertyDeleteAttachment propertyDeleteAttachment = (Attachment.PropertyDeleteAttachment)transaction.getAttachment();
                Asset.deleteProperty(propertyDeleteAttachment.getPropertyId());
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };

        private ColoredCoins() {
        }

        @Override
        public final byte getType() {
            return 2;
        }

        static abstract class ColoredCoinsAssetPropertyTransactionType
        extends ColoredCoins {
            ColoredCoinsAssetPropertyTransactionType() {
            }

            final void checkRecipient(Asset asset, long l) throws NxtException.NotValidException {
                if (l != asset.getAccountId()) {
                    throw new NxtException.NotValidException(String.format("Property transaction recipient must be asset issuer(%s), but was %s", Long.toUnsignedString(asset.getAccountId()), Long.toUnsignedString(l)));
                }
            }

            @Override
            boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                return true;
            }

            @Override
            void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            }
        }

        static abstract class ColoredCoinsOrderCancellation
        extends ColoredCoins {
            ColoredCoinsOrderCancellation() {
            }

            @Override
            final boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
                return true;
            }

            @Override
            final void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            }

            @Override
            boolean isUnconfirmedDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.ColoredCoinsOrderCancellation coloredCoinsOrderCancellation = (Attachment.ColoredCoinsOrderCancellation)transaction.getAttachment();
                return TransactionType.isDuplicate(ASK_ORDER_CANCELLATION, Long.toUnsignedString(coloredCoinsOrderCancellation.getOrderId()), map, true);
            }

            @Override
            public final boolean canHaveRecipient() {
                return false;
            }

            @Override
            public final boolean isPhasingSafe() {
                return true;
            }
        }

        static abstract class ColoredCoinsOrderPlacement
        extends ColoredCoins {
            ColoredCoinsOrderPlacement() {
            }

            @Override
            final void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.ColoredCoinsOrderPlacement coloredCoinsOrderPlacement = (Attachment.ColoredCoinsOrderPlacement)transaction.getAttachment();
                if (coloredCoinsOrderPlacement.getPriceNQT() <= 0L || coloredCoinsOrderPlacement.getPriceNQT() > 100000000000000000L || coloredCoinsOrderPlacement.getAssetId() == 0L) {
                    throw new NxtException.NotValidException("Invalid asset order placement: " + coloredCoinsOrderPlacement.getJSONObject());
                }
                Asset asset = Asset.getAsset(coloredCoinsOrderPlacement.getAssetId());
                if (coloredCoinsOrderPlacement.getQuantityQNT() <= 0L || asset != null && coloredCoinsOrderPlacement.getQuantityQNT() > asset.getInitialQuantityQNT()) {
                    throw new NxtException.NotValidException("Invalid asset order placement asset or quantity: " + coloredCoinsOrderPlacement.getJSONObject());
                }
                if (asset == null) {
                    throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(coloredCoinsOrderPlacement.getAssetId()) + " does not exist yet");
                }
            }

            @Override
            public final boolean canHaveRecipient() {
                return false;
            }

            @Override
            public final boolean isPhasingSafe() {
                return true;
            }
        }
    }

    public static abstract class Messaging
    extends TransactionType {
        public static final TransactionType ARBITRARY_MESSAGE = new Messaging(){

            @Override
            public final byte getSubtype() {
                return 0;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ARBITRARY_MESSAGE;
            }

            @Override
            public String getName() {
                return "ArbitraryMessage";
            }

            @Override
            Attachment.EmptyAttachment parseAttachment(ByteBuffer byteBuffer) {
                return Attachment.ARBITRARY_MESSAGE;
            }

            @Override
            Attachment.EmptyAttachment parseAttachment(JSONObject jSONObject) {
                return Attachment.ARBITRARY_MESSAGE;
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment attachment = transaction.getAttachment();
                if (transaction.getAmountNQT() != 0L) {
                    throw new NxtException.NotValidException("Invalid arbitrary message: " + attachment.getJSONObject());
                }
                if (transaction.getRecipientId() == Genesis.CREATOR_ID) {
                    throw new NxtException.NotValidException("Sending messages to Genesis not allowed.");
                }
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean mustHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType ALIAS_ASSIGNMENT = new Messaging(){
            private final Fee ALIAS_FEE = new Fee.SizeBasedFee(200000000L, 200000000L, 32){

                @Override
                public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                    Attachment.MessagingAliasAssignment messagingAliasAssignment = (Attachment.MessagingAliasAssignment)transactionImpl.getAttachment();
                    return messagingAliasAssignment.getAliasName().length() + messagingAliasAssignment.getAliasURI().length();
                }
            };

            @Override
            public final byte getSubtype() {
                return 1;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ALIAS_ASSIGNMENT;
            }

            @Override
            public String getName() {
                return "AliasAssignment";
            }

            @Override
            Fee getBaselineFee(Transaction transaction) {
                return this.ALIAS_FEE;
            }

            @Override
            Attachment.MessagingAliasAssignment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.MessagingAliasAssignment(byteBuffer);
            }

            @Override
            Attachment.MessagingAliasAssignment parseAttachment(JSONObject jSONObject) {
                return new Attachment.MessagingAliasAssignment(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.MessagingAliasAssignment messagingAliasAssignment = (Attachment.MessagingAliasAssignment)transaction.getAttachment();
                Alias.addOrUpdateAlias(transaction, messagingAliasAssignment);
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.MessagingAliasAssignment messagingAliasAssignment = (Attachment.MessagingAliasAssignment)transaction.getAttachment();
                return 2.isDuplicate(ALIAS_ASSIGNMENT, messagingAliasAssignment.getAliasName().toLowerCase(Locale.ROOT), map, true);
            }

            @Override
            boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                return Alias.getAlias(((Attachment.MessagingAliasAssignment)transaction.getAttachment()).getAliasName()) == null && 2.isDuplicate(ALIAS_ASSIGNMENT, "", map, true);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.MessagingAliasAssignment messagingAliasAssignment = (Attachment.MessagingAliasAssignment)transaction.getAttachment();
                if (messagingAliasAssignment.getAliasName().length() == 0 || !Attachment.MessagingAliasAssignment.ALIAS_NAME_RW.validate(messagingAliasAssignment.getAliasName()) || !Attachment.MessagingAliasAssignment.ALIAS_URI_RW.validate(messagingAliasAssignment.getAliasURI())) {
                    throw new NxtException.NotValidException("Invalid alias assignment: " + messagingAliasAssignment.getJSONObject());
                }
                String string = messagingAliasAssignment.getAliasName().toLowerCase(Locale.ROOT);
                for (int i = 0; i < string.length(); ++i) {
                    if ("0123456789abcdefghijklmnopqrstuvwxyz".indexOf(string.charAt(i)) >= 0) continue;
                    throw new NxtException.NotValidException("Invalid alias name: " + string);
                }
                Alias alias = Alias.getAlias(string);
                if (alias != null && alias.getAccountId() != transaction.getSenderId()) {
                    throw new NxtException.NotCurrentlyValidException("Alias already owned by another account: " + string);
                }
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType ALIAS_SELL = new Messaging(){

            @Override
            public final byte getSubtype() {
                return 6;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ALIAS_SELL;
            }

            @Override
            public String getName() {
                return "AliasSell";
            }

            @Override
            Attachment.MessagingAliasSell parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.MessagingAliasSell(byteBuffer);
            }

            @Override
            Attachment.MessagingAliasSell parseAttachment(JSONObject jSONObject) {
                return new Attachment.MessagingAliasSell(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.MessagingAliasSell messagingAliasSell = (Attachment.MessagingAliasSell)transaction.getAttachment();
                Alias.sellAlias(transaction, messagingAliasSell);
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.MessagingAliasSell messagingAliasSell = (Attachment.MessagingAliasSell)transaction.getAttachment();
                return 3.isDuplicate(ALIAS_ASSIGNMENT, messagingAliasSell.getAliasName().toLowerCase(Locale.ROOT), map, true);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Alias alias;
                if (transaction.getAmountNQT() != 0L) {
                    throw new NxtException.NotValidException("Invalid sell alias transaction: " + transaction.getJSONObject());
                }
                Attachment.MessagingAliasSell messagingAliasSell = (Attachment.MessagingAliasSell)transaction.getAttachment();
                String string = messagingAliasSell.getAliasName();
                if (string == null || string.length() == 0) {
                    throw new NxtException.NotValidException("Missing alias name");
                }
                long l = messagingAliasSell.getPriceNQT();
                if (l < 0L || l > 100000000000000000L) {
                    throw new NxtException.NotValidException("Invalid alias sell price: " + l);
                }
                if (l == 0L) {
                    if (Genesis.CREATOR_ID == transaction.getRecipientId()) {
                        throw new NxtException.NotValidException("Transferring aliases to Genesis account not allowed");
                    }
                    if (transaction.getRecipientId() == 0L) {
                        throw new NxtException.NotValidException("Missing alias transfer recipient");
                    }
                }
                if ((alias = Alias.getAlias(string)) == null) {
                    throw new NxtException.NotCurrentlyValidException("No such alias: " + string);
                }
                if (alias.getAccountId() != transaction.getSenderId()) {
                    throw new NxtException.NotCurrentlyValidException("Alias doesn't belong to sender: " + string);
                }
                if (transaction.getRecipientId() == Genesis.CREATOR_ID) {
                    throw new NxtException.NotValidException("Selling alias to Genesis not allowed");
                }
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean mustHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType ALIAS_BUY = new Messaging(){

            @Override
            public final byte getSubtype() {
                return 7;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ALIAS_BUY;
            }

            @Override
            public String getName() {
                return "AliasBuy";
            }

            @Override
            Attachment.MessagingAliasBuy parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.MessagingAliasBuy(byteBuffer);
            }

            @Override
            Attachment.MessagingAliasBuy parseAttachment(JSONObject jSONObject) {
                return new Attachment.MessagingAliasBuy(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.MessagingAliasBuy messagingAliasBuy = (Attachment.MessagingAliasBuy)transaction.getAttachment();
                String string = messagingAliasBuy.getAliasName();
                Alias.changeOwner(transaction.getSenderId(), string);
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.MessagingAliasBuy messagingAliasBuy = (Attachment.MessagingAliasBuy)transaction.getAttachment();
                return 4.isDuplicate(ALIAS_ASSIGNMENT, messagingAliasBuy.getAliasName().toLowerCase(Locale.ROOT), map, true);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.MessagingAliasBuy messagingAliasBuy = (Attachment.MessagingAliasBuy)transaction.getAttachment();
                String string = messagingAliasBuy.getAliasName();
                Alias alias = Alias.getAlias(string);
                if (alias == null) {
                    throw new NxtException.NotCurrentlyValidException("No such alias: " + string);
                }
                if (alias.getAccountId() != transaction.getRecipientId()) {
                    throw new NxtException.NotCurrentlyValidException("Alias is owned by account other than recipient: " + Long.toUnsignedString(alias.getAccountId()));
                }
                Alias.Offer offer = Alias.getOffer(alias);
                if (offer == null) {
                    throw new NxtException.NotCurrentlyValidException("Alias is not for sale: " + string);
                }
                if (transaction.getAmountNQT() < offer.getPriceNQT()) {
                    String string2 = "Price is too low for: " + string + " (" + transaction.getAmountNQT() + " < " + offer.getPriceNQT() + ")";
                    throw new NxtException.NotCurrentlyValidException(string2);
                }
                if (offer.getBuyerId() != 0L && offer.getBuyerId() != transaction.getSenderId()) {
                    throw new NxtException.NotCurrentlyValidException("Wrong buyer for " + string + ": " + Long.toUnsignedString(transaction.getSenderId()) + " expected: " + Long.toUnsignedString(offer.getBuyerId()));
                }
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType ALIAS_DELETE = new Messaging(){

            @Override
            public final byte getSubtype() {
                return 8;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ALIAS_DELETE;
            }

            @Override
            public String getName() {
                return "AliasDelete";
            }

            @Override
            Attachment.MessagingAliasDelete parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.MessagingAliasDelete(byteBuffer);
            }

            @Override
            Attachment.MessagingAliasDelete parseAttachment(JSONObject jSONObject) {
                return new Attachment.MessagingAliasDelete(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.MessagingAliasDelete messagingAliasDelete = (Attachment.MessagingAliasDelete)transaction.getAttachment();
                Alias.deleteAlias(messagingAliasDelete.getAliasName());
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.MessagingAliasDelete messagingAliasDelete = (Attachment.MessagingAliasDelete)transaction.getAttachment();
                return 5.isDuplicate(ALIAS_ASSIGNMENT, messagingAliasDelete.getAliasName().toLowerCase(Locale.ROOT), map, true);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.MessagingAliasDelete messagingAliasDelete = (Attachment.MessagingAliasDelete)transaction.getAttachment();
                String string = messagingAliasDelete.getAliasName();
                if (string == null || string.length() == 0) {
                    throw new NxtException.NotValidException("Missing alias name");
                }
                Alias alias = Alias.getAlias(string);
                if (alias == null) {
                    throw new NxtException.NotCurrentlyValidException("No such alias: " + string);
                }
                if (alias.getAccountId() != transaction.getSenderId()) {
                    throw new NxtException.NotCurrentlyValidException("Alias doesn't belong to sender: " + string);
                }
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType POLL_CREATION = new Messaging(){
            private final Fee POLL_OPTIONS_FEE = new Fee.SizeBasedFee(1000000000L, 100000000L, 1){

                @Override
                public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                    int n = ((Attachment.MessagingPollCreation)appendix).getPollOptions().length;
                    return n <= 19 ? 0 : n - 19;
                }
            };
            private final Fee POLL_SIZE_FEE = new Fee.SizeBasedFee(0L, 200000000L, 32){

                @Override
                public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                    Attachment.MessagingPollCreation messagingPollCreation = (Attachment.MessagingPollCreation)appendix;
                    int n = messagingPollCreation.getPollName().length() + messagingPollCreation.getPollDescription().length();
                    for (String string : ((Attachment.MessagingPollCreation)appendix).getPollOptions()) {
                        n += string.length();
                    }
                    return n <= 288 ? 0 : n - 288;
                }
            };
            private final Fee POLL_FEE = (transactionImpl, appendix) -> this.POLL_OPTIONS_FEE.getFee(transactionImpl, appendix) + this.POLL_SIZE_FEE.getFee(transactionImpl, appendix);

            @Override
            public final byte getSubtype() {
                return 2;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.POLL_CREATION;
            }

            @Override
            public String getName() {
                return "PollCreation";
            }

            @Override
            Fee getBaselineFee(Transaction transaction) {
                return this.POLL_FEE;
            }

            @Override
            Attachment.MessagingPollCreation parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.MessagingPollCreation(byteBuffer);
            }

            @Override
            Attachment.MessagingPollCreation parseAttachment(JSONObject jSONObject) {
                return new Attachment.MessagingPollCreation(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.MessagingPollCreation messagingPollCreation = (Attachment.MessagingPollCreation)transaction.getAttachment();
                Poll.addPoll(transaction, messagingPollCreation);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.MessagingPollCreation messagingPollCreation = (Attachment.MessagingPollCreation)transaction.getAttachment();
                int n = messagingPollCreation.getPollOptions().length;
                if (messagingPollCreation.getPollName().length() > 100 || messagingPollCreation.getPollName().isEmpty() || messagingPollCreation.getPollDescription().length() > 1000 || n > 100 || n == 0) {
                    throw new NxtException.NotValidException("Invalid poll attachment: " + messagingPollCreation.getJSONObject());
                }
                if (messagingPollCreation.getMinNumberOfOptions() < 1 || messagingPollCreation.getMinNumberOfOptions() > n) {
                    throw new NxtException.NotValidException("Invalid min number of options: " + messagingPollCreation.getJSONObject());
                }
                if (messagingPollCreation.getMaxNumberOfOptions() < 1 || messagingPollCreation.getMaxNumberOfOptions() < messagingPollCreation.getMinNumberOfOptions() || messagingPollCreation.getMaxNumberOfOptions() > n) {
                    throw new NxtException.NotValidException("Invalid max number of options: " + messagingPollCreation.getJSONObject());
                }
                for (int i = 0; i < n; ++i) {
                    if (messagingPollCreation.getPollOptions()[i].length() <= 100 && !messagingPollCreation.getPollOptions()[i].isEmpty()) continue;
                    throw new NxtException.NotValidException("Invalid poll options length: " + messagingPollCreation.getJSONObject());
                }
                if (messagingPollCreation.getMinRangeValue() < -92 || messagingPollCreation.getMaxRangeValue() > 92 || messagingPollCreation.getMaxRangeValue() < messagingPollCreation.getMinRangeValue()) {
                    throw new NxtException.NotValidException("Invalid range: " + messagingPollCreation.getJSONObject());
                }
                if (messagingPollCreation.getFinishHeight() <= messagingPollCreation.getFinishValidationHeight(transaction) + 1 || messagingPollCreation.getFinishHeight() >= messagingPollCreation.getFinishValidationHeight(transaction) + 20160) {
                    throw new NxtException.NotCurrentlyValidException("Invalid finishing height" + messagingPollCreation.getJSONObject());
                }
                if (!messagingPollCreation.getVoteWeighting().acceptsVotes() || messagingPollCreation.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.HASH) {
                    throw new NxtException.NotValidException("VotingModel " + messagingPollCreation.getVoteWeighting().getVotingModel() + " not valid for regular polls");
                }
                messagingPollCreation.getVoteWeighting().validate();
            }

            @Override
            boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                return 6.isDuplicate(POLL_CREATION, this.getName(), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType VOTE_CASTING = new Messaging(){

            @Override
            public final byte getSubtype() {
                return 3;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.VOTE_CASTING;
            }

            @Override
            public String getName() {
                return "VoteCasting";
            }

            @Override
            Attachment.MessagingVoteCasting parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.MessagingVoteCasting(byteBuffer);
            }

            @Override
            Attachment.MessagingVoteCasting parseAttachment(JSONObject jSONObject) {
                return new Attachment.MessagingVoteCasting(jSONObject);
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.MessagingVoteCasting messagingVoteCasting = (Attachment.MessagingVoteCasting)transaction.getAttachment();
                Vote.addVote(transaction, messagingVoteCasting);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.MessagingVoteCasting messagingVoteCasting = (Attachment.MessagingVoteCasting)transaction.getAttachment();
                if (messagingVoteCasting.getPollId() == 0L || messagingVoteCasting.getPollVote() == null || messagingVoteCasting.getPollVote().length > 100) {
                    throw new NxtException.NotValidException("Invalid vote casting attachment: " + messagingVoteCasting.getJSONObject());
                }
                long l = messagingVoteCasting.getPollId();
                Poll poll = Poll.getPoll(l);
                if (poll == null) {
                    throw new NxtException.NotCurrentlyValidException("Invalid poll: " + Long.toUnsignedString(messagingVoteCasting.getPollId()));
                }
                if (Vote.getVote(l, transaction.getSenderId()) != null) {
                    throw new NxtException.NotCurrentlyValidException("Double voting attempt");
                }
                if (poll.getFinishHeight() <= messagingVoteCasting.getFinishValidationHeight(transaction)) {
                    throw new NxtException.NotCurrentlyValidException("Voting for this poll finishes at " + poll.getFinishHeight());
                }
                byte[] byArray = messagingVoteCasting.getPollVote();
                int n = 0;
                for (byte by : byArray) {
                    if (by != -128 && (by < poll.getMinRangeValue() || by > poll.getMaxRangeValue())) {
                        throw new NxtException.NotValidException(String.format("Invalid vote %d, vote must be between %d and %d", by, poll.getMinRangeValue(), poll.getMaxRangeValue()));
                    }
                    if (by == -128) continue;
                    ++n;
                }
                if (n < poll.getMinNumberOfOptions() || n > poll.getMaxNumberOfOptions()) {
                    throw new NxtException.NotValidException(String.format("Invalid num of choices %d, number of choices must be between %d and %d", n, poll.getMinNumberOfOptions(), poll.getMaxNumberOfOptions()));
                }
            }

            @Override
            boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                Attachment.MessagingVoteCasting messagingVoteCasting = (Attachment.MessagingVoteCasting)transaction.getAttachment();
                String string = Long.toUnsignedString(messagingVoteCasting.getPollId()) + ":" + Long.toUnsignedString(transaction.getSenderId());
                return 7.isDuplicate(VOTE_CASTING, string, map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return false;
            }
        };
        public static final TransactionType PHASING_VOTE_CASTING = new Messaging(){
            private final Fee PHASING_VOTE_FEE = (transactionImpl, appendix) -> {
                Attachment.MessagingPhasingVoteCasting messagingPhasingVoteCasting = (Attachment.MessagingPhasingVoteCasting)transactionImpl.getAttachment();
                return (long)messagingPhasingVoteCasting.getTransactionFullHashes().size() * 100000000L;
            };

            @Override
            public final byte getSubtype() {
                return 9;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.PHASING_VOTE_CASTING;
            }

            @Override
            public String getName() {
                return "PhasingVoteCasting";
            }

            @Override
            Fee getBaselineFee(Transaction transaction) {
                return this.PHASING_VOTE_FEE;
            }

            @Override
            Attachment.MessagingPhasingVoteCasting parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.MessagingPhasingVoteCasting(byteBuffer);
            }

            @Override
            Attachment.MessagingPhasingVoteCasting parseAttachment(JSONObject jSONObject) {
                return new Attachment.MessagingPhasingVoteCasting(jSONObject);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.MessagingPhasingVoteCasting messagingPhasingVoteCasting = (Attachment.MessagingPhasingVoteCasting)transaction.getAttachment();
                byte[] byArray = messagingPhasingVoteCasting.getRevealedSecret();
                if (byArray.length > 100) {
                    throw new NxtException.NotValidException("Invalid revealed secret length " + byArray.length);
                }
                byte[] byArray2 = null;
                byte by = 0;
                List<byte[]> list = messagingPhasingVoteCasting.getTransactionFullHashes();
                if (list.size() > 10) {
                    throw new NxtException.NotValidException("No more than 10 votes allowed for two-phased multi-voting");
                }
                long l = transaction.getSenderId();
                for (byte[] byArray3 : list) {
                    long l2 = Convert.fullHashToId(byArray3);
                    if (l2 == 0L) {
                        throw new NxtException.NotValidException("Invalid phased transactionFullHash " + Convert.toHexString(byArray3));
                    }
                    PhasingPoll phasingPoll = PhasingPoll.getPoll(l2);
                    if (phasingPoll == null) {
                        throw new NxtException.NotCurrentlyValidException("Invalid phased transaction " + Long.toUnsignedString(l2) + ", or phasing is finished");
                    }
                    if (!phasingPoll.getVoteWeighting().acceptsVotes()) {
                        throw new NxtException.NotValidException("This phased transaction does not require or accept voting");
                    }
                    long[] lArray = phasingPoll.getWhitelist();
                    if (lArray.length > 0 && Arrays.binarySearch(lArray, l) < 0) {
                        throw new NxtException.NotValidException("Voter is not in the phased transaction whitelist");
                    }
                    if (byArray.length > 0) {
                        if (phasingPoll.getVoteWeighting().getVotingModel() != VoteWeighting.VotingModel.HASH) {
                            throw new NxtException.NotValidException("Phased transaction " + Long.toUnsignedString(l2) + " does not accept by-hash voting");
                        }
                        if (byArray2 != null && !Arrays.equals(phasingPoll.getHashedSecret(), byArray2)) {
                            throw new NxtException.NotValidException("Phased transaction " + Long.toUnsignedString(l2) + " is using a different hashedSecret");
                        }
                        if (by != 0 && by != phasingPoll.getAlgorithm()) {
                            throw new NxtException.NotValidException("Phased transaction " + Long.toUnsignedString(l2) + " is using a different hashedSecretAlgorithm");
                        }
                        if (byArray2 == null && !phasingPoll.verifySecret(byArray)) {
                            throw new NxtException.NotValidException("Revealed secret does not match phased transaction hashed secret");
                        }
                        byArray2 = phasingPoll.getHashedSecret();
                        by = phasingPoll.getAlgorithm();
                    } else if (phasingPoll.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.HASH) {
                        throw new NxtException.NotValidException("Phased transaction " + Long.toUnsignedString(l2) + " requires revealed secret for approval");
                    }
                    if (!Arrays.equals(phasingPoll.getFullHash(), byArray3)) {
                        throw new NxtException.NotCurrentlyValidException("Phased transaction hash does not match hash in voting transaction");
                    }
                    if (phasingPoll.getFinishHeight() > messagingPhasingVoteCasting.getFinishValidationHeight(transaction) + 1) continue;
                    throw new NxtException.NotCurrentlyValidException(String.format("Phased transaction finishes at height %d which is not after approval transaction height %d", phasingPoll.getFinishHeight(), messagingPhasingVoteCasting.getFinishValidationHeight(transaction) + 1));
                }
            }

            @Override
            final void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.MessagingPhasingVoteCasting messagingPhasingVoteCasting = (Attachment.MessagingPhasingVoteCasting)transaction.getAttachment();
                List<byte[]> list = messagingPhasingVoteCasting.getTransactionFullHashes();
                for (byte[] byArray : list) {
                    PhasingVote.addVote(transaction, account, Convert.fullHashToId(byArray));
                }
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };
        public static final Messaging ACCOUNT_INFO = new Messaging(){
            private final Fee ACCOUNT_INFO_FEE = new Fee.SizeBasedFee(100000000L, 200000000L, 32){

                @Override
                public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                    Attachment.MessagingAccountInfo messagingAccountInfo = (Attachment.MessagingAccountInfo)transactionImpl.getAttachment();
                    return messagingAccountInfo.getName().length() + messagingAccountInfo.getDescription().length();
                }
            };

            @Override
            public byte getSubtype() {
                return 5;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ACCOUNT_INFO;
            }

            @Override
            public String getName() {
                return "AccountInfo";
            }

            @Override
            Fee getBaselineFee(Transaction transaction) {
                return this.ACCOUNT_INFO_FEE;
            }

            @Override
            Attachment.MessagingAccountInfo parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.MessagingAccountInfo(byteBuffer);
            }

            @Override
            Attachment.MessagingAccountInfo parseAttachment(JSONObject jSONObject) {
                return new Attachment.MessagingAccountInfo(jSONObject);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.MessagingAccountInfo messagingAccountInfo = (Attachment.MessagingAccountInfo)transaction.getAttachment();
                if (!Attachment.MessagingAccountInfo.NAME_RW.validate(messagingAccountInfo.getName()) || !Attachment.MessagingAccountInfo.DESCRIPTION_RW.validate(messagingAccountInfo.getDescription())) {
                    throw new NxtException.NotValidException("Invalid account info issuance: " + messagingAccountInfo.getJSONObject());
                }
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.MessagingAccountInfo messagingAccountInfo = (Attachment.MessagingAccountInfo)transaction.getAttachment();
                account.setAccountInfo(messagingAccountInfo.getName(), messagingAccountInfo.getDescription());
            }

            @Override
            boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
                return 9.isDuplicate((TransactionType)ACCOUNT_INFO, this.getName(), map, true);
            }

            @Override
            public boolean canHaveRecipient() {
                return false;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };
        public static final Messaging ACCOUNT_PROPERTY = new Messaging(){
            private final Fee ACCOUNT_PROPERTY_FEE = new Fee.SizeBasedFee(100000000L, 100000000L, 32){

                @Override
                public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                    Attachment.MessagingAccountProperty messagingAccountProperty = (Attachment.MessagingAccountProperty)transactionImpl.getAttachment();
                    return messagingAccountProperty.getValue().length();
                }
            };

            @Override
            public byte getSubtype() {
                return 10;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ACCOUNT_PROPERTY;
            }

            @Override
            public String getName() {
                return "AccountProperty";
            }

            @Override
            Fee getBaselineFee(Transaction transaction) {
                return this.ACCOUNT_PROPERTY_FEE;
            }

            @Override
            Attachment.MessagingAccountProperty parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
                return new Attachment.MessagingAccountProperty(byteBuffer);
            }

            @Override
            Attachment.MessagingAccountProperty parseAttachment(JSONObject jSONObject) {
                return new Attachment.MessagingAccountProperty(jSONObject);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.MessagingAccountProperty messagingAccountProperty = (Attachment.MessagingAccountProperty)transaction.getAttachment();
                if (!Attachment.MessagingAccountProperty.PROPERTY_NAME_RW.validate(messagingAccountProperty.getProperty()) || messagingAccountProperty.getProperty().length() == 0 || !Attachment.MessagingAccountProperty.PROPERTY_VALUE_RW.validate(messagingAccountProperty.getValue())) {
                    throw new NxtException.NotValidException("Invalid account property: " + messagingAccountProperty.getJSONObject());
                }
                if (transaction.getAmountNQT() != 0L) {
                    throw new NxtException.NotValidException("Account property transaction cannot be used to send GMD");
                }
                if (transaction.getRecipientId() == Genesis.CREATOR_ID) {
                    throw new NxtException.NotValidException("Setting Genesis account properties not allowed");
                }
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.MessagingAccountProperty messagingAccountProperty = (Attachment.MessagingAccountProperty)transaction.getAttachment();
                account2.setProperty(transaction, account, messagingAccountProperty.getProperty(), messagingAccountProperty.getValue());
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };
        public static final Messaging ACCOUNT_PROPERTY_DELETE = new Messaging(){

            @Override
            public byte getSubtype() {
                return 11;
            }

            @Override
            public AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ACCOUNT_PROPERTY_DELETE;
            }

            @Override
            public String getName() {
                return "AccountPropertyDelete";
            }

            @Override
            Attachment.MessagingAccountPropertyDelete parseAttachment(ByteBuffer byteBuffer) {
                return new Attachment.MessagingAccountPropertyDelete(byteBuffer);
            }

            @Override
            Attachment.MessagingAccountPropertyDelete parseAttachment(JSONObject jSONObject) {
                return new Attachment.MessagingAccountPropertyDelete(jSONObject);
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                Attachment.MessagingAccountPropertyDelete messagingAccountPropertyDelete = (Attachment.MessagingAccountPropertyDelete)transaction.getAttachment();
                Account.AccountProperty accountProperty = Account.getProperty(messagingAccountPropertyDelete.getPropertyId());
                if (accountProperty == null) {
                    throw new NxtException.NotCurrentlyValidException("No such property " + Long.toUnsignedString(messagingAccountPropertyDelete.getPropertyId()));
                }
                if (accountProperty.getRecipientId() != transaction.getSenderId() && accountProperty.getSetterId() != transaction.getSenderId()) {
                    throw new NxtException.NotValidException("Account " + Long.toUnsignedString(transaction.getSenderId()) + " cannot delete property " + Long.toUnsignedString(messagingAccountPropertyDelete.getPropertyId()));
                }
                if (accountProperty.getRecipientId() != transaction.getRecipientId()) {
                    throw new NxtException.NotValidException("Account property " + Long.toUnsignedString(messagingAccountPropertyDelete.getPropertyId()) + " does not belong to " + Long.toUnsignedString(transaction.getRecipientId()));
                }
                if (transaction.getAmountNQT() != 0L) {
                    throw new NxtException.NotValidException("Account property transaction cannot be used to send GMD");
                }
                if (transaction.getRecipientId() == Genesis.CREATOR_ID) {
                    throw new NxtException.NotValidException("Deleting Genesis account properties not allowed");
                }
            }

            @Override
            void applyAttachment(Transaction transaction, Account account, Account account2) {
                Attachment.MessagingAccountPropertyDelete messagingAccountPropertyDelete = (Attachment.MessagingAccountPropertyDelete)transaction.getAttachment();
                account.deleteProperty(messagingAccountPropertyDelete.getPropertyId());
            }

            @Override
            public boolean canHaveRecipient() {
                return true;
            }

            @Override
            public boolean isPhasingSafe() {
                return true;
            }
        };

        private Messaging() {
        }

        @Override
        public final byte getType() {
            return 1;
        }

        @Override
        final boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        final void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }
    }

    public static abstract class Payment
    extends TransactionType {
        public static final TransactionType ORDINARY = new Payment(){

            @Override
            public final byte getSubtype() {
                return 0;
            }

            @Override
            public final AccountLedger.LedgerEvent getLedgerEvent() {
                return AccountLedger.LedgerEvent.ORDINARY_PAYMENT;
            }

            @Override
            public String getName() {
                return "OrdinaryPayment";
            }

            @Override
            Attachment.EmptyAttachment parseAttachment(ByteBuffer byteBuffer) {
                return Attachment.ORDINARY_PAYMENT;
            }

            @Override
            Attachment.EmptyAttachment parseAttachment(JSONObject jSONObject) {
                return Attachment.ORDINARY_PAYMENT;
            }

            @Override
            void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
                if (transaction.getAmountNQT() <= 0L || transaction.getAmountNQT() >= 100000000000000000L) {
                    throw new NxtException.NotValidException("Invalid ordinary payment");
                }
            }
        };

        private Payment() {
        }

        @Override
        public final byte getType() {
            return 0;
        }

        @Override
        final boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        final void applyAttachment(Transaction transaction, Account account, Account account2) {
            if (account2 == null) {
                Account.getAccount(Genesis.CREATOR_ID).addToBalanceAndUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), transaction.getAmountNQT());
            }
        }

        @Override
        final void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }

        @Override
        public final boolean canHaveRecipient() {
            return true;
        }

        @Override
        public final boolean isPhasingSafe() {
            return true;
        }
    }
}

