/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nxt.addons.JA;
import nxt.util.Convert;
import nxt.util.JSON;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class JO
extends AbstractMap {
    private final JSONObject jo;

    public JO() {
        this.jo = new JSONObject();
    }

    public JO(JSONObject jSONObject) {
        if (jSONObject == null) {
            throw new IllegalArgumentException("Attempt to initialize JO with null JSONObject");
        }
        this.jo = jSONObject;
    }

    public JO(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to initialize JO with null Object");
        }
        this.jo = object instanceof JSONObject ? (JSONObject)object : ((JO)object).toJSONObject();
    }

    public JSONObject toJSONObject() {
        return this.jo;
    }

    @Override
    public void put(String string, Object object) {
        this.jo.put(string, object);
    }

    public JA getArray(String string) {
        Object v = this.jo.get(string);
        if (v == null) {
            return new JA(new JSONArray());
        }
        if (v instanceof JA) {
            return (JA)v;
        }
        return new JA((JSONArray)v);
    }

    public List<JO> getJoList(String string) {
        Object v = this.jo.get(string);
        if (v == null) {
            return Collections.EMPTY_LIST;
        }
        if (v instanceof JSONArray) {
            return new JA((JSONArray)v);
        }
        if (v instanceof JA) {
            return (List)v;
        }
        throw new IllegalArgumentException(string);
    }

    public static JO valueOf(Object object) {
        return new JO((JSONObject)object);
    }

    public static JO parse(String string) {
        try {
            return new JO(JSONValue.parseWithException(string));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException);
        }
    }

    public static JO parse(Reader reader) {
        try {
            return new JO(JSONValue.parseWithException(reader));
        }
        catch (IOException | ParseException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public Object get(String string) {
        return this.jo.get(string);
    }

    public JO getJo(String string) {
        Object v = this.jo.get(string);
        if (v instanceof JSONObject) {
            return new JO(v);
        }
        return (JO)v;
    }

    public long getEntityId(String string) {
        Object v = this.jo.get(string);
        if (v == null) {
            return 0L;
        }
        return Long.parseUnsignedLong((String)v);
    }

    @Override
    public Set<Map.Entry> entrySet() {
        return this.jo.entrySet();
    }

    public String toJSONString() {
        return JSON.toJSONString(this.jo);
    }

    public long getLong(String string, long l) {
        if (this.isExist(string)) {
            return this.getLong(string);
        }
        return l;
    }

    public long getLong(String string) {
        Object v = this.jo.get(string);
        if (v instanceof String) {
            return Long.parseLong((String)v);
        }
        return (Long)v;
    }

    public int getInt(String string, int n) {
        if (this.isExist(string)) {
            return this.getInt(string);
        }
        return n;
    }

    public int getInt(String string) {
        Object v = this.jo.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return (int)this.getLong(string);
    }

    public double getDouble(String string, double d) {
        if (this.isExist(string)) {
            return this.getDouble(string);
        }
        return d;
    }

    public double getDouble(String string) {
        Object v = this.jo.get(string);
        if (v instanceof String) {
            return Double.parseDouble((String)v);
        }
        return (Double)v;
    }

    public float getFloat(String string, float f) {
        if (this.isExist(string)) {
            return this.getFloat(string);
        }
        return f;
    }

    public float getFloat(String string) {
        Object v = this.jo.get(string);
        if (v instanceof Float) {
            return ((Float)v).floatValue();
        }
        return (float)this.getDouble(string);
    }

    public short getShort(String string, short s) {
        if (this.isExist(string)) {
            return this.getShort(string);
        }
        return s;
    }

    public short getShort(String string) {
        Object v = this.jo.get(string);
        if (v instanceof Short) {
            return (Short)v;
        }
        return (short)this.getLong(string);
    }

    public byte getByte(String string, byte by) {
        if (this.isExist(string)) {
            return this.getByte(string);
        }
        return by;
    }

    public byte getByte(String string) {
        Object v = this.jo.get(string);
        if (v instanceof Byte) {
            return (Byte)v;
        }
        return (byte)this.getLong(string);
    }

    public boolean getBoolean(String string, boolean bl) {
        if (this.isExist(string)) {
            return this.getBoolean(string);
        }
        return bl;
    }

    public boolean getBoolean(String string) {
        Object v = this.jo.get(string);
        if (v == null) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return Boolean.valueOf((String)v);
    }

    public String getString(String string, String string2) {
        if (this.isExist(string)) {
            return this.getString(string);
        }
        return string2;
    }

    public String getString(String string) {
        Object v = this.jo.get(string);
        if (v == null) {
            return null;
        }
        if (!(v instanceof String)) {
            return v.toString();
        }
        return (String)v;
    }

    public byte[] parseHexString(String string) {
        Object v = this.jo.get(string);
        if (v == null) {
            return null;
        }
        return Convert.parseHexString((String)v);
    }

    public boolean isExist(String string) {
        return this.jo.get(string) != null;
    }
}

