/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.BufferedReader;
import java.util.List;
import nxt.FundingMonitor;
import nxt.HoldingType;
import nxt.addons.JO;
import nxt.addons.StartAuto;
import nxt.util.Logger;
import org.json.simple.JSONArray;

public final class StartFundingMonitors
extends StartAuto {
    @Override
    protected String getFilenameProperty() {
        return "nxt.startFundingMonitorsFile";
    }

    @Override
    protected void processFile(BufferedReader bufferedReader) {
        StartFundingMonitors.startFundingMonitors(JO.parse(bufferedReader));
    }

    static JSONArray startFundingMonitors(JO jO) {
        JSONArray jSONArray = new JSONArray();
        List<JO> list = jO.getJoList("monitors");
        for (JO jO2 : list) {
            boolean bl = StartFundingMonitors.startFundingMonitor(jO2);
            jO2.put("isStarted", (Object)bl);
            jSONArray.add(jO2.toJSONObject());
            if (bl) {
                Logger.logInfoMessage("Started funding monitor: " + jO2.toJSONString());
                continue;
            }
            Logger.logInfoMessage("Funding monitor already started: " + jO2.toJSONString());
        }
        return jSONArray;
    }

    private static boolean startFundingMonitor(JO jO) {
        String string = jO.getString("secretPhrase");
        if (string == null) {
            throw new RuntimeException("Monitor secretPhrase not defined");
        }
        HoldingType holdingType = HoldingType.get(jO.getByte("holdingType", (byte)0));
        long l = jO.getEntityId("holding");
        String string2 = jO.getString("property");
        long l2 = jO.getLong("amount");
        long l3 = jO.getLong("threshold");
        int n = jO.getInt("interval");
        return FundingMonitor.startMonitor(holdingType, l, string2, l2, l3, n, string);
    }
}

