/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import nxt.Constants;
import nxt.Nxt;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.FullTextTrigger;
import nxt.db.TrimmableDbTable;
import nxt.util.Logger;

public abstract class EntityDbTable<T>
extends TrimmableDbTable<T> {
    private final String defaultSort;
    private final String fullTextSearchColumns;

    protected EntityDbTable(String string, DbKey.Factory<T> factory) {
        this(string, factory, false, null);
    }

    protected EntityDbTable(String string, DbKey.Factory<T> factory, String string2) {
        this(string, factory, false, string2);
    }

    EntityDbTable(String string, DbKey.Factory<T> factory, boolean bl, String string2) {
        super(string, factory, bl);
        this.defaultSort = " ORDER BY " + (bl ? factory.getPKColumns() : " height DESC, db_id DESC ");
        this.fullTextSearchColumns = string2;
    }

    protected abstract T load(Connection var1, ResultSet var2, DbKey var3) throws SQLException;

    protected abstract void save(Connection var1, T var2) throws SQLException;

    protected String defaultSort() {
        return this.defaultSort;
    }

    protected void clearCache() {
        db.clearCache(this.table);
    }

    public void checkAvailable(int n) {
        if (this.multiversion) {
            int n2;
            int n3 = n2 = this.isPersistent() && Nxt.getBlockchainProcessor().isScanning() ? Math.max(Nxt.getBlockchainProcessor().getInitialScanHeight() - Constants.MAX_ROLLBACK, 0) : Nxt.getBlockchainProcessor().getMinRollbackHeight();
            if (n < n2) {
                throw new IllegalArgumentException("Historical data as of height " + n + " not available.");
            }
        }
        if (n > Nxt.getBlockchain().getHeight()) {
            throw new IllegalArgumentException("Height " + n + " exceeds blockchain height " + Nxt.getBlockchain().getHeight());
        }
    }

    public final T newEntity(DbKey dbKey) {
        Object object;
        boolean bl = db.isInTransaction();
        if (bl && (object = db.getCache(this.table).get(dbKey)) != null) {
            return object;
        }
        object = this.dbKeyFactory.newEntity(dbKey);
        if (bl) {
            db.getCache(this.table).put(dbKey, object);
        }
        return object;
    }

    public final T get(DbKey dbKey) {
        return this.get(dbKey, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final T get(DbKey dbKey, boolean bl) {
        Object object;
        if (bl && db.isInTransaction() && (object = db.getCache(this.table).get(dbKey)) != null) {
            return (T)object;
        }
        try {
            object = db.getConnection();
            try {
                T t;
                block15: {
                    PreparedStatement preparedStatement = object.prepareStatement("SELECT * FROM " + this.table + this.dbKeyFactory.getPKClause() + (this.multiversion ? " AND latest = TRUE LIMIT 1" : ""));
                    try {
                        dbKey.setPK(preparedStatement);
                        t = this.get((Connection)object, preparedStatement, bl);
                        if (preparedStatement == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    preparedStatement.close();
                }
                return t;
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final T get(DbKey dbKey, int n) {
        if (n < 0 || this.doesNotExceed(n)) {
            return this.get(dbKey);
        }
        this.checkAvailable(n);
        try (Connection connection = db.getConnection();){
            T t;
            block16: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + this.dbKeyFactory.getPKClause() + " AND height <= ?" + (String)(this.multiversion ? " AND (latest = TRUE OR EXISTS (SELECT 1 FROM " + this.table + this.dbKeyFactory.getPKClause() + " AND height > ?)) ORDER BY height DESC LIMIT 1" : ""));
                try {
                    int n2 = dbKey.setPK(preparedStatement);
                    preparedStatement.setInt(n2, n);
                    if (this.multiversion) {
                        ++n2;
                        n2 = dbKey.setPK(preparedStatement, n2);
                        preparedStatement.setInt(n2, n);
                    }
                    t = this.get(connection, preparedStatement, false);
                    if (preparedStatement == null) break block16;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return t;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final T getBy(DbClause dbClause) {
        try (Connection connection = db.getConnection();){
            T t;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + " WHERE " + dbClause.getClause() + (this.multiversion ? " AND latest = TRUE LIMIT 1" : ""));
                try {
                    dbClause.set(preparedStatement, 1);
                    t = this.get(connection, preparedStatement, true);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return t;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final T getBy(DbClause dbClause, int n) {
        if (n < 0 || this.doesNotExceed(n)) {
            return this.getBy(dbClause);
        }
        this.checkAvailable(n);
        try (Connection connection = db.getConnection();){
            T t;
            block16: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + " AS a WHERE " + dbClause.getClause() + " AND height <= ?" + (String)(this.multiversion ? " AND (latest = TRUE OR EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height > ?)) ORDER BY height DESC LIMIT 1" : ""));
                try {
                    int n2 = 0;
                    ++n2;
                    n2 = dbClause.set(preparedStatement, n2);
                    preparedStatement.setInt(n2, n);
                    if (this.multiversion) {
                        preparedStatement.setInt(++n2, n);
                    }
                    t = this.get(connection, preparedStatement, false);
                    if (preparedStatement == null) break block16;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return t;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private T get(Connection connection, PreparedStatement preparedStatement, boolean bl) throws SQLException {
        boolean bl2 = bl && db.isInTransaction();
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (!resultSet.next()) {
                T t = null;
                return t;
            }
            Object object = null;
            DbKey dbKey = null;
            if (bl2) {
                dbKey = this.dbKeyFactory.newKey(resultSet);
                object = db.getCache(this.table).get(dbKey);
            }
            if (object == null) {
                object = this.load(connection, resultSet, dbKey);
                if (bl2) {
                    db.getCache(this.table).put(dbKey, object);
                }
            }
            if (resultSet.next()) {
                throw new RuntimeException("Multiple records found");
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public final DbIterator<T> getManyBy(DbClause dbClause, int n, int n2) {
        return this.getManyBy(dbClause, n, n2, this.defaultSort());
    }

    public final DbIterator<T> getManyBy(DbClause dbClause, int n, int n2, String string) {
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + " WHERE " + dbClause.getClause() + (this.multiversion ? " AND latest = TRUE " : " ") + string + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            ++n3;
            n3 = dbClause.set(preparedStatement, n3);
            n3 = DbUtils.setLimits(n3, preparedStatement, n, n2);
            return this.getManyBy(connection, preparedStatement, true);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public final DbIterator<T> getManyBy(DbClause dbClause, int n, int n2, int n3) {
        return this.getManyBy(dbClause, n, n2, n3, this.defaultSort());
    }

    public final DbIterator<T> getManyBy(DbClause dbClause, int n, int n2, int n3, String string) {
        if (n < 0 || this.doesNotExceed(n)) {
            return this.getManyBy(dbClause, n2, n3, string);
        }
        this.checkAvailable(n);
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + " AS a WHERE " + dbClause.getClause() + "AND a.height <= ?" + (String)(this.multiversion ? " AND (a.latest = TRUE OR (a.latest = FALSE AND EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height > ?) AND NOT EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height <= ? AND b.height > a.height))) " : " ") + string + DbUtils.limitsClause(n2, n3));
            int n4 = 0;
            ++n4;
            n4 = dbClause.set(preparedStatement, n4);
            preparedStatement.setInt(n4, n);
            if (this.multiversion) {
                preparedStatement.setInt(++n4, n);
                preparedStatement.setInt(++n4, n);
            }
            ++n4;
            n4 = DbUtils.setLimits(n4, preparedStatement, n2, n3);
            return this.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public final DbIterator<T> getManyBy(Connection connection2, PreparedStatement preparedStatement, boolean bl) {
        boolean bl2 = bl && db.isInTransaction();
        return new DbIterator<Object>(connection2, preparedStatement, (connection, resultSet) -> {
            Object object = null;
            DbKey dbKey = null;
            if (bl2) {
                dbKey = this.dbKeyFactory.newKey(resultSet);
                object = db.getCache(this.table).get(dbKey);
            }
            if (object == null) {
                object = this.load(connection, resultSet, dbKey);
                if (bl2) {
                    db.getCache(this.table).put(dbKey, object);
                }
            }
            return object;
        });
    }

    public final DbIterator<T> search(String string, DbClause dbClause, int n, int n2) {
        return this.search(string, dbClause, n, n2, " ORDER BY ft.score DESC ");
    }

    public final DbIterator<T> search(String string, DbClause dbClause, int n, int n2, String string2) {
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT " + this.table + ".*, ft.score FROM " + this.table + ", ftl_search('PUBLIC', '" + this.table + "', ?, 2147483647, 0) ft  WHERE " + this.table + ".db_id = ft.keys[1] " + (String)(this.multiversion ? " AND " + this.table + ".latest = TRUE " : " ") + " AND " + dbClause.getClause() + string2 + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setString(++n3, string);
            ++n3;
            n3 = dbClause.set(preparedStatement, n3);
            n3 = DbUtils.setLimits(n3, preparedStatement, n, n2);
            return this.getManyBy(connection, preparedStatement, true);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public final DbIterator<T> getAll(int n, int n2) {
        return this.getAll(n, n2, this.defaultSort());
    }

    public final DbIterator<T> getAll(int n, int n2, String string) {
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + (this.multiversion ? " WHERE latest = TRUE " : " ") + string + DbUtils.limitsClause(n, n2));
            DbUtils.setLimits(1, preparedStatement, n, n2);
            return this.getManyBy(connection, preparedStatement, true);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public final DbIterator<T> getAll(int n, int n2, int n3) {
        return this.getAll(n, n2, n3, this.defaultSort());
    }

    public final DbIterator<T> getAll(int n, int n2, int n3, String string) {
        if (n < 0 || this.doesNotExceed(n)) {
            return this.getAll(n2, n3, string);
        }
        this.checkAvailable(n);
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.table + " AS a WHERE height <= ?" + (String)(this.multiversion ? " AND (latest = TRUE OR (latest = FALSE AND EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE b.height > ? AND " + this.dbKeyFactory.getSelfJoinClause() + ") AND NOT EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE b.height <= ? AND " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height > a.height))) " : " ") + string + DbUtils.limitsClause(n2, n3));
            int n4 = 0;
            preparedStatement.setInt(++n4, n);
            if (this.multiversion) {
                preparedStatement.setInt(++n4, n);
                preparedStatement.setInt(++n4, n);
            }
            ++n4;
            n4 = DbUtils.setLimits(n4, preparedStatement, n2, n3);
            return this.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final int getCount() {
        try (Connection connection = db.getConnection();){
            int n;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(*) FROM " + this.table + (this.multiversion ? " WHERE latest = TRUE" : ""));
                try {
                    n = this.getCount(preparedStatement);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final int getCount(DbClause dbClause) {
        try (Connection connection = db.getConnection();){
            int n;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(*) FROM " + this.table + " WHERE " + dbClause.getClause() + (this.multiversion ? " AND latest = TRUE" : ""));
                try {
                    dbClause.set(preparedStatement, 1);
                    n = this.getCount(preparedStatement);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public final int getCount(DbClause dbClause, int n) {
        if (n < 0 || this.doesNotExceed(n)) {
            return this.getCount(dbClause);
        }
        this.checkAvailable(n);
        Connection connection = null;
        try {
            connection = db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(*) FROM " + this.table + " AS a WHERE " + dbClause.getClause() + "AND a.height <= ?" + (String)(this.multiversion ? " AND (a.latest = TRUE OR (a.latest = FALSE AND EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height > ?) AND NOT EXISTS (SELECT 1 FROM " + this.table + " AS b WHERE " + this.dbKeyFactory.getSelfJoinClause() + " AND b.height <= ? AND b.height > a.height))) " : " "));
            int n2 = 0;
            ++n2;
            n2 = dbClause.set(preparedStatement, n2);
            preparedStatement.setInt(n2, n);
            if (this.multiversion) {
                preparedStatement.setInt(++n2, n);
                preparedStatement.setInt(++n2, n);
            }
            return this.getCount(preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final int getRowCount() {
        try (Connection connection = db.getConnection();){
            int n;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(*) FROM " + this.table);
                try {
                    n = this.getCount(preparedStatement);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private int getCount(PreparedStatement preparedStatement) throws SQLException {
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            int n = resultSet.getInt(1);
            return n;
        }
    }

    public final void insert(T t) {
        if (!db.isInTransaction()) {
            throw new IllegalStateException("Not in transaction");
        }
        DbKey dbKey = this.dbKeyFactory.newKey(t);
        if (dbKey == null) {
            throw new RuntimeException("DbKey not set");
        }
        Object object = db.getCache(this.table).get(dbKey);
        if (object == null) {
            db.getCache(this.table).put(dbKey, t);
        } else if (t != object) {
            Logger.logDebugMessage("In cache : " + object.toString() + ", inserting " + t.toString());
            throw new IllegalStateException("Different instance found in Db cache, perhaps trying to save an object that was read outside the current transaction");
        }
        try (Connection connection = db.getConnection();){
            if (this.multiversion) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.table + " SET latest = FALSE " + this.dbKeyFactory.getPKClause() + " AND latest = TRUE LIMIT 1");){
                    dbKey.setPK(preparedStatement);
                    preparedStatement.executeUpdate();
                }
            }
            this.save(connection, t);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    @Override
    public final void createSearchIndex(Connection connection) throws SQLException {
        if (this.fullTextSearchColumns != null) {
            Logger.logDebugMessage("Creating search index on " + this.table + " (" + this.fullTextSearchColumns + ")");
            FullTextTrigger.createIndex(connection, "PUBLIC", this.table.toUpperCase(Locale.ROOT), this.fullTextSearchColumns.toUpperCase(Locale.ROOT));
        }
    }

    private boolean doesNotExceed(int n) {
        return Nxt.getBlockchain().getHeight() <= n && (!this.isPersistent() || !Nxt.getBlockchainProcessor().isScanning());
    }
}

