/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import nxt.http.APICall;
import nxt.http.APIServlet;
import nxt.http.CreateTransaction;
import nxt.http.callers.ApiSpec;
import nxt.util.Logger;

public class APICallGenerator {
    private static Predicate<String> ENTITY_IDENTIFIERS = APICallGenerator.exactMatch("account", "recipient", "sender", "asset", "poll", "account", "currency", "order", "offer", "transaction", "ledgerId", "event", "goods", "buyer", "purchase", "holding", "block", "ecBlockId", "setter", "recipient").or(APICallGenerator.phasingParamWhich(APICallGenerator.endsWith("Holding")));
    private static Predicate<String> INT_IDENTIFIERS = APICallGenerator.exactMatch("height", "timestamp", "firstIndex", "lastIndex", "type", "subtype", "deadline", "ecBlockHeight", "totalPieces", "minimumPieces", "minParticipants", "vote00", "vote01", "vote02").or(APICallGenerator.phasingParamWhich(APICallGenerator.endsWith("FinishHeight")));
    private static Predicate<String> BYTE_IDENTIFIERS = APICallGenerator.exactMatch("holdingType", "votingModel", "minBalanceModel").or(APICallGenerator.phasingParamWhich(APICallGenerator.endsWith("VotingModel", "MinBalanceModel", "HashedSecretAlgorithm")));
    private static Predicate<String> BOOLEAN_IDENTIFIERS = APICallGenerator.exactMatch("executedOnly", "phased", "broadcast", "voucher", "retrieve", "add", "remove", "validate").or(APICallGenerator.startsWith("include", "is")).or(APICallGenerator.contains("Is"));
    private static Predicate<String> LONG_IDENTIFIERS = APICallGenerator.contains("NQT", "FQT", "FXT", "QNT").or(APICallGenerator.phasingParamWhich(APICallGenerator.endsWith("Quorum", "MinBalance", "Holding"))).or(APICallGenerator.exactMatch("timeout", "units", "counter", "minBalance", "minRangeValue", "maxRangeValue", "minNumberOfOptions", "maxNumberOfOptions", "votingModel")).or(APICallGenerator.endsWith("Limit", "Supply", "Height"));
    private static Predicate<String> BYTE_ARRAYS = APICallGenerator.startsWith("fullHash", "publicKey").or(APICallGenerator.contains("FullHash", "PublicKey")).or(APICallGenerator.endsWith("MessageData", "Nonce", "ransactionBytes"));
    private static Predicate<String> REMOTE_ONLY_APIS = APICallGenerator.exactMatch("eventRegister", "eventWait");
    private static final String outputPackageName = "nxt.http.callers";
    private final Set<String> parametersHandledInSuperClass = new HashSet<String>();
    private final String requestType;
    private final ClassName className;
    private final String typeName;
    private final TypeVariableName typeVariableName;
    private final TypeName parameterMethodReturnType;

    private APICallGenerator(String string) {
        this.requestType = string;
        this.typeName = APICallGenerator.initialCaps(string) + "Call";
        this.className = ClassName.get((String)outputPackageName, (String)this.typeName, (String[])new String[0]);
        this.typeVariableName = null;
        this.parameterMethodReturnType = this.className;
    }

    private APICallGenerator(String string, String string2) {
        this.requestType = string;
        this.typeName = string2;
        this.className = ClassName.get((String)outputPackageName, (String)string2, (String[])new String[0]);
        this.typeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{TypeName.get(APICall.Builder.class)});
        this.parameterMethodReturnType = this.typeVariableName;
    }

    public static void main(String[] stringArray) {
        APICallGenerator.generateApiSpec();
        APICallGenerator.generateApiCallers();
    }

    private static void generateApiCallers() {
        new APICallGenerator(null, "CreateTransactionCallBuilder").generateCreateTransactionCallBuilder();
        Map<String, APIServlet.APIRequestHandler> map = APIServlet.getAPIRequestHandlers();
        for (String string : map.keySet()) {
            APIServlet.APIRequestHandler aPIRequestHandler = map.get(string);
            new APICallGenerator(string).generateApiCall(aPIRequestHandler);
        }
    }

    private static void generateApiSpec() {
        ClassName className = ClassName.get((String)outputPackageName, (String)"ApiSpec", (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.enumBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Map.Entry<String, APIServlet.APIRequestHandler> entry : APIServlet.getAPIRequestHandlers().entrySet()) {
            String string = entry.getKey();
            APIServlet.APIRequestHandler aPIRequestHandler = entry.getValue();
            String string2 = aPIRequestHandler.getFileParameter();
            CodeBlock.Builder builder2 = CodeBlock.builder();
            if (string2 != null) {
                builder2.add("$S", new Object[]{string2});
            } else {
                builder2.add("$L", new Object[]{null});
            }
            builder2.add(", ", new Object[0]).add("\"$L\"", new Object[]{String.join((CharSequence)"\", \"", aPIRequestHandler.getParameters())});
            builder.addEnumConstant(string, TypeSpec.anonymousClassBuilder((CodeBlock)builder2.build()).build());
        }
        builder.addField(TypeName.get(String.class), "fileParameter", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class}), "parameters", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        CodeBlock codeBlock = CodeBlock.builder().add("this.$L = $T.asList($L);", new Object[]{"parameters", Arrays.class, "parameters"}).build();
        builder.addMethod(MethodSpec.constructorBuilder().addParameter(TypeName.get(String.class), "fileParameter", new Modifier[0]).addParameter(TypeName.get(String[].class), "parameters", new Modifier[0]).varargs().addStatement("this.$L = $L", new Object[]{"fileParameter", "fileParameter"}).addCode(codeBlock).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getFileParameter").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return fileParameter", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getParameters").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})).addStatement("return parameters", new Object[0]).build());
        APICallGenerator.writeToFile(builder.build());
    }

    private void generateApiCall(APIServlet.APIRequestHandler aPIRequestHandler) {
        ClassName className = ClassName.get(APICall.Builder.class);
        if (aPIRequestHandler instanceof CreateTransaction) {
            className = ClassName.get((String)outputPackageName, (String)"CreateTransactionCallBuilder", (String[])new String[0]);
            this.parametersHandledInSuperClass.addAll(CreateTransaction.getCommonParameters());
        }
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.typeName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)className, (TypeName[])new TypeName[]{this.className}));
        builder.addMethod(this.createCallerConstructor());
        builder.addMethod(this.createFactoryMethod());
        List<String> list = aPIRequestHandler.getParameters().stream().filter(string -> !this.parametersHandledInSuperClass.contains(string)).collect(Collectors.toList());
        builder.addMethods(this.createParameterMethods(list));
        builder.addMethods(this.createFileParameterMethods(aPIRequestHandler.getFileParameter()));
        builder.addMethods(this.createIsRemoteOnly());
        APICallGenerator.writeToFile(builder.build());
        String string2 = this.parametersHandledInSuperClass.stream().filter(string -> !aPIRequestHandler.getParameters().contains(string)).collect(Collectors.joining(", "));
        if (!string2.isEmpty()) {
            Logger.logWarningMessage("Caller %s contains invalid parameter(s): %s", this.typeName, string2);
        }
    }

    private void generateCreateTransactionCallBuilder() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.typeName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(this.typeVariableName).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(APICall.Builder.class), (TypeName[])new TypeName[]{this.typeVariableName}));
        builder.addMethod(this.createBuilderConstructor());
        List<String> list = CreateTransaction.getCommonParameters().stream().filter(string -> !this.parametersHandledInSuperClass.contains(string)).collect(Collectors.toList());
        builder.addMethods(this.createParameterMethods(list));
        APICallGenerator.writeToFile(builder.build());
    }

    private MethodSpec createBuilderConstructor() {
        return MethodSpec.constructorBuilder().addParameter(ApiSpec.class, "apiSpec", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED}).addStatement("super(apiSpec)", new Object[0]).build();
    }

    private static void writeToFile(TypeSpec typeSpec) {
        JavaFile javaFile = JavaFile.builder((String)outputPackageName, (TypeSpec)typeSpec).indent("    ").addFileComment("Auto generated code, do not modify", new Object[0]).skipJavaLangImports(true).build();
        Path path = Paths.get("./src/java", new String[0]);
        try {
            javaFile.writeTo(path);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private List<MethodSpec> createIsRemoteOnly() {
        if (!REMOTE_ONLY_APIS.test(this.requestType)) {
            return Collections.emptyList();
        }
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"isRemoteOnly").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return true", new Object[0]).addAnnotation(Override.class).build();
        return Collections.singletonList(methodSpec);
    }

    private List<MethodSpec> createFileParameterMethods(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)string).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterMethodReturnType).addParameter(byte[].class, "b", new Modifier[0]).addStatement("return parts($S, $L)", new Object[]{string, "b"}).build();
        return Collections.singletonList(methodSpec);
    }

    private List<MethodSpec> createParameterMethods(List<String> list) {
        ArrayList<MethodSpec> arrayList = new ArrayList<MethodSpec>();
        Map map = list.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.summingInt(string -> 1)));
        for (String string2 : map.keySet()) {
            boolean bl;
            boolean bl2 = bl = map.get(string2) > 1;
            if (ENTITY_IDENTIFIERS.test(string2)) {
                arrayList.add(this.createMethod(string2, "param", String.class, bl));
                arrayList.add(this.createMethod(string2, "unsignedLongParam", Long.TYPE, bl));
            } else if (INT_IDENTIFIERS.test(string2)) {
                arrayList.add(this.createMethod(string2, "param", Integer.TYPE, bl));
            } else if (BOOLEAN_IDENTIFIERS.test(string2)) {
                arrayList.add(this.createMethod(string2, "param", Boolean.TYPE, bl));
            } else if (BYTE_IDENTIFIERS.test(string2)) {
                arrayList.add(this.createMethod(string2, "param", Byte.TYPE, bl));
            } else if (LONG_IDENTIFIERS.test(string2)) {
                arrayList.add(this.createMethod(string2, "param", Long.TYPE, bl));
            } else {
                arrayList.add(this.createMethod(string2, "param", String.class, bl));
            }
            if (!BYTE_ARRAYS.test(string2)) continue;
            arrayList.add(this.createMethod(string2, "param", byte[].class, bl));
        }
        return arrayList;
    }

    private MethodSpec createCallerConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("super($T." + this.requestType + ")", new Object[]{ApiSpec.class}).build();
    }

    private MethodSpec createFactoryMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.className);
        builder.addStatement("return new $L()", new Object[]{this.typeName});
        return builder.build();
    }

    private MethodSpec createMethod(String string, String string2, Class clazz, boolean bl) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)string).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterMethodReturnType).addStatement("return " + string2 + "($S, $L)", new Object[]{string, string});
        if (bl) {
            Class<?> clazz2 = Array.newInstance(clazz, 0).getClass();
            builder.addParameter(clazz2, string, new Modifier[0]).varargs();
        } else {
            builder.addParameter((Type)clazz, string, new Modifier[0]);
        }
        return builder.build();
    }

    private static String initialCaps(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private static Predicate<String> startsWith(String ... stringArray) {
        return string -> Stream.of(stringArray).anyMatch(string::startsWith);
    }

    private static Predicate<String> endsWith(String ... stringArray) {
        return string -> Stream.of(stringArray).anyMatch(string::endsWith);
    }

    private static Predicate<String> contains(String ... stringArray) {
        return string -> Stream.of(stringArray).anyMatch(string::contains);
    }

    private static Predicate<String> exactMatch(String ... stringArray) {
        return new HashSet<String>(Arrays.asList(stringArray))::contains;
    }

    private static Predicate<String> phasingParamWhich(Predicate<String> predicate) {
        return APICallGenerator.startsWith("phasing", "control").and(predicate);
    }
}

