/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import nxt.Constants;
import nxt.Db;
import nxt.Nxt;
import nxt.http.API;
import nxt.http.APIEnum;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.HttpClientFactory;
import nxt.peer.Peer;
import nxt.peer.PeerImpl;
import nxt.peer.Peers;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class APIProxy {
    public static final Set<String> NOT_FORWARDED_REQUESTS;
    static final boolean enableAPIProxy;
    private static final int blacklistingPeriod;
    static final String forcedServerURL;
    public static final int PEER_CONNECTIONS_RETRIES = 3;
    private final List<String> bootstrapNodes = Nxt.getStringListProperty(Constants.isTestnet ? "nxt.testnetProxyBootstrapNodes" : "nxt.proxyBootstrapNodes");
    private volatile String forcedPeerHost;
    private volatile List<String> peersHosts = Collections.emptyList();
    private volatile String mainPeerAnnouncedAddress;
    private final Map<String, Integer> blacklistedPeers = new ConcurrentHashMap<String, Integer>();
    private static volatile APIProxy instance;
    private static final Runnable peersUpdateThread;
    private HttpClient bootstrapHttpClient;

    private APIProxy() {
        if (enableAPIProxy) {
            int n = Nxt.getEpochTime();
            APIProxy.loadBlacklistedPeers((string, n2) -> {
                if (n < n2) {
                    this.blacklistedPeers.put((String)string, (Integer)n2);
                }
            });
            ThreadPool.runBeforeStart(() -> {
                StringBuilder stringBuilder = new StringBuilder();
                this.bootstrap(stringBuilder);
                Logger.logDebugMessage(stringBuilder.toString());
            }, true);
        }
    }

    public static void init() {
        instance = new APIProxy();
    }

    public static APIProxy getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bootstrap(StringBuilder stringBuilder) {
        if (Constants.isOffline) {
            stringBuilder.append("Current instance is configured for offline work");
            return false;
        }
        if (this.forcedPeerHost != null) {
            stringBuilder.append("Forced peer is set to ").append(this.forcedPeerHost);
            return true;
        }
        this.bootstrapHttpClient = HttpClientFactory.newHttpClient();
        try {
            this.bootstrapHttpClient.start();
        }
        catch (Exception exception) {
            Logger.logErrorMessage("", exception);
            stringBuilder.append(exception.toString());
            return false;
        }
        try {
            boolean bl = true;
            List<Peer> list = null;
            while (true) {
                Peer peer2 = null;
                if (bl) {
                    peer2 = this.getServingPeer("getBlockchainStatus");
                }
                if (peer2 == null) {
                    bl = false;
                    if (list == null) {
                        list = Peers.getPeers(peer -> peer.isOpenAPI() && !this.blacklistedPeers.containsKey(peer.getHost()));
                    }
                    peer2 = this.tryToConnectPeer(list);
                }
                if (peer2 == null) break;
                if (this.testPeerAPI(peer2)) {
                    this.peersHosts = Collections.singletonList(peer2.getHost());
                    stringBuilder.append("Proxy bootstrap complete, known peer ").append(peer2.getHost()).append(" is connected");
                    boolean bl2 = true;
                    return bl2;
                }
                peer2.blacklist("Advertises open API but doesn't respond to getBlockchainStatus");
                this.blacklistHost(peer2.getHost());
            }
            boolean bl3 = this.trustedBootstrap(stringBuilder);
            return bl3;
        }
        finally {
            try {
                this.bootstrapHttpClient.stop();
            }
            catch (Exception exception) {
                Logger.logErrorMessage("", exception);
            }
        }
    }

    private boolean trustedBootstrap(StringBuilder stringBuilder) {
        Logger.logDebugMessage("Start trusted proxy bootstrap");
        Collections.shuffle(this.bootstrapNodes);
        for (String string : this.bootstrapNodes) {
            JSONObject jSONObject;
            Peer peer = this.addAndConnectPeer(string);
            if (peer == null || (jSONObject = this.executeRequest(peer, "getPeers", "state=CONNECTED&service=API")) == null) continue;
            JSONArray jSONArray = (JSONArray)jSONObject.get("peers");
            for (Object e : jSONArray) {
                Peer peer2 = this.addAndConnectPeer((String)e);
                if (peer2 == null || !this.testPeerAPI(peer2)) continue;
                this.peersHosts = Collections.singletonList(peer2.getHost());
                stringBuilder.append("Could not connect known peers. Bootstrapped from ").append(string).append(". Initial peer is ").append(peer2.getHost());
                return true;
            }
        }
        stringBuilder.append("Trusted proxy bootstrap failed");
        return false;
    }

    private Peer tryToConnectPeer(List<Peer> list) {
        for (int i = 3; !list.isEmpty() && i > 0; --i) {
            Peer peer = this.getRandomAPIPeer(list);
            if (peer == null) continue;
            Peers.connectPeer(peer);
            if (peer.getState() != Peer.State.CONNECTED) continue;
            return peer;
        }
        return null;
    }

    private Peer addAndConnectPeer(String string) {
        PeerImpl peerImpl = Peers.findOrCreatePeer(string, true);
        if (peerImpl == null) {
            return null;
        }
        Peers.addPeer(peerImpl);
        Peers.connectPeer(peerImpl);
        if (peerImpl.getState() == Peer.State.CONNECTED) {
            return peerImpl;
        }
        return null;
    }

    private boolean testPeerAPI(Peer peer) {
        JSONObject jSONObject = this.executeRequest(peer, "getBlockchainStatus", null);
        if (jSONObject == null) {
            this.blacklistHost(peer.getHost());
            return false;
        }
        Peer.BlockchainState blockchainState = Peer.BlockchainState.get((String)jSONObject.get("blockchainState"));
        return blockchainState == Peer.BlockchainState.UP_TO_DATE || blockchainState == Peer.BlockchainState.FORK;
    }

    private JSONObject executeRequest(Peer peer, String string, String string2) {
        this.bootstrapHttpClient.setAddressResolutionTimeout(500L);
        this.bootstrapHttpClient.setConnectTimeout(1000L);
        StringBuilder stringBuilder = peer.getPeerApiUri();
        try {
            stringBuilder.append("/nxt?requestType=").append(string);
            if (string2 != null) {
                stringBuilder.append("&").append(string2);
            }
            Request request = this.bootstrapHttpClient.newRequest(stringBuilder.toString()).timeout(2L, TimeUnit.SECONDS);
            ContentResponse contentResponse = request.send();
            return (JSONObject)JSONValue.parse(contentResponse.getContentAsString());
        }
        catch (Exception exception) {
            Logger.logDebugMessage("Proxy bootstrap request failed: " + stringBuilder.toString(), exception);
            return null;
        }
    }

    Peer getServingPeer(String string) {
        Object object;
        Object object2;
        Object object3;
        if (this.forcedPeerHost != null) {
            return Peers.getPeer(this.forcedPeerHost);
        }
        APIEnum aPIEnum = APIEnum.fromName(string);
        if (!this.peersHosts.isEmpty()) {
            object3 = this.peersHosts.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = Peers.getPeer((String)object2);
                if (object == null || !object.isApiConnectable() || object.getDisabledAPIs().contains((Object)aPIEnum)) continue;
                return object;
            }
        }
        if ((object3 = Peers.getPeers(peer -> peer.isApiConnectable() && !this.blacklistedPeers.containsKey(peer.getHost()))).isEmpty()) {
            return null;
        }
        object2 = this.getRandomAPIPeer((List<Peer>)object3);
        if (object2 == null) {
            return null;
        }
        object = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        EnumSet<APIEnum> enumSet = EnumSet.noneOf(APIEnum.class);
        arrayList.add(object2.getHost());
        this.mainPeerAnnouncedAddress = object2.getAnnouncedAddress();
        if (!object2.getDisabledAPIs().contains((Object)aPIEnum)) {
            object = object2;
        }
        while (!enumSet.isEmpty() && !object3.isEmpty()) {
            object3.removeIf(peer -> peer.getDisabledAPIs().containsAll(enumSet));
            object2 = this.getRandomAPIPeer((List<Peer>)object3);
            if (object2 == null) continue;
            arrayList.add(object2.getHost());
            if (!object2.getDisabledAPIs().contains((Object)aPIEnum)) {
                object = object2;
            }
            enumSet.retainAll(object2.getDisabledAPIs());
        }
        this.peersHosts = Collections.unmodifiableList(arrayList);
        Logger.logInfoMessage("Selected API peer " + (Peer)object + " peer hosts selected " + arrayList);
        return object;
    }

    Peer setForcedPeer(Peer peer) {
        if (peer != null) {
            this.forcedPeerHost = peer.getHost();
            this.mainPeerAnnouncedAddress = peer.getAnnouncedAddress();
            return peer;
        }
        this.forcedPeerHost = null;
        this.mainPeerAnnouncedAddress = null;
        return this.getServingPeer(null);
    }

    String getMainPeerAnnouncedAddress() {
        Peer peer;
        if (this.mainPeerAnnouncedAddress == null && (peer = this.getServingPeer(null)) != null) {
            this.mainPeerAnnouncedAddress = peer.getAnnouncedAddress();
        }
        return this.mainPeerAnnouncedAddress;
    }

    static boolean isActivated() {
        return Constants.isLightClient || enableAPIProxy && Nxt.getBlockchainProcessor().isDownloading();
    }

    boolean blacklistHost(String string) {
        if (this.blacklistedPeers.size() > 2000) {
            Logger.logInfoMessage("Too many blacklisted peers");
            return false;
        }
        int n = Nxt.getEpochTime() + blacklistingPeriod;
        this.blacklistedPeers.put(string, n);
        APIProxy.storeBlacklistedPeer(string, n);
        if (this.peersHosts.contains(string)) {
            this.peersHosts = Collections.emptyList();
            this.getServingPeer(null);
        }
        return true;
    }

    private Peer getRandomAPIPeer(List<Peer> list) {
        if (list.isEmpty()) {
            return null;
        }
        int n = ThreadLocalRandom.current().nextInt(list.size());
        return list.remove(n);
    }

    private static void storeBlacklistedPeer(String string, int n) {
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO blacklisted_open_api_nodes (host, unblacklist_time) KEY(host) VALUES(?, ?)");){
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private static void deleteBlacklistedPeers(int n) {
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM blacklisted_open_api_nodes WHERE unblacklist_time < ?");){
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private static void loadBlacklistedPeers(BiConsumer<String, Integer> biConsumer) {
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM blacklisted_open_api_nodes");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                biConsumer.accept(resultSet.getString("host"), resultSet.getInt("unblacklist_time"));
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    static {
        enableAPIProxy = Constants.isLightClient || Nxt.getBooleanProperty("nxt.enableAPIProxy") && !API.isOpenAPI;
        blacklistingPeriod = Nxt.getIntProperty("nxt.apiProxyBlacklistingPeriod");
        forcedServerURL = Nxt.getStringProperty("nxt.forceAPIProxyServerURL", "");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("getBlockchainStatus");
        hashSet.add("getState");
        EnumSet<APITag> enumSet = EnumSet.of(APITag.DEBUG, APITag.NETWORK);
        for (APIEnum aPIEnum : APIEnum.values()) {
            APIServlet.APIRequestHandler aPIRequestHandler = aPIEnum.getHandler();
            if (!aPIRequestHandler.requireBlockchain() || Collections.disjoint(aPIRequestHandler.getAPITags(), enumSet)) continue;
            hashSet.add(aPIEnum.getName());
        }
        NOT_FORWARDED_REQUESTS = Collections.unmodifiableSet(hashSet);
        peersUpdateThread = () -> {
            List<String> list;
            int n = Nxt.getEpochTime();
            boolean bl = APIProxy.getInstance().blacklistedPeers.entrySet().removeIf(entry -> {
                if ((Integer)entry.getValue() < n) {
                    Logger.logDebugMessage("Unblacklisting API peer " + (String)entry.getKey());
                    return true;
                }
                return false;
            });
            if (bl) {
                APIProxy.deleteBlacklistedPeers(n);
            }
            if ((list = APIProxy.getInstance().peersHosts) != null && Peers.isNetworkingEnabled()) {
                for (String string : list) {
                    Peer peer = Peers.getPeer(string);
                    if (peer == null) continue;
                    Peers.connectPeer(peer);
                }
            }
        };
        if (!Constants.isOffline && enableAPIProxy) {
            ThreadPool.scheduleThread("APIProxyPeersUpdate", peersUpdateThread, 60);
        }
    }
}

