/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Constants;
import nxt.Db;
import nxt.Nxt;
import nxt.NxtException;
import nxt.addons.AddOns;
import nxt.http.API;
import nxt.http.APIEnum;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class APIServlet
extends HttpServlet {
    private static final boolean enforcePost = Nxt.getBooleanProperty("nxt.apiServerEnforcePOST");
    private static final boolean fixResponseContentType = Nxt.getBooleanProperty("nxt.apiFixResponseContentType");
    static final Map<String, APIRequestHandler> apiRequestHandlers;
    static final Map<String, APIRequestHandler> disabledRequestHandlers;

    public static APIRequestHandler getAPIRequestHandler(String string) {
        return apiRequestHandlers.get(string);
    }

    static void initClass() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.process(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.process(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        if (fixResponseContentType) {
            httpServletResponse.setContentType("application/json");
        } else {
            httpServletResponse.setContentType("text/plain; charset=UTF-8");
        }
        JSONStreamAware jSONStreamAware = JSON.emptyJSON;
        long l = System.currentTimeMillis();
        try {
            long l2;
            if (!API.isAllowed(httpServletRequest.getRemoteHost())) {
                jSONStreamAware = JSONResponses.ERROR_NOT_ALLOWED;
                return;
            }
            String string = httpServletRequest.getParameter("requestType");
            if (string == null) {
                jSONStreamAware = JSONResponses.ERROR_INCORRECT_REQUEST;
                return;
            }
            object = apiRequestHandlers.get(string);
            if (object == null) {
                jSONStreamAware = disabledRequestHandlers.containsKey(string) ? JSONResponses.ERROR_DISABLED : JSONResponses.ERROR_INCORRECT_REQUEST;
                return;
            }
            if (Constants.isLightClient && ((APIRequestHandler)object).requireFullClient()) {
                jSONStreamAware = JSONResponses.LIGHT_CLIENT_DISABLED_API;
                return;
            }
            if (enforcePost && ((APIRequestHandler)object).requirePost() && !"POST".equals(httpServletRequest.getMethod())) {
                jSONStreamAware = JSONResponses.POST_REQUIRED;
                return;
            }
            if (((APIRequestHandler)object).requirePassword()) {
                API.verifyPassword(httpServletRequest);
            }
            long l3 = ((APIRequestHandler)object).allowRequiredBlockParameters() ? ParameterParser.getUnsignedLong(httpServletRequest, "requireBlock", false) : 0L;
            long l4 = l2 = ((APIRequestHandler)object).allowRequiredBlockParameters() ? ParameterParser.getUnsignedLong(httpServletRequest, "requireLastBlock", false) : 0L;
            if (l3 != 0L || l2 != 0L) {
                Nxt.getBlockchain().readLock();
            }
            try {
                try {
                    if (((APIRequestHandler)object).startDbTransaction()) {
                        Db.db.beginTransaction();
                    }
                    if (l3 != 0L && !Nxt.getBlockchain().hasBlock(l3)) {
                        jSONStreamAware = JSONResponses.REQUIRED_BLOCK_NOT_FOUND;
                        return;
                    }
                    if (l2 != 0L && l2 != Nxt.getBlockchain().getLastBlock().getId()) {
                        jSONStreamAware = JSONResponses.REQUIRED_LAST_BLOCK_NOT_FOUND;
                        return;
                    }
                    jSONStreamAware = ((APIRequestHandler)object).processRequest(httpServletRequest, httpServletResponse);
                    if (l2 == 0L && l3 != 0L && jSONStreamAware instanceof JSONObject) {
                        ((JSONObject)jSONStreamAware).put("lastBlock", Nxt.getBlockchain().getLastBlock().getStringId());
                    }
                }
                finally {
                    if (((APIRequestHandler)object).startDbTransaction()) {
                        Db.db.endTransaction();
                    }
                }
            }
            finally {
                if (l3 != 0L || l2 != 0L) {
                    Nxt.getBlockchain().readUnlock();
                }
            }
        }
        catch (ParameterException parameterException) {
            jSONStreamAware = parameterException.getErrorResponse();
        }
        catch (RuntimeException | NxtException exception) {
            Logger.logDebugMessage("Error processing API request", exception);
            object = new JSONObject();
            JSONData.putException((JSONObject)object, exception);
            jSONStreamAware = JSON.prepare((JSONObject)object);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            Logger.logErrorMessage("Initialization Error", exceptionInInitializerError.getCause());
            jSONStreamAware = JSONResponses.ERROR_INCORRECT_REQUEST;
        }
        catch (Exception exception) {
            Logger.logErrorMessage("Error processing request", exception);
            jSONStreamAware = JSONResponses.ERROR_INCORRECT_REQUEST;
        }
        finally {
            if (jSONStreamAware != null) {
                if (jSONStreamAware instanceof JSONObject) {
                    ((JSONObject)jSONStreamAware).put("requestProcessingTime", System.currentTimeMillis() - l);
                }
                try (PrintWriter printWriter = httpServletResponse.getWriter();){
                    JSON.writeJSONString(jSONStreamAware, printWriter);
                }
            }
        }
    }

    public static Map<String, APIRequestHandler> getAPIRequestHandlers() {
        return apiRequestHandlers;
    }

    static {
        HashMap<String, APIRequestHandler> hashMap = new HashMap<String, APIRequestHandler>();
        HashMap hashMap2 = new HashMap();
        for (APIEnum aPIEnum2 : APIEnum.values()) {
            if (aPIEnum2.getName().isEmpty() || aPIEnum2.getHandler() == null) continue;
            hashMap.put(aPIEnum2.getName(), aPIEnum2.getHandler());
        }
        AddOns.registerAPIRequestHandlers(hashMap);
        List<APIEnum> list = API.getDisabledApis();
        list.forEach(aPIEnum -> {
            APIRequestHandler aPIRequestHandler = (APIRequestHandler)hashMap.remove(aPIEnum.getName());
            if (aPIRequestHandler == null) {
                throw new RuntimeException("Invalid API in nxt.disabledAPIs: " + aPIEnum);
            }
            hashMap2.put(aPIEnum.getName(), aPIRequestHandler);
        });
        List<APITag> list2 = API.getDisabledApiTags();
        list2.forEach(aPITag -> {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((APIRequestHandler)entry.getValue()).getAPITags().contains(aPITag)) continue;
                hashMap2.put((String)entry.getKey(), (APIRequestHandler)entry.getValue());
                iterator.remove();
            }
        });
        if (!list.isEmpty()) {
            Logger.logInfoMessage("Disabled APIs: " + (List)list);
        }
        if (!list2.isEmpty()) {
            Logger.logInfoMessage("Disabled APITags: " + list2);
        }
        apiRequestHandlers = Collections.unmodifiableMap(hashMap);
        disabledRequestHandlers = hashMap2.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(hashMap2);
    }

    public static abstract class APIRequestHandler {
        private final List<String> parameters;
        private final String fileParameter;
        private final Set<APITag> apiTags;

        protected APIRequestHandler(APITag[] aPITagArray, String ... stringArray) {
            this(null, aPITagArray, stringArray);
        }

        protected APIRequestHandler(String string, APITag[] aPITagArray, String ... stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Collections.addAll(arrayList, stringArray);
            if ((this.requirePassword() || arrayList.contains("lastIndex")) && !API.disableAdminPassword) {
                arrayList.add("adminPassword");
            }
            if (this.allowRequiredBlockParameters()) {
                arrayList.add("requireBlock");
                arrayList.add("requireLastBlock");
            }
            this.parameters = Collections.unmodifiableList(arrayList);
            this.apiTags = Collections.unmodifiableSet(new HashSet<APITag>(Arrays.asList(aPITagArray)));
            this.fileParameter = string;
        }

        public final List<String> getParameters() {
            return this.parameters;
        }

        public final Set<APITag> getAPITags() {
            return this.apiTags;
        }

        public final String getFileParameter() {
            return this.fileParameter;
        }

        protected abstract JSONStreamAware processRequest(HttpServletRequest var1) throws NxtException;

        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NxtException {
            return this.processRequest(httpServletRequest);
        }

        protected boolean requirePost() {
            return false;
        }

        protected boolean startDbTransaction() {
            return false;
        }

        protected boolean requirePassword() {
            return false;
        }

        protected boolean allowRequiredBlockParameters() {
            return true;
        }

        protected boolean requireBlockchain() {
            return true;
        }

        protected boolean requireFullClient() {
            return false;
        }

        protected boolean isTextArea(String string) {
            return false;
        }

        protected boolean isPassword(String string) {
            return false;
        }
    }
}

