/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import nxt.Db;
import nxt.NxtException;
import nxt.db.TransactionalDb;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.util.CustomAPIResponse;
import org.json.simple.JSONStreamAware;

public class CountAccounts
extends APIServlet.APIRequestHandler {
    static final CountAccounts instance = new CountAccounts();
    protected static final TransactionalDb db = Db.db;

    private CountAccounts() {
        super(new APITag[]{APITag.ACCOUNTS}, "minUnconfirmedBalanceNQT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Long l = 0L;
        String string = httpServletRequest.getParameter("minUnconfirmedBalanceNQT");
        if (string != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterException(JSONResponses.INCORRECT_MIN_BALANCE);
            }
        }
        int n = -1;
        try (Connection connection = db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(DISTINCT ID) AS ACCOUNT_COUNT FROM ACCOUNT WHERE UNCONFIRMED_BALANCE > ?");){
            preparedStatement.setLong(1, l);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                resultSet.next();
                n = resultSet.getInt("ACCOUNT_COUNT");
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        return new CustomAPIResponse(n);
    }
}

