/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Appendix;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Search;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class DGSListing
extends CreateTransaction {
    static final DGSListing instance = new DGSListing();
    private static final JSONStreamAware MESSAGE_NOT_BINARY;
    private static final JSONStreamAware MESSAGE_NOT_IMAGE;

    private DGSListing() {
        super("messageFile", new APITag[]{APITag.DGS, APITag.CREATE_TRANSACTION}, "name", "description", "tags", "quantity", "priceNQT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        Object object2;
        String string = Convert.emptyToNull(httpServletRequest.getParameter("name"));
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("description"));
        String string3 = Convert.nullToEmpty(httpServletRequest.getParameter("tags"));
        long l = ParameterParser.getPriceNQT(httpServletRequest);
        int n = ParameterParser.getGoodsQuantity(httpServletRequest);
        if (string == null) {
            return JSONResponses.MISSING_NAME;
        }
        if ((string = string.trim()).length() > 100) {
            return JSONResponses.INCORRECT_DGS_LISTING_NAME;
        }
        if (string2.length() > 1000) {
            return JSONResponses.INCORRECT_DGS_LISTING_DESCRIPTION;
        }
        if (string3.length() > 100) {
            return JSONResponses.INCORRECT_DGS_LISTING_TAGS;
        }
        Appendix.PrunablePlainMessage prunablePlainMessage = (Appendix.PrunablePlainMessage)ParameterParser.getPlainMessage(httpServletRequest, true);
        if (prunablePlainMessage != null) {
            if (prunablePlainMessage.isText()) {
                return MESSAGE_NOT_BINARY;
            }
            object2 = prunablePlainMessage.getMessage();
            object = Search.detectMimeType((byte[])object2);
            if (object == null || !((String)object).startsWith("image/")) {
                return MESSAGE_NOT_IMAGE;
            }
        }
        object2 = ParameterParser.getSenderAccount(httpServletRequest);
        object = new Attachment.DigitalGoodsListing(string, string2, string3, n, l);
        return this.createTransaction(httpServletRequest, (Account)object2, (Attachment)object);
    }

    static {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Only binary message attachments accepted as DGS listing images");
        MESSAGE_NOT_BINARY = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 9);
        jSONObject.put("errorDescription", "Message attachment is not an image");
        MESSAGE_NOT_IMAGE = JSON.prepare(jSONObject);
    }
}

