/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Asset;
import nxt.Attachment;
import nxt.HoldingType;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public class DividendPayment
extends CreateTransaction {
    static final DividendPayment instance = new DividendPayment();

    private DividendPayment() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "holding", "holdingType", "asset", "height", "amountNQTPerQNT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n = ParameterParser.getHeight(httpServletRequest, true);
        long l = ParameterParser.getAmountNQTPerQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        if (Asset.getAsset(asset.getId(), n) == null) {
            return JSONResponses.ASSET_NOT_ISSUED_YET;
        }
        HoldingType holdingType = ParameterParser.getHoldingType(httpServletRequest);
        long l2 = holdingType != HoldingType.NXT ? ParameterParser.getHoldingId(httpServletRequest, holdingType) : 0L;
        Attachment.ColoredCoinsDividendPayment coloredCoinsDividendPayment = new Attachment.ColoredCoinsDividendPayment(l2, holdingType, asset.getId(), n, l);
        try {
            return this.createTransaction(httpServletRequest, account, coloredCoinsDividendPayment);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }
}

