/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Nxt;
import nxt.NxtException;
import nxt.PrunableMessage;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONStreamAware;

public final class DownloadPrunableMessage
extends APIServlet.APIRequestHandler {
    static final DownloadPrunableMessage instance = new DownloadPrunableMessage();

    private DownloadPrunableMessage() {
        super(new APITag[]{APITag.MESSAGES}, "transaction", "secretPhrase", "sharedKey", "retrieve", "save");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "transaction", true);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("retrieve"));
        PrunableMessage prunableMessage = PrunableMessage.getPrunableMessage(l);
        if (prunableMessage == null && bl) {
            if (Nxt.getBlockchainProcessor().restorePrunedTransaction(l) == null) {
                return JSONResponses.PRUNED_TRANSACTION;
            }
            prunableMessage = PrunableMessage.getPrunableMessage(l);
        }
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "sharedKey", false);
        if (byArray.length != 0 && string != null) {
            return JSONResponses.either("secretPhrase", "sharedKey");
        }
        byte[] byArray2 = null;
        if (prunableMessage != null) {
            try {
                byArray2 = string != null ? prunableMessage.decrypt(string) : (byArray.length > 0 ? prunableMessage.decrypt(byArray) : prunableMessage.getMessage());
            }
            catch (RuntimeException runtimeException) {
                Logger.logDebugMessage("Decryption of message to recipient failed: " + runtimeException.toString());
                return JSONResponses.error("Wrong secretPhrase or sharedKey");
            }
        }
        if (byArray2 == null) {
            byArray2 = Convert.EMPTY_BYTE;
        }
        String string2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("save")) ? "attachment" : "inline";
        httpServletResponse.setHeader("Content-Disposition", string2 + "; filename=" + Long.toUnsignedString(l));
        httpServletResponse.setContentLength(byArray2.length);
        try (ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();){
            try {
                servletOutputStream.write(byArray2);
            }
            catch (IOException iOException) {
                throw new ParameterException(JSONResponses.RESPONSE_WRITE_ERROR);
            }
        }
        catch (IOException iOException) {
            throw new ParameterException(JSONResponses.RESPONSE_STREAM_ERROR);
        }
        return null;
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        throw new UnsupportedOperationException();
    }
}

