/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.AccountLedger;
import nxt.Block;
import nxt.BlockchainProcessor;
import nxt.Db;
import nxt.Nxt;
import nxt.Transaction;
import nxt.TransactionProcessor;
import nxt.db.TransactionalDb;
import nxt.http.EventWait;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class EventListener
implements Runnable,
AsyncListener,
TransactionalDb.TransactionCallback {
    static final int maxEventUsers = Nxt.getIntProperty("nxt.apiMaxEventUsers");
    static final int eventTimeout = Math.max(Nxt.getIntProperty("nxt.apiEventTimeout"), 15);
    static final BlockchainProcessor blockchainProcessor = Nxt.getBlockchainProcessor();
    static final TransactionProcessor transactionProcessor = Nxt.getTransactionProcessor();
    static final Map<String, EventListener> eventListeners = new ConcurrentHashMap<String, EventListener>();
    private static final Timer eventTimer = new Timer();
    private static final ExecutorService threadPool;
    static final List<Peers.Event> peerEvents;
    static final List<BlockchainProcessor.Event> blockEvents;
    static final List<TransactionProcessor.Event> txEvents;
    static final List<AccountLedger.Event> ledgerEvents;
    private final String address;
    private long timestamp;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean deactivated;
    private boolean aborted;
    private boolean dispatched;
    private final List<NxtEventListener> nxtEventListeners = new ArrayList<NxtEventListener>();
    private final List<PendingEvent> pendingEvents = new ArrayList<PendingEvent>();
    private final List<PendingEvent> dbEvents = new ArrayList<PendingEvent>();
    private final List<AsyncContext> pendingWaits = new ArrayList<AsyncContext>();

    EventListener(String string) {
        this.address = string;
    }

    void activateListener(List<EventRegistration> list) throws EventListenerException {
        if (this.deactivated) {
            throw new EventListenerException("Event listener deactivated");
        }
        if (eventListeners.size() >= maxEventUsers && eventListeners.get(this.address) == null) {
            throw new EventListenerException(String.format("Too many API event users: Maximum %d", maxEventUsers));
        }
        this.addEvents(list);
        EventListener eventListener = eventListeners.put(this.address, this);
        if (eventListener != null) {
            eventListener.deactivateListener();
        }
        Logger.logDebugMessage(String.format("Event listener activated for %s", this.address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvents(List<EventRegistration> list) throws EventListenerException {
        this.lock.lock();
        try {
            if (this.deactivated) {
                return;
            }
            for (EventRegistration eventRegistration : list) {
                NxtEventListener nxtEventListener;
                boolean bl = true;
                Iterator<NxtEventListener> iterator = this.nxtEventListeners.iterator();
                while (iterator.hasNext()) {
                    nxtEventListener = iterator.next();
                    if (nxtEventListener.getEvent() != eventRegistration.getEvent()) continue;
                    long l = nxtEventListener.getAccountId();
                    if (l == eventRegistration.getAccountId() || l == 0L) {
                        bl = false;
                        break;
                    }
                    if (eventRegistration.getAccountId() != 0L) continue;
                    nxtEventListener.removeListener();
                    iterator.remove();
                }
                if (!bl) continue;
                nxtEventListener = new NxtEventListener(eventRegistration);
                nxtEventListener.addListener();
                this.nxtEventListeners.add(nxtEventListener);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEvents(List<EventRegistration> list) {
        this.lock.lock();
        try {
            if (this.deactivated) {
                return;
            }
            for (EventRegistration eventRegistration : list) {
                Iterator<NxtEventListener> iterator = this.nxtEventListeners.iterator();
                while (iterator.hasNext()) {
                    NxtEventListener nxtEventListener = iterator.next();
                    if (nxtEventListener.getEvent() != eventRegistration.getEvent() || nxtEventListener.getAccountId() != eventRegistration.getAccountId() && eventRegistration.getAccountId() != 0L) continue;
                    nxtEventListener.removeListener();
                    iterator.remove();
                }
            }
            if (this.nxtEventListeners.isEmpty()) {
                this.deactivateListener();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void deactivateListener() {
        this.lock.lock();
        try {
            if (this.deactivated) {
                return;
            }
            this.deactivated = true;
            if (!this.pendingWaits.isEmpty() && !this.dispatched) {
                this.dispatched = true;
                threadPool.submit(this);
            }
            eventListeners.remove(this.address);
            this.nxtEventListeners.forEach(NxtEventListener::removeListener);
        }
        finally {
            this.lock.unlock();
        }
        Logger.logDebugMessage(String.format("Event listener deactivated for %s", this.address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<PendingEvent> eventWait(HttpServletRequest httpServletRequest, long l) throws EventListenerException {
        ArrayList<PendingEvent> arrayList = null;
        this.lock.lock();
        try {
            if (this.deactivated) {
                throw new EventListenerException("Event listener deactivated");
            }
            if (!this.pendingWaits.isEmpty()) {
                this.aborted = true;
                if (!this.dispatched) {
                    this.dispatched = true;
                    threadPool.submit(this);
                }
                AsyncContext asyncContext = httpServletRequest.startAsync();
                asyncContext.addListener((AsyncListener)this);
                asyncContext.setTimeout(l * 1000L);
                this.pendingWaits.add(asyncContext);
            } else if (!this.pendingEvents.isEmpty()) {
                arrayList = new ArrayList<PendingEvent>(this.pendingEvents);
                this.pendingEvents.clear();
                this.timestamp = System.currentTimeMillis();
            } else {
                this.aborted = false;
                AsyncContext asyncContext = httpServletRequest.startAsync();
                asyncContext.addListener((AsyncListener)this);
                asyncContext.setTimeout(l * 1000L);
                this.pendingWaits.add(asyncContext);
                this.timestamp = System.currentTimeMillis();
            }
        }
        finally {
            this.lock.unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lock.lock();
        try {
            this.dispatched = false;
            while (!this.pendingWaits.isEmpty() && (this.aborted || this.deactivated || !this.pendingEvents.isEmpty())) {
                AsyncContext asyncContext = this.pendingWaits.remove(0);
                ArrayList<PendingEvent> arrayList = new ArrayList<PendingEvent>();
                if (!this.aborted && !this.deactivated) {
                    arrayList.addAll(this.pendingEvents);
                    this.pendingEvents.clear();
                }
                HttpServletResponse httpServletResponse = (HttpServletResponse)asyncContext.getResponse();
                JSONObject jSONObject = EventWait.formatResponse(arrayList);
                jSONObject.put("requestProcessingTime", System.currentTimeMillis() - this.timestamp);
                try (PrintWriter printWriter = httpServletResponse.getWriter();){
                    jSONObject.writeJSONString(printWriter);
                }
                catch (IOException iOException) {
                    Logger.logDebugMessage(String.format("Unable to return API response to %s: %s", this.address, iOException.toString()));
                }
                asyncContext.complete();
                this.aborted = false;
                this.timestamp = System.currentTimeMillis();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    long getTimestamp() {
        return this.timestamp;
    }

    public void onComplete(AsyncEvent asyncEvent) {
    }

    public void onError(AsyncEvent asyncEvent) {
        AsyncContext asyncContext = asyncEvent.getAsyncContext();
        this.lock.lock();
        try {
            this.pendingWaits.remove(asyncContext);
            asyncContext.complete();
            this.timestamp = System.currentTimeMillis();
            Logger.logDebugMessage("Error detected during event wait for " + this.address, asyncEvent.getThrowable());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onStartAsync(AsyncEvent asyncEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimeout(AsyncEvent asyncEvent) {
        AsyncContext asyncContext = asyncEvent.getAsyncContext();
        this.lock.lock();
        try {
            this.pendingWaits.remove(asyncContext);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("events", new JSONArray());
            jSONObject.put("requestProcessingTime", System.currentTimeMillis() - this.timestamp);
            try (PrintWriter printWriter = asyncContext.getResponse().getWriter();){
                jSONObject.writeJSONString(printWriter);
            }
            catch (IOException iOException) {
                Logger.logDebugMessage(String.format("Unable to return API response to %s: %s", this.address, iOException.toString()));
            }
            asyncContext.complete();
            this.timestamp = System.currentTimeMillis();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        Thread thread = Thread.currentThread();
        this.lock.lock();
        try {
            Iterator<PendingEvent> iterator = this.dbEvents.iterator();
            while (iterator.hasNext()) {
                PendingEvent pendingEvent = iterator.next();
                if (pendingEvent.getThread() != thread) continue;
                iterator.remove();
                this.pendingEvents.add(pendingEvent);
                if (this.pendingWaits.isEmpty() || this.dispatched) continue;
                this.dispatched = true;
                threadPool.submit(this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void rollback() {
        Thread thread = Thread.currentThread();
        this.lock.lock();
        try {
            this.dbEvents.removeIf(pendingEvent -> pendingEvent.getThread() == thread);
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        eventTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                long l = System.currentTimeMillis() - (long)(eventTimeout * 1000);
                eventListeners.values().forEach(eventListener -> {
                    if (eventListener.getTimestamp() < l) {
                        eventListener.deactivateListener();
                    }
                });
            }
        }, eventTimeout * 1000 / 2, (long)(eventTimeout * 1000 / 2));
        threadPool = Executors.newCachedThreadPool();
        peerEvents = new ArrayList<Peers.Event>();
        peerEvents.add(Peers.Event.ADD_INBOUND);
        peerEvents.add(Peers.Event.ADDED_ACTIVE_PEER);
        peerEvents.add(Peers.Event.BLACKLIST);
        peerEvents.add(Peers.Event.CHANGED_ACTIVE_PEER);
        peerEvents.add(Peers.Event.DEACTIVATE);
        peerEvents.add(Peers.Event.NEW_PEER);
        peerEvents.add(Peers.Event.REMOVE);
        peerEvents.add(Peers.Event.REMOVE_INBOUND);
        peerEvents.add(Peers.Event.UNBLACKLIST);
        blockEvents = new ArrayList<BlockchainProcessor.Event>();
        blockEvents.add(BlockchainProcessor.Event.BLOCK_GENERATED);
        blockEvents.add(BlockchainProcessor.Event.BLOCK_POPPED);
        blockEvents.add(BlockchainProcessor.Event.BLOCK_PUSHED);
        txEvents = new ArrayList<TransactionProcessor.Event>();
        txEvents.add(TransactionProcessor.Event.ADDED_CONFIRMED_TRANSACTIONS);
        txEvents.add(TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
        txEvents.add(TransactionProcessor.Event.REJECT_PHASED_TRANSACTION);
        txEvents.add(TransactionProcessor.Event.RELEASE_PHASED_TRANSACTION);
        txEvents.add(TransactionProcessor.Event.REMOVED_UNCONFIRMED_TRANSACTIONS);
        ledgerEvents = new ArrayList<AccountLedger.Event>();
        ledgerEvents.add(AccountLedger.Event.ADD_ENTRY);
    }

    static class EventListenerException
    extends Exception {
        public EventListenerException(String string) {
            super(string);
        }

        public EventListenerException(String string, Exception exception) {
            super(string, exception);
        }
    }

    static class EventRegistration {
        private final Enum<? extends Enum> event;
        private final long accountId;

        EventRegistration(Enum<? extends Enum> enum_, long l) {
            this.event = enum_;
            this.accountId = l;
        }

        public Enum<? extends Enum> getEvent() {
            return this.event;
        }

        public long getAccountId() {
            return this.accountId;
        }
    }

    private class NxtEventListener {
        private final NxtEventHandler eventHandler;

        public NxtEventListener(EventRegistration eventRegistration) throws EventListenerException {
            Enum<? extends Enum> enum_ = eventRegistration.getEvent();
            if (enum_ instanceof Peers.Event) {
                this.eventHandler = new PeerEventHandler(eventRegistration);
            } else if (enum_ instanceof BlockchainProcessor.Event) {
                this.eventHandler = new BlockEventHandler(eventRegistration);
            } else if (enum_ instanceof TransactionProcessor.Event) {
                this.eventHandler = new TransactionEventHandler(eventRegistration);
            } else if (enum_ instanceof AccountLedger.Event) {
                this.eventHandler = new LedgerEventHandler(eventRegistration);
            } else {
                throw new EventListenerException("Unsupported listener event");
            }
        }

        public Enum<? extends Enum> getEvent() {
            return this.eventHandler.getEvent();
        }

        public long getAccountId() {
            return this.eventHandler.getAccountId();
        }

        public void addListener() {
            this.eventHandler.addListener();
        }

        public void removeListener() {
            this.eventHandler.removeListener();
        }

        public int hashCode() {
            return this.eventHandler.hashCode();
        }

        public boolean equals(Object object) {
            return object != null && object instanceof NxtEventListener && this.eventHandler.equals(((NxtEventListener)object).eventHandler);
        }

        private class LedgerEventHandler
        extends NxtEventHandler
        implements Listener<AccountLedger.LedgerEntry> {
            public LedgerEventHandler(EventRegistration eventRegistration) {
                super(eventRegistration);
            }

            @Override
            public void addListener() {
                AccountLedger.addListener(this, (AccountLedger.Event)this.event);
            }

            @Override
            public void removeListener() {
                AccountLedger.removeListener(this, (AccountLedger.Event)this.event);
            }

            @Override
            public void notify(AccountLedger.LedgerEntry ledgerEntry) {
                if (ledgerEntry.getAccountId() == this.accountId || this.accountId == 0L) {
                    this.dispatch(new PendingEvent(String.format("Ledger.%s.%s", this.event.name(), Convert.rsAccount(ledgerEntry.getAccountId())), Long.toUnsignedString(ledgerEntry.getLedgerId())));
                }
            }
        }

        private class TransactionEventHandler
        extends NxtEventHandler
        implements Listener<List<? extends Transaction>> {
            public TransactionEventHandler(EventRegistration eventRegistration) {
                super(eventRegistration);
            }

            @Override
            public void addListener() {
                transactionProcessor.addListener(this, (TransactionProcessor.Event)this.event);
            }

            @Override
            public void removeListener() {
                transactionProcessor.removeListener(this, (TransactionProcessor.Event)this.event);
            }

            @Override
            public void notify(List<? extends Transaction> list) {
                ArrayList<String> arrayList = new ArrayList<String>();
                list.forEach(transaction -> arrayList.add(transaction.getStringId()));
                this.dispatch(new PendingEvent("Transaction." + this.event.name(), arrayList));
            }
        }

        private class BlockEventHandler
        extends NxtEventHandler
        implements Listener<Block> {
            public BlockEventHandler(EventRegistration eventRegistration) {
                super(eventRegistration);
            }

            @Override
            public void addListener() {
                blockchainProcessor.addListener(this, (BlockchainProcessor.Event)this.event);
            }

            @Override
            public void removeListener() {
                blockchainProcessor.removeListener(this, (BlockchainProcessor.Event)this.event);
            }

            @Override
            public void notify(Block block) {
                this.dispatch(new PendingEvent("Block." + this.event.name(), block.getStringId()));
            }
        }

        private class PeerEventHandler
        extends NxtEventHandler
        implements Listener<Peer> {
            public PeerEventHandler(EventRegistration eventRegistration) {
                super(eventRegistration);
            }

            @Override
            public void addListener() {
                Peers.addListener(this, (Peers.Event)this.event);
            }

            @Override
            public void removeListener() {
                Peers.removeListener(this, (Peers.Event)this.event);
            }

            @Override
            public void notify(Peer peer) {
                this.dispatch(new PendingEvent("Peer." + this.event.name(), peer.getHost()));
            }

            @Override
            protected boolean waitTransaction() {
                return false;
            }
        }

        private abstract class NxtEventHandler {
            protected final EventListener owner;
            protected final long accountId;
            protected final Enum<? extends Enum> event;

            public NxtEventHandler(EventRegistration eventRegistration) {
                this.owner = EventListener.this;
                this.accountId = eventRegistration.getAccountId();
                this.event = eventRegistration.getEvent();
            }

            public Enum<? extends Enum> getEvent() {
                return this.event;
            }

            public long getAccountId() {
                return this.accountId;
            }

            public abstract void addListener();

            public abstract void removeListener();

            protected boolean waitTransaction() {
                return true;
            }

            protected void dispatch(PendingEvent pendingEvent) {
                EventListener.this.lock.lock();
                try {
                    if (this.waitTransaction() && Db.db.isInTransaction()) {
                        pendingEvent.setThread(Thread.currentThread());
                        EventListener.this.dbEvents.add(pendingEvent);
                        Db.db.registerCallback(this.owner);
                    } else {
                        EventListener.this.pendingEvents.add(pendingEvent);
                        if (!EventListener.this.pendingWaits.isEmpty() && !EventListener.this.dispatched) {
                            EventListener.this.dispatched = true;
                            threadPool.submit(this.owner);
                        }
                    }
                }
                finally {
                    EventListener.this.lock.unlock();
                }
            }

            public int hashCode() {
                return this.event.hashCode();
            }

            public boolean equals(Object object) {
                return object != null && object instanceof NxtEventHandler && this.owner == ((NxtEventHandler)object).owner && this.accountId == ((NxtEventHandler)object).accountId && this.event == ((NxtEventHandler)object).event;
            }
        }
    }

    static class PendingEvent {
        private final String name;
        private final String id;
        private final List<String> idList;
        private Thread thread;

        public PendingEvent(String string, String string2) {
            this.name = string;
            this.id = string2;
            this.idList = null;
        }

        public PendingEvent(String string, List<String> list) {
            this.name = string;
            this.idList = list;
            this.id = null;
        }

        public String getName() {
            return this.name;
        }

        public boolean isList() {
            return this.idList != null;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getIdList() {
            return this.idList;
        }

        public Thread getThread() {
            return this.thread;
        }

        public void setThread(Thread thread) {
            this.thread = thread;
        }
    }
}

