/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.EventListener;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class EventWait
extends APIServlet.APIRequestHandler {
    static final EventWait instance = new EventWait();
    private static final JSONObject incorrectTimeout = new JSONObject();
    private static final JSONObject noEventsRegistered;

    private EventWait() {
        super(new APITag[]{APITag.INFO}, "timeout");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        JSONObject jSONObject = null;
        long l = EventListener.eventTimeout;
        String string = httpServletRequest.getParameter("timeout");
        if (string != null) {
            try {
                l = Math.min(Long.valueOf(string), l);
            }
            catch (NumberFormatException numberFormatException) {
                jSONObject = incorrectTimeout;
            }
        }
        if (jSONObject == null) {
            EventListener eventListener = EventListener.eventListeners.get(httpServletRequest.getRemoteAddr());
            if (eventListener == null) {
                jSONObject = noEventsRegistered;
            } else {
                try {
                    List<EventListener.PendingEvent> list = eventListener.eventWait(httpServletRequest, l);
                    if (list != null) {
                        jSONObject = EventWait.formatResponse(list);
                    }
                }
                catch (EventListener.EventListenerException eventListenerException) {
                    jSONObject = new JSONObject();
                    jSONObject.put("errorCode", 7);
                    jSONObject.put("errorDescription", "Unable to wait for an event: " + eventListenerException.getMessage());
                }
            }
        }
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    static JSONObject formatResponse(List<EventListener.PendingEvent> list) {
        JSONArray jSONArray = new JSONArray();
        list.forEach(pendingEvent -> {
            JSONArray jSONArray2 = new JSONArray();
            if (pendingEvent.isList()) {
                jSONArray2.addAll(pendingEvent.getIdList());
            } else {
                jSONArray2.add(pendingEvent.getId());
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("name", pendingEvent.getName());
            jSONObject.put("ids", jSONArray2);
            jSONArray.add(jSONObject);
        });
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("events", jSONArray);
        return jSONObject;
    }

    static {
        incorrectTimeout.put("errorCode", 4);
        incorrectTimeout.put("errorDescription", "Wait timeout is not valid");
        noEventsRegistered = new JSONObject();
        noEventsRegistered.put("errorCode", 8);
        noEventsRegistered.put("errorDescription", "No events registered");
    }
}

