/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.NxtException;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAccount
extends APIServlet.APIRequestHandler {
    static final GetAccount instance = new GetAccount();

    private GetAccount() {
        super(new APITag[]{APITag.ACCOUNTS}, "account", "includeLessors", "includeAssets", "includeCurrencies", "includeEffectiveBalance");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        Object object2;
        JSONArray jSONArray;
        JSONArray jSONArray2;
        Iterable<Object> iterable;
        Account.AccountLease accountLease;
        Account.AccountInfo accountInfo;
        Account account = ParameterParser.getAccount(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeLessors"));
        boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeAssets"));
        boolean bl3 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCurrencies"));
        boolean bl4 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeEffectiveBalance"));
        JSONObject jSONObject = JSONData.accountBalance(account, bl4);
        JSONData.putAccount(jSONObject, "account", account.getId());
        byte[] byArray = Account.getPublicKey(account.getId());
        if (byArray != null) {
            jSONObject.put("publicKey", Convert.toHexString(byArray));
        }
        if ((accountInfo = account.getAccountInfo()) != null) {
            jSONObject.put("name", Convert.nullToEmpty(accountInfo.getName()));
            jSONObject.put("description", Convert.nullToEmpty(accountInfo.getDescription()));
        }
        if ((accountLease = account.getAccountLease()) != null) {
            JSONData.putAccount(jSONObject, "currentLessee", accountLease.getCurrentLesseeId());
            jSONObject.put("currentLeasingHeightFrom", accountLease.getCurrentLeasingHeightFrom());
            jSONObject.put("currentLeasingHeightTo", accountLease.getCurrentLeasingHeightTo());
            if (accountLease.getNextLesseeId() != 0L) {
                JSONData.putAccount(jSONObject, "nextLessee", accountLease.getNextLesseeId());
                jSONObject.put("nextLeasingHeightFrom", accountLease.getNextLeasingHeightFrom());
                jSONObject.put("nextLeasingHeightTo", accountLease.getNextLeasingHeightTo());
            }
        }
        if (!account.getControls().isEmpty()) {
            iterable = new JSONArray();
            account.getControls().forEach(arg_0 -> GetAccount.lambda$processRequest$0((JSONArray)iterable, arg_0));
            jSONObject.put("accountControls", iterable);
        }
        if (bl) {
            iterable = account.getLessors();
            try {
                if (((DbIterator)iterable).hasNext()) {
                    jSONArray2 = new JSONArray();
                    jSONArray = new JSONArray();
                    object2 = new JSONArray();
                    while (((DbIterator)iterable).hasNext()) {
                        object = (Account)((DbIterator)iterable).next();
                        jSONArray2.add(Long.toUnsignedString(((Account)object).getId()));
                        jSONArray.add(Convert.rsAccount(((Account)object).getId()));
                        ((ArrayList)object2).add(JSONData.lessor((Account)object, bl4));
                    }
                    jSONObject.put("lessors", jSONArray2);
                    jSONObject.put("lessorsRS", jSONArray);
                    jSONObject.put("lessorsInfo", object2);
                }
            }
            finally {
                if (iterable != null) {
                    ((DbIterator)iterable).close();
                }
            }
        }
        if (bl2) {
            iterable = account.getAssets(0, -1);
            try {
                jSONArray2 = new JSONArray();
                jSONArray = new JSONArray();
                while (((DbIterator)iterable).hasNext()) {
                    object2 = (Account.AccountAsset)((DbIterator)iterable).next();
                    object = new JSONObject();
                    ((HashMap)object).put("asset", Long.toUnsignedString(((Account.AccountAsset)object2).getAssetId()));
                    ((HashMap)object).put("balanceQNT", String.valueOf(((Account.AccountAsset)object2).getQuantityQNT()));
                    jSONArray2.add(object);
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("asset", Long.toUnsignedString(((Account.AccountAsset)object2).getAssetId()));
                    jSONObject2.put("unconfirmedBalanceQNT", String.valueOf(((Account.AccountAsset)object2).getUnconfirmedQuantityQNT()));
                    jSONArray.add(jSONObject2);
                }
                if (jSONArray2.size() > 0) {
                    jSONObject.put("assetBalances", jSONArray2);
                }
                if (jSONArray.size() > 0) {
                    jSONObject.put("unconfirmedAssetBalances", jSONArray);
                }
            }
            finally {
                if (iterable != null) {
                    ((DbIterator)iterable).close();
                }
            }
        }
        if (bl3) {
            iterable = account.getCurrencies(0, -1);
            try {
                jSONArray2 = new JSONArray();
                while (((DbIterator)iterable).hasNext()) {
                    jSONArray2.add(JSONData.accountCurrency((Account.AccountCurrency)((DbIterator)iterable).next(), false, true));
                }
                if (jSONArray2.size() > 0) {
                    jSONObject.put("accountCurrencies", jSONArray2);
                }
            }
            finally {
                if (iterable != null) {
                    ((DbIterator)iterable).close();
                }
            }
        }
        return jSONObject;
    }

    private static /* synthetic */ void lambda$processRequest$0(JSONArray jSONArray, Account.ControlType controlType) {
        jSONArray.add(controlType.toString());
    }
}

