/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.NxtException;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.JSON;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAccountCurrencies
extends APIServlet.APIRequestHandler {
    static final GetAccountCurrencies instance = new GetAccountCurrencies();

    private GetAccountCurrencies() {
        super(new APITag[]{APITag.ACCOUNTS, APITag.MS}, "account", "currency", "height", "includeCurrencyInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, true);
        int n = ParameterParser.getHeight(httpServletRequest);
        long l2 = ParameterParser.getUnsignedLong(httpServletRequest, "currency", false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCurrencyInfo"));
        if (l2 == 0L) {
            JSONObject jSONObject = new JSONObject();
            try (DbIterator<Account.AccountCurrency> dbIterator = Account.getAccountCurrencies(l, n, 0, -1);){
                JSONArray jSONArray = new JSONArray();
                while (dbIterator.hasNext()) {
                    jSONArray.add(JSONData.accountCurrency(dbIterator.next(), false, bl));
                }
                jSONObject.put("accountCurrencies", jSONArray);
                JSONObject jSONObject2 = jSONObject;
                return jSONObject2;
            }
        }
        Account.AccountCurrency accountCurrency = Account.getAccountCurrency(l, l2, n);
        if (accountCurrency != null) {
            return JSONData.accountCurrency(accountCurrency, false, bl);
        }
        return JSON.emptyJSON;
    }
}

