/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import nxt.Db;
import nxt.crypto.Crypto;
import nxt.db.TransactionalDb;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetAccountsBulk
extends APIServlet.APIRequestHandler {
    static final GetAccountsBulk instance = new GetAccountsBulk();
    protected static final TransactionalDb db = Db.db;

    private GetAccountsBulk() {
        super(new APITag[]{APITag.ACCOUNTS}, "minBalanceNQT", "pageSize", "page", "includeDescription", "includeEffectiveBalance");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        boolean bl;
        boolean bl2;
        long l;
        int n;
        int n2;
        try {
            n2 = Integer.parseInt(httpServletRequest.getParameter("pageSize"));
            if (n2 < 1 || n2 > 100) {
                throw new ParameterException(JSONResponses.INCORRECT_PAGE_SIZE);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterException(JSONResponses.INCORRECT_PAGE_SIZE);
        }
        try {
            n = Integer.parseInt(httpServletRequest.getParameter("page"));
            if (n < 0) {
                throw new ParameterException(JSONResponses.INCORRECT_PAGE_SIZE);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterException(JSONResponses.INCORRECT_PAGE);
        }
        try {
            l = Long.parseLong(httpServletRequest.getParameter("minBalanceNQT"));
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        try {
            bl2 = Boolean.parseBoolean(httpServletRequest.getParameter("includeDescription"));
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = false;
        }
        try {
            bl = Boolean.parseBoolean(httpServletRequest.getParameter("includeEffectiveBalance"));
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        JSONObject jSONObject = new JSONObject();
        try (Connection connection = db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT ID,UNCONFIRMED_BALANCE,ACCOUNT.LATEST,FORGED_BALANCE,ACTIVE_LESSEE_ID,ACCOUNT.HEIGHT" + (bl2 ? ",NAME,DESCRIPTION " : " ") + (bl ? ",BALANCE " : " ") + "FROM ACCOUNT " + (bl2 ? "LEFT JOIN ACCOUNT_INFO ON ACCOUNT.ID = ACCOUNT_INFO.ACCOUNT_ID " : "") + "WHERE ACCOUNT.LATEST=TRUE AND UNCONFIRMED_BALANCE >= ? ORDER BY UNCONFIRMED_BALANCE DESC OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");){
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, n * n2);
            preparedStatement.setInt(3, n2);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                JSONArray jSONArray = new JSONArray();
                while (resultSet.next()) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("ID", "GMD-" + Crypto.rsEncode(resultSet.getLong("ID")));
                    jSONObject2.put("UNCONFIRMED_BALANCE", resultSet.getLong("UNCONFIRMED_BALANCE"));
                    jSONObject2.put("FORGED_BALANCE", resultSet.getLong("FORGED_BALANCE"));
                    Long l2 = resultSet.getLong("ACTIVE_LESSEE_ID");
                    if (l2 != 0L) {
                        jSONObject2.put("ACTIVE_LESSEE_ID", "GMD-" + Crypto.rsEncode(l2));
                    }
                    jSONObject2.put("HEIGHT", resultSet.getLong("ACCOUNT.HEIGHT"));
                    if (bl2) {
                        String string = resultSet.getString("NAME");
                        String string2 = resultSet.getString("DESCRIPTION");
                        if (string != null) {
                            jSONObject2.put("NAME", string);
                        }
                        if (string2 != null) {
                            jSONObject2.put("DESCRIPTION", string);
                        }
                    }
                    if (bl) {
                        jSONObject2.put("EFFECTIVE_BALANCE", resultSet.getLong("BALANCE"));
                    }
                    jSONArray.add(jSONObject2);
                }
                jSONObject.put("Accounts", jSONArray);
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        return jSONObject;
    }
}

