/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Alias;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAliasesLike
extends APIServlet.APIRequestHandler {
    static final GetAliasesLike instance = new GetAliasesLike();

    private GetAliasesLike() {
        super(new APITag[]{APITag.ALIASES, APITag.SEARCH}, "aliasPrefix", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        String string = Convert.emptyToNull(httpServletRequest.getParameter("aliasPrefix"));
        if (string == null) {
            return JSONResponses.missing("aliasPrefix");
        }
        if (string.length() < 2) {
            return JSONResponses.incorrect("aliasPrefix", "aliasPrefix must be at least 2 characters long");
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put("aliases", jSONArray);
        try (DbIterator<Alias> dbIterator = Alias.getAliasesLike(string, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add(JSONData.alias(dbIterator.next()));
            }
        }
        return jSONObject;
    }
}

