/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.Trade;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAllTrades
extends APIServlet.APIRequestHandler {
    static final GetAllTrades instance = new GetAllTrades();

    private GetAllTrades() {
        super(new APITag[]{APITag.AE}, "timestamp", "firstIndex", "lastIndex", "includeAssetInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n = ParameterParser.getTimestamp(httpServletRequest);
        int n2 = ParameterParser.getFirstIndex(httpServletRequest);
        int n3 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeAssetInfo"));
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<Trade> dbIterator = Trade.getAllTrades(n2, n3);){
            while (dbIterator.hasNext()) {
                Trade trade = dbIterator.next();
                if (trade.getTimestamp() < n) {
                    break;
                }
                jSONArray.add(JSONData.trade(trade, bl));
            }
        }
        jSONObject.put("trades", jSONArray);
        return jSONObject;
    }
}

