/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.AssetHistory;
import nxt.NxtException;
import nxt.db.DbIterator;
import nxt.db.DbUtils;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAssetHistory
extends APIServlet.APIRequestHandler {
    static final GetAssetHistory instance = new GetAssetHistory();

    private GetAssetHistory() {
        super(new APITag[]{APITag.AE}, "asset", "account", "firstIndex", "lastIndex", "timestamp", "includeAssetInfo", "deletesOnly", "increasesOnly");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, false);
        if (l == 0L && l2 == 0L) {
            return JSONResponses.MISSING_ASSET_ACCOUNT;
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("deletesOnly"));
        boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("increasesOnly"));
        if (bl && bl2) {
            return JSONResponses.either("deletesOnly", "increasesOnly");
        }
        Query query = Query.get(bl, bl2);
        int n = ParameterParser.getTimestamp(httpServletRequest);
        int n2 = ParameterParser.getFirstIndex(httpServletRequest);
        int n3 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl3 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeAssetInfo"));
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        DbIterator<AssetHistory> dbIterator = null;
        try {
            AssetHistory assetHistory;
            dbIterator = query.getAssetHistories(l, l2, n2, n3);
            while (dbIterator.hasNext() && (assetHistory = dbIterator.next()).getTimestamp() >= n) {
                jSONArray.add(JSONData.assetHistory(assetHistory, bl3));
            }
        }
        catch (Throwable throwable) {
            DbUtils.close(dbIterator);
            throw throwable;
        }
        DbUtils.close(dbIterator);
        jSONObject.put("assetHistory", jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean startDbTransaction() {
        return true;
    }

    static enum Query {
        DELETE_ONLY{

            @Override
            DbIterator<AssetHistory> getAssetHistories(long l, long l2, int n, int n2) {
                if (l2 == 0L) {
                    return AssetHistory.getAssetDeletes(l, n, n2);
                }
                if (l == 0L) {
                    return AssetHistory.getAccountAssetDeletes(l2, n, n2);
                }
                return AssetHistory.getAccountAssetDeletes(l2, l, n, n2);
            }
        }
        ,
        INCREASE_ONLY{

            @Override
            DbIterator<AssetHistory> getAssetHistories(long l, long l2, int n, int n2) {
                if (l2 == 0L) {
                    return AssetHistory.getAssetIncreases(l, n, n2);
                }
                if (l == 0L) {
                    return AssetHistory.getAccountAssetIncreases(l2, n, n2);
                }
                return AssetHistory.getAccountAssetIncreases(l2, l, n, n2);
            }
        }
        ,
        ALL{

            @Override
            DbIterator<AssetHistory> getAssetHistories(long l, long l2, int n, int n2) {
                if (l2 == 0L) {
                    return AssetHistory.getAssetHistory(l, n, n2);
                }
                if (l == 0L) {
                    return AssetHistory.getAccountAssetHistory(l2, n, n2);
                }
                return AssetHistory.getAccountAssetHistory(l2, l, n, n2);
            }
        };


        static Query get(boolean bl, boolean bl2) {
            if (bl) {
                return DELETE_ONLY;
            }
            if (bl2) {
                return INCREASE_ONLY;
            }
            return ALL;
        }

        abstract DbIterator<AssetHistory> getAssetHistories(long var1, long var3, int var5, int var6);
    }
}

