/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import nxt.Attachment;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Order;
import nxt.Transaction;
import nxt.TransactionType;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetBidOrders
extends APIServlet.APIRequestHandler {
    static final GetBidOrders instance = new GetBidOrders();

    private GetBidOrders() {
        super(new APITag[]{APITag.AE}, "asset", "firstIndex", "lastIndex", "showExpectedCancellations");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        Object object2;
        Object object3;
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", true);
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("showExpectedCancellations"));
        long[] lArray = null;
        if (bl) {
            object3 = transaction -> transaction.getType() == TransactionType.ColoredCoins.BID_ORDER_CANCELLATION;
            object2 = Nxt.getBlockchain().getExpectedTransactions((Filter<Transaction>)object3);
            lArray = new long[object2.size()];
            for (int i = 0; i < object2.size(); ++i) {
                object = (Attachment.ColoredCoinsOrderCancellation)((Transaction)object2.get(i)).getAttachment();
                lArray[i] = ((Attachment.ColoredCoinsOrderCancellation)object).getOrderId();
            }
            Arrays.sort(lArray);
        }
        object3 = new JSONArray();
        object2 = Order.Bid.getSortedOrders(l, n, n2);
        try {
            while (((DbIterator)object2).hasNext()) {
                Order.Bid bid = (Order.Bid)((DbIterator)object2).next();
                object = JSONData.bidOrder(bid);
                if (bl && Arrays.binarySearch(lArray, bid.getId()) >= 0) {
                    ((HashMap)object).put("expectedCancellation", Boolean.TRUE);
                }
                ((ArrayList)object3).add(object);
            }
        }
        finally {
            if (object2 != null) {
                ((DbIterator)object2).close();
            }
        }
        object2 = new JSONObject();
        ((HashMap)object2).put("bidOrders", object3);
        return object2;
    }
}

