/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.AccountLedger;
import nxt.Block;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Nxt;
import nxt.http.API;
import nxt.http.APIProxy;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.peer.Peer;
import nxt.peer.Peers;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class GetBlockchainStatus
extends APIServlet.APIRequestHandler {
    static final GetBlockchainStatus instance = new GetBlockchainStatus();

    private GetBlockchainStatus() {
        super(new APITag[]{APITag.BLOCKS, APITag.INFO}, new String[0]);
    }

    @Override
    protected JSONObject processRequest(HttpServletRequest httpServletRequest) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("application", "CoopNetwork");
        jSONObject.put("version", "1.12.2");
        jSONObject.put("time", Nxt.getEpochTime());
        Block block = Nxt.getBlockchain().getLastBlock();
        jSONObject.put("lastBlock", block.getStringId());
        jSONObject.put("cumulativeDifficulty", block.getCumulativeDifficulty().toString());
        jSONObject.put("numberOfBlocks", block.getHeight() + 1);
        BlockchainProcessor blockchainProcessor = Nxt.getBlockchainProcessor();
        Peer peer = blockchainProcessor.getLastBlockchainFeeder();
        jSONObject.put("lastBlockchainFeeder", peer == null ? null : peer.getAnnouncedAddress());
        jSONObject.put("lastBlockchainFeederHeight", blockchainProcessor.getLastBlockchainFeederHeight());
        jSONObject.put("isScanning", blockchainProcessor.isScanning());
        jSONObject.put("isDownloading", blockchainProcessor.isDownloading());
        jSONObject.put("maxRollback", Constants.MAX_ROLLBACK);
        jSONObject.put("currentMinRollbackHeight", Nxt.getBlockchainProcessor().getMinRollbackHeight());
        jSONObject.put("isTestnet", Constants.isTestnet);
        jSONObject.put("maxPrunableLifetime", Constants.MAX_PRUNABLE_LIFETIME);
        jSONObject.put("includeExpiredPrunable", Constants.INCLUDE_EXPIRED_PRUNABLE);
        jSONObject.put("correctInvalidFees", Constants.correctInvalidFees);
        jSONObject.put("ledgerTrimKeep", AccountLedger.trimKeep);
        JSONArray jSONArray = new JSONArray();
        Peers.getServices().forEach(service -> jSONArray.add(service.name()));
        jSONObject.put("services", jSONArray);
        if (APIProxy.isActivated()) {
            String string = APIProxy.getInstance().getMainPeerAnnouncedAddress();
            jSONObject.put("apiProxy", true);
            jSONObject.put("apiProxyPeer", string);
        } else {
            jSONObject.put("apiProxy", false);
        }
        jSONObject.put("isLightClient", Constants.isLightClient);
        jSONObject.put("maxAPIRecords", API.maxRecords);
        jSONObject.put("blockchainState", Peers.getMyBlockchainState());
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }
}

