/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.TaggedData;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetChannelTaggedData
extends APIServlet.APIRequestHandler {
    static final GetChannelTaggedData instance = new GetChannelTaggedData();

    private GetChannelTaggedData() {
        super(new APITag[]{APITag.DATA}, "channel", "account", "firstIndex", "lastIndex", "includeData");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("channel"));
        if (string == null) {
            return JSONResponses.missing("channel");
        }
        long l = ParameterParser.getAccountId(httpServletRequest, "account", false);
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeData"));
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put("data", jSONArray);
        try (DbIterator<TaggedData> dbIterator = TaggedData.getData(string, l, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add(JSONData.taggedData(dbIterator.next(), bl));
            }
        }
        return jSONObject;
    }
}

