/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.TaggedData;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetDataTagsLike
extends APIServlet.APIRequestHandler {
    static final GetDataTagsLike instance = new GetDataTagsLike();

    private GetDataTagsLike() {
        super(new APITag[]{APITag.DATA, APITag.SEARCH}, "tagPrefix", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        String string = Convert.emptyToNull(httpServletRequest.getParameter("tagPrefix"));
        if (string == null) {
            return JSONResponses.missing("tagPrefix");
        }
        if (string.length() < 2) {
            return JSONResponses.incorrect("tagPrefix", "tagPrefix must be at least 2 characters long");
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put("tags", jSONArray);
        try (DbIterator<TaggedData.Tag> dbIterator = TaggedData.Tag.getTagsLike(string, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add(JSONData.dataTag(dbIterator.next()));
            }
        }
        return jSONObject;
    }
}

