/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Exchange;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExchangesByExchangeRequest
extends APIServlet.APIRequestHandler {
    static final GetExchangesByExchangeRequest instance = new GetExchangesByExchangeRequest();

    private GetExchangesByExchangeRequest() {
        super(new APITag[]{APITag.MS}, "transaction", "includeCurrencyInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("transaction"));
        if (string == null) {
            return JSONResponses.MISSING_TRANSACTION;
        }
        long l = Convert.parseUnsignedLong(string);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCurrencyInfo"));
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<Exchange> dbIterator = Exchange.getExchanges(l);){
            while (dbIterator.hasNext()) {
                jSONArray.add(JSONData.exchange(dbIterator.next(), bl));
            }
        }
        jSONObject.put("exchanges", jSONArray);
        return jSONObject;
    }
}

