/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Attachment;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.TransactionType;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedAskOrders
extends APIServlet.APIRequestHandler {
    static final GetExpectedAskOrders instance = new GetExpectedAskOrders();
    private final Comparator<Transaction> priceComparator = (transaction, transaction2) -> {
        Attachment.ColoredCoinsOrderPlacement coloredCoinsOrderPlacement = (Attachment.ColoredCoinsOrderPlacement)transaction.getAttachment();
        Attachment.ColoredCoinsOrderPlacement coloredCoinsOrderPlacement2 = (Attachment.ColoredCoinsOrderPlacement)transaction2.getAttachment();
        return Long.compare(coloredCoinsOrderPlacement.getPriceNQT(), coloredCoinsOrderPlacement2.getPriceNQT());
    };

    private GetExpectedAskOrders() {
        super(new APITag[]{APITag.AE}, "asset", "sortByPrice");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("sortByPrice"));
        Filter<Transaction> filter = transaction -> {
            if (transaction.getType() != TransactionType.ColoredCoins.ASK_ORDER_PLACEMENT) {
                return false;
            }
            Attachment.ColoredCoinsOrderPlacement coloredCoinsOrderPlacement = (Attachment.ColoredCoinsOrderPlacement)transaction.getAttachment();
            return l == 0L || coloredCoinsOrderPlacement.getAssetId() == l;
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        if (bl) {
            list.sort(this.priceComparator);
        }
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add(JSONData.expectedAskOrder(transaction)));
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("askOrders", jSONArray);
        return jSONObject;
    }
}

