/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Attachment;
import nxt.MonetarySystem;
import nxt.Nxt;
import nxt.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedSellOffers
extends APIServlet.APIRequestHandler {
    static final GetExpectedSellOffers instance = new GetExpectedSellOffers();
    private final Comparator<Transaction> rateComparator = (transaction, transaction2) -> {
        Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
        Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer2 = (Attachment.MonetarySystemPublishExchangeOffer)transaction2.getAttachment();
        return Long.compare(monetarySystemPublishExchangeOffer.getSellRateNQT(), monetarySystemPublishExchangeOffer2.getSellRateNQT());
    };

    private GetExpectedSellOffers() {
        super(new APITag[]{APITag.MS}, "currency", "account", "sortByRate");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "currency", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, "account", false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("sortByRate"));
        Filter<Transaction> filter = transaction -> {
            if (transaction.getType() != MonetarySystem.PUBLISH_EXCHANGE_OFFER) {
                return false;
            }
            if (l2 != 0L && transaction.getSenderId() != l2) {
                return false;
            }
            Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
            return l == 0L || monetarySystemPublishExchangeOffer.getCurrencyId() == l;
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        if (bl) {
            list.sort(this.rateComparator);
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add(JSONData.expectedSellOffer(transaction)));
        jSONObject.put("offers", jSONArray);
        return jSONObject;
    }
}

