/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Shuffling;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetHoldingShufflings
extends APIServlet.APIRequestHandler {
    static final GetHoldingShufflings instance = new GetHoldingShufflings();

    private GetHoldingShufflings() {
        super(new APITag[]{APITag.SHUFFLING}, "holding", "stage", "includeFinished", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        long l = 0L;
        String string = Convert.emptyToNull(httpServletRequest.getParameter("holding"));
        if (string != null) {
            try {
                l = Convert.parseUnsignedLong(string);
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.incorrect("holding");
            }
        }
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("stage"));
        Shuffling.Stage stage = null;
        if (string2 != null) {
            try {
                stage = Shuffling.Stage.get(Byte.parseByte(string2));
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.incorrect("stage");
            }
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeFinished"));
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put("shufflings", jSONArray);
        try (DbIterator<Shuffling> dbIterator = Shuffling.getHoldingShufflings(l, stage, bl, n, n2);){
            for (Shuffling shuffling : dbIterator) {
                jSONArray.add(JSONData.shuffling(shuffling, false));
            }
        }
        return jSONObject;
    }
}

