/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetPeers
extends APIServlet.APIRequestHandler {
    static final GetPeers instance = new GetPeers();

    private GetPeers() {
        super(new APITag[]{APITag.NETWORK}, "active", "state", "service", "service", "service", "includePeerInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        Peer.State state;
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("active"));
        String string = Convert.emptyToNull(httpServletRequest.getParameter("state"));
        String[] stringArray = httpServletRequest.getParameterValues("service");
        boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includePeerInfo"));
        if (string != null) {
            try {
                state = Peer.State.valueOf(string);
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.incorrect("state", "- '" + string + "' is not defined");
            }
        } else {
            state = null;
        }
        long l = 0L;
        if (stringArray != null) {
            for (String string2 : stringArray) {
                try {
                    l |= Peer.Service.valueOf(string2).getCode();
                }
                catch (RuntimeException runtimeException) {
                    return JSONResponses.incorrect("service", "- '" + string2 + "' is not defined");
                }
            }
        }
        Collection<Peer> collection = bl ? Peers.getActivePeers() : (state != null ? Peers.getPeers(state) : Peers.getAllPeers());
        JSONArray jSONArray = new JSONArray();
        if (l != 0L) {
            long l2 = l;
            if (bl2) {
                collection.forEach(peer -> {
                    if (peer.providesServices(l2)) {
                        jSONArray.add(JSONData.peer(peer));
                    }
                });
            } else {
                collection.forEach(peer -> {
                    if (peer.providesServices(l2)) {
                        jSONArray.add(peer.getHost());
                    }
                });
            }
        } else if (bl2) {
            collection.forEach(peer -> jSONArray.add(JSONData.peer(peer)));
        } else {
            collection.forEach(peer -> jSONArray.add(peer.getHost()));
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("peers", jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }
}

