/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetStackTraces
extends APIServlet.APIRequestHandler {
    static final GetStackTraces instance = new GetStackTraces();

    private GetStackTraces() {
        super(new APITag[]{APITag.DEBUG}, "depth");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("depth");
        int n = string != null ? Math.max(Integer.valueOf(string), 1) : Integer.MAX_VALUE;
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        boolean bl = threadMXBean.isObjectMonitorUsageSupported();
        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(bl, false);
        for (ThreadInfo threadInfo : threadInfoArray) {
            Object object;
            Object[] objectArray;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("id", threadInfo.getThreadId());
            jSONObject.put("name", threadInfo.getThreadName());
            jSONObject.put("state", threadInfo.getThreadState().toString());
            if (bl) {
                objectArray = threadInfo.getLockedMonitors();
                if (objectArray.length > 0) {
                    object = new JSONArray();
                    for (Object object2 : objectArray) {
                        Object object3 = new JSONObject();
                        ((HashMap)object3).put("name", ((LockInfo)object2).getClassName());
                        ((HashMap)object3).put("hash", ((LockInfo)object2).getIdentityHashCode());
                        ((HashMap)object3).put("depth", ((MonitorInfo)object2).getLockedStackDepth());
                        ((HashMap)object3).put("trace", ((MonitorInfo)object2).getLockedStackFrame().toString());
                        ((ArrayList)object).add(object3);
                    }
                    jSONObject.put("locks", object);
                }
                if (threadInfo.getThreadState() == Thread.State.BLOCKED && (object = threadInfo.getLockInfo()) != null) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("name", ((LockInfo)object).getClassName());
                    jSONObject2.put("hash", ((LockInfo)object).getIdentityHashCode());
                    jSONObject2.put("thread", threadInfo.getLockOwnerId());
                    jSONObject.put("blocked", jSONObject2);
                    int n2 = 1;
                    for (Object object2 : jSONArray2) {
                        if (!((JSONObject)object2).get("name").equals(((LockInfo)object).getClassName())) continue;
                        n2 = 0;
                        break;
                    }
                    if (n2 != 0) {
                        jSONArray2.add(jSONObject2);
                    }
                }
            }
            objectArray = threadInfo.getStackTrace();
            object = new JSONArray();
            int n3 = 0;
            for (Object object3 : objectArray) {
                ((ArrayList)object).add(((StackTraceElement)object3).toString());
                if (++n3 == n) break;
            }
            jSONObject.put("trace", object);
            jSONArray.add(jSONObject);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("threads", jSONArray);
        jSONObject.put("locks", jSONArray2);
        return jSONObject;
    }

    @Override
    protected boolean requirePassword() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }
}

