/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.AccountRestrictions;
import nxt.Alias;
import nxt.Asset;
import nxt.AssetTransfer;
import nxt.Constants;
import nxt.Currency;
import nxt.CurrencyBuyOffer;
import nxt.CurrencyTransfer;
import nxt.DigitalGoodsStore;
import nxt.Exchange;
import nxt.ExchangeRequest;
import nxt.Generator;
import nxt.Nxt;
import nxt.Order;
import nxt.Poll;
import nxt.PrunableMessage;
import nxt.Shuffling;
import nxt.TaggedData;
import nxt.Trade;
import nxt.Vote;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.GetBlockchainStatus;
import nxt.peer.Peers;
import nxt.util.UPnP;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetState
extends APIServlet.APIRequestHandler {
    static final GetState instance = new GetState();

    private GetState() {
        super(new APITag[]{APITag.INFO}, "includeCounts", "adminPassword");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        JSONObject jSONObject = GetBlockchainStatus.instance.processRequest(httpServletRequest);
        if ("true".equalsIgnoreCase(httpServletRequest.getParameter("includeCounts")) && API.checkPassword(httpServletRequest)) {
            jSONObject.put("numberOfTransactions", Nxt.getBlockchain().getTransactionCount());
            jSONObject.put("numberOfAccounts", Account.getCount());
            jSONObject.put("numberOfAssets", Asset.getCount());
            int n = Order.Ask.getCount();
            int n2 = Order.Bid.getCount();
            jSONObject.put("numberOfOrders", n + n2);
            jSONObject.put("numberOfAskOrders", n);
            jSONObject.put("numberOfBidOrders", n2);
            jSONObject.put("numberOfTrades", Trade.getCount());
            jSONObject.put("numberOfTransfers", AssetTransfer.getCount());
            jSONObject.put("numberOfCurrencies", Currency.getCount());
            jSONObject.put("numberOfOffers", CurrencyBuyOffer.getCount());
            jSONObject.put("numberOfExchangeRequests", ExchangeRequest.getCount());
            jSONObject.put("numberOfExchanges", Exchange.getCount());
            jSONObject.put("numberOfCurrencyTransfers", CurrencyTransfer.getCount());
            jSONObject.put("numberOfAliases", Alias.getCount());
            jSONObject.put("numberOfGoods", DigitalGoodsStore.Goods.getCount());
            jSONObject.put("numberOfPurchases", DigitalGoodsStore.Purchase.getCount());
            jSONObject.put("numberOfTags", DigitalGoodsStore.Tag.getCount());
            jSONObject.put("numberOfPolls", Poll.getCount());
            jSONObject.put("numberOfVotes", Vote.getCount());
            jSONObject.put("numberOfPrunableMessages", PrunableMessage.getCount());
            jSONObject.put("numberOfTaggedData", TaggedData.getCount());
            jSONObject.put("numberOfDataTags", TaggedData.Tag.getTagCount());
            jSONObject.put("numberOfAccountLeases", Account.getAccountLeaseCount());
            jSONObject.put("numberOfActiveAccountLeases", Account.getActiveLeaseCount());
            jSONObject.put("numberOfShufflings", Shuffling.getCount());
            jSONObject.put("numberOfActiveShufflings", Shuffling.getActiveCount());
            jSONObject.put("numberOfPhasingOnlyAccounts", AccountRestrictions.PhasingOnly.getCount());
        }
        jSONObject.put("numberOfPeers", Peers.getAllPeers().size());
        jSONObject.put("numberOfActivePeers", Peers.getActivePeers().size());
        jSONObject.put("numberOfUnlockedAccounts", Generator.getAllGenerators().size());
        jSONObject.put("availableProcessors", Runtime.getRuntime().availableProcessors());
        jSONObject.put("maxMemory", Runtime.getRuntime().maxMemory());
        jSONObject.put("totalMemory", Runtime.getRuntime().totalMemory());
        jSONObject.put("freeMemory", Runtime.getRuntime().freeMemory());
        jSONObject.put("peerPort", Peers.getDefaultPeerPort());
        jSONObject.put("isOffline", Constants.isOffline);
        jSONObject.put("needsAdminPassword", !API.disableAdminPassword);
        jSONObject.put("customLoginWarning", Constants.customLoginWarning);
        InetAddress inetAddress = UPnP.getExternalAddress();
        if (inetAddress != null) {
            jSONObject.put("upnpExternalAddress", inetAddress.getHostAddress());
        }
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }
}

