/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetTransactionBytes
extends APIServlet.APIRequestHandler {
    static final GetTransactionBytes instance = new GetTransactionBytes();

    private GetTransactionBytes() {
        super(new APITag[]{APITag.TRANSACTIONS}, "transaction");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        long l;
        String string = httpServletRequest.getParameter("transaction");
        if (string == null) {
            return JSONResponses.MISSING_TRANSACTION;
        }
        try {
            l = Convert.parseUnsignedLong(string);
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_TRANSACTION;
        }
        Transaction transaction = Nxt.getBlockchain().getTransaction(l);
        JSONObject jSONObject = new JSONObject();
        if (transaction == null) {
            transaction = Nxt.getTransactionProcessor().getUnconfirmedTransaction(l);
            if (transaction == null) {
                return JSONResponses.UNKNOWN_TRANSACTION;
            }
        } else {
            jSONObject.put("confirmations", Nxt.getBlockchain().getHeight() - transaction.getHeight());
        }
        jSONObject.put("transactionBytes", Convert.toHexString(transaction.getBytes()));
        jSONObject.put("unsignedTransactionBytes", Convert.toHexString(transaction.getUnsignedBytes()));
        JSONData.putPrunableAttachment(jSONObject, transaction);
        return jSONObject;
    }
}

