/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import nxt.Db;
import nxt.crypto.Crypto;
import nxt.db.TransactionalDb;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetTransactionsBulk
extends APIServlet.APIRequestHandler {
    static final GetTransactionsBulk instance = new GetTransactionsBulk();
    protected static final TransactionalDb db = Db.db;
    public static final String[] type = new String[]{"payment", "messaging", "colored_coins", "digital_goods", "account_control", "monetary_system", "data", "shuffling"};
    public static final String[][] subtype = new String[][]{{"ordinary_payment"}, {"arbitrary_message", "alias_assignment", "poll_creation", "vote_casting", "hub_announcement", "account_info", "alias_sell", "alias_buy", "alias_delete", "phasing_vote_casting", "account_property", "account_property_delete"}, {"asset_issuance", "asset_transfer", "ask_order_placement", "bid_order_placement", "ask_order_cancellation", "bid_order_cancellation", "dividend_payment", "asset_delete", "asset_increase", "property_set", "property_delete"}, {"listing", "delisting", "price_change", "quantity_change", "purchase", "delivery", "feedback", "refund"}, {"effective_balance_leasing", "phasing_only"}, {"currency_issuance", "reserve_increase", "reserve_claim", "currency_transfer", "publish_exchange_offer", "exchange_buy", "exchange_sell", "currency_minting", "currency_deletion"}, {"upload", "extend"}, {"creation", "registration", "processing", "recipients", "verification", "cancellation"}};

    private GetTransactionsBulk() {
        super(new APITag[]{APITag.TRANSACTIONS}, "pageSize", "page", "filterBySender", "filterByReceiver", "filterByType", "filterBySubtype", "minHeight", "maxHeight");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        Integer n3 = this.getIntParamFromRequest(httpServletRequest, "pageSize", n -> n < 1 || n > 100, JSONResponses.INCORRECT_PAGE_SIZE, false);
        Integer n4 = this.getIntParamFromRequest(httpServletRequest, "page", n -> n < 0, JSONResponses.INCORRECT_PAGE, false);
        long l = this.decodeAddrToLongId(httpServletRequest.getParameter("filterBySender"));
        long l2 = this.decodeAddrToLongId(httpServletRequest.getParameter("filterByReceiver"));
        Integer n5 = this.getIntParamFromRequest(httpServletRequest, "filterByType", n -> false, JSONResponses.INCORRECT_TYPE, true);
        Integer n6 = this.getIntParamFromRequest(httpServletRequest, "filterBySubtype", n -> false, JSONResponses.INCORRECT_SUBTYPE, true);
        Integer n7 = this.getIntParamFromRequest(httpServletRequest, "minHeight", n -> n < 0, JSONResponses.INCORRECT_MIN_HEIGHT, true);
        Integer n8 = this.getIntParamFromRequest(httpServletRequest, "maxHeight", n2 -> n2 < 0 || n7 != null && n7 > n2, JSONResponses.INCORRECT_MAX_HEIGHT, true);
        try (Connection connection = db.getConnection();){
            JSONObject jSONObject;
            block20: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM TRANSACTION WHERE TRUE " + (l != 0L ? "AND ? = SENDER_ID " : "") + (l2 != 0L ? "AND ? = RECIPIENT_ID " : "") + (n5 != null ? "AND ? = TYPE " : "") + (n6 != null ? "AND ? = SUBTYPE " : "") + (n7 != null ? "AND ? <= HEIGHT " : "") + (n8 != null ? "AND ? >= HEIGHT " : "") + "ORDER BY TIMESTAMP DESC OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
                try {
                    int n9 = 0;
                    if (l != 0L) {
                        preparedStatement.setLong(++n9, l);
                    }
                    if (l2 != 0L) {
                        preparedStatement.setLong(++n9, l2);
                    }
                    if (n5 != null) {
                        preparedStatement.setInt(++n9, n5);
                    }
                    if (n6 != null) {
                        preparedStatement.setInt(++n9, n6);
                    }
                    if (n7 != null) {
                        preparedStatement.setInt(++n9, n7);
                    }
                    if (n8 != null) {
                        preparedStatement.setInt(++n9, n8);
                    }
                    preparedStatement.setInt(++n9, n4 * n3);
                    preparedStatement.setInt(++n9, n3);
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("Transactions", this.executePreparedStatement(preparedStatement));
                    jSONObject = jSONObject2;
                    if (preparedStatement == null) break block20;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return jSONObject;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private Integer getIntParamFromRequest(HttpServletRequest httpServletRequest, String string, Predicate<Integer> predicate, JSONStreamAware jSONStreamAware, boolean bl) throws ParameterException {
        Integer n;
        String string2 = httpServletRequest.getParameter(string);
        if (string2 == null) {
            if (!bl) {
                throw new ParameterException(jSONStreamAware);
            }
            return null;
        }
        try {
            n = Integer.parseInt(string2);
            if (predicate.test(n)) {
                throw new ParameterException(jSONStreamAware);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterException(jSONStreamAware);
        }
        return n;
    }

    private long decodeAddrToLongId(String string) {
        long l = 0L;
        if (string != null) {
            if (string.toUpperCase().startsWith("GMD-")) {
                String string2 = string.substring(4);
                try {
                    l = Crypto.rsDecode(string2);
                }
                catch (Exception exception) {}
            } else {
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return l;
    }

    private JSONArray executePreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        JSONArray jSONArray = new JSONArray();
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("ID", resultSet.getLong("ID"));
                Long l = resultSet.getLong("RECIPIENT_ID");
                if (l != 0L) {
                    jSONObject.put("RECIPIENT_ID", "GMD-" + Crypto.rsEncode(l));
                }
                jSONObject.put("TRANSACTION_INDEX", resultSet.getInt("TRANSACTION_INDEX"));
                jSONObject.put("AMOUNT", resultSet.getLong("AMOUNT"));
                jSONObject.put("FEE", resultSet.getLong("FEE"));
                jSONObject.put("FULL_HASH", resultSet.getString("FULL_HASH"));
                jSONObject.put("HEIGHT", resultSet.getLong("HEIGHT"));
                jSONObject.put("BLOCK_ID", resultSet.getLong("BLOCK_ID"));
                jSONObject.put("SIGNATURE", resultSet.getString("SIGNATURE"));
                jSONObject.put("TIMESTAMP", resultSet.getLong("TIMESTAMP"));
                jSONObject.put("SENDER_ID", "GMD-" + Crypto.rsEncode(resultSet.getLong("SENDER_ID")));
                jSONObject.put("BLOCK_TIMESTAMP", resultSet.getLong("BLOCK_TIMESTAMP"));
                jSONObject.put("PHASED", resultSet.getBoolean("PHASED"));
                jSONObject.put("ATTACHMENT_BYTES", resultSet.getString("ATTACHMENT_BYTES"));
                JSONObject jSONObject2 = new JSONObject();
                int n = resultSet.getInt("TYPE");
                int n2 = resultSet.getInt("SUBTYPE");
                jSONObject2.put("TYPE", n);
                jSONObject2.put("SUBTYPE", n2);
                try {
                    jSONObject2.put("type_str", type[n]);
                }
                catch (Exception exception) {
                    jSONObject2.put("type_str", "unknown");
                }
                try {
                    jSONObject2.put("subtype_str", subtype[n][n2]);
                }
                catch (Exception exception) {
                    jSONObject2.put("subtype_str", "unknown");
                }
                jSONObject.put("type_obj", jSONObject2);
                jSONArray.add(jSONObject);
            }
        }
        return jSONArray;
    }
}

