/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.crypto.HashFunction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class Hash
extends APIServlet.APIRequestHandler {
    static final Hash instance = new Hash();

    private Hash() {
        super(new APITag[]{APITag.UTILS}, "hashAlgorithm", "secret", "secretIsText");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        byte[] byArray;
        byte by = ParameterParser.getByte(httpServletRequest, "hashAlgorithm", (byte)0, (byte)127, false);
        HashFunction hashFunction = null;
        try {
            hashFunction = HashFunction.getHashFunction(by);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (hashFunction == null) {
            return JSONResponses.INCORRECT_HASH_ALGORITHM;
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("secretIsText"));
        try {
            byArray = bl ? Convert.toBytes(httpServletRequest.getParameter("secret")) : Convert.parseHexString(httpServletRequest.getParameter("secret"));
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_SECRET;
        }
        if (byArray == null || byArray.length == 0) {
            return JSONResponses.MISSING_SECRET;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("hash", Convert.toHexString(hashFunction.hash(byArray)));
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }
}

