/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nxt.Account;
import nxt.AccountLedger;
import nxt.AccountRestrictions;
import nxt.Alias;
import nxt.Appendix;
import nxt.Asset;
import nxt.AssetDividend;
import nxt.AssetHistory;
import nxt.AssetTransfer;
import nxt.Attachment;
import nxt.Block;
import nxt.Constants;
import nxt.Currency;
import nxt.CurrencyExchangeOffer;
import nxt.CurrencyFounder;
import nxt.CurrencyTransfer;
import nxt.CurrencyType;
import nxt.DigitalGoodsStore;
import nxt.Exchange;
import nxt.ExchangeRequest;
import nxt.FundingMonitor;
import nxt.Generator;
import nxt.HoldingType;
import nxt.MonetarySystem;
import nxt.Nxt;
import nxt.Order;
import nxt.PhasingPoll;
import nxt.PhasingVote;
import nxt.Poll;
import nxt.PrunableMessage;
import nxt.Shuffler;
import nxt.Shuffling;
import nxt.ShufflingParticipant;
import nxt.TaggedData;
import nxt.Token;
import nxt.Trade;
import nxt.Transaction;
import nxt.Vote;
import nxt.VoteWeighting;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.peer.Hallmark;
import nxt.peer.Peer;
import nxt.util.Convert;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class JSONData {
    static JSONObject alias(Alias alias) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", alias.getAccountId());
        jSONObject.put("aliasName", alias.getAliasName());
        jSONObject.put("aliasURI", alias.getAliasURI());
        jSONObject.put("timestamp", alias.getTimestamp());
        jSONObject.put("alias", Long.toUnsignedString(alias.getId()));
        Alias.Offer offer = Alias.getOffer(alias);
        if (offer != null) {
            jSONObject.put("priceNQT", String.valueOf(offer.getPriceNQT()));
            if (offer.getBuyerId() != 0L) {
                jSONObject.put("buyer", Long.toUnsignedString(offer.getBuyerId()));
            }
        }
        return jSONObject;
    }

    static JSONObject accountBalance(Account account, boolean bl) {
        return JSONData.accountBalance(account, bl, Nxt.getBlockchain().getHeight());
    }

    static JSONObject accountBalance(Account account, boolean bl, int n) {
        JSONObject jSONObject = new JSONObject();
        if (account == null) {
            jSONObject.put("balanceNQT", "0");
            jSONObject.put("unconfirmedBalanceNQT", "0");
            jSONObject.put("forgedBalanceNQT", "0");
            if (bl) {
                jSONObject.put("effectiveBalanceNXT", "0");
                jSONObject.put("guaranteedBalanceNQT", "0");
            }
        } else {
            jSONObject.put("balanceNQT", String.valueOf(account.getBalanceNQT()));
            jSONObject.put("unconfirmedBalanceNQT", String.valueOf(account.getUnconfirmedBalanceNQT()));
            jSONObject.put("forgedBalanceNQT", String.valueOf(account.getForgedBalanceNQT()));
            if (bl) {
                jSONObject.put("effectiveBalanceNXT", account.getEffectiveBalanceNXT(n));
                jSONObject.put("guaranteedBalanceNQT", String.valueOf(account.getGuaranteedBalanceNQT(Constants.GUARANTEED_BALANCE_CONFIRMATIONS, n)));
            }
        }
        return jSONObject;
    }

    static JSONObject lessor(Account account, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        Account.AccountLease accountLease = account.getAccountLease();
        if (accountLease.getCurrentLesseeId() != 0L) {
            JSONData.putAccount(jSONObject, "currentLessee", accountLease.getCurrentLesseeId());
            jSONObject.put("currentHeightFrom", String.valueOf(accountLease.getCurrentLeasingHeightFrom()));
            jSONObject.put("currentHeightTo", String.valueOf(accountLease.getCurrentLeasingHeightTo()));
            if (bl) {
                jSONObject.put("effectiveBalanceNXT", String.valueOf(account.getGuaranteedBalanceNQT() / 100000000L));
            }
        }
        if (accountLease.getNextLesseeId() != 0L) {
            JSONData.putAccount(jSONObject, "nextLessee", accountLease.getNextLesseeId());
            jSONObject.put("nextHeightFrom", String.valueOf(accountLease.getNextLeasingHeightFrom()));
            jSONObject.put("nextHeightTo", String.valueOf(accountLease.getNextLeasingHeightTo()));
        }
        return jSONObject;
    }

    static JSONObject asset(Asset asset, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", asset.getAccountId());
        jSONObject.put("name", asset.getName());
        jSONObject.put("description", asset.getDescription());
        jSONObject.put("decimals", asset.getDecimals());
        jSONObject.put("initialQuantityQNT", String.valueOf(asset.getInitialQuantityQNT()));
        jSONObject.put("quantityQNT", String.valueOf(asset.getQuantityQNT()));
        jSONObject.put("asset", Long.toUnsignedString(asset.getId()));
        if (bl) {
            jSONObject.put("numberOfTrades", Trade.getTradeCount(asset.getId()));
            jSONObject.put("numberOfTransfers", AssetTransfer.getTransferCount(asset.getId()));
            jSONObject.put("numberOfAccounts", Account.getAssetAccountCount(asset.getId()));
        }
        return jSONObject;
    }

    static JSONObject currency(Currency currency, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("currency", Long.toUnsignedString(currency.getId()));
        JSONData.putAccount(jSONObject, "account", currency.getAccountId());
        jSONObject.put("name", currency.getName());
        jSONObject.put("code", currency.getCode());
        jSONObject.put("description", currency.getDescription());
        jSONObject.put("type", currency.getType());
        jSONObject.put("initialSupply", String.valueOf(currency.getInitialSupply()));
        jSONObject.put("currentSupply", String.valueOf(currency.getCurrentSupply()));
        jSONObject.put("reserveSupply", String.valueOf(currency.getReserveSupply()));
        jSONObject.put("maxSupply", String.valueOf(currency.getMaxSupply()));
        jSONObject.put("creationHeight", currency.getCreationHeight());
        jSONObject.put("issuanceHeight", currency.getIssuanceHeight());
        jSONObject.put("minReservePerUnitNQT", String.valueOf(currency.getMinReservePerUnitNQT()));
        jSONObject.put("currentReservePerUnitNQT", String.valueOf(currency.getCurrentReservePerUnitNQT()));
        jSONObject.put("minDifficulty", currency.getMinDifficulty());
        jSONObject.put("maxDifficulty", currency.getMaxDifficulty());
        jSONObject.put("algorithm", currency.getAlgorithm());
        jSONObject.put("decimals", currency.getDecimals());
        if (bl) {
            jSONObject.put("numberOfExchanges", Exchange.getExchangeCount(currency.getId()));
            jSONObject.put("numberOfTransfers", CurrencyTransfer.getTransferCount(currency.getId()));
        }
        JSONArray jSONArray = new JSONArray();
        for (CurrencyType currencyType : CurrencyType.values()) {
            if (!currency.is(currencyType)) continue;
            jSONArray.add(currencyType.toString());
        }
        jSONObject.put("types", jSONArray);
        return jSONObject;
    }

    static JSONObject currencyFounder(CurrencyFounder currencyFounder) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("currency", Long.toUnsignedString(currencyFounder.getCurrencyId()));
        JSONData.putAccount(jSONObject, "account", currencyFounder.getAccountId());
        jSONObject.put("amountPerUnitNQT", String.valueOf(currencyFounder.getAmountPerUnitNQT()));
        return jSONObject;
    }

    static JSONObject accountAsset(Account.AccountAsset accountAsset, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            JSONData.putAccount(jSONObject, "account", accountAsset.getAccountId());
        }
        jSONObject.put("asset", Long.toUnsignedString(accountAsset.getAssetId()));
        jSONObject.put("quantityQNT", String.valueOf(accountAsset.getQuantityQNT()));
        jSONObject.put("unconfirmedQuantityQNT", String.valueOf(accountAsset.getUnconfirmedQuantityQNT()));
        if (bl2) {
            JSONData.putAssetInfo(jSONObject, accountAsset.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject accountCurrency(Account.AccountCurrency accountCurrency, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            JSONData.putAccount(jSONObject, "account", accountCurrency.getAccountId());
        }
        jSONObject.put("currency", Long.toUnsignedString(accountCurrency.getCurrencyId()));
        jSONObject.put("units", String.valueOf(accountCurrency.getUnits()));
        jSONObject.put("unconfirmedUnits", String.valueOf(accountCurrency.getUnconfirmedUnits()));
        if (bl2) {
            JSONData.putCurrencyInfo(jSONObject, accountCurrency.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject accountProperty(Account.AccountProperty accountProperty, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            JSONData.putAccount(jSONObject, "recipient", accountProperty.getRecipientId());
        }
        if (bl2) {
            JSONData.putAccount(jSONObject, "setter", accountProperty.getSetterId());
        }
        jSONObject.put("property", accountProperty.getProperty());
        jSONObject.put("value", accountProperty.getValue());
        return jSONObject;
    }

    static JSONObject assetProperty(Asset.AssetProperty assetProperty, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            jSONObject.put("asset", Long.toUnsignedString(assetProperty.getAssetId()));
        }
        if (bl2) {
            JSONData.putAccount(jSONObject, "setter", assetProperty.getSetterId());
        }
        jSONObject.put("property", assetProperty.getProperty());
        jSONObject.put("value", assetProperty.getValue());
        return jSONObject;
    }

    static JSONObject askOrder(Order.Ask ask) {
        JSONObject jSONObject = JSONData.order(ask);
        jSONObject.put("type", "ask");
        return jSONObject;
    }

    static JSONObject bidOrder(Order.Bid bid) {
        JSONObject jSONObject = JSONData.order(bid);
        jSONObject.put("type", "bid");
        return jSONObject;
    }

    private static JSONObject order(Order order) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("order", Long.toUnsignedString(order.getId()));
        jSONObject.put("asset", Long.toUnsignedString(order.getAssetId()));
        JSONData.putAccount(jSONObject, "account", order.getAccountId());
        jSONObject.put("quantityQNT", String.valueOf(order.getQuantityQNT()));
        jSONObject.put("priceNQT", String.valueOf(order.getPriceNQT()));
        jSONObject.put("height", order.getHeight());
        jSONObject.put("transactionIndex", order.getTransactionIndex());
        jSONObject.put("transactionHeight", order.getTransactionHeight());
        return jSONObject;
    }

    static JSONObject expectedAskOrder(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOrder(transaction);
        jSONObject.put("type", "ask");
        return jSONObject;
    }

    static JSONObject expectedBidOrder(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOrder(transaction);
        jSONObject.put("type", "bid");
        return jSONObject;
    }

    private static JSONObject expectedOrder(Transaction transaction) {
        JSONObject jSONObject = new JSONObject();
        Attachment.ColoredCoinsOrderPlacement coloredCoinsOrderPlacement = (Attachment.ColoredCoinsOrderPlacement)transaction.getAttachment();
        jSONObject.put("order", transaction.getStringId());
        jSONObject.put("asset", Long.toUnsignedString(coloredCoinsOrderPlacement.getAssetId()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        jSONObject.put("quantityQNT", String.valueOf(coloredCoinsOrderPlacement.getQuantityQNT()));
        jSONObject.put("priceNQT", String.valueOf(coloredCoinsOrderPlacement.getPriceNQT()));
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject expectedOrderCancellation(Transaction transaction) {
        JSONObject jSONObject = new JSONObject();
        Attachment.ColoredCoinsOrderCancellation coloredCoinsOrderCancellation = (Attachment.ColoredCoinsOrderCancellation)transaction.getAttachment();
        jSONObject.put("order", Long.toUnsignedString(coloredCoinsOrderCancellation.getOrderId()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject offer(CurrencyExchangeOffer currencyExchangeOffer) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("offer", Long.toUnsignedString(currencyExchangeOffer.getId()));
        JSONData.putAccount(jSONObject, "account", currencyExchangeOffer.getAccountId());
        jSONObject.put("height", currencyExchangeOffer.getHeight());
        jSONObject.put("expirationHeight", currencyExchangeOffer.getExpirationHeight());
        jSONObject.put("currency", Long.toUnsignedString(currencyExchangeOffer.getCurrencyId()));
        jSONObject.put("rateNQT", String.valueOf(currencyExchangeOffer.getRateNQT()));
        jSONObject.put("limit", String.valueOf(currencyExchangeOffer.getLimit()));
        jSONObject.put("supply", String.valueOf(currencyExchangeOffer.getSupply()));
        return jSONObject;
    }

    static JSONObject expectedBuyOffer(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOffer(transaction);
        Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
        jSONObject.put("rateNQT", String.valueOf(monetarySystemPublishExchangeOffer.getBuyRateNQT()));
        jSONObject.put("limit", String.valueOf(monetarySystemPublishExchangeOffer.getTotalBuyLimit()));
        jSONObject.put("supply", String.valueOf(monetarySystemPublishExchangeOffer.getInitialBuySupply()));
        return jSONObject;
    }

    static JSONObject expectedSellOffer(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOffer(transaction);
        Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
        jSONObject.put("rateNQT", String.valueOf(monetarySystemPublishExchangeOffer.getSellRateNQT()));
        jSONObject.put("limit", String.valueOf(monetarySystemPublishExchangeOffer.getTotalSellLimit()));
        jSONObject.put("supply", String.valueOf(monetarySystemPublishExchangeOffer.getInitialSellSupply()));
        return jSONObject;
    }

    private static JSONObject expectedOffer(Transaction transaction) {
        Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = (Attachment.MonetarySystemPublishExchangeOffer)transaction.getAttachment();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("offer", transaction.getStringId());
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        jSONObject.put("expirationHeight", monetarySystemPublishExchangeOffer.getExpirationHeight());
        jSONObject.put("currency", Long.toUnsignedString(monetarySystemPublishExchangeOffer.getCurrencyId()));
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject availableOffers(CurrencyExchangeOffer.AvailableOffers availableOffers) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("rateNQT", String.valueOf(availableOffers.getRateNQT()));
        jSONObject.put("units", String.valueOf(availableOffers.getUnits()));
        jSONObject.put("amountNQT", String.valueOf(availableOffers.getAmountNQT()));
        return jSONObject;
    }

    static JSONObject shuffling(Shuffling shuffling, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("shuffling", Long.toUnsignedString(shuffling.getId()));
        JSONData.putAccount(jSONObject, "issuer", shuffling.getIssuerId());
        jSONObject.put("holding", Long.toUnsignedString(shuffling.getHoldingId()));
        jSONObject.put("holdingType", shuffling.getHoldingType().getCode());
        if (shuffling.getAssigneeAccountId() != 0L) {
            JSONData.putAccount(jSONObject, "assignee", shuffling.getAssigneeAccountId());
        }
        jSONObject.put("amount", String.valueOf(shuffling.getAmount()));
        jSONObject.put("blocksRemaining", shuffling.getBlocksRemaining());
        jSONObject.put("participantCount", shuffling.getParticipantCount());
        jSONObject.put("registrantCount", shuffling.getRegistrantCount());
        jSONObject.put("stage", shuffling.getStage().getCode());
        jSONObject.put("shufflingStateHash", Convert.toHexString(shuffling.getStateHash()));
        jSONObject.put("shufflingFullHash", Convert.toHexString(shuffling.getFullHash()));
        JSONArray jSONArray = new JSONArray();
        for (byte[] byArray : shuffling.getRecipientPublicKeys()) {
            jSONArray.add(Convert.toHexString(byArray));
        }
        if (jSONArray.size() > 0) {
            jSONObject.put("recipientPublicKeys", jSONArray);
        }
        if (bl && shuffling.getHoldingType() != HoldingType.NXT) {
            jSONObject.put("holdingInfo", JSONData.holdingInfoJson(shuffling.getHoldingType(), shuffling.getHoldingId()));
        }
        return jSONObject;
    }

    private static JSONObject holdingInfoJson(HoldingType holdingType, long l) {
        JSONObject jSONObject = new JSONObject();
        if (holdingType == HoldingType.ASSET) {
            JSONData.putAssetInfo(jSONObject, l);
        } else if (holdingType == HoldingType.CURRENCY) {
            JSONData.putCurrencyInfo(jSONObject, l);
        }
        return jSONObject;
    }

    static JSONObject participant(ShufflingParticipant shufflingParticipant) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("shuffling", Long.toUnsignedString(shufflingParticipant.getShufflingId()));
        JSONData.putAccount(jSONObject, "account", shufflingParticipant.getAccountId());
        JSONData.putAccount(jSONObject, "nextAccount", shufflingParticipant.getNextAccountId());
        jSONObject.put("state", shufflingParticipant.getState().getCode());
        return jSONObject;
    }

    static JSONObject shuffler(Shuffler shuffler, boolean bl) {
        ShufflingParticipant shufflingParticipant;
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", shuffler.getAccountId());
        JSONData.putAccount(jSONObject, "recipient", Account.getId(shuffler.getRecipientPublicKey()));
        jSONObject.put("shufflingFullHash", Convert.toHexString(shuffler.getShufflingFullHash()));
        jSONObject.put("shuffling", Long.toUnsignedString(Convert.fullHashToId(shuffler.getShufflingFullHash())));
        if (shuffler.getFailedTransaction() != null) {
            jSONObject.put("failedTransaction", JSONData.unconfirmedTransaction(shuffler.getFailedTransaction()));
            jSONObject.put("failureCause", shuffler.getFailureCause().getMessage());
        }
        if (bl && (shufflingParticipant = ShufflingParticipant.getParticipant(Convert.fullHashToId(shuffler.getShufflingFullHash()), shuffler.getAccountId())) != null) {
            jSONObject.put("participantState", shufflingParticipant.getState().getCode());
        }
        return jSONObject;
    }

    static JSONObject block(Block block, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("block", block.getStringId());
        jSONObject.put("height", block.getHeight());
        JSONData.putAccount(jSONObject, "generator", block.getGeneratorId());
        jSONObject.put("generatorPublicKey", Convert.toHexString(block.getGeneratorPublicKey()));
        jSONObject.put("timestamp", block.getTimestamp());
        jSONObject.put("numberOfTransactions", block.getTransactions().size());
        jSONObject.put("totalAmountNQT", String.valueOf(block.getTotalAmountNQT()));
        jSONObject.put("totalFeeNQT", String.valueOf(block.getTotalFeeNQT()));
        jSONObject.put("payloadLength", block.getPayloadLength());
        jSONObject.put("version", block.getVersion());
        jSONObject.put("baseTarget", Long.toUnsignedString(block.getBaseTarget()));
        jSONObject.put("cumulativeDifficulty", block.getCumulativeDifficulty().toString());
        if (block.getPreviousBlockId() != 0L) {
            jSONObject.put("previousBlock", Long.toUnsignedString(block.getPreviousBlockId()));
        }
        if (block.getNextBlockId() != 0L) {
            jSONObject.put("nextBlock", Long.toUnsignedString(block.getNextBlockId()));
        }
        jSONObject.put("payloadHash", Convert.toHexString(block.getPayloadHash()));
        jSONObject.put("generationSignature", Convert.toHexString(block.getGenerationSignature()));
        jSONObject.put("previousBlockHash", Convert.toHexString(block.getPreviousBlockHash()));
        jSONObject.put("blockSignature", Convert.toHexString(block.getBlockSignature()));
        JSONArray jSONArray = new JSONArray();
        if (bl) {
            block.getTransactions().forEach(transaction -> jSONArray.add(JSONData.transaction(transaction)));
        } else {
            block.getTransactions().forEach(transaction -> jSONArray.add(transaction.getStringId()));
        }
        jSONObject.put("transactions", jSONArray);
        if (bl2) {
            JSONArray jSONArray2 = new JSONArray();
            try (DbIterator<PhasingPoll.PhasingPollResult> dbIterator = PhasingPoll.getApproved(block.getHeight());){
                for (PhasingPoll.PhasingPollResult phasingPollResult : dbIterator) {
                    long l = phasingPollResult.getId();
                    if (bl) {
                        jSONArray2.add(JSONData.transaction(Nxt.getBlockchain().getTransaction(l)));
                        continue;
                    }
                    jSONArray2.add(Long.toUnsignedString(l));
                }
            }
            jSONObject.put("executedPhasedTransactions", jSONArray2);
        }
        return jSONObject;
    }

    static JSONObject encryptedData(EncryptedData encryptedData) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("data", Convert.toHexString(encryptedData.getData()));
        jSONObject.put("nonce", Convert.toHexString(encryptedData.getNonce()));
        return jSONObject;
    }

    static JSONObject goods(DigitalGoodsStore.Goods goods, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("goods", Long.toUnsignedString(goods.getId()));
        jSONObject.put("name", goods.getName());
        jSONObject.put("description", goods.getDescription());
        jSONObject.put("quantity", goods.getQuantity());
        jSONObject.put("priceNQT", String.valueOf(goods.getPriceNQT()));
        JSONData.putAccount(jSONObject, "seller", goods.getSellerId());
        jSONObject.put("tags", goods.getTags());
        JSONArray jSONArray = new JSONArray();
        Collections.addAll(jSONArray, goods.getParsedTags());
        jSONObject.put("parsedTags", jSONArray);
        jSONObject.put("delisted", goods.isDelisted());
        jSONObject.put("timestamp", goods.getTimestamp());
        jSONObject.put("hasImage", goods.hasImage());
        if (bl) {
            jSONObject.put("numberOfPurchases", DigitalGoodsStore.Purchase.getGoodsPurchaseCount(goods.getId(), false, true));
            jSONObject.put("numberOfPublicFeedbacks", DigitalGoodsStore.Purchase.getGoodsPurchaseCount(goods.getId(), true, true));
        }
        return jSONObject;
    }

    static JSONObject tag(DigitalGoodsStore.Tag tag) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("tag", tag.getTag());
        jSONObject.put("inStockCount", tag.getInStockCount());
        jSONObject.put("totalCount", tag.getTotalCount());
        return jSONObject;
    }

    static JSONObject hallmark(Hallmark hallmark) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", Account.getId(hallmark.getPublicKey()));
        jSONObject.put("host", hallmark.getHost());
        jSONObject.put("port", hallmark.getPort());
        jSONObject.put("weight", hallmark.getWeight());
        String string = Hallmark.formatDate(hallmark.getDate());
        jSONObject.put("date", string);
        jSONObject.put("valid", hallmark.isValid());
        return jSONObject;
    }

    static JSONObject token(Token token) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", Account.getId(token.getPublicKey()));
        jSONObject.put("timestamp", token.getTimestamp());
        jSONObject.put("valid", token.isValid());
        return jSONObject;
    }

    static JSONObject peer(Peer peer) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("address", peer.getHost());
        jSONObject.put("port", peer.getPort());
        jSONObject.put("state", peer.getState().ordinal());
        jSONObject.put("announcedAddress", peer.getAnnouncedAddress());
        jSONObject.put("shareAddress", peer.shareAddress());
        if (peer.getHallmark() != null) {
            jSONObject.put("hallmark", peer.getHallmark().getHallmarkString());
        }
        jSONObject.put("weight", peer.getWeight());
        jSONObject.put("downloadedVolume", peer.getDownloadedVolume());
        jSONObject.put("uploadedVolume", peer.getUploadedVolume());
        jSONObject.put("application", peer.getApplication());
        jSONObject.put("version", peer.getVersion());
        jSONObject.put("platform", peer.getPlatform());
        if (peer.getApiPort() != 0) {
            jSONObject.put("apiPort", peer.getApiPort());
        }
        if (peer.getApiSSLPort() != 0) {
            jSONObject.put("apiSSLPort", peer.getApiSSLPort());
        }
        jSONObject.put("blacklisted", peer.isBlacklisted());
        jSONObject.put("lastUpdated", peer.getLastUpdated());
        jSONObject.put("lastConnectAttempt", peer.getLastConnectAttempt());
        jSONObject.put("inbound", peer.isInbound());
        jSONObject.put("inboundWebSocket", peer.isInboundWebSocket());
        jSONObject.put("outboundWebSocket", peer.isOutboundWebSocket());
        if (peer.isBlacklisted()) {
            jSONObject.put("blacklistingCause", peer.getBlacklistingCause());
        }
        JSONArray jSONArray = new JSONArray();
        for (Peer.Service service : Peer.Service.values()) {
            if (!peer.providesService(service)) continue;
            jSONArray.add(service.name());
        }
        jSONObject.put("services", jSONArray);
        jSONObject.put("blockchainState", peer.getBlockchainState());
        return jSONObject;
    }

    static JSONObject poll(Poll poll) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", poll.getAccountId());
        jSONObject.put("poll", Long.toUnsignedString(poll.getId()));
        jSONObject.put("name", poll.getName());
        jSONObject.put("description", poll.getDescription());
        JSONArray jSONArray = new JSONArray();
        Collections.addAll(jSONArray, poll.getOptions());
        jSONObject.put("options", jSONArray);
        jSONObject.put("finishHeight", poll.getFinishHeight());
        jSONObject.put("minNumberOfOptions", poll.getMinNumberOfOptions());
        jSONObject.put("maxNumberOfOptions", poll.getMaxNumberOfOptions());
        jSONObject.put("minRangeValue", poll.getMinRangeValue());
        jSONObject.put("maxRangeValue", poll.getMaxRangeValue());
        JSONData.putVoteWeighting(jSONObject, poll.getVoteWeighting());
        jSONObject.put("finished", poll.isFinished());
        jSONObject.put("timestamp", poll.getTimestamp());
        return jSONObject;
    }

    static JSONObject pollResults(Poll poll, List<Poll.OptionResult> list, VoteWeighting voteWeighting) {
        Object object;
        Object object2;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("poll", Long.toUnsignedString(poll.getId()));
        if (voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.ASSET) {
            jSONObject.put("decimals", Asset.getAsset(voteWeighting.getHoldingId()).getDecimals());
        } else if (voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.CURRENCY) {
            object2 = Currency.getCurrency(voteWeighting.getHoldingId());
            if (object2 != null) {
                jSONObject.put("decimals", ((Currency)object2).getDecimals());
            } else {
                object = Nxt.getBlockchain().getTransaction(voteWeighting.getHoldingId());
                Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = (Attachment.MonetarySystemCurrencyIssuance)object.getAttachment();
                jSONObject.put("decimals", monetarySystemCurrencyIssuance.getDecimals());
            }
        }
        JSONData.putVoteWeighting(jSONObject, voteWeighting);
        jSONObject.put("finished", poll.isFinished());
        object2 = new JSONArray();
        Collections.addAll(object2, poll.getOptions());
        jSONObject.put("options", object2);
        object = new JSONArray();
        for (Poll.OptionResult optionResult : list) {
            JSONObject jSONObject2 = new JSONObject();
            if (optionResult != null) {
                jSONObject2.put("result", String.valueOf(optionResult.getResult()));
                jSONObject2.put("weight", String.valueOf(optionResult.getWeight()));
            } else {
                jSONObject2.put("result", "");
                jSONObject2.put("weight", "0");
            }
            ((ArrayList)object).add(jSONObject2);
        }
        jSONObject.put("results", object);
        return jSONObject;
    }

    static JSONObject vote(Vote vote, VoteWeighter voteWeighter) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "voter", vote.getVoterId());
        jSONObject.put("transaction", Long.toUnsignedString(vote.getId()));
        JSONArray jSONArray = new JSONArray();
        for (byte by : vote.getVoteBytes()) {
            if (by == -128) {
                jSONArray.add("");
                continue;
            }
            jSONArray.add(Byte.toString(by));
        }
        jSONObject.put("votes", jSONArray);
        if (voteWeighter != null) {
            jSONObject.put("weight", String.valueOf(voteWeighter.calcWeight(vote.getVoterId())));
        }
        return jSONObject;
    }

    static JSONObject phasingPoll(PhasingPoll phasingPoll, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("transaction", Long.toUnsignedString(phasingPoll.getId()));
        jSONObject.put("transactionFullHash", Convert.toHexString(phasingPoll.getFullHash()));
        jSONObject.put("finishHeight", phasingPoll.getFinishHeight());
        jSONObject.put("quorum", String.valueOf(phasingPoll.getQuorum()));
        JSONData.putAccount(jSONObject, "account", phasingPoll.getAccountId());
        JSONArray jSONArray = new JSONArray();
        for (long l : phasingPoll.getWhitelist()) {
            JSONObject jSONObject2 = new JSONObject();
            JSONData.putAccount(jSONObject2, "whitelisted", l);
            jSONArray.add(jSONObject2);
        }
        jSONObject.put("whitelist", jSONArray);
        Object object = phasingPoll.getLinkedFullHashes();
        if (object.size() > 0) {
            JSONArray jSONArray2 = new JSONArray();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                jSONArray2.add(Convert.toHexString(byArray));
            }
            jSONObject.put("linkedFullHashes", jSONArray2);
        }
        if (phasingPoll.getHashedSecret() != null) {
            jSONObject.put("hashedSecret", Convert.toHexString(phasingPoll.getHashedSecret()));
        }
        JSONData.putVoteWeighting(jSONObject, phasingPoll.getVoteWeighting());
        PhasingPoll.PhasingPollResult phasingPollResult = PhasingPoll.getResult(phasingPoll.getId());
        jSONObject.put("finished", phasingPollResult != null);
        if (phasingPollResult != null) {
            jSONObject.put("approved", phasingPollResult.isApproved());
            jSONObject.put("result", String.valueOf(phasingPollResult.getResult()));
            jSONObject.put("executionHeight", phasingPollResult.getHeight());
        } else if (bl) {
            jSONObject.put("result", String.valueOf(phasingPoll.countVotes()));
        }
        return jSONObject;
    }

    static JSONObject phasingPollResult(PhasingPoll.PhasingPollResult phasingPollResult) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("transaction", Long.toUnsignedString(phasingPollResult.getId()));
        jSONObject.put("approved", phasingPollResult.isApproved());
        jSONObject.put("result", String.valueOf(phasingPollResult.getResult()));
        jSONObject.put("executionHeight", phasingPollResult.getHeight());
        return jSONObject;
    }

    static JSONObject phasingPollVote(PhasingVote phasingVote) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "voter", phasingVote.getVoterId());
        jSONObject.put("transaction", Long.toUnsignedString(phasingVote.getVoteId()));
        return jSONObject;
    }

    private static void putVoteWeighting(JSONObject jSONObject, VoteWeighting voteWeighting) {
        jSONObject.put("votingModel", voteWeighting.getVotingModel().getCode());
        jSONObject.put("minBalance", String.valueOf(voteWeighting.getMinBalance()));
        jSONObject.put("minBalanceModel", voteWeighting.getMinBalanceModel().getCode());
        if (voteWeighting.getHoldingId() != 0L) {
            jSONObject.put("holding", Long.toUnsignedString(voteWeighting.getHoldingId()));
        }
    }

    static JSONObject phasingOnly(AccountRestrictions.PhasingOnly phasingOnly) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", phasingOnly.getAccountId());
        jSONObject.put("quorum", String.valueOf(phasingOnly.getPhasingParams().getQuorum()));
        JSONArray jSONArray = new JSONArray();
        for (long l : phasingOnly.getPhasingParams().getWhitelist()) {
            JSONObject jSONObject2 = new JSONObject();
            JSONData.putAccount(jSONObject2, "whitelisted", l);
            jSONArray.add(jSONObject2);
        }
        jSONObject.put("whitelist", jSONArray);
        jSONObject.put("maxFees", String.valueOf(phasingOnly.getMaxFees()));
        jSONObject.put("minDuration", phasingOnly.getMinDuration());
        jSONObject.put("maxDuration", phasingOnly.getMaxDuration());
        JSONData.putVoteWeighting(jSONObject, phasingOnly.getPhasingParams().getVoteWeighting());
        return jSONObject;
    }

    static JSONObject purchase(DigitalGoodsStore.Purchase purchase) {
        JSONArray jSONArray;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("purchase", Long.toUnsignedString(purchase.getId()));
        jSONObject.put("goods", Long.toUnsignedString(purchase.getGoodsId()));
        DigitalGoodsStore.Goods goods = DigitalGoodsStore.Goods.getGoods(purchase.getGoodsId());
        jSONObject.put("name", goods.getName());
        jSONObject.put("hasImage", goods.hasImage());
        JSONData.putAccount(jSONObject, "seller", purchase.getSellerId());
        jSONObject.put("priceNQT", String.valueOf(purchase.getPriceNQT()));
        jSONObject.put("quantity", purchase.getQuantity());
        JSONData.putAccount(jSONObject, "buyer", purchase.getBuyerId());
        jSONObject.put("timestamp", purchase.getTimestamp());
        jSONObject.put("deliveryDeadlineTimestamp", purchase.getDeliveryDeadlineTimestamp());
        if (purchase.getNote() != null) {
            jSONObject.put("note", JSONData.encryptedData(purchase.getNote()));
        }
        jSONObject.put("pending", purchase.isPending());
        if (purchase.getEncryptedGoods() != null) {
            jSONObject.put("goodsData", JSONData.encryptedData(purchase.getEncryptedGoods()));
            jSONObject.put("goodsIsText", purchase.goodsIsText());
        }
        if (purchase.getFeedbackNotes() != null) {
            jSONArray = new JSONArray();
            for (EncryptedData object : purchase.getFeedbackNotes()) {
                jSONArray.add(0, JSONData.encryptedData(object));
            }
            jSONObject.put("feedbackNotes", jSONArray);
        }
        if (purchase.getPublicFeedbacks() != null) {
            jSONArray = new JSONArray();
            for (String string : purchase.getPublicFeedbacks()) {
                jSONArray.add(0, string);
            }
            jSONObject.put("publicFeedbacks", jSONArray);
        }
        if (purchase.getRefundNote() != null) {
            jSONObject.put("refundNote", JSONData.encryptedData(purchase.getRefundNote()));
        }
        if (purchase.getDiscountNQT() > 0L) {
            jSONObject.put("discountNQT", String.valueOf(purchase.getDiscountNQT()));
        }
        if (purchase.getRefundNQT() > 0L) {
            jSONObject.put("refundNQT", String.valueOf(purchase.getRefundNQT()));
        }
        return jSONObject;
    }

    static JSONObject trade(Trade trade, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("timestamp", trade.getTimestamp());
        jSONObject.put("quantityQNT", String.valueOf(trade.getQuantityQNT()));
        jSONObject.put("priceNQT", String.valueOf(trade.getPriceNQT()));
        jSONObject.put("asset", Long.toUnsignedString(trade.getAssetId()));
        jSONObject.put("askOrder", Long.toUnsignedString(trade.getAskOrderId()));
        jSONObject.put("bidOrder", Long.toUnsignedString(trade.getBidOrderId()));
        jSONObject.put("askOrderHeight", trade.getAskOrderHeight());
        jSONObject.put("bidOrderHeight", trade.getBidOrderHeight());
        JSONData.putAccount(jSONObject, "seller", trade.getSellerId());
        JSONData.putAccount(jSONObject, "buyer", trade.getBuyerId());
        jSONObject.put("block", Long.toUnsignedString(trade.getBlockId()));
        jSONObject.put("height", trade.getHeight());
        jSONObject.put("tradeType", trade.isBuy() ? "buy" : "sell");
        if (bl) {
            JSONData.putAssetInfo(jSONObject, trade.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject assetTransfer(AssetTransfer assetTransfer, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("assetTransfer", Long.toUnsignedString(assetTransfer.getId()));
        jSONObject.put("asset", Long.toUnsignedString(assetTransfer.getAssetId()));
        JSONData.putAccount(jSONObject, "sender", assetTransfer.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", assetTransfer.getRecipientId());
        jSONObject.put("quantityQNT", String.valueOf(assetTransfer.getQuantityQNT()));
        jSONObject.put("height", assetTransfer.getHeight());
        jSONObject.put("timestamp", assetTransfer.getTimestamp());
        if (bl) {
            JSONData.putAssetInfo(jSONObject, assetTransfer.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject expectedAssetTransfer(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        Attachment.ColoredCoinsAssetTransfer coloredCoinsAssetTransfer = (Attachment.ColoredCoinsAssetTransfer)transaction.getAttachment();
        jSONObject.put("assetTransfer", transaction.getStringId());
        jSONObject.put("asset", Long.toUnsignedString(coloredCoinsAssetTransfer.getAssetId()));
        JSONData.putAccount(jSONObject, "sender", transaction.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", transaction.getRecipientId());
        jSONObject.put("quantityQNT", String.valueOf(coloredCoinsAssetTransfer.getQuantityQNT()));
        if (bl) {
            JSONData.putAssetInfo(jSONObject, coloredCoinsAssetTransfer.getAssetId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject assetDelete(AssetHistory assetHistory, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("assetDelete", Long.toUnsignedString(assetHistory.getId()));
        jSONObject.put("asset", Long.toUnsignedString(assetHistory.getAssetId()));
        JSONData.putAccount(jSONObject, "account", assetHistory.getAccountId());
        jSONObject.put("quantityQNT", String.valueOf(-assetHistory.getQuantityQNT()));
        jSONObject.put("height", assetHistory.getHeight());
        jSONObject.put("timestamp", assetHistory.getTimestamp());
        if (bl) {
            JSONData.putAssetInfo(jSONObject, assetHistory.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject assetHistory(AssetHistory assetHistory, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("assetHistory", Long.toUnsignedString(assetHistory.getId()));
        jSONObject.put("asset", Long.toUnsignedString(assetHistory.getAssetId()));
        JSONData.putAccount(jSONObject, "account", assetHistory.getAccountId());
        jSONObject.put("quantityQNT", String.valueOf(assetHistory.getQuantityQNT()));
        jSONObject.put("height", assetHistory.getHeight());
        jSONObject.put("timestamp", assetHistory.getTimestamp());
        if (bl) {
            JSONData.putAssetInfo(jSONObject, assetHistory.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject expectedAssetDelete(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        Attachment.ColoredCoinsAssetDelete coloredCoinsAssetDelete = (Attachment.ColoredCoinsAssetDelete)transaction.getAttachment();
        jSONObject.put("assetDelete", transaction.getStringId());
        jSONObject.put("asset", Long.toUnsignedString(coloredCoinsAssetDelete.getAssetId()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        jSONObject.put("quantityQNT", String.valueOf(coloredCoinsAssetDelete.getQuantityQNT()));
        if (bl) {
            JSONData.putAssetInfo(jSONObject, coloredCoinsAssetDelete.getAssetId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject assetDividend(AssetDividend assetDividend, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("assetDividend", Long.toUnsignedString(assetDividend.getId()));
        jSONObject.put("asset", Long.toUnsignedString(assetDividend.getAssetId()));
        jSONObject.put("amountNQTPerQNT", String.valueOf(assetDividend.getAmountNQTPerQNT()));
        jSONObject.put("totalDividend", String.valueOf(assetDividend.getTotalDividend()));
        jSONObject.put("dividendHeight", assetDividend.getDividendHeight());
        jSONObject.put("numberOfAccounts", assetDividend.getNumAccounts());
        jSONObject.put("height", assetDividend.getHeight());
        jSONObject.put("timestamp", assetDividend.getTimestamp());
        jSONObject.put("holding", Long.toUnsignedString(assetDividend.getHoldingId()));
        HoldingType holdingType = assetDividend.getHoldingType();
        jSONObject.put("holdingType", holdingType.getCode());
        if (bl && holdingType != HoldingType.NXT) {
            jSONObject.put("holdingInfo", JSONData.holdingInfoJson(holdingType, assetDividend.getHoldingId()));
        }
        return jSONObject;
    }

    static JSONObject currencyTransfer(CurrencyTransfer currencyTransfer, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("transfer", Long.toUnsignedString(currencyTransfer.getId()));
        jSONObject.put("currency", Long.toUnsignedString(currencyTransfer.getCurrencyId()));
        JSONData.putAccount(jSONObject, "sender", currencyTransfer.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", currencyTransfer.getRecipientId());
        jSONObject.put("units", String.valueOf(currencyTransfer.getUnits()));
        jSONObject.put("height", currencyTransfer.getHeight());
        jSONObject.put("timestamp", currencyTransfer.getTimestamp());
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, currencyTransfer.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject expectedCurrencyTransfer(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        Attachment.MonetarySystemCurrencyTransfer monetarySystemCurrencyTransfer = (Attachment.MonetarySystemCurrencyTransfer)transaction.getAttachment();
        jSONObject.put("transfer", transaction.getStringId());
        jSONObject.put("currency", Long.toUnsignedString(monetarySystemCurrencyTransfer.getCurrencyId()));
        JSONData.putAccount(jSONObject, "sender", transaction.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", transaction.getRecipientId());
        jSONObject.put("units", String.valueOf(monetarySystemCurrencyTransfer.getUnits()));
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, monetarySystemCurrencyTransfer.getCurrencyId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject exchange(Exchange exchange, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("transaction", Long.toUnsignedString(exchange.getTransactionId()));
        jSONObject.put("timestamp", exchange.getTimestamp());
        jSONObject.put("units", String.valueOf(exchange.getUnits()));
        jSONObject.put("rateNQT", String.valueOf(exchange.getRate()));
        jSONObject.put("currency", Long.toUnsignedString(exchange.getCurrencyId()));
        jSONObject.put("offer", Long.toUnsignedString(exchange.getOfferId()));
        JSONData.putAccount(jSONObject, "seller", exchange.getSellerId());
        JSONData.putAccount(jSONObject, "buyer", exchange.getBuyerId());
        jSONObject.put("block", Long.toUnsignedString(exchange.getBlockId()));
        jSONObject.put("height", exchange.getHeight());
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, exchange.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject exchangeRequest(ExchangeRequest exchangeRequest, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("transaction", Long.toUnsignedString(exchangeRequest.getId()));
        jSONObject.put("subtype", exchangeRequest.isBuy() ? MonetarySystem.EXCHANGE_BUY.getSubtype() : MonetarySystem.EXCHANGE_SELL.getSubtype());
        jSONObject.put("timestamp", exchangeRequest.getTimestamp());
        jSONObject.put("units", String.valueOf(exchangeRequest.getUnits()));
        jSONObject.put("rateNQT", String.valueOf(exchangeRequest.getRate()));
        jSONObject.put("height", exchangeRequest.getHeight());
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, exchangeRequest.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject expectedExchangeRequest(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("transaction", transaction.getStringId());
        jSONObject.put("subtype", transaction.getType().getSubtype());
        Attachment.MonetarySystemExchange monetarySystemExchange = (Attachment.MonetarySystemExchange)transaction.getAttachment();
        jSONObject.put("units", String.valueOf(monetarySystemExchange.getUnits()));
        jSONObject.put("rateNQT", String.valueOf(monetarySystemExchange.getRateNQT()));
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, monetarySystemExchange.getCurrencyId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject unconfirmedTransaction(Transaction transaction) {
        return JSONData.unconfirmedTransaction(transaction, null);
    }

    static JSONObject unconfirmedTransaction(Transaction transaction, Filter<Appendix> filter) {
        byte[] byArray;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", transaction.getType().getType());
        jSONObject.put("subtype", transaction.getType().getSubtype());
        jSONObject.put("phased", transaction.getPhasing() != null);
        jSONObject.put("timestamp", transaction.getTimestamp());
        jSONObject.put("deadline", transaction.getDeadline());
        jSONObject.put("senderPublicKey", Convert.toHexString(transaction.getSenderPublicKey()));
        if (transaction.getRecipientId() != 0L) {
            JSONData.putAccount(jSONObject, "recipient", transaction.getRecipientId());
        }
        jSONObject.put("amountNQT", String.valueOf(transaction.getAmountNQT()));
        jSONObject.put("feeNQT", String.valueOf(transaction.getFeeNQT()));
        String string = transaction.getReferencedTransactionFullHash();
        if (string != null) {
            jSONObject.put("referencedTransactionFullHash", string);
        }
        if ((byArray = Convert.emptyToNull(transaction.getSignature())) != null) {
            jSONObject.put("signature", Convert.toHexString(byArray));
            jSONObject.put("signatureHash", Convert.toHexString(Crypto.sha256().digest(byArray)));
            jSONObject.put("fullHash", transaction.getFullHash());
            jSONObject.put("transaction", transaction.getStringId());
        }
        JSONObject jSONObject2 = new JSONObject();
        if (filter == null) {
            for (Appendix object : transaction.getAppendages(true)) {
                jSONObject2.putAll(object.getJSONObject());
            }
        } else {
            for (Appendix appendix : transaction.getAppendages(filter, true)) {
                jSONObject2.putAll(appendix.getJSONObject());
            }
        }
        if (!jSONObject2.isEmpty()) {
            for (Map.Entry entry : jSONObject2.entrySet()) {
                if (!(entry.getValue() instanceof Long)) continue;
                entry.setValue(String.valueOf(entry.getValue()));
            }
            jSONObject.put("attachment", jSONObject2);
        }
        JSONData.putAccount(jSONObject, "sender", transaction.getSenderId());
        jSONObject.put("height", transaction.getHeight());
        jSONObject.put("version", transaction.getVersion());
        jSONObject.put("ecBlockId", Long.toUnsignedString(transaction.getECBlockId()));
        jSONObject.put("ecBlockHeight", transaction.getECBlockHeight());
        return jSONObject;
    }

    static JSONObject transaction(Transaction transaction) {
        return JSONData.transaction(transaction, false);
    }

    static JSONObject transaction(Transaction transaction, boolean bl) {
        PhasingPoll.PhasingPollResult phasingPollResult;
        JSONObject jSONObject = JSONData.transaction(transaction, null);
        if (bl && transaction.getPhasing() != null && (phasingPollResult = PhasingPoll.getResult(transaction.getId())) != null) {
            jSONObject.put("approved", phasingPollResult.isApproved());
            jSONObject.put("result", String.valueOf(phasingPollResult.getResult()));
            jSONObject.put("executionHeight", phasingPollResult.getHeight());
        }
        return jSONObject;
    }

    static JSONObject transaction(Transaction transaction, Filter<Appendix> filter) {
        JSONObject jSONObject = JSONData.unconfirmedTransaction(transaction, filter);
        jSONObject.put("block", Long.toUnsignedString(transaction.getBlockId()));
        jSONObject.put("confirmations", Nxt.getBlockchain().getHeight() - transaction.getHeight());
        jSONObject.put("blockTimestamp", transaction.getBlockTimestamp());
        jSONObject.put("transactionIndex", transaction.getIndex());
        return jSONObject;
    }

    static JSONObject generator(Generator generator, int n) {
        JSONObject jSONObject = new JSONObject();
        long l = generator.getDeadline();
        JSONData.putAccount(jSONObject, "account", generator.getAccountId());
        jSONObject.put("deadline", l);
        jSONObject.put("hitTime", generator.getHitTime());
        jSONObject.put("remaining", Math.max(l - (long)n, 0L));
        return jSONObject;
    }

    static JSONObject accountMonitor(FundingMonitor fundingMonitor, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("holdingType", fundingMonitor.getHoldingType().getCode());
        jSONObject.put("account", Long.toUnsignedString(fundingMonitor.getAccountId()));
        jSONObject.put("accountRS", fundingMonitor.getAccountName());
        jSONObject.put("holding", Long.toUnsignedString(fundingMonitor.getHoldingId()));
        jSONObject.put("property", fundingMonitor.getProperty());
        jSONObject.put("amount", String.valueOf(fundingMonitor.getAmount()));
        jSONObject.put("threshold", String.valueOf(fundingMonitor.getThreshold()));
        jSONObject.put("interval", fundingMonitor.getInterval());
        if (bl) {
            JSONArray jSONArray = new JSONArray();
            List<FundingMonitor.MonitoredAccount> list = FundingMonitor.getMonitoredAccounts(fundingMonitor);
            list.forEach(monitoredAccount -> jSONArray.add(JSONData.monitoredAccount(monitoredAccount)));
            jSONObject.put("monitoredAccounts", jSONArray);
        }
        return jSONObject;
    }

    static JSONObject monitoredAccount(FundingMonitor.MonitoredAccount monitoredAccount) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("account", Long.toUnsignedString(monitoredAccount.getAccountId()));
        jSONObject.put("accountRS", monitoredAccount.getAccountName());
        jSONObject.put("amount", String.valueOf(monitoredAccount.getAmount()));
        jSONObject.put("threshold", String.valueOf(monitoredAccount.getThreshold()));
        jSONObject.put("interval", monitoredAccount.getInterval());
        return jSONObject;
    }

    static JSONObject prunableMessage(PrunableMessage prunableMessage, String string, byte[] byArray) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("transaction", Long.toUnsignedString(prunableMessage.getId()));
        if (prunableMessage.getMessage() == null || prunableMessage.getEncryptedData() == null) {
            jSONObject.put("isText", prunableMessage.getMessage() != null ? prunableMessage.messageIsText() : prunableMessage.encryptedMessageIsText());
        }
        JSONData.putAccount(jSONObject, "sender", prunableMessage.getSenderId());
        if (prunableMessage.getRecipientId() != 0L) {
            JSONData.putAccount(jSONObject, "recipient", prunableMessage.getRecipientId());
        }
        jSONObject.put("transactionTimestamp", prunableMessage.getTransactionTimestamp());
        jSONObject.put("blockTimestamp", prunableMessage.getBlockTimestamp());
        EncryptedData encryptedData = prunableMessage.getEncryptedData();
        if (encryptedData != null) {
            jSONObject.put("encryptedMessage", JSONData.encryptedData(prunableMessage.getEncryptedData()));
            jSONObject.put("encryptedMessageIsText", prunableMessage.encryptedMessageIsText());
            byte[] byArray2 = null;
            try {
                if (string != null) {
                    byArray2 = prunableMessage.decrypt(string);
                } else if (byArray != null && byArray.length > 0) {
                    byArray2 = prunableMessage.decrypt(byArray);
                }
                if (byArray2 != null) {
                    jSONObject.put("decryptedMessage", Convert.toString(byArray2, prunableMessage.encryptedMessageIsText()));
                }
            }
            catch (RuntimeException runtimeException) {
                JSONData.putException(jSONObject, runtimeException, "Decryption failed");
            }
            jSONObject.put("isCompressed", prunableMessage.isCompressed());
        }
        if (prunableMessage.getMessage() != null) {
            jSONObject.put("message", Convert.toString(prunableMessage.getMessage(), prunableMessage.messageIsText()));
            jSONObject.put("messageIsText", prunableMessage.messageIsText());
        }
        return jSONObject;
    }

    static JSONObject taggedData(TaggedData taggedData, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("transaction", Long.toUnsignedString(taggedData.getId()));
        JSONData.putAccount(jSONObject, "account", taggedData.getAccountId());
        jSONObject.put("name", taggedData.getName());
        jSONObject.put("description", taggedData.getDescription());
        jSONObject.put("tags", taggedData.getTags());
        JSONArray jSONArray = new JSONArray();
        Collections.addAll(jSONArray, taggedData.getParsedTags());
        jSONObject.put("parsedTags", jSONArray);
        jSONObject.put("type", taggedData.getType());
        jSONObject.put("channel", taggedData.getChannel());
        jSONObject.put("filename", taggedData.getFilename());
        jSONObject.put("isText", taggedData.isText());
        if (bl) {
            jSONObject.put("data", taggedData.isText() ? Convert.toString(taggedData.getData()) : Convert.toHexString(taggedData.getData()));
        }
        jSONObject.put("transactionTimestamp", taggedData.getTransactionTimestamp());
        jSONObject.put("blockTimestamp", taggedData.getBlockTimestamp());
        return jSONObject;
    }

    static JSONObject dataTag(TaggedData.Tag tag) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("tag", tag.getTag());
        jSONObject.put("count", tag.getCount());
        return jSONObject;
    }

    static JSONObject apiRequestHandler(APIServlet.APIRequestHandler aPIRequestHandler) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("allowRequiredBlockParameters", aPIRequestHandler.allowRequiredBlockParameters());
        if (aPIRequestHandler.getFileParameter() != null) {
            jSONObject.put("fileParameter", aPIRequestHandler.getFileParameter());
        }
        jSONObject.put("requireBlockchain", aPIRequestHandler.requireBlockchain());
        jSONObject.put("requirePost", aPIRequestHandler.requirePost());
        jSONObject.put("requirePassword", aPIRequestHandler.requirePassword());
        jSONObject.put("requireFullClient", aPIRequestHandler.requireFullClient());
        return jSONObject;
    }

    static void putPrunableAttachment(JSONObject jSONObject, Transaction transaction) {
        JSONObject jSONObject2 = transaction.getPrunableAttachmentJSON();
        if (jSONObject2 != null) {
            jSONObject.put("prunableAttachmentJSON", jSONObject2);
        }
    }

    static void putException(JSONObject jSONObject, Exception exception) {
        JSONData.putException(jSONObject, exception, "");
    }

    static void putException(JSONObject jSONObject, Exception exception, String object) {
        jSONObject.put("errorCode", 4);
        if (((String)object).length() > 0) {
            object = (String)object + ": ";
        }
        jSONObject.put("error", exception.toString());
        jSONObject.put("errorDescription", (String)object + exception.getMessage());
    }

    static void putAccount(JSONObject jSONObject, String string, long l) {
        jSONObject.put(string, Long.toUnsignedString(l));
        jSONObject.put(string + "RS", Convert.rsAccount(l));
    }

    private static void putCurrencyInfo(JSONObject jSONObject, long l) {
        Currency currency = Currency.getCurrency(l);
        if (currency == null) {
            return;
        }
        jSONObject.put("name", currency.getName());
        jSONObject.put("code", currency.getCode());
        jSONObject.put("type", currency.getType());
        jSONObject.put("decimals", currency.getDecimals());
        jSONObject.put("issuanceHeight", currency.getIssuanceHeight());
        JSONData.putAccount(jSONObject, "issuerAccount", currency.getAccountId());
    }

    private static void putAssetInfo(JSONObject jSONObject, long l) {
        Asset asset = Asset.getAsset(l);
        jSONObject.put("name", asset.getName());
        jSONObject.put("decimals", asset.getDecimals());
    }

    private static void putExpectedTransaction(JSONObject jSONObject, Transaction transaction) {
        jSONObject.put("height", Nxt.getBlockchain().getHeight() + 1);
        jSONObject.put("phased", transaction.getPhasing() != null);
        if (transaction.getBlockId() != 0L) {
            jSONObject.put("transactionHeight", transaction.getHeight());
            jSONObject.put("confirmations", Nxt.getBlockchain().getHeight() - transaction.getHeight());
        }
    }

    static void ledgerEntry(JSONObject jSONObject, AccountLedger.LedgerEntry ledgerEntry, boolean bl, boolean bl2) {
        Object object;
        JSONData.putAccount(jSONObject, "account", ledgerEntry.getAccountId());
        jSONObject.put("ledgerId", Long.toUnsignedString(ledgerEntry.getLedgerId()));
        jSONObject.put("block", Long.toUnsignedString(ledgerEntry.getBlockId()));
        jSONObject.put("height", ledgerEntry.getHeight());
        jSONObject.put("timestamp", ledgerEntry.getTimestamp());
        jSONObject.put("eventType", ledgerEntry.getEvent().name());
        jSONObject.put("event", Long.toUnsignedString(ledgerEntry.getEventId()));
        jSONObject.put("isTransactionEvent", ledgerEntry.getEvent().isTransaction());
        jSONObject.put("change", String.valueOf(ledgerEntry.getChange()));
        jSONObject.put("balance", String.valueOf(ledgerEntry.getBalance()));
        AccountLedger.LedgerHolding ledgerHolding = ledgerEntry.getHolding();
        if (ledgerHolding != null) {
            jSONObject.put("holdingType", ledgerHolding.name());
            if (ledgerEntry.getHoldingId() != null) {
                jSONObject.put("holding", Long.toUnsignedString(ledgerEntry.getHoldingId()));
            }
            if (bl2) {
                object = null;
                if (ledgerHolding == AccountLedger.LedgerHolding.ASSET_BALANCE || ledgerHolding == AccountLedger.LedgerHolding.UNCONFIRMED_ASSET_BALANCE) {
                    object = new JSONObject();
                    JSONData.putAssetInfo((JSONObject)object, ledgerEntry.getHoldingId());
                } else if (ledgerHolding == AccountLedger.LedgerHolding.CURRENCY_BALANCE || ledgerHolding == AccountLedger.LedgerHolding.UNCONFIRMED_CURRENCY_BALANCE) {
                    object = new JSONObject();
                    JSONData.putCurrencyInfo((JSONObject)object, ledgerEntry.getHoldingId());
                }
                if (object != null) {
                    jSONObject.put("holdingInfo", object);
                }
            }
        }
        if (bl && ledgerEntry.getEvent().isTransaction()) {
            object = Nxt.getBlockchain().getTransaction(ledgerEntry.getEventId());
            jSONObject.put("transaction", JSONData.transaction((Transaction)object));
        }
    }

    private JSONData() {
    }

    static interface VoteWeighter {
        public long calcWeight(long var1);
    }
}

