/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import nxt.HoldingType;
import nxt.util.Convert;
import nxt.util.JSON;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class JSONResponses {
    public static final JSONStreamAware INCORRECT_ALIAS = JSONResponses.incorrect("alias");
    public static final JSONStreamAware INCORRECT_ALIAS_OWNER = JSONResponses.incorrect("alias", "(invalid alias owner)");
    public static final JSONStreamAware INCORRECT_ALIAS_LENGTH = JSONResponses.incorrect("alias", "(length must be in [1..100] range)");
    public static final JSONStreamAware INCORRECT_ALIAS_NAME = JSONResponses.incorrect("alias", "(must contain only digits and latin letters)");
    public static final JSONStreamAware INCORRECT_ALIAS_NOTFORSALE = JSONResponses.incorrect("alias", "(alias is not for sale at the moment)");
    public static final JSONStreamAware INCORRECT_URI_LENGTH = JSONResponses.incorrect("uri", "(length must be not longer than 1000 characters)");
    public static final JSONStreamAware INCORRECT_PUBLIC_KEY = JSONResponses.incorrect("publicKey");
    public static final JSONStreamAware MISSING_ALIAS_NAME = JSONResponses.missing("aliasName");
    public static final JSONStreamAware MISSING_ALIAS_OR_ALIAS_NAME = JSONResponses.missing("alias", "aliasName");
    public static final JSONStreamAware MISSING_DEADLINE = JSONResponses.missing("deadline");
    public static final JSONStreamAware INCORRECT_DEADLINE = JSONResponses.incorrect("deadline");
    public static final JSONStreamAware MISSING_TRANSACTION_BYTES_OR_JSON = JSONResponses.missing("transactionBytes", "transactionJSON");
    public static final JSONStreamAware UNKNOWN_ORDER = JSONResponses.unknown("order");
    public static final JSONStreamAware MISSING_HALLMARK = JSONResponses.missing("hallmark");
    public static final JSONStreamAware INCORRECT_HALLMARK = JSONResponses.incorrect("hallmark");
    public static final JSONStreamAware MISSING_WEBSITE = JSONResponses.missing("website");
    public static final JSONStreamAware INCORRECT_WEBSITE = JSONResponses.incorrect("website");
    public static final JSONStreamAware MISSING_TOKEN = JSONResponses.missing("token");
    public static final JSONStreamAware INCORRECT_TOKEN = JSONResponses.incorrect("token");
    public static final JSONStreamAware MISSING_ACCOUNT = JSONResponses.missing("account");
    public static final JSONStreamAware INCORRECT_ACCOUNT = JSONResponses.incorrect("account");
    public static final JSONStreamAware INCORRECT_TIMESTAMP = JSONResponses.incorrect("timestamp");
    public static final JSONStreamAware UNKNOWN_ACCOUNT = JSONResponses.unknown("account");
    public static final JSONStreamAware UNKNOWN_ALIAS = JSONResponses.unknown("alias");
    public static final JSONStreamAware UNKNOWN_ASSET = JSONResponses.unknown("asset");
    public static final JSONStreamAware INCORRECT_ASSET = JSONResponses.incorrect("asset");
    public static final JSONStreamAware MISSING_ASSET = JSONResponses.missing("asset");
    public static final JSONStreamAware MISSING_ASSET_ACCOUNT = JSONResponses.missing("asset", "account");
    public static final JSONStreamAware UNKNOWN_BLOCK = JSONResponses.unknown("block");
    public static final JSONStreamAware INCORRECT_BLOCK = JSONResponses.incorrect("block");
    public static final JSONStreamAware UNKNOWN_ENTRY = JSONResponses.unknown("entry");
    public static final JSONStreamAware MISSING_PEER = JSONResponses.missing("peer");
    public static final JSONStreamAware UNKNOWN_PEER = JSONResponses.unknown("peer");
    public static final JSONStreamAware MISSING_TRANSACTION = JSONResponses.missing("transaction");
    public static final JSONStreamAware UNKNOWN_TRANSACTION = JSONResponses.unknown("transaction");
    public static final JSONStreamAware INCORRECT_TRANSACTION = JSONResponses.incorrect("transaction");
    public static final JSONStreamAware INCORRECT_ASSET_DESCRIPTION = JSONResponses.incorrect("description", "(length must not exceed 1000 characters)");
    public static final JSONStreamAware INCORRECT_ASSET_NAME = JSONResponses.incorrect("name", "(must contain only digits and latin letters)");
    public static final JSONStreamAware INCORRECT_ASSET_NAME_LENGTH = JSONResponses.incorrect("name", "(length must be in [3..10] range)");
    public static final JSONStreamAware MISSING_NAME = JSONResponses.missing("name");
    public static final JSONStreamAware INCORRECT_DECIMALS = JSONResponses.incorrect("decimals");
    public static final JSONStreamAware MISSING_HOST = JSONResponses.missing("host");
    public static final JSONStreamAware MISSING_DATE = JSONResponses.missing("date");
    public static final JSONStreamAware MISSING_WEIGHT = JSONResponses.missing("weight");
    public static final JSONStreamAware INCORRECT_HOST = JSONResponses.incorrect("host", "(the length exceeds 100 chars limit)");
    public static final JSONStreamAware INCORRECT_WEIGHT = JSONResponses.incorrect("weight");
    public static final JSONStreamAware INCORRECT_DATE = JSONResponses.incorrect("date");
    public static final JSONStreamAware INCORRECT_RECIPIENT = JSONResponses.incorrect("recipient");
    public static final JSONStreamAware INCORRECT_ARBITRARY_MESSAGE = JSONResponses.incorrect("message");
    public static final JSONStreamAware MISSING_DESCRIPTION = JSONResponses.missing("description");
    public static final JSONStreamAware INCORRECT_POLL_NAME_LENGTH = JSONResponses.incorrect("name", "(length must be not longer than 100 characters)");
    public static final JSONStreamAware INCORRECT_POLL_DESCRIPTION_LENGTH = JSONResponses.incorrect("description", "(length must be not longer than 1000 characters)");
    public static final JSONStreamAware INCORRECT_POLL_OPTION_LENGTH = JSONResponses.incorrect("option", "(length must be not longer than 100 characters)");
    public static final JSONStreamAware INCORRECT_ZEROOPTIONS = JSONResponses.incorrect("option", "no options given");
    public static final JSONStreamAware INCORRECT_VOTE = JSONResponses.incorrect("vote");
    public static final JSONStreamAware UNKNOWN_POLL = JSONResponses.unknown("poll");
    public static final JSONStreamAware INCORRECT_WHITELIST = JSONResponses.incorrect("whitelist");
    public static final JSONStreamAware INCORRECT_ACCOUNT_NAME_LENGTH = JSONResponses.incorrect("name", "(length must be less than 100 characters)");
    public static final JSONStreamAware INCORRECT_ACCOUNT_DESCRIPTION_LENGTH = JSONResponses.incorrect("description", "(length must be less than 1000 characters)");
    public static final JSONStreamAware MISSING_UNSIGNED_BYTES = JSONResponses.missing("unsignedTransactionBytes");
    public static final JSONStreamAware MISSING_SIGNATURE_HASH = JSONResponses.missing("signatureHash");
    public static final JSONStreamAware INCORRECT_DGS_LISTING_NAME = JSONResponses.incorrect("name", "(length must be not longer than 100 characters)");
    public static final JSONStreamAware INCORRECT_DGS_LISTING_DESCRIPTION = JSONResponses.incorrect("description", "(length must be not longer than 1000 characters)");
    public static final JSONStreamAware INCORRECT_DGS_LISTING_TAGS = JSONResponses.incorrect("tags", "(length must be not longer than 100 characters)");
    public static final JSONStreamAware UNKNOWN_GOODS = JSONResponses.unknown("goods");
    public static final JSONStreamAware INCORRECT_DELTA_QUANTITY = JSONResponses.incorrect("deltaQuantity");
    public static final JSONStreamAware MISSING_DELTA_QUANTITY = JSONResponses.missing("deltaQuantity");
    public static final JSONStreamAware MISSING_DELIVERY_DEADLINE_TIMESTAMP = JSONResponses.missing("deliveryDeadlineTimestamp");
    public static final JSONStreamAware INCORRECT_DELIVERY_DEADLINE_TIMESTAMP = JSONResponses.incorrect("deliveryDeadlineTimestamp");
    public static final JSONStreamAware INCORRECT_PURCHASE_QUANTITY = JSONResponses.incorrect("quantity", "(quantity exceeds available goods quantity)");
    public static final JSONStreamAware INCORRECT_PURCHASE_PRICE = JSONResponses.incorrect("priceNQT", "(purchase price doesn't match goods price)");
    public static final JSONStreamAware INCORRECT_PURCHASE = JSONResponses.incorrect("purchase");
    public static final JSONStreamAware INCORRECT_DGS_GOODS = JSONResponses.incorrect("goodsToEncrypt");
    public static final JSONStreamAware INCORRECT_DGS_DISCOUNT = JSONResponses.incorrect("discountNQT");
    public static final JSONStreamAware INCORRECT_DGS_REFUND = JSONResponses.incorrect("refundNQT");
    public static final JSONStreamAware INCORRECT_ENCRYPTED_MESSAGE = JSONResponses.incorrect("encryptedMessageData");
    public static final JSONStreamAware INCORRECT_DGS_ENCRYPTED_GOODS = JSONResponses.incorrect("goodsData");
    public static final JSONStreamAware INCORRECT_HEIGHT = JSONResponses.incorrect("height");
    public static final JSONStreamAware MISSING_HEIGHT = JSONResponses.missing("height");
    public static final JSONStreamAware INCORRECT_MESSAGE_TO_ENCRYPT = JSONResponses.incorrect("messageToEncrypt");
    public static final JSONStreamAware MISSING_MESSAGE_TO_ENCRYPT = JSONResponses.missing("messageToEncrypt");
    public static final JSONStreamAware INCORRECT_CURRENCY_NAME_LENGTH = JSONResponses.incorrect("name", "(length must be in [3..10] range)");
    public static final JSONStreamAware INCORRECT_CURRENCY_CODE_LENGTH = JSONResponses.incorrect("code", "(length must be in [3..5] range)");
    public static final JSONStreamAware INCORRECT_CURRENCY_NAME = JSONResponses.incorrect("name", "(must contain only digits and latin letters)");
    public static final JSONStreamAware INCORRECT_CURRENCY_CODE = JSONResponses.incorrect("code", "(must contain only uppercase latin letters)");
    public static final JSONStreamAware INCORRECT_CURRENCY_DESCRIPTION_LENGTH = JSONResponses.incorrect("description", "(length must not exceed 1000 characters)");
    public static final JSONStreamAware MISSING_CURRENCY = JSONResponses.missing("currency");
    public static final JSONStreamAware MISSING_CURRENCY_ACCOUNT = JSONResponses.missing("currency", "account");
    public static final JSONStreamAware UNKNOWN_CURRENCY = JSONResponses.unknown("currency");
    public static final JSONStreamAware INCORRECT_CURRENCY = JSONResponses.incorrect("currency");
    public static final JSONStreamAware MISSING_OFFER = JSONResponses.missing("offer");
    public static final JSONStreamAware UNKNOWN_OFFER = JSONResponses.unknown("offer");
    public static final JSONStreamAware INCORRECT_OFFER = JSONResponses.incorrect("offer");
    public static final JSONStreamAware MISSING_ADMIN_PASSWORD = JSONResponses.missing("adminPassword");
    public static final JSONStreamAware INCORRECT_ADMIN_PASSWORD = JSONResponses.incorrect("adminPassword", "(the specified password does not match nxt.adminPassword)");
    public static final JSONStreamAware LOCKED_ADMIN_PASSWORD = JSONResponses.incorrect("adminPassword", "(locked for 1 hour, too many incorrect password attempts)");
    public static final JSONStreamAware OVERFLOW = JSONResponses.error("overflow");
    public static final JSONStreamAware MISSING_SHUFFLING = JSONResponses.missing("shuffling");
    public static final JSONStreamAware UNKNOWN_SHUFFLING = JSONResponses.unknown("shuffling");
    public static final JSONStreamAware INCORRECT_SHUFFLING = JSONResponses.incorrect("shuffling");
    public static final JSONStreamAware RESPONSE_STREAM_ERROR = JSONResponses.responseError("responseOutputStream");
    public static final JSONStreamAware RESPONSE_WRITE_ERROR = JSONResponses.responseError("responseWrite");
    public static final JSONStreamAware MISSING_TRANSACTION_FULL_HASH = JSONResponses.missing("transactionFullHash");
    public static final JSONStreamAware UNKNOWN_TRANSACTION_FULL_HASH = JSONResponses.unknown("transactionFullHash");
    public static final JSONStreamAware INCORRECT_LINKED_FULL_HASH = JSONResponses.incorrect("phasingLinkedFullHash");
    public static final JSONStreamAware INCORRECT_TAGGED_DATA_NAME = JSONResponses.incorrect("name", "(length must be not longer than 100 characters)");
    public static final JSONStreamAware INCORRECT_TAGGED_DATA_DESCRIPTION = JSONResponses.incorrect("description", "(length must be not longer than 1000 characters)");
    public static final JSONStreamAware INCORRECT_TAGGED_DATA_TAGS = JSONResponses.incorrect("tags", "(length must be not longer than 100 characters)");
    public static final JSONStreamAware INCORRECT_TAGGED_DATA_FILENAME = JSONResponses.incorrect("filename", "(length must be not longer than 100 characters)");
    public static final JSONStreamAware INCORRECT_TAGGED_DATA_TYPE = JSONResponses.incorrect("type", "(length must be not longer than 100 characters)");
    public static final JSONStreamAware INCORRECT_TAGGED_DATA_CHANNEL = JSONResponses.incorrect("channel", "(length must be not longer than 100 characters)");
    public static final JSONStreamAware INCORRECT_TAGGED_DATA_FILE = JSONResponses.incorrect("data", "cannot read file data");
    public static final JSONStreamAware INCORRECT_FILE = JSONResponses.incorrect("file", "cannot read file data");
    public static final JSONStreamAware INCORRECT_DATA_TOO_LONG = JSONResponses.incorrect("data", "(length must be not longer than 43008 bytes)");
    public static final JSONStreamAware INCORRECT_DATA_ZERO_LENGTH = JSONResponses.incorrect("data", "(length cannot be 0 bytes)");
    public static final JSONStreamAware MISSING_MESSAGE_ENCRYPTED_MESSAGE = JSONResponses.missing("message", "encryptedMessageData");
    public static final JSONStreamAware EITHER_MESSAGE_ENCRYPTED_MESSAGE = JSONResponses.either("message", "encryptedMessageData");
    public static final JSONStreamAware INCORRECT_HASH_ALGORITHM = JSONResponses.incorrect("hashAlgorithm");
    public static final JSONStreamAware MISSING_SECRET = JSONResponses.missing("secret");
    public static final JSONStreamAware INCORRECT_SECRET = JSONResponses.incorrect("secret");
    public static final JSONStreamAware MISSING_RECIPIENT_PUBLIC_KEY = JSONResponses.missing("recipientPublicKey");
    public static final JSONStreamAware INCORRECT_ACCOUNT_PROPERTY_NAME_LENGTH = JSONResponses.incorrect("property", "(length must be > 0 but less than 32 characters)");
    public static final JSONStreamAware INCORRECT_ACCOUNT_PROPERTY_VALUE_LENGTH = JSONResponses.incorrect("value", "(length must be less than 160 characters)");
    public static final JSONStreamAware INCORRECT_PROPERTY = JSONResponses.incorrect("property", "(cannot be deleted by this account)");
    public static final JSONStreamAware UNKNOWN_PROPERTY = JSONResponses.unknown("property");
    public static final JSONStreamAware MISSING_PROPERTY = JSONResponses.missing("property");
    public static final JSONStreamAware INCORRECT_EC_BLOCK = JSONResponses.incorrect("ecBlockId", "ecBlockId does not match the block id at ecBlockHeight");
    public static final JSONStreamAware INCORRECT_ASSET_PROPERTY_NAME_LENGTH = JSONResponses.incorrect("property", "(length must be > 0 but less than 32 characters)");
    public static final JSONStreamAware INCORRECT_ASSET_PROPERTY_VALUE_LENGTH = JSONResponses.incorrect("value", "(length must be less than 160 characters)");
    public static final JSONStreamAware INCORRECT_PAGE_SIZE = JSONResponses.incorrect("pageSize", "Page size must be integer between 1 and 100");
    public static final JSONStreamAware INCORRECT_PAGE = JSONResponses.incorrect("page", "page must be integer. page 0 is first page");
    public static final JSONStreamAware INCORRECT_TYPE = JSONResponses.incorrect("type", "Must be positive integer");
    public static final JSONStreamAware INCORRECT_SUBTYPE = JSONResponses.incorrect("subType", "Must be positive integer");
    public static final JSONStreamAware INCORRECT_MIN_HEIGHT = JSONResponses.incorrect("minHeight", "Minimum blockchain height must be positive integer.");
    public static final JSONStreamAware INCORRECT_MAX_HEIGHT = JSONResponses.incorrect("maxHeight", "Maximum blockchain height must be positive integer greater than minHeight.");
    public static final JSONStreamAware INCORRECT_MIN_BALANCE = JSONResponses.incorrect("minUnconfirmedBalanceNQT", "Could not parse");
    public static final JSONStreamAware INCORRECT_INPUT_LIST_PARAMETER = JSONResponses.incorrect("listOfAccounts", "Should be comma separated list of accounts");
    public static final JSONStreamAware NOT_ENOUGH_FUNDS;
    public static final JSONStreamAware NOT_ENOUGH_ASSETS;
    public static final JSONStreamAware ASSET_NOT_ISSUED_YET;
    public static final JSONStreamAware NOT_ENOUGH_CURRENCY;
    public static final JSONStreamAware ERROR_NOT_ALLOWED;
    public static final JSONStreamAware ERROR_DISABLED;
    public static final JSONStreamAware ERROR_INCORRECT_REQUEST;
    public static final JSONStreamAware NOT_FORGING;
    public static final JSONStreamAware POST_REQUIRED;
    public static final JSONStreamAware FEATURE_NOT_AVAILABLE;
    public static final JSONStreamAware DECRYPTION_FAILED;
    public static final JSONStreamAware ALREADY_DELIVERED;
    public static final JSONStreamAware DUPLICATE_REFUND;
    public static final JSONStreamAware GOODS_NOT_DELIVERED;
    public static final JSONStreamAware NO_MESSAGE;
    public static final JSONStreamAware HEIGHT_NOT_AVAILABLE;
    public static final JSONStreamAware CANNOT_DELETE_CURRENCY;
    public static final JSONStreamAware NO_PASSWORD_IN_CONFIG;
    public static final JSONStreamAware POLL_RESULTS_NOT_AVAILABLE;
    public static final JSONStreamAware POLL_FINISHED;
    public static final JSONStreamAware PHASING_TRANSACTION_FINISHED;
    public static final JSONStreamAware TOO_MANY_PHASING_VOTES;
    public static final JSONStreamAware HASHES_MISMATCH;
    public static final JSONStreamAware REQUIRED_BLOCK_NOT_FOUND;
    public static final JSONStreamAware REQUIRED_LAST_BLOCK_NOT_FOUND;
    public static final JSONStreamAware MISSING_SECRET_PHRASE;
    public static final JSONStreamAware PRUNED_TRANSACTION;
    public static final JSONStreamAware PROXY_MISSING_REQUEST_TYPE;
    public static final JSONStreamAware PROXY_SECRET_DATA_DETECTED;
    public static final JSONStreamAware API_PROXY_NO_OPEN_API_PEERS;
    public static final JSONStreamAware LIGHT_CLIENT_DISABLED_API;
    public static final JSONStreamAware API_PROXY_NO_PUBLIC_PEERS;
    public static final JSONStreamAware PEER_NOT_CONNECTED;
    public static final JSONStreamAware PEER_NOT_OPEN_API;
    public static final JSONStreamAware PEERS_NETWORKING_DISABLED;
    public static final JSONStreamAware MONITOR_ALREADY_STARTED;
    public static final JSONStreamAware MONITOR_NOT_STARTED;
    public static final JSONStreamAware INCORRECT_PROCESS_FILE;

    static JSONStreamAware missing(String ... stringArray) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("errorCode", 3);
        if (stringArray.length == 1) {
            jSONObject.put("errorDescription", "\"" + stringArray[0] + "\" not specified");
        } else {
            jSONObject.put("errorDescription", "At least one of " + Arrays.toString(stringArray) + " must be specified");
        }
        return JSON.prepare(jSONObject);
    }

    static JSONStreamAware either(String ... stringArray) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("errorCode", 6);
        jSONObject.put("errorDescription", "Not more than one of " + Arrays.toString(stringArray) + " can be specified");
        return JSON.prepare(jSONObject);
    }

    static JSONStreamAware incorrect(String string) {
        return JSONResponses.incorrect(string, null);
    }

    static JSONStreamAware incorrect(String string, String string2) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("errorCode", 4);
        jSONObject.put("errorDescription", "Incorrect \"" + string + (String)(string2 != null ? "\" " + string2 : "\""));
        return JSON.prepare(jSONObject);
    }

    static JSONStreamAware unknown(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("errorCode", 5);
        jSONObject.put("errorDescription", "Unknown " + string);
        return JSON.prepare(jSONObject);
    }

    static JSONStreamAware unknownAccount(long l) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("errorCode", 5);
        jSONObject.put("errorDescription", "Unknown account");
        jSONObject.put("account", Long.toUnsignedString(l));
        jSONObject.put("accountRS", Convert.rsAccount(l));
        return JSON.prepare(jSONObject);
    }

    static JSONStreamAware fileNotFound(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("errorCode", 10);
        jSONObject.put("errorDescription", "File not found " + string);
        return JSON.prepare(jSONObject);
    }

    static JSONStreamAware error(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("errorCode", 11);
        jSONObject.put("errorDescription", string);
        return JSON.prepare(jSONObject);
    }

    private static JSONStreamAware responseError(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("errorCode", 12);
        jSONObject.put("errorDescription", string);
        return JSON.prepare(jSONObject);
    }

    static JSONStreamAware notEnoughHolding(HoldingType holdingType) {
        switch (holdingType) {
            case NXT: {
                return NOT_ENOUGH_FUNDS;
            }
            case ASSET: {
                return NOT_ENOUGH_ASSETS;
            }
            case CURRENCY: {
                return NOT_ENOUGH_CURRENCY;
            }
        }
        throw new RuntimeException();
    }

    private JSONResponses() {
    }

    static {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("errorCode", 6);
        jSONObject.put("errorDescription", "Not enough funds");
        NOT_ENOUGH_FUNDS = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 6);
        jSONObject.put("errorDescription", "Not enough assets");
        NOT_ENOUGH_ASSETS = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 6);
        jSONObject.put("errorDescription", "Asset not issued yet");
        ASSET_NOT_ISSUED_YET = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 6);
        jSONObject.put("errorDescription", "Not enough currency");
        NOT_ENOUGH_CURRENCY = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 7);
        jSONObject.put("errorDescription", "Not allowed");
        ERROR_NOT_ALLOWED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 16);
        jSONObject.put("errorDescription", "This API has been disabled");
        ERROR_DISABLED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 1);
        jSONObject.put("errorDescription", "Incorrect request");
        ERROR_INCORRECT_REQUEST = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 5);
        jSONObject.put("errorDescription", "Account is not forging");
        NOT_FORGING = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 1);
        jSONObject.put("errorDescription", "This request is only accepted using POST!");
        POST_REQUIRED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 9);
        jSONObject.put("errorDescription", "Feature not available");
        FEATURE_NOT_AVAILABLE = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Decryption failed");
        DECRYPTION_FAILED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Purchase already delivered");
        ALREADY_DELIVERED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Refund already sent");
        DUPLICATE_REFUND = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Goods have not been delivered yet");
        GOODS_NOT_DELIVERED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "No attached message found");
        NO_MESSAGE = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Requested height not available");
        HEIGHT_NOT_AVAILABLE = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Currency cannot be deleted");
        CANNOT_DELETE_CURRENCY = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Administrator's password is not configured. Please set nxt.adminPassword");
        NO_PASSWORD_IN_CONFIG = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Poll results no longer available, set nxt.processPolls=true and rescan");
        POLL_RESULTS_NOT_AVAILABLE = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Poll has already finished");
        POLL_FINISHED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 8);
        jSONObject.put("errorDescription", "Phasing transaction has already finished");
        PHASING_TRANSACTION_FINISHED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 10);
        jSONObject.put("errorDescription", "Can vote for at most 10 phased transactions at once");
        TOO_MANY_PHASING_VOTES = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 10);
        jSONObject.put("errorDescription", "Hashes don't match. You should notify Jeff Garzik.");
        HASHES_MISMATCH = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 13);
        jSONObject.put("errorDescription", "Required block not found in the blockchain");
        REQUIRED_BLOCK_NOT_FOUND = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 14);
        jSONObject.put("errorDescription", "Current last block is different");
        REQUIRED_LAST_BLOCK_NOT_FOUND = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 3);
        jSONObject.put("errorDescription", "secretPhrase not specified or not submitted to the remote node");
        MISSING_SECRET_PHRASE = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 15);
        jSONObject.put("errorDescription", "Pruned transaction data not currently available from any peer");
        PRUNED_TRANSACTION = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 17);
        jSONObject.put("errorDescription", "Proxy servlet needs requestType parameter in the URL query");
        PROXY_MISSING_REQUEST_TYPE = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 18);
        jSONObject.put("errorDescription", "Proxied requests contains secret parameters");
        PROXY_SECRET_DATA_DETECTED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 19);
        jSONObject.put("errorDescription", "No openAPI peers found");
        API_PROXY_NO_OPEN_API_PEERS = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 20);
        jSONObject.put("errorDescription", "This API is disabled when running as light client");
        LIGHT_CLIENT_DISABLED_API = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 21);
        jSONObject.put("errorDescription", "No public peers found. Please wait while retrying connection to peers...");
        API_PROXY_NO_PUBLIC_PEERS = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 5);
        jSONObject.put("errorDescription", "Peer not connected");
        PEER_NOT_CONNECTED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 5);
        jSONObject.put("errorDescription", "Peer is not providing open API");
        PEER_NOT_OPEN_API = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 24);
        jSONObject.put("errorDescription", "Network connection to peers is disabled");
        PEERS_NETWORKING_DISABLED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 5);
        jSONObject.put("errorDescription", "Account monitor already started");
        MONITOR_ALREADY_STARTED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 5);
        jSONObject.put("errorDescription", "Account monitor not started");
        MONITOR_NOT_STARTED = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("errorCode", 10);
        jSONObject.put("errorDescription", "Encrypted configuration data does not exist");
        INCORRECT_PROCESS_FILE = JSON.prepare(jSONObject);
    }
}

