/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.Constants;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.ParameterParser;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class LeaseBalance
extends CreateTransaction {
    static final LeaseBalance instance = new LeaseBalance();

    private LeaseBalance() {
        super(new APITag[]{APITag.FORGING, APITag.ACCOUNT_CONTROL, APITag.CREATE_TRANSACTION}, "period", "recipient");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n = ParameterParser.getInt(httpServletRequest, "period", Constants.LEASING_DELAY, 65535, true);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        long l = ParameterParser.getAccountId(httpServletRequest, "recipient", true);
        Account account2 = Account.getAccount(l);
        if (account2 == null || Account.getPublicKey(account2.getId()) == null) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorCode", 8);
            jSONObject.put("errorDescription", "recipient account does not have public key");
            return jSONObject;
        }
        Attachment.AccountControlEffectiveBalanceLeasing accountControlEffectiveBalanceLeasing = new Attachment.AccountControlEffectiveBalanceLeasing(n);
        return this.createTransaction(httpServletRequest, account, l, 0L, accountControlEffectiveBalanceLeasing);
    }
}

