/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import nxt.Account;
import nxt.Alias;
import nxt.Appendix;
import nxt.Asset;
import nxt.Attachment;
import nxt.Currency;
import nxt.CurrencyBuyOffer;
import nxt.CurrencySellOffer;
import nxt.DigitalGoodsStore;
import nxt.HoldingType;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Poll;
import nxt.Shuffling;
import nxt.Transaction;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.http.API;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.Search;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public final class ParameterParser {
    public static byte getByte(HttpServletRequest httpServletRequest, String string, byte by, byte by2, boolean bl) throws ParameterException {
        return ParameterParser.getByte(httpServletRequest, string, by, by2, (byte)0, bl);
    }

    public static byte getByte(HttpServletRequest httpServletRequest, String string, byte by, byte by2, byte by3, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return by3;
        }
        try {
            byte by4 = Byte.parseByte(string2);
            if (by4 < by || by4 > by2) {
                throw new ParameterException(JSONResponses.incorrect(string, String.format("value %d not in range [%d-%d]", by4, by, by2)));
            }
            return by4;
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string, String.format("value %s is not numeric", string2)));
        }
    }

    public static int getInt(HttpServletRequest httpServletRequest, String string, int n, int n2, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return 0;
        }
        return ParameterParser.getInt(string, string2, n, n2);
    }

    public static int getInt(HttpServletRequest httpServletRequest, String string, int n, int n2, int n3) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            return n3;
        }
        return ParameterParser.getInt(string, string2, n, n2);
    }

    private static int getInt(String string, String string2, int n, int n2) throws ParameterException {
        try {
            int n3 = Integer.parseInt(string2);
            if (n3 < n || n3 > n2) {
                throw new ParameterException(JSONResponses.incorrect(string, String.format("value %d not in range [%d-%d]", n3, n, n2)));
            }
            return n3;
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string, String.format("value %s is not numeric", string2)));
        }
    }

    public static long getLong(HttpServletRequest httpServletRequest, String string, long l, long l2, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return 0L;
        }
        return ParameterParser.getLong(string, string2, l, l2);
    }

    public static long getLong(HttpServletRequest httpServletRequest, String string, long l, long l2, long l3) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            return l3;
        }
        return ParameterParser.getLong(string, string2, l, l2);
    }

    private static long getLong(String string, String string2, long l, long l2) throws ParameterException {
        try {
            long l3 = Long.parseLong(string2);
            if (l3 < l || l3 > l2) {
                throw new ParameterException(JSONResponses.incorrect(string, String.format("value %d not in range [%d-%d]", l3, l, l2)));
            }
            return l3;
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string, String.format("value %s is not numeric", string2)));
        }
    }

    public static long getUnsignedLong(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return 0L;
        }
        try {
            long l = Convert.parseUnsignedLong(string2);
            if (l == 0L) {
                throw new ParameterException(JSONResponses.incorrect(string));
            }
            return l;
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string));
        }
    }

    public static long[] getUnsignedLongs(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        String[] stringArray = httpServletRequest.getParameterValues(string);
        if (stringArray == null || stringArray.length == 0) {
            throw new ParameterException(JSONResponses.missing(string));
        }
        long[] lArray = new long[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].isEmpty()) {
                    throw new ParameterException(JSONResponses.incorrect(string));
                }
                lArray[i] = Long.parseUnsignedLong(stringArray[i]);
                if (lArray[i] != 0L) continue;
                throw new ParameterException(JSONResponses.incorrect(string));
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string));
        }
        return lArray;
    }

    public static byte[] getBytes(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return Convert.EMPTY_BYTE;
        }
        return Convert.parseHexString(string2);
    }

    public static String getParameter(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            throw new ParameterException(JSONResponses.missing(string));
        }
        return string2;
    }

    public static long getAccountId(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        return ParameterParser.getAccountId(httpServletRequest, "account", bl);
    }

    public static long getAccountId(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return 0L;
        }
        try {
            long l = Convert.parseAccountId(string2);
            if (l == 0L) {
                throw new ParameterException(JSONResponses.incorrect(string));
            }
            return l;
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string));
        }
    }

    public static long[] getAccountIds(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        String[] stringArray = httpServletRequest.getParameterValues("account");
        if (stringArray == null || stringArray.length == 0) {
            if (bl) {
                throw new ParameterException(JSONResponses.MISSING_ACCOUNT);
            }
            return Convert.EMPTY_LONG;
        }
        long[] lArray = new long[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].isEmpty()) {
                    throw new ParameterException(JSONResponses.INCORRECT_ACCOUNT);
                }
                lArray[i] = Convert.parseAccountId(stringArray[i]);
                if (lArray[i] != 0L) continue;
                throw new ParameterException(JSONResponses.INCORRECT_ACCOUNT);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.INCORRECT_ACCOUNT);
        }
        return lArray;
    }

    public static Alias getAlias(HttpServletRequest httpServletRequest) throws ParameterException {
        Alias alias;
        long l;
        try {
            l = Convert.parseUnsignedLong(Convert.emptyToNull(httpServletRequest.getParameter("alias")));
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.INCORRECT_ALIAS);
        }
        String string = Convert.emptyToNull(httpServletRequest.getParameter("aliasName"));
        if (l != 0L) {
            alias = Alias.getAlias(l);
        } else if (string != null) {
            alias = Alias.getAlias(string);
        } else {
            throw new ParameterException(JSONResponses.MISSING_ALIAS_OR_ALIAS_NAME);
        }
        if (alias == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_ALIAS);
        }
        return alias;
    }

    public static long getAmountNQT(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "amountNQT", 1L, 100000000000000000L, true);
    }

    public static long getFeeNQT(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "feeNQT", 0L, 100000000000000000L, true);
    }

    public static long getPriceNQT(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "priceNQT", 1L, 100000000000000000L, true);
    }

    public static Poll getPoll(HttpServletRequest httpServletRequest) throws ParameterException {
        Poll poll = Poll.getPoll(ParameterParser.getUnsignedLong(httpServletRequest, "poll", true));
        if (poll == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_POLL);
        }
        return poll;
    }

    public static Asset getAsset(HttpServletRequest httpServletRequest) throws ParameterException {
        Asset asset = Asset.getAsset(ParameterParser.getUnsignedLong(httpServletRequest, "asset", true));
        if (asset == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_ASSET);
        }
        return asset;
    }

    public static Currency getCurrency(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getCurrency(httpServletRequest, true);
    }

    public static Currency getCurrency(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        Currency currency = Currency.getCurrency(ParameterParser.getUnsignedLong(httpServletRequest, "currency", bl));
        if (bl && currency == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_CURRENCY);
        }
        return currency;
    }

    public static CurrencyBuyOffer getBuyOffer(HttpServletRequest httpServletRequest) throws ParameterException {
        CurrencyBuyOffer currencyBuyOffer = CurrencyBuyOffer.getOffer(ParameterParser.getUnsignedLong(httpServletRequest, "offer", true));
        if (currencyBuyOffer == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_OFFER);
        }
        return currencyBuyOffer;
    }

    public static CurrencySellOffer getSellOffer(HttpServletRequest httpServletRequest) throws ParameterException {
        CurrencySellOffer currencySellOffer = CurrencySellOffer.getOffer(ParameterParser.getUnsignedLong(httpServletRequest, "offer", true));
        if (currencySellOffer == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_OFFER);
        }
        return currencySellOffer;
    }

    public static Shuffling getShuffling(HttpServletRequest httpServletRequest) throws ParameterException {
        Shuffling shuffling = Shuffling.getShuffling(ParameterParser.getUnsignedLong(httpServletRequest, "shuffling", true));
        if (shuffling == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_SHUFFLING);
        }
        return shuffling;
    }

    public static long getQuantityQNT(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "quantityQNT", 1L, 100000000000000000L, true);
    }

    public static long getAmountNQTPerQNT(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "amountNQTPerQNT", 1L, 100000000000000000L, true);
    }

    public static DigitalGoodsStore.Goods getGoods(HttpServletRequest httpServletRequest) throws ParameterException {
        DigitalGoodsStore.Goods goods = DigitalGoodsStore.Goods.getGoods(ParameterParser.getUnsignedLong(httpServletRequest, "goods", true));
        if (goods == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_GOODS);
        }
        return goods;
    }

    public static int getGoodsQuantity(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getInt(httpServletRequest, "quantity", 0, 1000000000, true);
    }

    public static EncryptedData getEncryptedData(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        byte[] byArray;
        byte[] byArray2;
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string + "Data"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter(string + "Nonce"));
        if (string3 == null) {
            return null;
        }
        try {
            byArray2 = Convert.parseHexString(string3);
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string + "Nonce"));
        }
        if (string2 != null) {
            try {
                byArray = Convert.parseHexString(string2);
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.incorrect(string + "Data"));
            }
        }
        if (httpServletRequest.getContentType() == null || !httpServletRequest.getContentType().startsWith("multipart/form-data")) {
            return null;
        }
        try {
            Part part = httpServletRequest.getPart(string + "File");
            if (part == null) {
                return null;
            }
            FileData fileData = new FileData(part).invoke();
            byArray = fileData.getData();
        }
        catch (IOException | ServletException throwable) {
            Logger.logDebugMessage("error in reading file data", throwable);
            throw new ParameterException(JSONResponses.incorrect(string + "File"));
        }
        return new EncryptedData(byArray, byArray2);
    }

    public static Appendix.EncryptToSelfMessage getEncryptToSelfMessage(HttpServletRequest httpServletRequest) throws ParameterException {
        boolean bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("messageToEncryptToSelfIsText"));
        boolean bl2 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("compressMessageToEncryptToSelf"));
        byte[] byArray = null;
        EncryptedData encryptedData = ParameterParser.getEncryptedData(httpServletRequest, "encryptToSelfMessage");
        if (encryptedData == null) {
            String string = Convert.emptyToNull(httpServletRequest.getParameter("messageToEncryptToSelf"));
            if (string == null) {
                return null;
            }
            try {
                byArray = bl ? Convert.toBytes(string) : Convert.parseHexString(string);
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.INCORRECT_MESSAGE_TO_ENCRYPT);
            }
            String string2 = ParameterParser.getSecretPhrase(httpServletRequest, false);
            if (string2 != null) {
                byte[] byArray2 = Crypto.getPublicKey(string2);
                encryptedData = Account.encryptTo(byArray2, byArray, string2, bl2);
            }
        }
        if (encryptedData != null) {
            return new Appendix.EncryptToSelfMessage(encryptedData, bl, bl2);
        }
        return new Appendix.UnencryptedEncryptToSelfMessage(byArray, bl, bl2);
    }

    public static DigitalGoodsStore.Purchase getPurchase(HttpServletRequest httpServletRequest) throws ParameterException {
        DigitalGoodsStore.Purchase purchase = DigitalGoodsStore.Purchase.getPurchase(ParameterParser.getUnsignedLong(httpServletRequest, "purchase", true));
        if (purchase == null) {
            throw new ParameterException(JSONResponses.INCORRECT_PURCHASE);
        }
        return purchase;
    }

    public static String getSecretPhrase(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("secretPhrase"));
        if (string == null && bl) {
            throw new ParameterException(JSONResponses.MISSING_SECRET_PHRASE);
        }
        return string;
    }

    public static byte[] getPublicKey(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getPublicKey(httpServletRequest, null);
    }

    public static byte[] getPublicKey(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        Object object = string == null ? "secretPhrase" : string + "SecretPhrase";
        Object object2 = string == null ? "publicKey" : string + "PublicKey";
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter((String)object));
        if (string2 == null) {
            try {
                byte[] byArray = Convert.parseHexString(Convert.emptyToNull(httpServletRequest.getParameter((String)object2)));
                if (byArray == null) {
                    throw new ParameterException(JSONResponses.missing(new String[]{object, object2}));
                }
                if (!Crypto.isCanonicalPublicKey(byArray)) {
                    throw new ParameterException(JSONResponses.incorrect((String)object2));
                }
                return byArray;
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.incorrect((String)object2));
            }
        }
        return Crypto.getPublicKey(string2);
    }

    public static Account getSenderAccount(HttpServletRequest httpServletRequest) throws ParameterException {
        byte[] byArray = ParameterParser.getPublicKey(httpServletRequest);
        Account account = Account.getAccount(byArray);
        if (account == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_ACCOUNT);
        }
        return account;
    }

    public static Account getAccount(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getAccount(httpServletRequest, true);
    }

    public static Account getAccount(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        long l = ParameterParser.getAccountId(httpServletRequest, "account", bl);
        if (l == 0L && !bl) {
            return null;
        }
        Account account = Account.getAccount(l);
        if (account == null) {
            throw new ParameterException(JSONResponses.unknownAccount(l));
        }
        return account;
    }

    public static List<Account> getAccounts(HttpServletRequest httpServletRequest) throws ParameterException {
        String[] stringArray = httpServletRequest.getParameterValues("account");
        if (stringArray == null || stringArray.length == 0) {
            throw new ParameterException(JSONResponses.MISSING_ACCOUNT);
        }
        ArrayList<Account> arrayList = new ArrayList<Account>();
        for (String string : stringArray) {
            if (string == null || string.equals("")) continue;
            try {
                Account account = Account.getAccount(Convert.parseAccountId(string));
                if (account == null) {
                    throw new ParameterException(JSONResponses.UNKNOWN_ACCOUNT);
                }
                arrayList.add(account);
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.INCORRECT_ACCOUNT);
            }
        }
        return arrayList;
    }

    public static int getTimestamp(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getInt(httpServletRequest, "timestamp", 0, Integer.MAX_VALUE, false);
    }

    public static int getFirstIndex(HttpServletRequest httpServletRequest) {
        try {
            int n = Integer.parseInt(httpServletRequest.getParameter("firstIndex"));
            if (n < 0) {
                return 0;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int getLastIndex(HttpServletRequest httpServletRequest) {
        int n = Integer.MAX_VALUE;
        try {
            n = Integer.parseInt(httpServletRequest.getParameter("lastIndex"));
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!API.checkPassword(httpServletRequest)) {
            int n2 = Math.min(ParameterParser.getFirstIndex(httpServletRequest), Integer.MAX_VALUE - API.maxRecords + 1);
            n = Math.min(n, n2 + API.maxRecords - 1);
        }
        return n;
    }

    public static int getNumberOfConfirmations(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getInt(httpServletRequest, "numberOfConfirmations", 0, Nxt.getBlockchain().getHeight(), false);
    }

    public static int getHeight(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getHeight(httpServletRequest, false);
    }

    public static int getHeight(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("height"));
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n < 0 || n > Nxt.getBlockchain().getHeight()) {
                    throw new ParameterException(JSONResponses.INCORRECT_HEIGHT);
                }
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParameterException(JSONResponses.INCORRECT_HEIGHT);
            }
        }
        if (bl) {
            throw new ParameterException(JSONResponses.missing("height"));
        }
        return -1;
    }

    public static HoldingType getHoldingType(HttpServletRequest httpServletRequest) throws ParameterException {
        return HoldingType.get(ParameterParser.getByte(httpServletRequest, "holdingType", (byte)0, (byte)2, false));
    }

    public static long getHoldingId(HttpServletRequest httpServletRequest, HoldingType holdingType) throws ParameterException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "holding", holdingType != HoldingType.NXT);
        if (holdingType == HoldingType.NXT && l != 0L) {
            throw new ParameterException(JSONResponses.incorrect("holding", "holding id should not be specified if holdingType is GMD"));
        }
        return l;
    }

    public static String getAccountProperty(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("property"));
        if (string == null && bl) {
            throw new ParameterException(JSONResponses.MISSING_PROPERTY);
        }
        return string;
    }

    public static String getSearchQuery(HttpServletRequest httpServletRequest) throws ParameterException {
        Object object = Convert.nullToEmpty(httpServletRequest.getParameter("query")).trim();
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("tag")).trim();
        if (((String)object).isEmpty() && string.isEmpty()) {
            throw new ParameterException(JSONResponses.missing("query", "tag"));
        }
        if (!string.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner(" AND TAGS:", "TAGS:", "");
            for (String string2 : Search.parseTags(string, 0, Integer.MAX_VALUE, Integer.MAX_VALUE)) {
                stringJoiner.add(string2);
            }
            object = stringJoiner.toString() + (String)(((String)object).isEmpty() ? "" : " AND (" + (String)object + ")");
        }
        return object;
    }

    public static Transaction.Builder parseTransaction(String string, String string2, String string3) throws ParameterException {
        if (string2 == null && string == null) {
            throw new ParameterException(JSONResponses.MISSING_TRANSACTION_BYTES_OR_JSON);
        }
        if (string2 != null && string != null) {
            throw new ParameterException(JSONResponses.either("transactionBytes", "transactionJSON"));
        }
        if (string3 != null && string2 == null) {
            throw new ParameterException(JSONResponses.missing("transactionBytes"));
        }
        if (string != null) {
            try {
                JSONObject jSONObject = (JSONObject)JSONValue.parseWithException(string);
                return Nxt.newTransactionBuilder(jSONObject);
            }
            catch (RuntimeException | NxtException.ValidationException | ParseException exception) {
                Logger.logDebugMessage(exception.getMessage(), exception);
                JSONObject jSONObject = new JSONObject();
                JSONData.putException(jSONObject, exception, "Incorrect transactionJSON");
                throw new ParameterException(jSONObject);
            }
        }
        try {
            byte[] byArray = Convert.parseHexString(string2);
            JSONObject jSONObject = string3 == null ? null : (JSONObject)JSONValue.parseWithException(string3);
            return Nxt.newTransactionBuilder(byArray, jSONObject);
        }
        catch (RuntimeException | NxtException.ValidationException | ParseException exception) {
            Logger.logDebugMessage(exception.getMessage(), exception);
            JSONObject jSONObject = new JSONObject();
            JSONData.putException(jSONObject, exception, "Incorrect transactionBytes");
            throw new ParameterException(jSONObject);
        }
    }

    public static Appendix getPlainMessage(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        boolean bl2;
        String string = Convert.emptyToNull(httpServletRequest.getParameter("message"));
        boolean bl3 = bl2 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("messageIsText"));
        if (string != null) {
            try {
                if (bl) {
                    return new Appendix.PrunablePlainMessage(string, bl2);
                }
                return new Appendix.Message(string, bl2);
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.INCORRECT_ARBITRARY_MESSAGE);
            }
        }
        if (httpServletRequest.getContentType() == null || !httpServletRequest.getContentType().startsWith("multipart/form-data")) {
            return null;
        }
        try {
            Part part = httpServletRequest.getPart("messageFile");
            if (part == null) {
                return null;
            }
            FileData fileData = new FileData(part).invoke();
            byte[] byArray = fileData.getData();
            String string2 = Search.detectMimeType(byArray);
            if (string2 != null) {
                bl2 = string2.startsWith("text/");
            }
            if (bl2 && !Arrays.equals(byArray, Convert.toBytes(Convert.toString(byArray)))) {
                bl2 = false;
            }
            if (bl) {
                return new Appendix.PrunablePlainMessage(byArray, bl2);
            }
            return new Appendix.Message(byArray, bl2);
        }
        catch (IOException | ServletException throwable) {
            Logger.logDebugMessage("error in reading file data", throwable);
            throw new ParameterException(JSONResponses.INCORRECT_ARBITRARY_MESSAGE);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Appendix getEncryptedMessage(HttpServletRequest var0, Account var1_1, boolean var2_2) throws ParameterException {
        var3_3 = "false".equalsIgnoreCase(var0.getParameter("messageToEncryptIsText")) == false;
        var4_4 = "false".equalsIgnoreCase(var0.getParameter("compressMessageToEncrypt")) == false;
        var5_5 = null;
        var6_6 = null;
        var7_7 = ParameterParser.getEncryptedData(var0, "encryptedMessage");
        if (var7_7 == null) {
            var8_8 = Convert.emptyToNull(var0.getParameter("messageToEncrypt"));
            if (var8_8 == null) {
                if (var0.getContentType() == null || !var0.getContentType().startsWith("multipart/form-data")) {
                    return null;
                }
                try {
                    var9_9 /* !! */  = var0.getPart("messageToEncryptFile");
                    if (var9_9 /* !! */  == null) {
                        return null;
                    }
                    var10_12 = new FileData(var9_9 /* !! */ ).invoke();
                    var5_5 = var10_12.getData();
                    var11_13 = Search.detectMimeType(var5_5);
                    if (var11_13 != null) {
                        var3_3 = var11_13.startsWith("text/");
                    }
                    if (!var3_3 || Arrays.equals(var5_5, Convert.toBytes(Convert.toString(var5_5)))) ** GOTO lbl31
                    var3_3 = false;
                }
                catch (IOException | ServletException var9_10) {
                    Logger.logDebugMessage("error in reading file data", var9_10);
                    throw new ParameterException(JSONResponses.INCORRECT_MESSAGE_TO_ENCRYPT);
                }
            } else {
                try {
                    var5_5 = var3_3 != false ? Convert.toBytes(var8_8) : Convert.parseHexString(var8_8);
                }
                catch (RuntimeException var9_11) {
                    throw new ParameterException(JSONResponses.INCORRECT_MESSAGE_TO_ENCRYPT);
                }
            }
lbl31:
            // 3 sources

            if (var1_1 != null) {
                var6_6 = Account.getPublicKey(var1_1.getId());
            }
            if (var6_6 == null) {
                var6_6 = Convert.parseHexString(Convert.emptyToNull(var0.getParameter("recipientPublicKey")));
            }
            if (var6_6 == null) {
                throw new ParameterException(JSONResponses.MISSING_RECIPIENT_PUBLIC_KEY);
            }
            var9_9 /* !! */  = ParameterParser.getSecretPhrase(var0, false);
            if (var9_9 /* !! */  != null) {
                var7_7 = Account.encryptTo(var6_6, var5_5, (String)var9_9 /* !! */ , var4_4);
            }
        }
        if (var7_7 != null) {
            if (var2_2) {
                return new Appendix.PrunableEncryptedMessage(var7_7, var3_3, var4_4);
            }
            return new Appendix.EncryptedMessage(var7_7, var3_3, var4_4);
        }
        if (var2_2) {
            return new Appendix.UnencryptedPrunableEncryptedMessage(var5_5, var3_3, var4_4, var6_6);
        }
        return new Appendix.UnencryptedEncryptedMessage(var5_5, var3_3, var4_4, var6_6);
    }

    /*
     * Unable to fully structure code
     */
    public static Attachment.TaggedDataUpload getTaggedData(HttpServletRequest var0) throws ParameterException, NxtException.NotValidException {
        var1_1 = Convert.emptyToNull(var0.getParameter("name"));
        var2_2 = Convert.nullToEmpty(var0.getParameter("description"));
        var3_3 = Convert.nullToEmpty(var0.getParameter("tags"));
        var4_4 = Convert.nullToEmpty(var0.getParameter("type")).trim();
        var5_5 = Convert.nullToEmpty(var0.getParameter("channel"));
        var6_6 = "false".equalsIgnoreCase(var0.getParameter("isText")) == false;
        var7_7 = Convert.nullToEmpty(var0.getParameter("filename")).trim();
        var8_8 = Convert.emptyToNull(var0.getParameter("data"));
        if (var8_8 == null) {
            try {
                var10_9 = var0.getPart("file");
                if (var10_9 == null) {
                    throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_FILE);
                }
                var11_11 = new FileData((Part)var10_9).invoke();
                var9_12 = var11_11.getData();
                if (var7_7.isEmpty() && var11_11.getFilename() != null) {
                    var7_7 = var11_11.getFilename().trim();
                }
                if (var1_1 != null) ** GOTO lbl25
                var1_1 = var7_7;
            }
            catch (IOException | ServletException var10_10) {
                Logger.logDebugMessage("error in reading file data", var10_10);
                throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_FILE);
            }
        } else {
            var9_12 = var6_6 != false ? Convert.toBytes(var8_8) : Convert.parseHexString(var8_8);
        }
lbl25:
        // 3 sources

        var10_9 = Search.detectMimeType(var9_12, var7_7);
        if (var10_9 != null) {
            var6_6 = var10_9.startsWith("text/");
            if (var4_4.isEmpty()) {
                var4_4 = var10_9.substring(0, Math.min(var10_9.length(), 100));
            }
        }
        if (var1_1 == null) {
            throw new ParameterException(JSONResponses.MISSING_NAME);
        }
        if ((var1_1 = var1_1.trim()).length() > 100) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_NAME);
        }
        if (var2_2.length() > 1000) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_DESCRIPTION);
        }
        if (var3_3.length() > 100) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_TAGS);
        }
        if ((var4_4 = var4_4.trim()).length() > 100) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_TYPE);
        }
        if ((var5_5 = var5_5.trim()).length() > 100) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_CHANNEL);
        }
        if (var9_12.length == 0) {
            throw new ParameterException(JSONResponses.INCORRECT_DATA_ZERO_LENGTH);
        }
        if (var9_12.length > 43008) {
            throw new ParameterException(JSONResponses.INCORRECT_DATA_TOO_LONG);
        }
        if (var7_7.length() > 100) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_FILENAME);
        }
        return new Attachment.TaggedDataUpload(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7, var9_12);
    }

    private ParameterParser() {
    }

    public static class FileData {
        private final Part part;
        private String filename;
        private byte[] data;

        public FileData(Part part) {
            this.part = part;
        }

        public String getFilename() {
            return this.filename;
        }

        public byte[] getData() {
            return this.data;
        }

        public FileData invoke() throws IOException {
            try (InputStream inputStream = this.part.getInputStream();){
                int n;
                byte[] byArray = new byte[1024];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                this.data = byteArrayOutputStream.toByteArray();
                this.filename = this.part.getSubmittedFileName();
            }
            return this;
        }
    }
}

