/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class RSConvert
extends APIServlet.APIRequestHandler {
    static final RSConvert instance = new RSConvert();

    private RSConvert() {
        super(new APITag[]{APITag.ACCOUNTS, APITag.UTILS}, "account");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("account"));
        if (string == null) {
            return JSONResponses.MISSING_ACCOUNT;
        }
        try {
            long l = Convert.parseAccountId(string);
            if (l == 0L) {
                return JSONResponses.INCORRECT_ACCOUNT;
            }
            JSONObject jSONObject = new JSONObject();
            JSONData.putAccount(jSONObject, "account", l);
            jSONObject.put("accountLongId", String.valueOf(l));
            return jSONObject;
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_ACCOUNT;
        }
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }
}

