/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Poll;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class SearchPolls
extends APIServlet.APIRequestHandler {
    static final SearchPolls instance = new SearchPolls();

    private SearchPolls() {
        super(new APITag[]{APITag.VS, APITag.SEARCH}, "query", "firstIndex", "lastIndex", "includeFinished");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("query"));
        if (string.isEmpty()) {
            return JSONResponses.missing("query");
        }
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeFinished"));
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<Poll> dbIterator = Poll.searchPolls(string, bl, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add(JSONData.poll(dbIterator.next()));
            }
        }
        jSONObject.put("polls", jSONArray);
        return jSONObject;
    }
}

